/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseResource;
import org.traccar.helper.DateUtil;
import org.traccar.model.Position;
import org.traccar.web.CsvBuilder;
import org.traccar.web.GpxBuilder;

@Path(value="positions")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PositionResource
extends BaseResource {
    public static final String TEXT_CSV = "text/csv";
    public static final String CONTENT_DISPOSITION_VALUE_CSV = "attachment; filename=positions.csv";
    public static final String GPX = "application/gpx+xml";
    public static final String CONTENT_DISPOSITION_VALUE_GPX = "attachment; filename=positions.gpx";

    @GET
    public Collection<Position> getJson(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="id") List<Long> positionIds, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        if (!positionIds.isEmpty()) {
            ArrayList<Position> positions = new ArrayList<Position>();
            for (Long positionId : positionIds) {
                Position position = Context.getDataManager().getObject(Position.class, positionId);
                Context.getPermissionsManager().checkDevice(this.getUserId(), position.getDeviceId());
                positions.add(position);
            }
            return positions;
        }
        if (deviceId == 0L) {
            return Context.getDeviceManager().getInitialState(this.getUserId());
        }
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        if (from != null && to != null) {
            return Context.getDataManager().getPositions(deviceId, DateUtil.parseDate(from), DateUtil.parseDate(to));
        }
        return Collections.singleton(Context.getDeviceManager().getLastPosition(deviceId));
    }

    @GET
    @Produces(value={"text/csv"})
    public Response getCsv(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        CsvBuilder csv = new CsvBuilder();
        csv.addHeaderLine(new Position());
        csv.addArray(Context.getDataManager().getPositions(deviceId, DateUtil.parseDate(from), DateUtil.parseDate(to)));
        return Response.ok((Object)csv.build()).header("Content-Disposition", (Object)CONTENT_DISPOSITION_VALUE_CSV).build();
    }

    @GET
    @Produces(value={"application/gpx+xml"})
    public Response getGpx(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="from") String from, @QueryParam(value="to") String to) throws SQLException {
        Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
        GpxBuilder gpx = new GpxBuilder(Context.getIdentityManager().getById(deviceId).getName());
        gpx.addPositions(Context.getDataManager().getPositions(deviceId, DateUtil.parseDate(from), DateUtil.parseDate(to)));
        return Response.ok((Object)gpx.build()).header("Content-Disposition", (Object)CONTENT_DISPOSITION_VALUE_GPX).build();
    }
}

