(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/db/postgresql-driver#postgresql::proto
    (##structure
     std/actor/proto#!protocol::t
     'std/db/postgresql-driver#postgresql
     '()
     (hash-copy std/actor/xdr#+xdr-default-type-registry+)))
  (define std/db/postgresql-driver#postgresql.prepare::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.prepare::t
     '#f
     '2
     'postgresql.prepare
     '((final: . #t))
     '#f
     '(name sql)))
  (define std/db/postgresql-driver#postgresql.prepare?
    (make-struct-predicate std/db/postgresql-driver#postgresql.prepare::t))
  (define std/db/postgresql-driver#make-postgresql.prepare
    (lambda _$args215795_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.prepare::t
             _$args215795_)))
  (define std/db/postgresql-driver#postgresql.prepare-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.prepare::t
     '0))
  (define std/db/postgresql-driver#postgresql.prepare-sql
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.prepare::t
     '1))
  (define std/db/postgresql-driver#postgresql.prepare-name-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.prepare::t
     '0))
  (define std/db/postgresql-driver#postgresql.prepare-sql-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.prepare::t
     '1))
  (define std/db/postgresql-driver#xdr-postgresql.prepare-read
    (lambda (_buffer215793_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.prepare::t
       _buffer215793_)))
  (define std/db/postgresql-driver#xdr-postgresql.prepare-write
    (lambda (_obj215790_ _buffer215791_)
      (std/actor/xdr#xdr-write-struct _obj215790_ _buffer215791_)))
  (define std/db/postgresql-driver#postgresql.prepare::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.prepare-read
     std/db/postgresql-driver#xdr-postgresql.prepare-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.prepare::t
   std/db/postgresql-driver#postgresql.prepare::xdr)
  (define std/db/postgresql-driver#postgresql.exec::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.exec::t
     '#f
     '2
     'postgresql.exec
     '((final: . #t))
     '#f
     '(name params)))
  (define std/db/postgresql-driver#postgresql.exec?
    (make-struct-predicate std/db/postgresql-driver#postgresql.exec::t))
  (define std/db/postgresql-driver#make-postgresql.exec
    (lambda _$args215787_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.exec::t
             _$args215787_)))
  (define std/db/postgresql-driver#postgresql.exec-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.exec::t
     '0))
  (define std/db/postgresql-driver#postgresql.exec-params
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.exec::t
     '1))
  (define std/db/postgresql-driver#postgresql.exec-name-set!
    (make-struct-field-mutator std/db/postgresql-driver#postgresql.exec::t '0))
  (define std/db/postgresql-driver#postgresql.exec-params-set!
    (make-struct-field-mutator std/db/postgresql-driver#postgresql.exec::t '1))
  (define std/db/postgresql-driver#xdr-postgresql.exec-read
    (lambda (_buffer215785_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.exec::t
       _buffer215785_)))
  (define std/db/postgresql-driver#xdr-postgresql.exec-write
    (lambda (_obj215782_ _buffer215783_)
      (std/actor/xdr#xdr-write-struct _obj215782_ _buffer215783_)))
  (define std/db/postgresql-driver#postgresql.exec::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.exec-read
     std/db/postgresql-driver#xdr-postgresql.exec-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.exec::t
   std/db/postgresql-driver#postgresql.exec::xdr)
  (define std/db/postgresql-driver#postgresql.query::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.query::t
     '#f
     '2
     'postgresql.query
     '((final: . #t))
     '#f
     '(name params)))
  (define std/db/postgresql-driver#postgresql.query?
    (make-struct-predicate std/db/postgresql-driver#postgresql.query::t))
  (define std/db/postgresql-driver#make-postgresql.query
    (lambda _$args215779_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.query::t
             _$args215779_)))
  (define std/db/postgresql-driver#postgresql.query-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.query::t
     '0))
  (define std/db/postgresql-driver#postgresql.query-params
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.query::t
     '1))
  (define std/db/postgresql-driver#postgresql.query-name-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.query::t
     '0))
  (define std/db/postgresql-driver#postgresql.query-params-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.query::t
     '1))
  (define std/db/postgresql-driver#xdr-postgresql.query-read
    (lambda (_buffer215777_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.query::t
       _buffer215777_)))
  (define std/db/postgresql-driver#xdr-postgresql.query-write
    (lambda (_obj215774_ _buffer215775_)
      (std/actor/xdr#xdr-write-struct _obj215774_ _buffer215775_)))
  (define std/db/postgresql-driver#postgresql.query::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.query-read
     std/db/postgresql-driver#xdr-postgresql.query-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.query::t
   std/db/postgresql-driver#postgresql.query::xdr)
  (define std/db/postgresql-driver#postgresql.continue::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.continue::t
     '#f
     '1
     'postgresql.continue
     '((final: . #t))
     '#f
     '(token)))
  (define std/db/postgresql-driver#postgresql.continue?
    (make-struct-predicate std/db/postgresql-driver#postgresql.continue::t))
  (define std/db/postgresql-driver#make-postgresql.continue
    (lambda _$args215771_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.continue::t
             _$args215771_)))
  (define std/db/postgresql-driver#postgresql.continue-token
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.continue::t
     '0))
  (define std/db/postgresql-driver#postgresql.continue-token-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.continue::t
     '0))
  (define std/db/postgresql-driver#xdr-postgresql.continue-read
    (lambda (_buffer215769_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.continue::t
       _buffer215769_)))
  (define std/db/postgresql-driver#xdr-postgresql.continue-write
    (lambda (_obj215766_ _buffer215767_)
      (std/actor/xdr#xdr-write-struct _obj215766_ _buffer215767_)))
  (define std/db/postgresql-driver#postgresql.continue::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.continue-read
     std/db/postgresql-driver#xdr-postgresql.continue-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.continue::t
   std/db/postgresql-driver#postgresql.continue::xdr)
  (define std/db/postgresql-driver#postgresql.reset::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.reset::t
     '#f
     '1
     'postgresql.reset
     '((final: . #t))
     '#f
     '(token)))
  (define std/db/postgresql-driver#postgresql.reset?
    (make-struct-predicate std/db/postgresql-driver#postgresql.reset::t))
  (define std/db/postgresql-driver#make-postgresql.reset
    (lambda _$args215763_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.reset::t
             _$args215763_)))
  (define std/db/postgresql-driver#postgresql.reset-token
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.reset::t
     '0))
  (define std/db/postgresql-driver#postgresql.reset-token-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.reset::t
     '0))
  (define std/db/postgresql-driver#xdr-postgresql.reset-read
    (lambda (_buffer215761_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.reset::t
       _buffer215761_)))
  (define std/db/postgresql-driver#xdr-postgresql.reset-write
    (lambda (_obj215758_ _buffer215759_)
      (std/actor/xdr#xdr-write-struct _obj215758_ _buffer215759_)))
  (define std/db/postgresql-driver#postgresql.reset::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.reset-read
     std/db/postgresql-driver#xdr-postgresql.reset-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.reset::t
   std/db/postgresql-driver#postgresql.reset::xdr)
  (define std/db/postgresql-driver#postgresql.close::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.close::t
     '#f
     '1
     'postgresql.close
     '((final: . #t))
     '#f
     '(name)))
  (define std/db/postgresql-driver#postgresql.close?
    (make-struct-predicate std/db/postgresql-driver#postgresql.close::t))
  (define std/db/postgresql-driver#make-postgresql.close
    (lambda _$args215755_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.close::t
             _$args215755_)))
  (define std/db/postgresql-driver#postgresql.close-name
    (make-struct-field-accessor
     std/db/postgresql-driver#postgresql.close::t
     '0))
  (define std/db/postgresql-driver#postgresql.close-name-set!
    (make-struct-field-mutator
     std/db/postgresql-driver#postgresql.close::t
     '0))
  (define std/db/postgresql-driver#xdr-postgresql.close-read
    (lambda (_buffer215753_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.close::t
       _buffer215753_)))
  (define std/db/postgresql-driver#xdr-postgresql.close-write
    (lambda (_obj215750_ _buffer215751_)
      (std/actor/xdr#xdr-write-struct _obj215750_ _buffer215751_)))
  (define std/db/postgresql-driver#postgresql.close::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.close-read
     std/db/postgresql-driver#xdr-postgresql.close-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.close::t
   std/db/postgresql-driver#postgresql.close::xdr)
  (define std/db/postgresql-driver#postgresql.shutdown::t
    (make-struct-type
     'std/db/postgresql-driver#postgresql.shutdown::t
     '#f
     '0
     'postgresql.shutdown
     '((final: . #t))
     '#f
     '()))
  (define std/db/postgresql-driver#postgresql.shutdown?
    (make-struct-predicate std/db/postgresql-driver#postgresql.shutdown::t))
  (define std/db/postgresql-driver#make-postgresql.shutdown
    (lambda _$args215747_
      (apply make-struct-instance
             std/db/postgresql-driver#postgresql.shutdown::t
             _$args215747_)))
  (define std/db/postgresql-driver#xdr-postgresql.shutdown-read
    (lambda (_buffer215745_)
      (std/actor/xdr#xdr-read-struct
       std/db/postgresql-driver#postgresql.shutdown::t
       _buffer215745_)))
  (define std/db/postgresql-driver#xdr-postgresql.shutdown-write
    (lambda (_obj215740_ _buffer215742_)
      (std/actor/xdr#xdr-write-struct _obj215740_ _buffer215742_)))
  (define std/db/postgresql-driver#postgresql.shutdown::xdr
    (##structure
     std/actor/xdr#XDR::t
     std/db/postgresql-driver#xdr-postgresql.shutdown-read
     std/db/postgresql-driver#xdr-postgresql.shutdown-write))
  (table-set!
   (##direct-structure-ref
    std/db/postgresql-driver#postgresql::proto
    '3
    std/actor/proto#!protocol::t
    '#f)
   'std/db/postgresql-driver#postgresql.shutdown::t
   std/db/postgresql-driver#postgresql.shutdown::xdr)
  (define std/db/postgresql-driver#postgresql-prepare-statement!
    (lambda (_conn215719_ _name215720_ _sql215721_)
      (if (thread? _conn215719_)
          (let ((_driver215723_ _conn215719_))
            (let ((_token215725_ (##structure std/actor/proto#!token::t))
                  (_dest215727_ _driver215723_))
              (std/actor/message#send-message__%
               _dest215727_
               (##structure
                std/actor/proto#!call::t
                (##structure
                 std/db/postgresql-driver#postgresql.prepare::t
                 _name215720_
                 _sql215721_)
                _token215725_)
               '#f
               '#t)
              (std/actor/proto#!!call-recv _token215725_ _dest215727_)))
          (let ((_$e215730_
                 (##structure-ref
                  _conn215719_
                  '1
                  std/db/dbi#connection::t
                  '#f)))
            (if _$e215730_
                ((lambda (_driver215733_)
                   (let ((_token215735_
                          (##structure std/actor/proto#!token::t))
                         (_dest215737_ _driver215733_))
                     (std/actor/message#send-message__%
                      _dest215737_
                      (##structure
                       std/actor/proto#!call::t
                       (##structure
                        std/db/postgresql-driver#postgresql.prepare::t
                        _name215720_
                        _sql215721_)
                       _token215735_)
                      '#f
                      '#t)
                     (std/actor/proto#!!call-recv _token215735_ _dest215737_)))
                 _$e215730_)
                (error '"connection has been closed" _conn215719_))))))
  (define std/db/postgresql-driver#postgresql-close-statement!
    (lambda (_conn215710_ _name215711_)
      (let ((_driver215712215714_
             (if (thread? _conn215710_)
                 _conn215710_
                 (##structure-ref
                  _conn215710_
                  '1
                  std/db/dbi#connection::t
                  '#f))))
        (if _driver215712215714_
            (let ((_driver215717_ _driver215712215714_))
              (std/actor/message#send-message__0
               _driver215717_
               (##structure
                std/actor/proto#!event::t
                (##structure
                 std/db/postgresql-driver#postgresql.close::t
                 _name215711_))))
            '#f))))
  (define std/db/postgresql-driver#postgresql-exec!
    (lambda (_conn215689_ _name215690_ _bind215691_)
      (if (thread? _conn215689_)
          (let ((_driver215693_ _conn215689_))
            (let ((_token215695_ (##structure std/actor/proto#!token::t))
                  (_dest215697_ _driver215693_))
              (std/actor/message#send-message__%
               _dest215697_
               (##structure
                std/actor/proto#!call::t
                (##structure
                 std/db/postgresql-driver#postgresql.exec::t
                 _name215690_
                 _bind215691_)
                _token215695_)
               '#f
               '#t)
              (std/actor/proto#!!call-recv _token215695_ _dest215697_)))
          (let ((_$e215700_
                 (##structure-ref
                  _conn215689_
                  '1
                  std/db/dbi#connection::t
                  '#f)))
            (if _$e215700_
                ((lambda (_driver215703_)
                   (let ((_token215705_
                          (##structure std/actor/proto#!token::t))
                         (_dest215707_ _driver215703_))
                     (std/actor/message#send-message__%
                      _dest215707_
                      (##structure
                       std/actor/proto#!call::t
                       (##structure
                        std/db/postgresql-driver#postgresql.exec::t
                        _name215690_
                        _bind215691_)
                       _token215705_)
                      '#f
                      '#t)
                     (std/actor/proto#!!call-recv _token215705_ _dest215707_)))
                 _$e215700_)
                (error '"connection has been closed" _conn215689_))))))
  (define std/db/postgresql-driver#postgresql-query!
    (lambda (_conn215668_ _name215669_ _bind215670_)
      (if (thread? _conn215668_)
          (let ((_driver215672_ _conn215668_))
            (let ((_token215674_ (##structure std/actor/proto#!token::t))
                  (_dest215676_ _driver215672_))
              (std/actor/message#send-message__%
               _dest215676_
               (##structure
                std/actor/proto#!call::t
                (##structure
                 std/db/postgresql-driver#postgresql.query::t
                 _name215669_
                 _bind215670_)
                _token215674_)
               '#f
               '#t)
              (std/actor/proto#!!call-recv _token215674_ _dest215676_)))
          (let ((_$e215679_
                 (##structure-ref
                  _conn215668_
                  '1
                  std/db/dbi#connection::t
                  '#f)))
            (if _$e215679_
                ((lambda (_driver215682_)
                   (let ((_token215684_
                          (##structure std/actor/proto#!token::t))
                         (_dest215686_ _driver215682_))
                     (std/actor/message#send-message__%
                      _dest215686_
                      (##structure
                       std/actor/proto#!call::t
                       (##structure
                        std/db/postgresql-driver#postgresql.query::t
                        _name215669_
                        _bind215670_)
                       _token215684_)
                      '#f
                      '#t)
                     (std/actor/proto#!!call-recv _token215684_ _dest215686_)))
                 _$e215679_)
                (error '"connection has been closed" _conn215668_))))))
  (define std/db/postgresql-driver#postgresql-continue!
    (lambda (_conn215658_ _token215659_)
      (if (##structure-direct-instance-of?
           _token215659_
           'std/actor/proto#!token::t)
          (if (thread? _conn215658_)
              (let ((_driver215661_ _conn215658_))
                (std/actor/message#send-message__0
                 _driver215661_
                 (##structure
                  std/actor/proto#!event::t
                  (##structure
                   std/db/postgresql-driver#postgresql.continue::t
                   _token215659_))))
              (let ((_$e215663_
                     (##structure-ref
                      _conn215658_
                      '1
                      std/db/dbi#connection::t
                      '#f)))
                (if _$e215663_
                    ((lambda (_driver215666_)
                       (std/actor/message#send-message__0
                        _driver215666_
                        (##structure
                         std/actor/proto#!event::t
                         (##structure
                          std/db/postgresql-driver#postgresql.continue::t
                          _token215659_))))
                     _$e215663_)
                    (error '"connection has been closed" _conn215658_))))
          (error '"Bad argument; illegal query token" _token215659_))))
  (define std/db/postgresql-driver#postgresql-reset!
    (lambda (_conn215649_ _token215650_)
      (if (##structure-direct-instance-of?
           _token215650_
           'std/actor/proto#!token::t)
          (let ((_driver215651215653_
                 (if (thread? _conn215649_)
                     _conn215649_
                     (##structure-ref
                      _conn215649_
                      '1
                      std/db/dbi#connection::t
                      '#f))))
            (if _driver215651215653_
                (let ((_driver215656_ _driver215651215653_))
                  (std/actor/message#send-message__0
                   _driver215656_
                   (##structure
                    std/actor/proto#!event::t
                    (##structure
                     std/db/postgresql-driver#postgresql.reset::t
                     _token215650_))))
                '#f))
          (error '"Bad argument; illegal query token" _token215650_))))
  (define std/db/postgresql-driver#postgresql-close!
    (lambda (_conn215641_)
      (let ((_driver215642215644_
             (if (thread? _conn215641_)
                 _conn215641_
                 (##structure-ref
                  _conn215641_
                  '1
                  std/db/dbi#connection::t
                  '#f))))
        (if _driver215642215644_
            (let ((_driver215647_ _driver215642215644_))
              (std/actor/message#send-message__0
               _driver215647_
               (##structure
                std/actor/proto#!event::t
                (##structure
                 std/db/postgresql-driver#postgresql.shutdown::t))))
            '#f))))
  (define std/db/postgresql-driver#postgresql-connect!
    (lambda (_host214917_ _port214918_ _user214919_ _passwd214920_ _db214921_)
      (letrec* ((_sock214923_
                 (open-tcp-client
                  (cons 'server-address:
                        (cons _host214917_
                              (cons 'port-number: (cons _port214918_ '()))))))
                (_buffer214924_ (box (make-u8vector '1024)))
                (_start-driver!214925_
                 (lambda (_sock215544_)
                   (let _lp215546_ ()
                     (let* ((_g215548215570_
                             (std/db/postgresql-driver#postgresql-recv!
                              _sock215544_
                              _buffer214924_))
                            (_else215552215578_ (lambda () (_lp215546_))))
                       (let ((_K215564215630_
                              (lambda ()
                                (gerbil/gambit/threads#spawn/name
                                 'postgresql-connection
                                 std/db/postgresql-driver#postgresql-driver
                                 _sock215544_)))
                             (_K215559215609_
                              (lambda (_irritants215606_ _msg215607_)
                                (apply std/error#raise-io-error
                                       'postgresql-connect!
                                       _msg215607_
                                       _irritants215606_)))
                             (_K215554215585_
                              (lambda (_irritants215582_ _msg215583_)
                                (std/logger#warning
                                 '"NOTICE: ~a ~a"
                                 _msg215583_
                                 _irritants215582_)
                                (_lp215546_))))
                         (if (##pair? _g215548215570_)
                             (let ((_tl215566215635_ (##cdr _g215548215570_))
                                   (_hd215565215633_ (##car _g215548215570_)))
                               (if (##eq? _hd215565215633_ 'ReadyForQuery)
                                   (if (##pair? _tl215566215635_)
                                       (let ((_tl215568215638_
                                              (##cdr _tl215566215635_)))
                                         (if (##null? _tl215568215638_)
                                             (_K215564215630_)
                                             (_lp215546_)))
                                       (_lp215546_))
                                   (if (##eq? _hd215565215633_ 'ErrorResponse)
                                       (if (##pair? _tl215566215635_)
                                           (let ((_tl215563215619_
                                                  (##cdr _tl215566215635_))
                                                 (_hd215562215617_
                                                  (##car _tl215566215635_)))
                                             (let ((_msg215622_
                                                    _hd215562215617_)
                                                   (_irritants215624_
                                                    _tl215563215619_))
                                               (_K215559215609_
                                                _irritants215624_
                                                _msg215622_)))
                                           (_lp215546_))
                                       (if (##eq? _hd215565215633_
                                                  'NoticeResponse)
                                           (if (##pair? _tl215566215635_)
                                               (let ((_tl215558215595_
                                                      (##cdr _tl215566215635_))
                                                     (_hd215557215593_
                                                      (##car _tl215566215635_)))
                                                 (let ((_msg215598_
                                                        _hd215557215593_)
                                                       (_irritants215600_
                                                        _tl215558215595_))
                                                   (_K215554215585_
                                                    _irritants215600_
                                                    _msg215598_)))
                                               (_lp215546_))
                                           (_lp215546_)))))
                             (_lp215546_)))))))
                (_authen-pass215095_
                 (lambda (_sock215466_ _pass215467_)
                   (std/db/postgresql-driver#postgresql-send!
                    _sock214923_
                    (cons 'PasswordMessage (cons _pass215467_ '())))
                   (let* ((_g215468215485_
                           (std/db/postgresql-driver#postgresql-recv!
                            _sock214923_
                            _buffer214924_))
                          (_E215472215489_
                           (lambda ()
                             (error '"No clause matching" _g215468215485_))))
                     (let ((_K215479215531_
                            (lambda () (_start-driver!214925_ _sock215466_)))
                           (_K215474215510_
                            (lambda (_irritants215505_ _msg215507_)
                              (apply std/error#raise-io-error
                                     'postgresql-connect!
                                     _msg215507_
                                     _irritants215505_)))
                           (_K215473215496_
                            (lambda (_unexpected215493_)
                              (std/error#raise-io-error
                               'postgresql-connect!
                               '"unexpected message"
                               _unexpected215493_))))
                       (if (##pair? _g215468215485_)
                           (let ((_tl215481215536_ (##cdr _g215468215485_))
                                 (_hd215480215534_ (##car _g215468215485_)))
                             (if (##eq? _hd215480215534_
                                        'AuthenticationRequest)
                                 (if (##pair? _tl215481215536_)
                                     (let ((_tl215483215541_
                                            (##cdr _tl215481215536_))
                                           (_hd215482215539_
                                            (##car _tl215481215536_)))
                                       (if (##eq? _hd215482215539_
                                                  'AuthenticationOk)
                                           (if (##null? _tl215483215541_)
                                               (_K215479215531_)
                                               (let ((_unexpected215499_
                                                      _g215468215485_))
                                                 (_K215473215496_
                                                  _unexpected215499_)))
                                           (let ((_unexpected215499_
                                                  _g215468215485_))
                                             (_K215473215496_
                                              _unexpected215499_))))
                                     (let ((_unexpected215499_
                                            _g215468215485_))
                                       (_K215473215496_ _unexpected215499_)))
                                 (if (##eq? _hd215480215534_ 'ErrorResponse)
                                     (if (##pair? _tl215481215536_)
                                         (let ((_tl215478215520_
                                                (##cdr _tl215481215536_))
                                               (_hd215477215518_
                                                (##car _tl215481215536_)))
                                           (let ((_msg215523_ _hd215477215518_)
                                                 (_irritants215525_
                                                  _tl215478215520_))
                                             (_K215474215510_
                                              _irritants215525_
                                              _msg215523_)))
                                         (let ((_unexpected215499_
                                                _g215468215485_))
                                           (_K215473215496_
                                            _unexpected215499_)))
                                     (let ((_unexpected215499_
                                            _g215468215485_))
                                       (_K215473215496_ _unexpected215499_)))))
                           (let ((_unexpected215499_ _g215468215485_))
                             (_K215473215496_ _unexpected215499_)))))))
                (_authen-cleartext215096_
                 (lambda (_sock215464_)
                   (_authen-pass215095_ _sock215464_ _passwd214920_)))
                (_authen-md5215097_
                 (lambda (_sock215446_ _salt215447_)
                   (letrec ((_md5-hex215449_
                             (lambda (_data215462_)
                               (std/text/hex#hex-encode__0
                                (std/crypto/digest#md5 _data215462_)))))
                     (let* ((_word1215451_
                             (string-append _passwd214920_ _user214919_))
                            (_word2215453_ (_md5-hex215449_ _word1215451_))
                            (_word3215455_
                             (u8vector-append
                              (std/text/utf8#string->utf8__0 _word2215453_)
                              _salt215447_))
                            (_word4215457_ (_md5-hex215449_ _word3215455_))
                            (_pass215459_
                             (string-append '"md5" _word4215457_)))
                       (_authen-pass215095_ _sock215446_ _pass215459_)))))
                (_authen-sasl215098_
                 (lambda (_sock215191_ _mechanisms215192_)
                   (if (member '"SCRAM-SHA-256" _mechanisms215192_)
                       '#!void
                       (std/error#raise-io-error
                        'postgresql-connect!
                        '"unknown SASL authentication mechanisms"
                        _mechanisms215192_))
                   (let* ((_ctx215194_
                           (std/net/sasl#scram-sha-256-begin
                            '""
                            _passwd214920_))
                          (_msg215196_
                           (std/net/sasl#scram-client-first-message__0
                            _ctx215194_)))
                     (std/db/postgresql-driver#postgresql-send!
                      _sock214923_
                      (cons 'SASLInitialResponse
                            (cons '"SCRAM-SHA-256" (cons _msg215196_ '()))))
                     (let* ((_g215198215217_
                             (std/db/postgresql-driver#postgresql-recv!
                              _sock214923_
                              _buffer214924_))
                            (_E215202215221_
                             (lambda ()
                               (error '"No clause matching" _g215198215217_))))
                       (let ((_K215209215426_
                              (lambda (_msg215262_)
                                (std/net/sasl#scram-client-first-server-message!
                                 _ctx215194_
                                 _msg215262_)
                                (let ((_msg215264_
                                       (std/net/sasl#scram-client-final-message
                                        _ctx215194_)))
                                  (std/db/postgresql-driver#postgresql-send!
                                   _sock214923_
                                   (cons 'SASLResponse (cons _msg215264_ '())))
                                  (let* ((_g215265215284_
                                          (std/db/postgresql-driver#postgresql-recv!
                                           _sock214923_
                                           _buffer214924_))
                                         (_E215269215288_
                                          (lambda ()
                                            (error '"No clause matching"
                                                   _g215265215284_))))
                                    (let ((_K215276215406_
                                           (lambda (_msg215329_)
                                             (std/net/sasl#scram-client-final-server-message!
                                              _ctx215194_
                                              _msg215329_)
                                             (let* ((_g215330215347_
                                                     (std/db/postgresql-driver#postgresql-recv!
                                                      _sock214923_
                                                      _buffer214924_))
                                                    (_E215334215351_
                                                     (lambda ()
                                                       (error '"No clause matching"
                                                              _g215330215347_))))
                                               (let ((_K215341215393_
                                                      (lambda ()
                                                        (_start-driver!214925_
                                                         _sock215191_)))
                                                     (_K215336215372_
                                                      (lambda (_irritants215367_
                                                               _msg215369_)
                                                        (apply std/error#raise-io-error
                                                               'postgresql-connect!
                                                               _msg215369_
                                                               _irritants215367_)))
                                                     (_K215335215358_
                                                      (lambda (_unexpected215355_)
                                                        (std/error#raise-io-error
                                                         'postgresql-connect!
                                                         '"unexpected message"
                                                         _unexpected215355_))))
                                                 (if (##pair? _g215330215347_)
                                                     (let ((_tl215343215398_
                                                            (##cdr _g215330215347_))
                                                           (_hd215342215396_
                                                            (##car _g215330215347_)))
                                                       (if (##eq? _hd215342215396_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          'AuthenticationRequest)
                   (if (##pair? _tl215343215398_)
                       (let ((_tl215345215403_ (##cdr _tl215343215398_))
                             (_hd215344215401_ (##car _tl215343215398_)))
                         (if (##eq? _hd215344215401_ 'AuthenticationOk)
                             (if (##null? _tl215345215403_)
                                 (_K215341215393_)
                                 (let ((_unexpected215361_ _g215330215347_))
                                   (_K215335215358_ _unexpected215361_)))
                             (let ((_unexpected215361_ _g215330215347_))
                               (_K215335215358_ _unexpected215361_))))
                       (let ((_unexpected215361_ _g215330215347_))
                         (_K215335215358_ _unexpected215361_)))
                   (if (##eq? _hd215342215396_ 'ErrorResponse)
                       (if (##pair? _tl215343215398_)
                           (let ((_tl215340215382_ (##cdr _tl215343215398_))
                                 (_hd215339215380_ (##car _tl215343215398_)))
                             (let ((_msg215385_ _hd215339215380_)
                                   (_irritants215387_ _tl215340215382_))
                               (_K215336215372_
                                _irritants215387_
                                _msg215385_)))
                           (let ((_unexpected215361_ _g215330215347_))
                             (_K215335215358_ _unexpected215361_)))
                       (let ((_unexpected215361_ _g215330215347_))
                         (_K215335215358_ _unexpected215361_)))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (let ((_unexpected215361_
                                                            _g215330215347_))
                                                       (_K215335215358_
                                                        _unexpected215361_)))))))
                                          (_K215271215309_
                                           (lambda (_irritants215304_
                                                    _msg215306_)
                                             (apply std/error#raise-io-error
                                                    'postgresql-connect!
                                                    _msg215306_
                                                    _irritants215304_)))
                                          (_K215270215295_
                                           (lambda (_unexpected215292_)
                                             (std/error#raise-io-error
                                              'postgresql-connect!
                                              '"unexpected message"
                                              _unexpected215292_))))
                                      (if (##pair? _g215265215284_)
                                          (let ((_tl215278215411_
                                                 (##cdr _g215265215284_))
                                                (_hd215277215409_
                                                 (##car _g215265215284_)))
                                            (if (##eq? _hd215277215409_
                                                       'AuthenticationRequest)
                                                (if (##pair? _tl215278215411_)
                                                    (let ((_tl215280215416_
                                                           (##cdr _tl215278215411_))
                                                          (_hd215279215414_
                                                           (##car _tl215278215411_)))
                                                      (if (##eq? _hd215279215414_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         'AuthenticationSASLFinal)
                  (if (##pair? _tl215280215416_)
                      (let ((_tl215282215421_ (##cdr _tl215280215416_))
                            (_hd215281215419_ (##car _tl215280215416_)))
                        (if (##null? _tl215282215421_)
                            (let ((_msg215424_ _hd215281215419_))
                              (_K215276215406_ _msg215424_))
                            (let ((_unexpected215298_ _g215265215284_))
                              (_K215270215295_ _unexpected215298_))))
                      (let ((_unexpected215298_ _g215265215284_))
                        (_K215270215295_ _unexpected215298_)))
                  (let ((_unexpected215298_ _g215265215284_))
                    (_K215270215295_ _unexpected215298_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (let ((_unexpected215298_
                                                           _g215265215284_))
                                                      (_K215270215295_
                                                       _unexpected215298_)))
                                                (if (##eq? _hd215277215409_
                                                           'ErrorResponse)
                                                    (if (##pair? _tl215278215411_)
                                                        (let ((_tl215275215319_
                                                               (##cdr _tl215278215411_))
                                                              (_hd215274215317_
                                                               (##car _tl215278215411_)))
                                                          (let ((_msg215322_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _hd215274215317_)
                        (_irritants215324_ _tl215275215319_))
                    (_K215271215309_ _irritants215324_ _msg215322_)))
                (let ((_unexpected215298_ _g215265215284_))
                  (_K215270215295_ _unexpected215298_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                    (let ((_unexpected215298_
                                                           _g215265215284_))
                                                      (_K215270215295_
                                                       _unexpected215298_)))))
                                          (let ((_unexpected215298_
                                                 _g215265215284_))
                                            (_K215270215295_
                                             _unexpected215298_))))))))
                             (_K215204215242_
                              (lambda (_irritants215237_ _msg215239_)
                                (apply std/error#raise-io-error
                                       'postgresql-connect!
                                       _msg215239_
                                       _irritants215237_)))
                             (_K215203215228_
                              (lambda (_unexpected215225_)
                                (std/error#raise-io-error
                                 'postgresql-connect!
                                 '"unexpected message"
                                 _unexpected215225_))))
                         (if (##pair? _g215198215217_)
                             (let ((_tl215211215431_ (##cdr _g215198215217_))
                                   (_hd215210215429_ (##car _g215198215217_)))
                               (if (##eq? _hd215210215429_
                                          'AuthenticationRequest)
                                   (if (##pair? _tl215211215431_)
                                       (let ((_tl215213215436_
                                              (##cdr _tl215211215431_))
                                             (_hd215212215434_
                                              (##car _tl215211215431_)))
                                         (if (##eq? _hd215212215434_
                                                    'AuthenticationSASLContinue)
                                             (if (##pair? _tl215213215436_)
                                                 (let ((_tl215215215441_
                                                        (##cdr _tl215213215436_))
                                                       (_hd215214215439_
                                                        (##car _tl215213215436_)))
                                                   (if (##null? _tl215215215441_)
                                                       (let ((_msg215444_
                                                              _hd215214215439_))
                                                         (_K215209215426_
                                                          _msg215444_))
                                                       (let ((_unexpected215231_
                                                              _g215198215217_))
                                                         (_K215203215228_
                                                          _unexpected215231_))))
                                                 (let ((_unexpected215231_
                                                        _g215198215217_))
                                                   (_K215203215228_
                                                    _unexpected215231_)))
                                             (let ((_unexpected215231_
                                                    _g215198215217_))
                                               (_K215203215228_
                                                _unexpected215231_))))
                                       (let ((_unexpected215231_
                                              _g215198215217_))
                                         (_K215203215228_ _unexpected215231_)))
                                   (if (##eq? _hd215210215429_ 'ErrorResponse)
                                       (if (##pair? _tl215211215431_)
                                           (let ((_tl215208215252_
                                                  (##cdr _tl215211215431_))
                                                 (_hd215207215250_
                                                  (##car _tl215211215431_)))
                                             (let ((_msg215255_
                                                    _hd215207215250_)
                                                   (_irritants215257_
                                                    _tl215208215252_))
                                               (_K215204215242_
                                                _irritants215257_
                                                _msg215255_)))
                                           (let ((_unexpected215231_
                                                  _g215198215217_))
                                             (_K215203215228_
                                              _unexpected215231_)))
                                       (let ((_unexpected215231_
                                              _g215198215217_))
                                         (_K215203215228_
                                          _unexpected215231_)))))
                             (let ((_unexpected215231_ _g215198215217_))
                               (_K215203215228_ _unexpected215231_)))))))))
        (std/logger#start-logger!__0)
        (with-exception-catcher
         (lambda (_g215099215101_)
           (if '#t
               (let ((_e215104_ _g215099215101_))
                 (close-port _sock214923_)
                 (raise _e215104_))
               (raise _g215099215101_)))
         (lambda ()
           (std/db/postgresql-driver#postgresql-send!
            _sock214923_
            (cons 'StartupMessage
                  (cons (cons '"user" _user214919_)
                        (if _db214921_
                            (cons (cons '"database" _db214921_) '())
                            '()))))
           (let* ((_g215106215123_
                   (std/db/postgresql-driver#postgresql-recv!
                    _sock214923_
                    _buffer214924_))
                  (_E215110215127_
                   (lambda () (error '"No clause matching" _g215106215123_))))
             (let ((_K215117215174_
                    (lambda (_rest215168_ _what215169_)
                      (let ((_$e215171_ _what215169_))
                        (if (eq? 'AuthenticationOk _$e215171_)
                            (_start-driver!214925_ _sock214923_)
                            (if (eq? 'AuthenticationCleartextPassword
                                     _$e215171_)
                                (_authen-cleartext215096_ _sock214923_)
                                (if (eq? 'AuthenticationMD5Password _$e215171_)
                                    (_authen-md5215097_
                                     _sock214923_
                                     (car _rest215168_))
                                    (if (eq? 'AuthenticationSASL _$e215171_)
                                        (_authen-sasl215098_
                                         _sock214923_
                                         _rest215168_)
                                        (std/error#raise-io-error
                                         'postgresql-connect!
                                         '"unsupported authentication mechanism"
                                         _what215169_))))))))
                   (_K215112215148_
                    (lambda (_irritants215143_ _msg215145_)
                      (apply std/error#raise-io-error
                             'postgresql-connect!
                             _msg215145_
                             _irritants215143_)))
                   (_K215111215134_
                    (lambda (_unexpected215131_)
                      (std/error#raise-io-error
                       'postgresql-connect!
                       '"unexpected message"
                       _unexpected215131_))))
               (if (##pair? _g215106215123_)
                   (let ((_tl215119215179_ (##cdr _g215106215123_))
                         (_hd215118215177_ (##car _g215106215123_)))
                     (if (##eq? _hd215118215177_ 'AuthenticationRequest)
                         (if (##pair? _tl215119215179_)
                             (let ((_tl215121215184_ (##cdr _tl215119215179_))
                                   (_hd215120215182_ (##car _tl215119215179_)))
                               (let ((_what215187_ _hd215120215182_)
                                     (_rest215189_ _tl215121215184_))
                                 (_K215117215174_ _rest215189_ _what215187_)))
                             (let ((_unexpected215137_ _g215106215123_))
                               (_K215111215134_ _unexpected215137_)))
                         (if (##eq? _hd215118215177_ 'ErrorResponse)
                             (if (##pair? _tl215119215179_)
                                 (let ((_tl215116215158_
                                        (##cdr _tl215119215179_))
                                       (_hd215115215156_
                                        (##car _tl215119215179_)))
                                   (let ((_msg215161_ _hd215115215156_)
                                         (_irritants215163_ _tl215116215158_))
                                     (_K215112215148_
                                      _irritants215163_
                                      _msg215161_)))
                                 (let ((_unexpected215137_ _g215106215123_))
                                   (_K215111215134_ _unexpected215137_)))
                             (let ((_unexpected215137_ _g215106215123_))
                               (_K215111215134_ _unexpected215137_)))))
                   (let ((_unexpected215137_ _g215106215123_))
                     (_K215111215134_ _unexpected215137_))))))))))
  (define std/db/postgresql-driver#postgresql-driver
    (lambda (_sock213736_)
      (letrec* ((_query-limit213738_ '1000)
                (_query-output213739_ '#f)
                (_query-token213740_ '#f)
                (_buffer213741_ (box (make-u8vector '1024)))
                (_deferred-close213742_ '())
                (_send!213743_
                 (lambda (_msg214915_)
                   (std/db/postgresql-driver#postgresql-send!
                    _sock213736_
                    _msg214915_)))
                (_recv!213744_
                 (lambda ()
                   (let* ((_g214866214877_
                           (std/db/postgresql-driver#postgresql-recv!
                            _sock213736_
                            _buffer213741_))
                          (_E214869214881_
                           (lambda ()
                             (error '"No clause matching" _g214866214877_))))
                     (let ((_K214871214898_
                            (lambda (_irritants214895_ _msg214896_)
                              (_notice!213745_ _msg214896_ _irritants214895_)
                              (_recv!213744_)))
                           (_K214870214887_
                            (lambda (_msg214885_) _msg214885_)))
                       (if (##pair? _g214866214877_)
                           (let ((_tl214873214903_ (##cdr _g214866214877_))
                                 (_hd214872214901_ (##car _g214866214877_)))
                             (if (##eq? _hd214872214901_ 'NoticeResponse)
                                 (if (##pair? _tl214873214903_)
                                     (let ((_tl214875214908_
                                            (##cdr _tl214873214903_))
                                           (_hd214874214906_
                                            (##car _tl214873214903_)))
                                       (let ((_msg214911_ _hd214874214906_)
                                             (_irritants214913_
                                              _tl214875214908_))
                                         (_K214871214898_
                                          _irritants214913_
                                          _msg214911_)))
                                     (let ((_msg214890_ _g214866214877_))
                                       (_K214870214887_ _msg214890_)))
                                 (let ((_msg214890_ _g214866214877_))
                                   (_K214870214887_ _msg214890_))))
                           (let ((_msg214890_ _g214866214877_))
                             (_K214870214887_ _msg214890_)))))))
                (_notice!213745_
                 (lambda (_msg214863_ _irritants214864_)
                   (std/logger#warning
                    '"NOTICE: ~a ~a"
                    _msg214863_
                    _irritants214864_)))
                (_resync!213746_
                 (lambda ()
                   (let _lp214828_ ()
                     (let* ((_g214830214840_ (_recv!213744_))
                            (_else214832214848_ (lambda () (_lp214828_)))
                            (_K214834214852_ (lambda () '#!void)))
                       (if (##pair? _g214830214840_)
                           (let ((_hd214835214855_ (##car _g214830214840_))
                                 (_tl214836214857_ (##cdr _g214830214840_)))
                             (if (##eq? _hd214835214855_ 'ReadyForQuery)
                                 (if (##pair? _tl214836214857_)
                                     (let ((_tl214838214860_
                                            (##cdr _tl214836214857_)))
                                       (if (##null? _tl214838214860_)
                                           '#!void
                                           (_lp214828_)))
                                     (_lp214828_))
                                 (_lp214828_)))
                           (_lp214828_))))))
                (_maybe-sync!213747_
                 (lambda ()
                   (if _query-output213739_
                       (begin
                         (std/misc/channel#channel-sync
                          _query-output213739_
                          (make-struct-instance
                           std/db/dbi#sql-error::t
                           '"portal expired"
                           '()
                           'postgresql-query-pump!))
                         (std/misc/channel#channel-close _query-output213739_)
                         (set! _query-output213739_ '#f)
                         (set! _query-token213740_ '#f)
                         (_resync!213746_)
                         (let ((_to-close214825_ _deferred-close213742_))
                           (set! _deferred-close213742_ '())
                           (for-each _close213752_ _to-close214825_)))
                       '#!void)))
                (_prepare213748_
                 (lambda (_name214669_ _sql214670_)
                   (letrec* ((_params214672_ '#f) (_cols214673_ '#f))
                     (_maybe-sync!213747_)
                     (_send!213743_
                      (cons 'Parse (cons _name214669_ (cons _sql214670_ '()))))
                     (_send!213743_
                      (cons 'Describe (cons '#\S (cons _name214669_ '()))))
                     (_send!213743_ '(Sync))
                     (let* ((_g214674214687_ (_recv!213744_))
                            (_E214677214691_
                             (lambda ()
                               (error '"No clause matching" _g214674214687_))))
                       (let ((_K214683214719_ (lambda () '#!void))
                             (_K214678214698_
                              (lambda (_irritants214695_ _msg214696_)
                                (_resync!213746_)
                                (apply std/db/dbi#raise-sql-error
                                       'postgresql-prepare!
                                       _msg214696_
                                       _irritants214695_))))
                         (if (##pair? _g214674214687_)
                             (let ((_tl214685214724_ (##cdr _g214674214687_))
                                   (_hd214684214722_ (##car _g214674214687_)))
                               (if (##eq? _hd214684214722_ 'ParseComplete)
                                   (if (##null? _tl214685214724_)
                                       '#!void
                                       (_E214677214691_))
                                   (if (##eq? _hd214684214722_ 'ErrorResponse)
                                       (if (##pair? _tl214685214724_)
                                           (let ((_tl214682214708_
                                                  (##cdr _tl214685214724_))
                                                 (_hd214681214706_
                                                  (##car _tl214685214724_)))
                                             (let ((_msg214711_
                                                    _hd214681214706_)
                                                   (_irritants214713_
                                                    _tl214682214708_))
                                               (_K214678214698_
                                                _irritants214713_
                                                _msg214711_)))
                                           (_E214677214691_))
                                       (_E214677214691_))))
                             (_E214677214691_))))
                     (let* ((_g214726214739_ (_recv!213744_))
                            (_E214729214743_
                             (lambda ()
                               (error '"No clause matching" _g214726214739_))))
                       (let ((_K214735214772_
                              (lambda (_query-params214770_)
                                (set! _params214672_ _query-params214770_)))
                             (_K214730214750_
                              (lambda (_irritants214747_ _msg214748_)
                                (_resync!213746_)
                                (apply std/db/dbi#raise-sql-error
                                       'postgresql-prepare!
                                       _msg214748_
                                       _irritants214747_))))
                         (if (##pair? _g214726214739_)
                             (let ((_tl214737214777_ (##cdr _g214726214739_))
                                   (_hd214736214775_ (##car _g214726214739_)))
                               (if (##eq? _hd214736214775_
                                          'ParameterDescription)
                                   (let ((_query-params214780_
                                          _tl214737214777_))
                                     (_K214735214772_ _query-params214780_))
                                   (if (##eq? _hd214736214775_ 'ErrorResponse)
                                       (if (##pair? _tl214737214777_)
                                           (let ((_tl214734214760_
                                                  (##cdr _tl214737214777_))
                                                 (_hd214733214758_
                                                  (##car _tl214737214777_)))
                                             (let ((_msg214763_
                                                    _hd214733214758_)
                                                   (_irritants214765_
                                                    _tl214734214760_))
                                               (_K214730214750_
                                                _irritants214765_
                                                _msg214763_)))
                                           (_E214729214743_))
                                       (_E214729214743_))))
                             (_E214729214743_))))
                     (let* ((_g214781214792_ (_recv!213744_))
                            (_E214784214796_
                             (lambda ()
                               (error '"No clause matching" _g214781214792_))))
                       (let ((_K214788214814_
                              (lambda (_fields214812_)
                                (set! _cols214673_ _fields214812_)))
                             (_K214785214801_
                              (lambda () (set! _cols214673_ '()))))
                         (if (##pair? _g214781214792_)
                             (let ((_tl214790214819_ (##cdr _g214781214792_))
                                   (_hd214789214817_ (##car _g214781214792_)))
                               (if (##eq? _hd214789214817_ 'RowDescription)
                                   (let ((_fields214822_ _tl214790214819_))
                                     (_K214788214814_ _fields214822_))
                                   (if (##eq? _hd214789214817_ 'NoData)
                                       (if (##null? _tl214790214819_)
                                           (_K214785214801_)
                                           (_E214784214796_))
                                       (_E214784214796_))))
                             (_E214784214796_))))
                     (_resync!213746_)
                     (values _params214672_ _cols214673_))))
                (_exec213749_
                 (lambda (_name214510_ _params214511_)
                   (letrec* ((_res214513_ '#f))
                     (_maybe-sync!213747_)
                     (_send!213743_
                      (cons 'Bind
                            (cons '"" (cons _name214510_ _params214511_))))
                     (_send!213743_ '(Execute "" 1))
                     (_send!213743_ '(Sync))
                     (let* ((_g214514214527_ (_recv!213744_))
                            (_E214517214531_
                             (lambda ()
                               (error '"No clause matching" _g214514214527_))))
                       (let ((_K214523214559_ (lambda () '#!void))
                             (_K214518214538_
                              (lambda (_irritants214535_ _msg214536_)
                                (_resync!213746_)
                                (apply std/db/dbi#raise-sql-error
                                       'postgresql-exec!
                                       _msg214536_
                                       _irritants214535_))))
                         (if (##pair? _g214514214527_)
                             (let ((_tl214525214564_ (##cdr _g214514214527_))
                                   (_hd214524214562_ (##car _g214514214527_)))
                               (if (##eq? _hd214524214562_ 'BindComplete)
                                   (if (##null? _tl214525214564_)
                                       '#!void
                                       (_E214517214531_))
                                   (if (##eq? _hd214524214562_ 'ErrorResponse)
                                       (if (##pair? _tl214525214564_)
                                           (let ((_tl214522214548_
                                                  (##cdr _tl214525214564_))
                                                 (_hd214521214546_
                                                  (##car _tl214525214564_)))
                                             (let ((_msg214551_
                                                    _hd214521214546_)
                                                   (_irritants214553_
                                                    _tl214522214548_))
                                               (_K214518214538_
                                                _irritants214553_
                                                _msg214551_)))
                                           (_E214517214531_))
                                       (_E214517214531_))))
                             (_E214517214531_))))
                     (let _lp214567_ ()
                       (let* ((_g214569214592_ (_recv!213744_))
                              (_E214574214596_
                               (lambda ()
                                 (error '"No clause matching"
                                        _g214569214592_))))
                         (let ((_K214588214659_
                                (lambda (_cols214657_) (_lp214567_)))
                               (_K214583214639_
                                (lambda (_tag214637_)
                                  (set! _res214513_ _tag214637_)))
                               (_K214580214625_ (lambda () '#!void))
                               (_K214575214603_
                                (lambda (_irritants214600_ _msg214601_)
                                  (_resync!213746_)
                                  (apply std/db/dbi#raise-sql-error
                                         'postgreql-exec
                                         _msg214601_
                                         _irritants214600_))))
                           (let ((___match216459216460_
                                  (lambda (_hd214581214628_ _tl214582214630_)
                                    (if (##eq? _hd214581214628_
                                               'EmptyQueryResponse)
                                        (if (##null? _tl214582214630_)
                                            '#!void
                                            (_E214574214596_))
                                        (if (##eq? _hd214581214628_
                                                   'ErrorResponse)
                                            (if (##pair? _tl214582214630_)
                                                (let ((_tl214579214613_
                                                       (##cdr _tl214582214630_))
                                                      (_hd214578214611_
                                                       (##car _tl214582214630_)))
                                                  (let ((_msg214616_
                                                         _hd214578214611_)
                                                        (_irritants214618_
                                                         _tl214579214613_))
                                                    (_K214575214603_
                                                     _irritants214618_
                                                     _msg214616_)))
                                                (_E214574214596_))
                                            (_E214574214596_))))))
                             (if (##pair? _g214569214592_)
                                 (let ((_tl214590214664_
                                        (##cdr _g214569214592_))
                                       (_hd214589214662_
                                        (##car _g214569214592_)))
                                   (if (##eq? _hd214589214662_ 'DataRow)
                                       (let ((_cols214667_ _tl214590214664_))
                                         (_K214588214659_ _cols214667_))
                                       (if (##eq? _hd214589214662_
                                                  'CommandComplete)
                                           (if (##pair? _tl214590214664_)
                                               (let ((_tl214587214649_
                                                      (##cdr _tl214590214664_))
                                                     (_hd214586214647_
                                                      (##car _tl214590214664_)))
                                                 (if (##null? _tl214587214649_)
                                                     (let ((_tag214652_
                                                            _hd214586214647_))
                                                       (_K214583214639_
                                                        _tag214652_))
                                                     (_E214574214596_)))
                                               (_E214574214596_))
                                           (if (##eq? _hd214589214662_
                                                      'PortalSuspended)
                                               (if (##null? _tl214590214664_)
                                                   '#!void
                                                   (_E214574214596_))
                                               (___match216459216460_
                                                _hd214589214662_
                                                _tl214590214664_)))))
                                 (_E214574214596_))))))
                     (_resync!213746_)
                     _res214513_)))
                (_query-start213750_
                 (lambda (_name214452_ _params214453_)
                   (_maybe-sync!213747_)
                   (_send!213743_
                    (cons 'Bind (cons '"" (cons _name214452_ _params214453_))))
                   (_send!213743_ '(Execute "" 0))
                   (_send!213743_ '(Sync))
                   (let* ((_g214454214467_ (_recv!213744_))
                          (_E214457214471_
                           (lambda ()
                             (error '"No clause matching" _g214454214467_))))
                     (let ((_K214463214502_
                            (lambda ()
                              (let ((_ch214499_
                                     (let ((__obj216625
                                            (make-object
                                             std/misc/channel#channel::t
                                             '5)))
                                       (std/misc/channel#channel:::init!__%
                                        __obj216625
                                        _query-limit213738_)
                                       __obj216625))
                                    (_token214500_
                                     (##structure std/actor/proto#!token::t)))
                                (set! _query-output213739_ _ch214499_)
                                (set! _query-token213740_ _token214500_)
                                (values _ch214499_ _token214500_))))
                           (_K214458214478_
                            (lambda (_irritants214475_ _msg214476_)
                              (_resync!213746_)
                              (apply std/db/dbi#raise-sql-error
                                     'postgresql-query!
                                     _msg214476_
                                     _irritants214475_))))
                       (if (##pair? _g214454214467_)
                           (let ((_tl214465214507_ (##cdr _g214454214467_))
                                 (_hd214464214505_ (##car _g214454214467_)))
                             (if (##eq? _hd214464214505_ 'BindComplete)
                                 (if (##null? _tl214465214507_)
                                     (_K214463214502_)
                                     (_E214457214471_))
                                 (if (##eq? _hd214464214505_ 'ErrorResponse)
                                     (if (##pair? _tl214465214507_)
                                         (let ((_tl214462214488_
                                                (##cdr _tl214465214507_))
                                               (_hd214461214486_
                                                (##car _tl214465214507_)))
                                           (let ((_msg214491_ _hd214461214486_)
                                                 (_irritants214493_
                                                  _tl214462214488_))
                                             (_K214458214478_
                                              _irritants214493_
                                              _msg214491_)))
                                         (_E214457214471_))
                                     (_E214457214471_))))
                           (_E214457214471_))))))
                (_query-pump213751_
                 (lambda ()
                   (call-with-current-continuation
                    (lambda (_break214348_)
                      (let _lp214350_ ()
                        (let* ((_g214352214375_ (_recv!213744_))
                               (_E214357214379_
                                (lambda ()
                                  (error '"No clause matching"
                                         _g214352214375_))))
                          (let ((_K214371214442_
                                 (lambda (_cols214440_)
                                   (if (std/misc/channel#channel-try-put
                                        _query-output213739_
                                        _cols214440_)
                                       (_lp214350_)
                                       (begin
                                         (std/misc/channel#channel-sync
                                          _query-output213739_
                                          _cols214440_
                                          _query-token213740_)
                                         (_break214348_)))))
                                (_K214366214422_
                                 (lambda (_tag214420_) '#!void))
                                (_K214363214408_ (lambda () '#!void))
                                (_K214358214386_
                                 (lambda (_irritants214383_ _msg214384_)
                                   (std/misc/channel#channel-sync
                                    _query-output213739_
                                    (make-struct-instance
                                     std/db/dbi#sql-error::t
                                     _msg214384_
                                     _irritants214383_
                                     'postgresql-query!)))))
                            (let ((___match216521216522_
                                   (lambda (_hd214364214411_ _tl214365214413_)
                                     (if (##eq? _hd214364214411_
                                                'EmptyQueryResponse)
                                         (if (##null? _tl214365214413_)
                                             '#!void
                                             (_E214357214379_))
                                         (if (##eq? _hd214364214411_
                                                    'ErrorResponse)
                                             (if (##pair? _tl214365214413_)
                                                 (let ((_tl214362214396_
                                                        (##cdr _tl214365214413_))
                                                       (_hd214361214394_
                                                        (##car _tl214365214413_)))
                                                   (let ((_msg214399_
                                                          _hd214361214394_)
                                                         (_irritants214401_
                                                          _tl214362214396_))
                                                     (_K214358214386_
                                                      _irritants214401_
                                                      _msg214399_)))
                                                 (_E214357214379_))
                                             (_E214357214379_))))))
                              (if (##pair? _g214352214375_)
                                  (let ((_tl214373214447_
                                         (##cdr _g214352214375_))
                                        (_hd214372214445_
                                         (##car _g214352214375_)))
                                    (if (##eq? _hd214372214445_ 'DataRow)
                                        (let ((_cols214450_ _tl214373214447_))
                                          (_K214371214442_ _cols214450_))
                                        (if (##eq? _hd214372214445_
                                                   'CommandComplete)
                                            (if (##pair? _tl214373214447_)
                                                (let ((_tl214370214432_
                                                       (##cdr _tl214373214447_))
                                                      (_hd214369214430_
                                                       (##car _tl214373214447_)))
                                                  (if (##null? _tl214370214432_)
                                                      (let ((_tag214435_
                                                             _hd214369214430_))
                                                        (_K214366214422_
                                                         _tag214435_))
                                                      (_E214357214379_)))
                                                (_E214357214379_))
                                            (if (##eq? _hd214372214445_
                                                       'PortalSuspended)
                                                (if (##null? _tl214373214447_)
                                                    '#!void
                                                    (_E214357214379_))
                                                (___match216521216522_
                                                 _hd214372214445_
                                                 _tl214373214447_)))))
                                  (_E214357214379_))))))
                      (std/misc/channel#channel-close _query-output213739_)
                      (set! _query-output213739_ '#f)
                      (set! _query-token213740_ '#f)
                      (_resync!213746_)))))
                (_close213752_
                 (lambda (_name214293_)
                   (if _query-output213739_
                       (set! _deferred-close213742_
                             (cons _name214293_ _deferred-close213742_))
                       (begin
                         (_send!213743_
                          (cons 'Close (cons '#\S (cons _name214293_ '()))))
                         (_send!213743_ '(Sync))
                         (let* ((_g214294214307_ (_recv!213744_))
                                (_E214297214311_
                                 (lambda ()
                                   (error '"No clause matching"
                                          _g214294214307_))))
                           (let ((_K214303214339_ (lambda () '#!void))
                                 (_K214298214318_
                                  (lambda (_irritants214315_ _msg214316_)
                                    (std/logger#warning
                                     '"error closing statement ~a: ~a"
                                     _name214293_
                                     _msg214316_))))
                             (if (##pair? _g214294214307_)
                                 (let ((_tl214305214344_
                                        (##cdr _g214294214307_))
                                       (_hd214304214342_
                                        (##car _g214294214307_)))
                                   (if (##eq? _hd214304214342_ 'CloseComplete)
                                       (if (##null? _tl214305214344_)
                                           '#!void
                                           (_E214297214311_))
                                       (if (##eq? _hd214304214342_
                                                  'ErrorResponse)
                                           (if (##pair? _tl214305214344_)
                                               (let ((_tl214302214328_
                                                      (##cdr _tl214305214344_))
                                                     (_hd214301214326_
                                                      (##car _tl214305214344_)))
                                                 (let ((_msg214331_
                                                        _hd214301214326_)
                                                       (_irritants214333_
                                                        _tl214302214328_))
                                                   (_K214298214318_
                                                    _irritants214333_
                                                    _msg214331_)))
                                               (_E214297214311_))
                                           (_E214297214311_))))
                                 (_E214297214311_))))
                         (_resync!213746_)))))
                (_shutdown!213753_
                 (lambda ()
                   (_send!213743_ '(Sync))
                   (_resync!213746_)
                   (_send!213743_ '(Terminate))
                   (raise 'shutdown)))
                (_loop213964_
                 (lambda ()
                   (let _loop213975213977_ ()
                     (let ((_next213981_ (thread-mailbox-next)))
                       ((lambda (_$message213984_)
                          (let* ((_$message213986213996_ _$message213984_)
                                 (_else213988214004_
                                  (lambda () (_loop213975213977_)))
                                 (_K213990214269_
                                  (lambda (_$options214007_
                                           _$dest214009_
                                           _$source214011_
                                           _$value214013_)
                                    (let* ((_$value214030214069_
                                            _$value214013_)
                                           (_else214039214077_
                                            (lambda () (_loop213975213977_))))
                                      (let ((_K214063214248_
                                             (lambda (_k214233_
                                                      _sql214234_
                                                      _name214235_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g214236214238_)
                                                  (if '#t
                                                      (let ((_e214241_
                                                             _g214236214238_))
                                                        (std/actor/message#send-message__%
                                                         _$source214011_
                                                         (##structure
                                                          std/actor/proto#!error::t
                                                          _e214241_
                                                          _k214233_)
                                                         '#f
                                                         '#f)
                                                        (if (##structure-instance-of?
                                                             _e214241_
                                                             'std/db/dbi#sql-error::t)
                                                            '#!void
                                                            (raise _e214241_)))
                                                      (raise _g214236214238_)))
                                                (lambda ()
                                                  (let ((_res214245_
                                                         (_prepare213748_
                                                          _name214235_
                                                          _sql214234_)))
                                                    (std/actor/message#send-message__%
                                                     _$source214011_
                                                     (##structure
                                                      std/actor/proto#!value::t
                                                      _res214245_
                                                      _k214233_)
                                                     '#f
                                                     '#f))))))
                                            (_K214058214209_
                                             (lambda (_k214194_
                                                      _params214195_
                                                      _name214196_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g214197214199_)
                                                  (if '#t
                                                      (let ((_e214202_
                                                             _g214197214199_))
                                                        (std/actor/message#send-message__%
                                                         _$source214011_
                                                         (##structure
                                                          std/actor/proto#!error::t
                                                          _e214202_
                                                          _k214194_)
                                                         '#f
                                                         '#f)
                                                        (if (##structure-instance-of?
                                                             _e214202_
                                                             'std/db/dbi#sql-error::t)
                                                            '#!void
                                                            (raise _e214202_)))
                                                      (raise _g214197214199_)))
                                                (lambda ()
                                                  (let ((_res214206_
                                                         (_exec213749_
                                                          _name214196_
                                                          _params214195_)))
                                                    (std/actor/message#send-message__%
                                                     _$source214011_
                                                     (##structure
                                                      std/actor/proto#!value::t
                                                      _res214206_
                                                      _k214194_)
                                                     '#f
                                                     '#f))))))
                                            (_K214053214169_
                                             (lambda (_k214154_
                                                      _params214155_
                                                      _name214156_)
                                               (thread-mailbox-extract-and-rewind)
                                               (with-exception-catcher
                                                (lambda (_g214157214159_)
                                                  (if '#t
                                                      (let ((_e214162_
                                                             _g214157214159_))
                                                        (std/actor/message#send-message__%
                                                         _$source214011_
                                                         (##structure
                                                          std/actor/proto#!error::t
                                                          _e214162_
                                                          _k214154_)
                                                         '#f
                                                         '#f)
                                                        (if (##structure-instance-of?
                                                             _e214162_
                                                             'std/db/dbi#sql-error::t)
                                                            '#!void
                                                            (raise _e214162_)))
                                                      (raise _g214157214159_)))
                                                (lambda ()
                                                  (let ((_res214166_
                                                         (_query-start213750_
                                                          _name214156_
                                                          _params214155_)))
                                                    (std/actor/message#send-message__%
                                                     _$source214011_
                                                     (##structure
                                                      std/actor/proto#!value::t
                                                      _res214166_
                                                      _k214154_)
                                                     '#f
                                                     '#f))))
                                               (_query-pump213751_)))
                                            (_K214050214139_
                                             (lambda (_token214137_)
                                               (thread-mailbox-extract-and-rewind)
                                               (if (eq? _token214137_
                                                        _query-token213740_)
                                                   (_query-pump213751_)
                                                   '#!void)))
                                            (_K214047214122_
                                             (lambda (_token214120_)
                                               (thread-mailbox-extract-and-rewind)
                                               (if (eq? _token214120_
                                                        _query-token213740_)
                                                   (_maybe-sync!213747_)
                                                   '#!void)))
                                            (_K214044214105_
                                             (lambda (_name214103_)
                                               (thread-mailbox-extract-and-rewind)
                                               (_close213752_ _name214103_)))
                                            (_K214042214093_
                                             (lambda ()
                                               (thread-mailbox-extract-and-rewind)
                                               (_shutdown!213753_)))
                                            (_K214041214083_
                                             (lambda (_bogus214081_)
                                               (thread-mailbox-extract-and-rewind)
                                               (std/logger#warning
                                                '"unexpected message: ~a"
                                                _bogus214081_))))
                                        (let ((_try-match214034214150_
                                               (lambda ()
                                                 (if (##structure-direct-instance-of?
                                                      _$value214030214069_
                                                      'std/actor/proto#!event::t)
                                                     (let ((_e214051214142_
                                                            (##vector-ref
                                                             _$value214030214069_
                                                             '1)))
                                                       (if (##structure-direct-instance-of?
                                                            _e214051214142_
                                                            'std/db/postgresql-driver#postgresql.continue::t)
                                                           (let* ((_e214052214145_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           (##vector-ref _e214051214142_ '1))
                          (_token214148_ _e214052214145_))
                     (_K214050214139_ _token214148_))
                   (if (##structure-direct-instance-of?
                        _e214051214142_
                        'std/db/postgresql-driver#postgresql.reset::t)
                       (let* ((_e214049214128_
                               (##vector-ref _e214051214142_ '1))
                              (_token214131_ _e214049214128_))
                         (_K214047214122_ _token214131_))
                       (if (##structure-direct-instance-of?
                            _e214051214142_
                            'std/db/postgresql-driver#postgresql.close::t)
                           (let* ((_e214046214111_
                                   (##vector-ref _e214051214142_ '1))
                                  (_name214114_ _e214046214111_))
                             (_K214044214105_ _name214114_))
                           (if (##structure-direct-instance-of?
                                _e214051214142_
                                'std/db/postgresql-driver#postgresql.shutdown::t)
                               (_K214042214093_)
                               (let ((_bogus214086_ _$value214030214069_))
                                 (_K214041214083_ _bogus214086_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (let ((_bogus214086_
                                                            _$value214030214069_))
                                                       (_K214041214083_
                                                        _bogus214086_))))))
                                          (if (##structure-direct-instance-of?
                                               _$value214030214069_
                                               'std/actor/proto#!call::t)
                                              (let ((_e214064214251_
                                                     (##vector-ref
                                                      _$value214030214069_
                                                      '1)))
                                                (if (##structure-direct-instance-of?
                                                     _e214064214251_
                                                     'std/db/postgresql-driver#postgresql.prepare::t)
                                                    (let* ((_e214066214254_
                                                            (##vector-ref
                                                             _e214064214251_
                                                             '1))
                                                           (_e214067214259_
                                                            (##vector-ref
                                                             _e214064214251_
                                                             '2))
                                                           (_e214065214264_
                                                            (##vector-ref
                                                             _$value214030214069_
                                                             '2)))
                                                      (let ((_name214257_
                                                             _e214066214254_)
                                                            (_sql214262_
                                                             _e214067214259_)
                                                            (_k214267_
                                                             _e214065214264_))
                                                        (_K214063214248_
                                                         _k214267_
                                                         _sql214262_
                                                         _name214257_)))
                                                    (if (##structure-direct-instance-of?
                                                         _e214064214251_
                                                         'std/db/postgresql-driver#postgresql.exec::t)
                                                        (let* ((_e214061214215_
                                                                (##vector-ref
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _e214064214251_
                         '1))
                       (_e214062214220_ (##vector-ref _e214064214251_ '2))
                       (_e214060214225_
                        (##vector-ref _$value214030214069_ '2)))
                  (let ((_name214218_ _e214061214215_)
                        (_params214223_ _e214062214220_)
                        (_k214228_ _e214060214225_))
                    (_K214058214209_ _k214228_ _params214223_ _name214218_)))
                (if (##structure-direct-instance-of?
                     _e214064214251_
                     'std/db/postgresql-driver#postgresql.query::t)
                    (let* ((_e214056214175_ (##vector-ref _e214064214251_ '1))
                           (_e214057214180_ (##vector-ref _e214064214251_ '2))
                           (_e214055214185_
                            (##vector-ref _$value214030214069_ '2)))
                      (let ((_name214178_ _e214056214175_)
                            (_params214183_ _e214057214180_)
                            (_k214188_ _e214055214185_))
                        (_K214053214169_
                         _k214188_
                         _params214183_
                         _name214178_)))
                    (let ((_bogus214086_ _$value214030214069_))
                      (_K214041214083_ _bogus214086_))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (_try-match214034214150_))))))))
                            (if (##structure-direct-instance-of?
                                 _$message213986213996_
                                 'std/actor/message#message::t)
                                (let* ((_e213991214272_
                                        (##vector-ref
                                         _$message213986213996_
                                         '1))
                                       (_$value214275_ _e213991214272_)
                                       (_e213992214277_
                                        (##vector-ref
                                         _$message213986213996_
                                         '2))
                                       (_$source214280_ _e213992214277_)
                                       (_e213993214282_
                                        (##vector-ref
                                         _$message213986213996_
                                         '3))
                                       (_$dest214285_ _e213993214282_)
                                       (_e213994214287_
                                        (##vector-ref
                                         _$message213986213996_
                                         '4))
                                       (_$options214290_ _e213994214287_))
                                  (_K213990214269_
                                   _$options214290_
                                   _$dest214285_
                                   _$source214280_
                                   _$value214275_))
                                (_loop213975213977_))))
                        _next213981_)))
                   (_loop213964_))))
        (with-unwind-protect
         (lambda ()
           (with-exception-catcher
            (lambda (_g213965213968_)
              (if '#t
                  (let ((_e213971_ _g213965213968_))
                    (if (eq? _e213971_ 'shutdown)
                        '#!void
                        (begin
                          (std/logger#log-error
                           '"unhandled exception"
                           _e213971_)
                          (raise _e213971_))))
                  (raise _g213965213968_)))
            (lambda () (_loop213964_))))
         (lambda ()
           (if _query-output213739_
               (begin
                 (std/misc/channel#channel-sync
                  _query-output213739_
                  (make-struct-instance
                   std/db/dbi#sql-error::t
                   '"connection error"
                   '()
                   'postgresql-driver))
                 (std/misc/channel#channel-close _query-output213739_))
               '#!void)
           (close-port _sock213736_))))))
  (define std/db/postgresql-driver#postgresql-send!
    (lambda (_sock213651_ _msg213652_)
      (letrec ((_marshal-and-write213654_
                (lambda (_tid213723_ _body213724_ _marshal213725_)
                  (let* ((_payload213727_ (_marshal213725_ _body213724_))
                         (_payload-len213729_
                          (if (u8vector? _payload213727_)
                              (u8vector-length _payload213727_)
                              (if (##structure-instance-of?
                                   _payload213727_
                                   'std/net/bio/buffer#chunked-output-buffer::t)
                                  (std/net/bio/buffer#chunked-output-length
                                   _payload213727_)
                                  (std/error#raise-io-error
                                   'postgresql-send!
                                   '"unexpected payload"
                                   _tid213723_
                                   _body213724_
                                   _payload213727_)))))
                    (if _tid213723_
                        (write-u8 _tid213723_ _sock213651_)
                        '#!void)
                    (_write-u32213655_
                     (##fx+ _payload-len213729_ '4)
                     _sock213651_)
                    (if (u8vector? _payload213727_)
                        (let ((_len213732_ (u8vector-length _payload213727_)))
                          (if (##fx> _len213732_ '0)
                              (write-subu8vector
                               _payload213727_
                               '0
                               _len213732_
                               _sock213651_)
                              '#!void))
                        (for-each
                         (lambda (_u8v213734_)
                           (write-subu8vector
                            _u8v213734_
                            '0
                            (u8vector-length _u8v213734_)
                            _sock213651_))
                         (std/net/bio/buffer#chunked-output-chunks
                          _payload213727_)))
                    (force-output _sock213651_))))
               (_write-u32213655_
                (lambda (_u32213720_ _sock213721_)
                  (write-u8
                   (##fxand (##fxarithmetic-shift-right _u32213720_ '24) '255)
                   _sock213721_)
                  (write-u8
                   (##fxand (##fxarithmetic-shift-right _u32213720_ '16) '255)
                   _sock213721_)
                  (write-u8
                   (##fxand (##fxarithmetic-shift-right _u32213720_ '8) '255)
                   _sock213721_)
                  (write-u8 (##fxand _u32213720_ '255) _sock213721_))))
        (let* ((_msg213656213663_ _msg213652_)
               (_E213658213667_
                (lambda () (error '"No clause matching" _msg213656213663_)))
               (_K213659213708_
                (lambda (_body213670_ _tag213671_)
                  (let ((_$e213673_
                         (table-ref
                          std/db/postgresql-driver#+frontend-messages+
                          _tag213671_
                          '#f)))
                    (if _$e213673_
                        ((lambda (_e213675213677_)
                           (let* ((_g213679213686_ _e213675213677_)
                                  (_E213681213690_
                                   (lambda ()
                                     (error '"No clause matching"
                                            _g213679213686_)))
                                  (_K213682213696_
                                   (lambda (_marshal213693_ _tid213694_)
                                     (_marshal-and-write213654_
                                      _tid213694_
                                      _body213670_
                                      _marshal213693_))))
                             (if (##pair? _g213679213686_)
                                 (let ((_hd213683213699_
                                        (##car _g213679213686_))
                                       (_tl213684213701_
                                        (##cdr _g213679213686_)))
                                   (let* ((_tid213704_ _hd213683213699_)
                                          (_marshal213706_ _tl213684213701_))
                                     (_K213682213696_
                                      _marshal213706_
                                      _tid213704_)))
                                 (_E213681213690_))))
                         _$e213673_)
                        (if (eq? _tag213671_ 'StartupMessage)
                            (_marshal-and-write213654_
                             '#f
                             _body213670_
                             std/db/postgresql-driver#marshal-startup)
                            (std/error#raise-io-error
                             'postgresql-send!
                             '"cannot marshal; unknown message tag"
                             _msg213652_)))))))
          (if (##pair? _msg213656213663_)
              (let ((_hd213660213711_ (##car _msg213656213663_))
                    (_tl213661213713_ (##cdr _msg213656213663_)))
                (let* ((_tag213716_ _hd213660213711_)
                       (_body213718_ _tl213661213713_))
                  (_K213659213708_ _body213718_ _tag213716_)))
              (_E213658213667_))))))
  (define std/db/postgresql-driver#postgresql-recv!
    (lambda (_sock213577_ _buf213578_)
      (letrec ((_read-u32213580_
                (lambda (_sock213641_ _u8v213642_)
                  (let ((_rd213644_
                         (read-subu8vector _u8v213642_ '0 '4 _sock213641_)))
                    (if (##fx< _rd213644_ '4)
                        (std/error#raise-io-error
                         'postgresql-recv!
                         '"premature end of input"
                         _rd213644_)
                        (let ((_$e213646_
                               (##fxarithmetic-shift-left?
                                (##u8vector-ref _u8v213642_ '0)
                                '24)))
                          (if _$e213646_
                              ((lambda (_bits213649_)
                                 (##fxior _bits213649_
                                          (##fxarithmetic-shift-left
                                           (##u8vector-ref _u8v213642_ '1)
                                           '16)
                                          (##fxarithmetic-shift-left
                                           (##u8vector-ref _u8v213642_ '2)
                                           '8)
                                          (##u8vector-ref _u8v213642_ '3)))
                               _$e213646_)
                              (bitwise-ior
                               (arithmetic-shift
                                (##u8vector-ref _u8v213642_ '0)
                                '24)
                               (##fxarithmetic-shift-left
                                (##u8vector-ref _u8v213642_ '1)
                                '16)
                               (##fxarithmetic-shift-left
                                (##u8vector-ref _u8v213642_ '2)
                                '8)
                               (##u8vector-ref _u8v213642_ '3)))))))))
        (let* ((_tid213582_ (read-u8 _sock213577_))
               (_g216626_
                (if (eof-object? _tid213582_)
                    (std/error#raise-io-error
                     'postgresql-recv!
                     '"connection closed")
                    '#!void))
               (_payload-len213585_
                (_read-u32213580_ _sock213577_ (unbox _buf213578_)))
               (_payload-len213587_ (##fx- _payload-len213585_ '4))
               (_u8buf213593_
                (let ((_u8buf213589_ (unbox _buf213578_)))
                  (if (##fx< (u8vector-length _u8buf213589_)
                             _payload-len213587_)
                      (let ((_u8buf213591_
                             (make-u8vector _payload-len213587_)))
                        (set-box! _buf213578_ _u8buf213591_)
                        _u8buf213591_)
                      _u8buf213589_)))
               (_rd213595_
                (if (##fx> _payload-len213587_ '0)
                    (read-subu8vector
                     _u8buf213593_
                     '0
                     _payload-len213587_
                     _sock213577_)
                    '0))
               (_g216627_
                (if (##fx< _rd213595_ _payload-len213587_)
                    (std/error#raise-io-error
                     'postgresql-recv!
                     '"premature end of input"
                     _rd213595_
                     _tid213582_
                     _payload-len213587_)
                    '#!void))
               (_bio213598_
                (std/net/bio/buffer#open-input-buffer__%
                 _u8buf213593_
                 '0
                 _payload-len213587_)))
          (let ((_$e213601_
                 (vector-ref
                  std/db/postgresql-driver#+backend-messages+
                  _tid213582_)))
            (if _$e213601_
                ((lambda (_e213603213605_)
                   (let* ((_g213607213614_ _e213603213605_)
                          (_E213609213618_
                           (lambda ()
                             (error '"No clause matching" _g213607213614_)))
                          (_K213610213629_
                           (lambda (_unmarshal213621_ _tag213622_)
                             (let* ((_body213624_
                                     (_unmarshal213621_ _bio213598_))
                                    (_msg213626_
                                     (cons _tag213622_ _body213624_)))
                               _msg213626_))))
                     (if (##pair? _g213607213614_)
                         (let ((_hd213611213632_ (##car _g213607213614_))
                               (_tl213612213634_ (##cdr _g213607213614_)))
                           (let* ((_tag213637_ _hd213611213632_)
                                  (_unmarshal213639_ _tl213612213634_))
                             (_K213610213629_ _unmarshal213639_ _tag213637_)))
                         (_E213609213618_))))
                 _$e213601_)
                (std/error#raise-io-error
                 'postgresql-recv!
                 '"unexpected backend message"
                 _tid213582_)))))))
  (define std/db/postgresql-driver#unmarshal-ignore
    (lambda (_bio213575_) '(...)))
  (define std/db/postgresql-driver#unmarshal-empty (lambda (_bio213573_) '()))
  (define std/db/postgresql-driver#unmarshal-authen-request
    (lambda (_bio213545_)
      (let* ((_t213547_ (std/net/bio/input#bio-read-u32 _bio213545_))
             (_$e213549_ _t213547_))
        (let ((_default213551213555_
               (lambda () (cons _t213547_ (cons '... '()))))
              (_table213552213557_ '#(0 #f 1 2 #f 3 4 5 6 7 8 9 10)))
          (if (fixnum? _$e213549_)
              (if (and (##fx>= _$e213549_ '0) (##fx< _$e213549_ '13))
                  (let ((_x213560_
                         (##vector-ref _table213552213557_ _$e213549_)))
                    (if _x213560_
                        (if (##fx< _x213560_ '5)
                            (if (##fx< _x213560_ '2)
                                (if (##fx= _x213560_ '0)
                                    '(AuthenticationOk)
                                    '(AuthenticationKerberosV5))
                                (if (##fx= _x213560_ '2)
                                    '(AuthenticationCleartextPassword)
                                    (if (##fx= _x213560_ '3)
                                        (let ((_salt213563_
                                               (make-u8vector '4)))
                                          (std/net/bio/input#bio-read-bytes
                                           _salt213563_
                                           _bio213545_)
                                          (cons 'AuthenticationMD5Password
                                                (cons _salt213563_ '())))
                                        '(AuthenticationSCMCredential))))
                            (if (##fx< _x213560_ '8)
                                (if (##fx= _x213560_ '5)
                                    '(AuthenticationGSS)
                                    (if (##fx= _x213560_ '6)
                                        (let ((_data213565_
                                               (std/db/postgresql-driver#unmarshal-bytes-rest
                                                _bio213545_)))
                                          (cons 'AuthenticationGSSContinue
                                                (cons _data213565_ '())))
                                        '(AuthenticationSSPI)))
                                (if (##fx= _x213560_ '8)
                                    (let ((_mechanisms213567_
                                           (std/db/postgresql-driver#unmarshal-string-list
                                            _bio213545_)))
                                      (cons 'AuthenticationSASL
                                            _mechanisms213567_))
                                    (if (##fx= _x213560_ '9)
                                        (let ((_data213569_
                                               (std/db/postgresql-driver#unmarshal-string-rest
                                                _bio213545_)))
                                          (cons 'AuthenticationSASLContinue
                                                (cons _data213569_ '())))
                                        (let ((_data213571_
                                               (std/db/postgresql-driver#unmarshal-string-rest
                                                _bio213545_)))
                                          (cons 'AuthenticationSASLFinal
                                                (cons _data213571_ '())))))))
                        (_default213551213555_)))
                  (_default213551213555_))
              (_default213551213555_))))))
  (define std/db/postgresql-driver#unmarshal-string-list
    (lambda (_bio213537_)
      (let _lp213539_ ((_r213541_ '()))
        (let ((_next213543_
               (std/db/postgresql-driver#unmarshal-string _bio213537_)))
          (if (string-empty? _next213543_)
              (reverse _r213541_)
              (_lp213539_ (cons _next213543_ _r213541_)))))))
  (define std/db/postgresql-driver#unmarshal-string
    (lambda (_bio213529_)
      (let _lp213531_ ((_bytes213533_ '()))
        (let ((_next213535_ (std/net/bio/input#bio-read-u8 _bio213529_)))
          (if (##fx= _next213535_ '0)
              (std/text/utf8#utf8->string__0
               (list->u8vector (reverse _bytes213533_)))
              (_lp213531_ (cons _next213535_ _bytes213533_)))))))
  (define std/db/postgresql-driver#unmarshal-bytes-rest
    (lambda (_bio213522_)
      (let* ((_count213524_ (std/net/bio/input#bio-input-count _bio213522_))
             (_data213526_ (make-u8vector _count213524_)))
        (std/net/bio/input#bio-read-bytes _data213526_ _bio213522_)
        _data213526_)))
  (define std/db/postgresql-driver#unmarshal-string-rest
    (lambda (_bio213518_)
      (let ((_count213520_ (std/net/bio/input#bio-input-count _bio213518_)))
        (std/net/bio/input#bio-input-utf8-decode _count213520_ _bio213518_))))
  (define std/db/postgresql-driver#unmarshal-complete
    (lambda (_bio213514_)
      (let ((_tag213516_
             (std/db/postgresql-driver#unmarshal-string _bio213514_)))
        (cons _tag213516_ '()))))
  (define std/db/postgresql-driver#unmarshal-data-row
    (lambda (_bio213501_)
      (let ((_count213503_ (std/net/bio/input#bio-read-u16 _bio213501_)))
        (let _lp213505_ ((_i213507_ '0) (_r213508_ '()))
          (if (##fx< _i213507_ _count213503_)
              (let ((_len213510_ (std/net/bio/input#bio-read-s32 _bio213501_)))
                (if (##fx>= _len213510_ '0)
                    (let ((_str213512_
                           (std/net/bio/input#bio-input-utf8-decode
                            _len213510_
                            _bio213501_)))
                      (_lp213505_
                       (##fx+ _i213507_ '1)
                       (cons _str213512_ _r213508_)))
                    (_lp213505_ (##fx+ _i213507_ '1) (cons '#f _r213508_))))
              (reverse _r213508_))))))
  (define std/db/postgresql-driver#unmarshal-error-notice
    (lambda (_bio213486_)
      (let _lp213488_ ((_r213490_ '()))
        (let ((_t213492_ (std/net/bio/input#bio-read-u8 _bio213486_)))
          (if (##fx= _t213492_ '0)
              (let* ((_alist213494_ (reverse _r213490_))
                     (_msg213496_ (assgetq '#\M _alist213494_)))
                (cons _msg213496_ _alist213494_))
              (let ((_field213499_
                     (std/db/postgresql-driver#unmarshal-string _bio213486_)))
                (_lp213488_
                 (cons (cons (integer->char _t213492_) _field213499_)
                       _r213490_))))))))
  (define std/db/postgresql-driver#unmarshal-param-description
    (lambda (_bio213475_)
      (let ((_count213477_ (std/net/bio/input#bio-read-u16 _bio213475_)))
        (let _lp213479_ ((_i213481_ '0) (_r213482_ '()))
          (if (##fx< _i213481_ _count213477_)
              (let ((_oid213484_ (std/net/bio/input#bio-read-u32 _bio213475_)))
                (_lp213479_ (##fx+ _i213481_ '1) (cons _oid213484_ _r213482_)))
              (reverse _r213482_))))))
  (define std/db/postgresql-driver#unmarshal-row-description
    (lambda (_bio213451_)
      (let ((_count213453_ (std/net/bio/input#bio-read-u16 _bio213451_)))
        (let _lp213455_ ((_i213457_ '0) (_r213458_ '()))
          (if (##fx< _i213457_ _count213453_)
              (let* ((_field-name213460_
                      (std/db/postgresql-driver#unmarshal-string _bio213451_))
                     (_table-id213462_
                      (std/net/bio/input#bio-read-u32 _bio213451_))
                     (_attr-id213464_
                      (std/net/bio/input#bio-read-u16 _bio213451_))
                     (_type-id213466_
                      (std/net/bio/input#bio-read-u32 _bio213451_))
                     (_type-sz213468_
                      (std/net/bio/input#bio-read-s16 _bio213451_))
                     (_modifier213470_
                      (std/net/bio/input#bio-read-s32 _bio213451_))
                     (_fmt213472_
                      (std/net/bio/input#bio-read-u16 _bio213451_)))
                (_lp213455_
                 (##fx+ _i213457_ '1)
                 (cons (cons _field-name213460_
                             (cons _table-id213462_
                                   (cons _attr-id213464_
                                         (cons _type-id213466_
                                               (cons _type-sz213468_
                                                     (cons _modifier213470_
                                                           (cons _fmt213472_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         '())))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                       _r213458_)))
              (reverse _r213458_))))))
  (define std/db/postgresql-driver#unmarshal-ready
    (lambda (_bio213447_)
      (let ((_status213449_ (std/net/bio/input#bio-read-u8 _bio213447_)))
        (cons (integer->char _status213449_) '()))))
  (define std/db/postgresql-driver#marshal-fail
    (lambda (_what213443_)
      (lambda (_body213445_)
        (std/error#raise-io-error
         'postgresql-send!
         '"Cannot marshal; unsupported message"
         (cons _what213443_ _body213445_)))))
  (define std/db/postgresql-driver#marshal-empty
    (lambda (_body213441_) '#u8()))
  (define std/db/postgresql-driver#marshal-string
    (lambda (_str213438_ _bio213439_)
      (std/net/bio/output#bio-write-string _str213438_ _bio213439_)
      (std/net/bio/output#bio-write-u8 '0 _bio213439_)))
  (define std/db/postgresql-driver#marshal-startup
    (lambda (_body213372_)
      (let* ((_body213373213387_ _body213372_)
             (_E213375213391_
              (lambda () (error '"No clause matching" _body213373213387_)))
             (_K213376213402_
              (lambda (_value213394_ _param213395_)
                (let ((_bio213397_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/net/bio/output#bio-write-u32 '196608 _bio213397_)
                  (for-each
                   (lambda (_param213399_ _value213400_)
                     (std/db/postgresql-driver#marshal-string
                      _param213399_
                      _bio213397_)
                     (std/db/postgresql-driver#marshal-string
                      _value213400_
                      _bio213397_))
                   _param213395_
                   _value213394_)
                  (std/net/bio/output#bio-write-u8 '0 _bio213397_)))))
        (letrec ((_splice-rest213379213405_
                  (lambda (_rest213383213412_ _value213414_ _param213415_)
                    (if (##null? _rest213383213412_)
                        (_K213376213402_ _value213414_ _param213415_)
                        (_E213375213391_))))
                 (_splice-try213381213407_
                  (lambda (_hd213382213417_
                           _rest213383213419_
                           _value213377213420_
                           _param213378213422_)
                    (if (##pair? _hd213382213417_)
                        (let ((_hd213384213425_ (##car _hd213382213417_))
                              (_tl213385213427_ (##cdr _hd213382213417_)))
                          (let* ((_param213430_ _hd213384213425_)
                                 (_value213432_ _tl213385213427_))
                            (_splice-loop213380213409_
                             (##cdr _rest213383213419_)
                             (cons _value213432_ _value213377213420_)
                             (cons _param213430_ _param213378213422_))))
                        (_splice-rest213379213405_
                         _rest213383213419_
                         (reverse _value213377213420_)
                         (reverse _param213378213422_)))))
                 (_splice-loop213380213409_
                  (lambda (_rest213383213434_
                           _value213377213435_
                           _param213378213436_)
                    (if (pair? _rest213383213434_)
                        (_splice-try213381213407_
                         (##car _rest213383213434_)
                         _rest213383213434_
                         _value213377213435_
                         _param213378213436_)
                        (_splice-rest213379213405_
                         _rest213383213434_
                         (reverse _value213377213435_)
                         (reverse _param213378213436_))))))
          (_splice-loop213380213409_ _body213373213387_ '() '())))))
  (define std/db/postgresql-driver#marshal-bind
    (lambda (_body213326_)
      (let* ((_body213327213336_ _body213326_)
             (_E213329213340_
              (lambda () (error '"No clause matching" _body213327213336_)))
             (_K213330213353_
              (lambda (_params213343_ _stmt-name213344_ _portal-name213345_)
                (let ((_bio213347_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _portal-name213345_
                   _bio213347_)
                  (std/db/postgresql-driver#marshal-string
                   _stmt-name213344_
                   _bio213347_)
                  (std/net/bio/output#bio-write-u16 '0 _bio213347_)
                  (std/net/bio/output#bio-write-u16
                   (length _params213343_)
                   _bio213347_)
                  (for-each
                   (lambda (_param213349_)
                     (if (not _param213349_)
                         (std/net/bio/output#bio-write-s32 '-1 _bio213347_)
                         (if (string? _param213349_)
                             (let ((_len213351_
                                    (std/text/utf8#string-utf8-length__0
                                     _param213349_)))
                               (std/net/bio/output#bio-write-u32
                                _len213351_
                                _bio213347_)
                               (std/net/bio/output#bio-write-string
                                _param213349_
                                _bio213347_))
                             (if (u8vector? _param213349_)
                                 (begin
                                   (std/net/bio/output#bio-write-u32
                                    (u8vector-length _param213349_)
                                    _bio213347_)
                                   (std/net/bio/output#bio-write-bytes
                                    _param213349_
                                    _bio213347_))
                                 (std/error#raise-io-error
                                  'postgresql-send!
                                  '"Cannot marshal; bad parameter"
                                  _param213349_)))))
                   _params213343_)
                  (std/net/bio/output#bio-write-u16 '0 _bio213347_)
                  _bio213347_))))
        (if (##pair? _body213327213336_)
            (let ((_hd213331213356_ (##car _body213327213336_))
                  (_tl213332213358_ (##cdr _body213327213336_)))
              (let ((_portal-name213361_ _hd213331213356_))
                (if (##pair? _tl213332213358_)
                    (let ((_hd213333213363_ (##car _tl213332213358_))
                          (_tl213334213365_ (##cdr _tl213332213358_)))
                      (let* ((_stmt-name213368_ _hd213333213363_)
                             (_params213370_ _tl213334213365_))
                        (_K213330213353_
                         _params213370_
                         _stmt-name213368_
                         _portal-name213361_)))
                    (_E213329213340_))))
            (_E213329213340_)))))
  (define std/db/postgresql-driver#marshal-close
    (lambda (_body213324_)
      (std/db/postgresql-driver#marshal-describe _body213324_)))
  (define std/db/postgresql-driver#marshal-describe
    (lambda (_body213285_)
      (let* ((_body213286213295_ _body213285_)
             (_E213288213299_
              (lambda () (error '"No clause matching" _body213286213295_)))
             (_K213289213307_
              (lambda (_name213302_ _what213303_)
                (let ((_bio213305_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/net/bio/output#bio-write-u8
                   (char->integer _what213303_)
                   _bio213305_)
                  (std/db/postgresql-driver#marshal-string
                   _name213302_
                   _bio213305_)
                  _bio213305_))))
        (if (##pair? _body213286213295_)
            (let ((_hd213290213310_ (##car _body213286213295_))
                  (_tl213291213312_ (##cdr _body213286213295_)))
              (let ((_what213315_ _hd213290213310_))
                (if (##pair? _tl213291213312_)
                    (let ((_hd213292213317_ (##car _tl213291213312_))
                          (_tl213293213319_ (##cdr _tl213291213312_)))
                      (let ((_name213322_ _hd213292213317_))
                        (if (##null? _tl213293213319_)
                            (_K213289213307_ _name213322_ _what213315_)
                            (_E213288213299_))))
                    (_E213288213299_))))
            (_E213288213299_)))))
  (define std/db/postgresql-driver#marshal-exec
    (lambda (_body213246_)
      (let* ((_body213247213256_ _body213246_)
             (_E213249213260_
              (lambda () (error '"No clause matching" _body213247213256_)))
             (_K213250213268_
              (lambda (_limit213263_ _portal213264_)
                (let ((_bio213266_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _portal213264_
                   _bio213266_)
                  (std/net/bio/output#bio-write-u32 '0 _bio213266_)
                  _bio213266_))))
        (if (##pair? _body213247213256_)
            (let ((_hd213251213271_ (##car _body213247213256_))
                  (_tl213252213273_ (##cdr _body213247213256_)))
              (let ((_portal213276_ _hd213251213271_))
                (if (##pair? _tl213252213273_)
                    (let ((_hd213253213278_ (##car _tl213252213273_))
                          (_tl213254213280_ (##cdr _tl213252213273_)))
                      (let ((_limit213283_ _hd213253213278_))
                        (if (##null? _tl213254213280_)
                            (_K213250213268_ _limit213283_ _portal213276_)
                            (_E213249213260_))))
                    (_E213249213260_))))
            (_E213249213260_)))))
  (define std/db/postgresql-driver#marshal-parse
    (lambda (_body213207_)
      (let* ((_body213208213217_ _body213207_)
             (_E213210213221_
              (lambda () (error '"No clause matching" _body213208213217_)))
             (_K213211213229_
              (lambda (_sql213224_ _stmt213225_)
                (let ((_bio213227_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _stmt213225_
                   _bio213227_)
                  (std/db/postgresql-driver#marshal-string
                   _sql213224_
                   _bio213227_)
                  (std/net/bio/output#bio-write-u16 '0 _bio213227_)
                  _bio213227_))))
        (if (##pair? _body213208213217_)
            (let ((_hd213212213232_ (##car _body213208213217_))
                  (_tl213213213234_ (##cdr _body213208213217_)))
              (let ((_stmt213237_ _hd213212213232_))
                (if (##pair? _tl213213213234_)
                    (let ((_hd213214213239_ (##car _tl213213213234_))
                          (_tl213215213241_ (##cdr _tl213213213234_)))
                      (let ((_sql213244_ _hd213214213239_))
                        (if (##null? _tl213215213241_)
                            (_K213211213229_ _sql213244_ _stmt213237_)
                            (_E213210213221_))))
                    (_E213210213221_))))
            (_E213210213221_)))))
  (define std/db/postgresql-driver#marshal-passwd
    (lambda (_body213178_)
      (let* ((_body213179213186_ _body213178_)
             (_E213181213190_
              (lambda () (error '"No clause matching" _body213179213186_)))
             (_K213182213197_
              (lambda (_passwd213193_)
                (let ((_bio213195_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _passwd213193_
                   _bio213195_)
                  _bio213195_))))
        (if (##pair? _body213179213186_)
            (let ((_hd213183213200_ (##car _body213179213186_))
                  (_tl213184213202_ (##cdr _body213179213186_)))
              (let ((_passwd213205_ _hd213183213200_))
                (if (##null? _tl213184213202_)
                    (_K213182213197_ _passwd213205_)
                    (_E213181213190_))))
            (_E213181213190_)))))
  (define std/db/postgresql-driver#marshal-query
    (lambda (_body213149_)
      (let* ((_body213150213157_ _body213149_)
             (_E213152213161_
              (lambda () (error '"No clause matching" _body213150213157_)))
             (_K213153213168_
              (lambda (_sql213164_)
                (let ((_bio213166_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _sql213164_
                   _bio213166_)
                  _bio213166_))))
        (if (##pair? _body213150213157_)
            (let ((_hd213154213171_ (##car _body213150213157_))
                  (_tl213155213173_ (##cdr _body213150213157_)))
              (let ((_sql213176_ _hd213154213171_))
                (if (##null? _tl213155213173_)
                    (_K213153213168_ _sql213176_)
                    (_E213152213161_))))
            (_E213152213161_)))))
  (define std/db/postgresql-driver#marshal-sasl-initial-reponse
    (lambda (_body213108_)
      (let* ((_body213109213118_ _body213108_)
             (_E213111213122_
              (lambda () (error '"No clause matching" _body213109213118_)))
             (_K213112213132_
              (lambda (_data213125_ _mechanism213126_)
                (let ((_bio213128_
                       (std/net/bio/buffer#open-serializer-output-buffer__0)))
                  (std/db/postgresql-driver#marshal-string
                   _mechanism213126_
                   _bio213128_)
                  (if _data213125_
                      (let ((_len213130_
                             (std/text/utf8#string-utf8-length__0
                              _data213125_)))
                        (std/net/bio/output#bio-write-u32
                         _len213130_
                         _bio213128_)
                        (std/net/bio/output#bio-write-string
                         _data213125_
                         _bio213128_))
                      (std/net/bio/output#bio-write-s32 '-1 _bio213128_))
                  _bio213128_))))
        (if (##pair? _body213109213118_)
            (let ((_hd213113213135_ (##car _body213109213118_))
                  (_tl213114213137_ (##cdr _body213109213118_)))
              (let ((_mechanism213140_ _hd213113213135_))
                (if (##pair? _tl213114213137_)
                    (let ((_hd213115213142_ (##car _tl213114213137_))
                          (_tl213116213144_ (##cdr _tl213114213137_)))
                      (let ((_data213147_ _hd213115213142_))
                        (if (##null? _tl213116213144_)
                            (_K213112213132_ _data213147_ _mechanism213140_)
                            (_E213111213122_))))
                    (_E213111213122_))))
            (_E213111213122_)))))
  (define std/db/postgresql-driver#marshal-sasl-response
    (lambda (_body213081_)
      (let* ((_body213082213089_ _body213081_)
             (_E213084213093_
              (lambda () (error '"No clause matching" _body213082213089_)))
             (_K213085213098_
              (lambda (_data213096_)
                (std/text/utf8#string->utf8__0 _data213096_))))
        (if (##pair? _body213082213089_)
            (let ((_hd213086213101_ (##car _body213082213089_))
                  (_tl213087213103_ (##cdr _body213082213089_)))
              (let ((_data213106_ _hd213086213101_))
                (if (##null? _tl213087213103_)
                    (std/text/utf8#string->utf8__0 _data213106_)
                    (_E213084213093_))))
            (_E213084213093_)))))
  (define std/db/postgresql-driver#+backend-messages+ (make-vector '256 '#f))
  (define std/db/postgresql-driver#+frontend-messages+ (make-table 'test: eq?))
  (let ((_t213079_ (char->integer '#\R)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213079_
     (cons 'AuthenticationRequest
           std/db/postgresql-driver#unmarshal-authen-request)))
  (let ((_t213077_ (char->integer '#\K)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213077_
     (cons 'BackendKeyData std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213075_ (char->integer '#\2)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213075_
     (cons 'BindComplete std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t213073_ (char->integer '#\3)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213073_
     (cons 'CloseComplete std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t213071_ (char->integer '#\C)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213071_
     (cons 'CommandComplete std/db/postgresql-driver#unmarshal-complete)))
  (let ((_t213069_ (char->integer '#\d)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213069_
     (cons 'CopyData std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213067_ (char->integer '#\c)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213067_
     (cons 'CopyDone std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213065_ (char->integer '#\G)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213065_
     (cons 'CopyInResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213063_ (char->integer '#\H)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213063_
     (cons 'CopyOutResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213061_ (char->integer '#\W)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213061_
     (cons 'CopyBothResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213059_ (char->integer '#\D)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213059_
     (cons 'DataRow std/db/postgresql-driver#unmarshal-data-row)))
  (let ((_t213057_ (char->integer '#\I)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213057_
     (cons 'EmptyQueryResponse std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t213055_ (char->integer '#\E)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213055_
     (cons 'ErrorResponse std/db/postgresql-driver#unmarshal-error-notice)))
  (let ((_t213053_ (char->integer '#\V)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213053_
     (cons 'FunctionCallResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213051_ (char->integer '#\v)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213051_
     (cons 'NegotiateProtocolVersion
           std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213049_ (char->integer '#\n)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213049_
     (cons 'NoData std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t213047_ (char->integer '#\N)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213047_
     (cons 'NoticeResponse std/db/postgresql-driver#unmarshal-error-notice)))
  (let ((_t213045_ (char->integer '#\A)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213045_
     (cons 'NotificationResponse std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213043_ (char->integer '#\t)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213043_
     (cons 'ParameterDescription
           std/db/postgresql-driver#unmarshal-param-description)))
  (let ((_t213041_ (char->integer '#\S)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213041_
     (cons 'ParameterStatus std/db/postgresql-driver#unmarshal-ignore)))
  (let ((_t213039_ (char->integer '#\1)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213039_
     (cons 'ParseComplete std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t213037_ (char->integer '#\s)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213037_
     (cons 'PortalSuspended std/db/postgresql-driver#unmarshal-empty)))
  (let ((_t213035_ (char->integer '#\Z)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213035_
     (cons 'ReadyForQuery std/db/postgresql-driver#unmarshal-ready)))
  (let ((_t213032_ (char->integer '#\T)))
    (vector-set!
     std/db/postgresql-driver#+backend-messages+
     _t213032_
     (cons 'RowDescription
           std/db/postgresql-driver#unmarshal-row-description)))
  (let ((_t213030_ (char->integer '#\B)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Bind
     (cons _t213030_ std/db/postgresql-driver#marshal-bind)))
  (let ((_t213028_ (char->integer '#\C)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Close
     (cons _t213028_ std/db/postgresql-driver#marshal-close)))
  (let ((_t213026_ (char->integer '#\d)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'CopyData
     (cons _t213026_ (std/db/postgresql-driver#marshal-fail 'CopyData))))
  (let ((_t213024_ (char->integer '#\c)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'CopyDone
     (cons _t213024_ (std/db/postgresql-driver#marshal-fail 'CopyDone))))
  (let ((_t213022_ (char->integer '#\f)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'CopyFail
     (cons _t213022_ (std/db/postgresql-driver#marshal-fail 'CopyFail))))
  (let ((_t213020_ (char->integer '#\D)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Describe
     (cons _t213020_ std/db/postgresql-driver#marshal-describe)))
  (let ((_t213018_ (char->integer '#\E)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Execute
     (cons _t213018_ std/db/postgresql-driver#marshal-exec)))
  (let ((_t213016_ (char->integer '#\H)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Flush
     (cons _t213016_ std/db/postgresql-driver#marshal-empty)))
  (let ((_t213014_ (char->integer '#\F)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'FunctionCall
     (cons _t213014_ (std/db/postgresql-driver#marshal-fail 'FunctionCall))))
  (let ((_t213012_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'GSSResponse
     (cons _t213012_ (std/db/postgresql-driver#marshal-fail 'GSSResponse))))
  (let ((_t213010_ (char->integer '#\P)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Parse
     (cons _t213010_ std/db/postgresql-driver#marshal-parse)))
  (let ((_t213008_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'PasswordMessage
     (cons _t213008_ std/db/postgresql-driver#marshal-passwd)))
  (let ((_t213006_ (char->integer '#\Q)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Query
     (cons _t213006_ std/db/postgresql-driver#marshal-query)))
  (let ((_t213004_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'SASLInitialResponse
     (cons _t213004_ std/db/postgresql-driver#marshal-sasl-initial-reponse)))
  (let ((_t213002_ (char->integer '#\p)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'SASLResponse
     (cons _t213002_ std/db/postgresql-driver#marshal-sasl-response)))
  (let ((_t213000_ (char->integer '#\S)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Sync
     (cons _t213000_ std/db/postgresql-driver#marshal-empty)))
  (let ((_t212997_ (char->integer '#\X)))
    (table-set!
     std/db/postgresql-driver#+frontend-messages+
     'Terminate
     (cons _t212997_ std/db/postgresql-driver#marshal-empty))))
