(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/event#wait__%
    (lambda (_sel29821_ _timeo29822_)
      (if (std/event#maybe-timeout? _timeo29822_)
          (let ((_wait-e29824_ (std/event#selector-wait-e _sel29821_)))
            (if (_wait-e29824_ _sel29821_ _timeo29822_) _sel29821_ '#f))
          (error '"Bad argument; expected timeout or #f" _timeo29822_))))
  (define std/event#wait__0
    (lambda (_sel29829_)
      (let ((_timeo29831_ '#f)) (std/event#wait__% _sel29829_ _timeo29831_))))
  (define std/event#wait
    (lambda _g29937_
      (let ((_g29936_ (length _g29937_)))
        (cond ((##fx= _g29936_ 1) (apply std/event#wait__0 _g29937_))
              ((##fx= _g29936_ 2) (apply std/event#wait__% _g29937_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/event#wait
                _g29937_))))))
  (define std/event#select__%
    (lambda (_sels29767_ _timeo29768_)
      (let* ((_sels2976929779_ _sels29767_)
             (_else2977229787_
              (lambda ()
                (if (std/event#maybe-timeout? _timeo29768_)
                    (std/event#do-select _sels29767_ _timeo29768_)
                    (error '"Bad argument; expected timeout or #f"
                           _timeo29768_)))))
        (let ((_K2977729807_ (lambda () (error '"empty selection set")))
              (_K2977429793_
               (lambda (_sel29791_)
                 (std/event#wait__% _sel29791_ _timeo29768_))))
          (let ((_try-match2977129803_
                 (lambda ()
                   (if (##pair? _sels2976929779_)
                       (let ((_tl2977629798_ (##cdr _sels2976929779_))
                             (_hd2977529796_ (##car _sels2976929779_)))
                         (if (##null? _tl2977629798_)
                             (let ((_sel29801_ _hd2977529796_))
                               (_K2977429793_ _sel29801_))
                             (_else2977229787_)))
                       (_else2977229787_)))))
            (if (##null? _sels2976929779_)
                (_K2977729807_)
                (_try-match2977129803_)))))))
  (define std/event#select__0
    (lambda (_sels29813_)
      (let ((_timeo29815_ '#f))
        (std/event#select__% _sels29813_ _timeo29815_))))
  (define std/event#select
    (lambda _g29939_
      (let ((_g29938_ (length _g29939_)))
        (cond ((##fx= _g29938_ 1) (apply std/event#select__0 _g29939_))
              ((##fx= _g29938_ 2) (apply std/event#select__% _g29939_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/event#select
                _g29939_))))))
  (define std/event#selection::t
    (make-struct-type
     'std/event#selection::t
     '#f
     '3
     'selection
     '((final: . #t))
     '#f
     '(e mx cv)))
  (define std/event#selection? (make-struct-predicate std/event#selection::t))
  (define std/event#make-selection
    (lambda _$args29763_
      (apply make-struct-instance std/event#selection::t _$args29763_)))
  (define std/event#selection-e
    (make-struct-field-accessor std/event#selection::t '0))
  (define std/event#selection-mx
    (make-struct-field-accessor std/event#selection::t '1))
  (define std/event#selection-cv
    (make-struct-field-accessor std/event#selection::t '2))
  (define std/event#selection-e-set!
    (make-struct-field-mutator std/event#selection::t '0))
  (define std/event#selection-mx-set!
    (make-struct-field-mutator std/event#selection::t '1))
  (define std/event#selection-cv-set!
    (make-struct-field-mutator std/event#selection::t '2))
  (define std/event#selector::t
    (make-struct-type
     'std/event#selector::t
     '#f
     '3
     'selector
     '((final: . #t))
     '#f
     '(sel wait abort)))
  (define std/event#selector? (make-struct-predicate std/event#selector::t))
  (define std/event#make-selector
    (lambda _$args29760_
      (apply make-struct-instance std/event#selector::t _$args29760_)))
  (define std/event#selector-sel
    (make-struct-field-accessor std/event#selector::t '0))
  (define std/event#selector-wait
    (make-struct-field-accessor std/event#selector::t '1))
  (define std/event#selector-abort
    (make-struct-field-accessor std/event#selector::t '2))
  (define std/event#selector-sel-set!
    (make-struct-field-mutator std/event#selector::t '0))
  (define std/event#selector-wait-set!
    (make-struct-field-mutator std/event#selector::t '1))
  (define std/event#selector-abort-set!
    (make-struct-field-mutator std/event#selector::t '2))
  (define std/event#do-select
    (lambda (_sels29729_ _timeo29730_)
      (let* ((_xsels29732_ (map std/event#wrap-selector _sels29729_))
             (_mx29734_ (make-mutex 'select))
             (_cv29736_ (make-condition-variable 'select))
             (_selection29738_
              (##structure std/event#selection::t '#f _mx29734_ _cv29736_))
             (_threads29742_
              (map (lambda (_xsel29740_)
                     (gerbil/gambit/threads#spawn/name
                      'select
                      std/event#select1
                      _selection29738_
                      _xsel29740_))
                   _xsels29732_))
             (_abs-timeo29744_
              (if _timeo29730_
                  (std/event#timeout->abs-timeout _timeo29730_)
                  absent-obj))
             (_finalize!29749_
              (lambda ()
                (for-each thread-terminate! _threads29742_)
                (for-each
                 (lambda (_xsel29747_)
                   ((##direct-structure-ref
                     _xsel29747_
                     '3
                     std/event#selector::t
                     '#f)
                    (##direct-structure-ref
                     _xsel29747_
                     '1
                     std/event#selector::t
                     '#f)))
                 _xsels29732_))))
        (let _lp29752_ ()
          (mutex-lock! _mx29734_)
          (let ((_$e29755_
                 (##direct-structure-ref
                  _selection29738_
                  '1
                  std/event#selection::t
                  '#f)))
            (if _$e29755_
                ((lambda (_xsel29758_)
                   (mutex-unlock! _mx29734_)
                   (_finalize!29749_)
                   (##direct-structure-ref
                    _xsel29758_
                    '1
                    std/event#selector::t
                    '#f))
                 _$e29755_)
                (if (mutex-unlock! _mx29734_ _cv29736_ _abs-timeo29744_)
                    (_lp29752_)
                    (begin (_finalize!29749_) '#f))))))))
  (define std/event#select1
    (lambda (_selection29726_ _xsel29727_)
      (if ((##direct-structure-ref _xsel29727_ '2 std/event#selector::t '#f)
           (##direct-structure-ref _xsel29727_ '1 std/event#selector::t '#f)
           '#f)
          (begin
            (mutex-lock!
             (##direct-structure-ref
              _selection29726_
              '2
              std/event#selection::t
              '#f))
            (if (##direct-structure-ref
                 _selection29726_
                 '1
                 std/event#selection::t
                 '#f)
                '#!void
                (begin
                  (##direct-structure-set!
                   _selection29726_
                   _xsel29727_
                   '1
                   std/event#selection::t
                   '#f)
                  (condition-variable-signal!
                   (##direct-structure-ref
                    _selection29726_
                    '3
                    std/event#selection::t
                    '#f))))
            (mutex-unlock!
             (##direct-structure-ref
              _selection29726_
              '2
              std/event#selection::t
              '#f)))
          '#!void)))
  (define std/event#wrap-selector
    (lambda (_sel29724_)
      (if (thread? _sel29724_)
          (##structure
           std/event#selector::t
           _sel29724_
           std/event#selector-wait-thread
           void)
          (if (and (pair? _sel29724_)
                   (mutex? (car _sel29724_))
                   (condition-variable? (cdr _sel29724_)))
              (if (eq? (current-thread)
                       (macro-mutex-btq-owner (car _sel29724_)))
                  (##structure
                   std/event#selector::t
                   _sel29724_
                   std/event#selector-wait-condvar
                   std/event#selector-abort-condvar)
                  (error '"Illegal selector; mutex must be owned by current thread"
                         _sel29724_))
              (if (std/event#io-condition-variable? _sel29724_)
                  (##structure
                   std/event#selector::t
                   _sel29724_
                   std/event#selector-wait-io-condvar
                   void)
                  (error '"Illegal selector" _sel29724_))))))
  (define std/event#selector-wait-e
    (lambda (_sel29722_)
      (if (thread? _sel29722_)
          std/event#selector-wait-thread
          (if (and (pair? _sel29722_)
                   (mutex? (car _sel29722_))
                   (condition-variable? (cdr _sel29722_)))
              (if (eq? (current-thread)
                       (macro-mutex-btq-owner (car _sel29722_)))
                  std/event#selector-wait-condvar
                  (error '"Illegal selector; mutex must be owned by current thread"
                         _sel29722_))
              (if (std/event#io-condition-variable? _sel29722_)
                  std/event#selector-wait-io-condvar
                  (error '"Illegal selector" _sel29722_))))))
  (define std/event#selector-wait-thread
    (lambda (_sel29696_ _timeo29697_)
      (with-exception-catcher
       (lambda (_g2969829700_)
         (if ((lambda (_$obj29703_) (uncaught-exception? _$obj29703_))
              _g2969829700_)
             (let ((_e29706_ _g2969829700_)) '#t)
             (if ((lambda (_$obj29708_)
                    (terminated-thread-exception? _$obj29708_))
                  _g2969829700_)
                 (let ((_e29711_ _g2969829700_)) '#t)
                 (if ((lambda (_$obj29713_)
                        (join-timeout-exception? _$obj29713_))
                      _g2969829700_)
                     (let ((_e29716_ _g2969829700_)) '#f)
                     (raise _g2969829700_)))))
       (lambda ()
         (thread-join!
          _sel29696_
          (let ((_$e29719_ _timeo29697_)) (if _$e29719_ _$e29719_ absent-obj)))
         '#t))))
  (define std/event#selector-wait-condvar
    (lambda (_sel29662_ _timeo29663_)
      (let* ((_sel2966429671_ _sel29662_)
             (_E2966629675_
              (lambda () (error '"No clause matching" _sel2966429671_)))
             (_K2966729684_
              (lambda (_cv29678_ _mx29679_)
                (mutex-unlock!
                 _mx29679_
                 _cv29678_
                 (let ((_$e29681_ _timeo29663_))
                   (if _$e29681_ _$e29681_ absent-obj))))))
        (if (##pair? _sel2966429671_)
            (let ((_hd2966829687_ (##car _sel2966429671_))
                  (_tl2966929689_ (##cdr _sel2966429671_)))
              (let* ((_mx29692_ _hd2966829687_) (_cv29694_ _tl2966929689_))
                (_K2966729684_ _cv29694_ _mx29692_)))
            (_E2966629675_)))))
  (define std/event#selector-abort-condvar
    (lambda (_sel29632_)
      (let* ((_sel2963329640_ _sel29632_)
             (_E2963529644_
              (lambda () (error '"No clause matching" _sel2963329640_)))
             (_K2963629650_
              (lambda (_cv29647_ _mx29648_)
                (if (eq? (current-thread) (macro-mutex-btq-owner _mx29648_))
                    (mutex-unlock! _mx29648_)
                    '#!void))))
        (if (##pair? _sel2963329640_)
            (let ((_hd2963729653_ (##car _sel2963329640_))
                  (_tl2963829655_ (##cdr _sel2963329640_)))
              (let* ((_mx29658_ _hd2963729653_) (_cv29660_ _tl2963829655_))
                (_K2963629650_ _cv29660_ _mx29658_)))
            (_E2963529644_)))))
  (define std/event#selector-wait-io-condvar
    (lambda (_sel29629_ _timeo29630_)
      (##wait-for-io!
       _sel29629_
       (if _timeo29630_
           (time->seconds (std/event#timeout->abs-timeout _timeo29630_))
           '#t))))
  (define std/event#maybe-timeout?
    (lambda (_obj29621_)
      (let ((_$e29623_ (not _obj29621_)))
        (if _$e29623_
            _$e29623_
            (let ((_$e29626_ (real? _obj29621_)))
              (if _$e29626_ _$e29626_ (time? _obj29621_)))))))
  (define std/event#timeout->abs-timeout
    (lambda (_timeo29619_)
      (if (time? _timeo29619_)
          _timeo29619_
          (seconds->time (+ (##current-time-point) _timeo29619_)))))
  (define std/event#io-condition-variable?
    (lambda (_obj29617_)
      (if (condition-variable? _obj29617_)
          (##foreign? (macro-condvar-name _obj29617_))
          '#f)))
  (define std/event#event::t
    (make-struct-type
     'std/event#event::t
     '#f
     '4
     'event
     '((final: . #t))
     ':init!
     '(e poll ready abort)))
  (define std/event#event? (make-struct-predicate std/event#event::t))
  (define std/event#make-event
    (lambda _$args29614_
      (apply make-struct-instance std/event#event::t _$args29614_)))
  (define std/event#event-e (make-struct-field-accessor std/event#event::t '0))
  (define std/event#event-poll
    (make-struct-field-accessor std/event#event::t '1))
  (define std/event#event-ready
    (make-struct-field-accessor std/event#event::t '2))
  (define std/event#event-abort
    (make-struct-field-accessor std/event#event::t '3))
  (define std/event#event-e-set!
    (make-struct-field-mutator std/event#event::t '0))
  (define std/event#event-poll-set!
    (make-struct-field-mutator std/event#event::t '1))
  (define std/event#event-ready-set!
    (make-struct-field-mutator std/event#event::t '2))
  (define std/event#event-abort-set!
    (make-struct-field-mutator std/event#event::t '3))
  (define std/event#event-handler::t
    (make-struct-type
     'std/event#event-handler::t
     '#f
     '2
     'event-handler
     '((final: . #t))
     '#f
     '(e K)))
  (define std/event#event-handler?
    (make-struct-predicate std/event#event-handler::t))
  (define std/event#make-event-handler
    (lambda _$args29611_
      (apply make-struct-instance std/event#event-handler::t _$args29611_)))
  (define std/event#event-handler-e
    (make-struct-field-accessor std/event#event-handler::t '0))
  (define std/event#event-handler-K
    (make-struct-field-accessor std/event#event-handler::t '1))
  (define std/event#event-handler-e-set!
    (make-struct-field-mutator std/event#event-handler::t '0))
  (define std/event#event-handler-K-set!
    (make-struct-field-mutator std/event#event-handler::t '1))
  (define std/event#event-set::t
    (make-struct-type
     'std/event#event-set::t
     '#f
     '1
     'event-set
     '((final: . #t))
     '#f
     '(e)))
  (define std/event#event-set? (make-struct-predicate std/event#event-set::t))
  (define std/event#make-event-set
    (lambda _$args29608_
      (apply make-struct-instance std/event#event-set::t _$args29608_)))
  (define std/event#event-set-e
    (make-struct-field-accessor std/event#event-set::t '0))
  (define std/event#event-set-e-set!
    (make-struct-field-mutator std/event#event-set::t '0))
  (define std/event#event:::init!__%
    (lambda (_self29586_ _e29587_ _poll29588_ _ready29589_ _abort29590_)
      (if (##fx< '4 (##vector-length _self29586_))
          (begin
            (##vector-set! _self29586_ '1 _e29587_)
            (##vector-set! _self29586_ '2 _poll29588_)
            (##vector-set! _self29586_ '3 _ready29589_)
            (##vector-set! _self29586_ '4 _abort29590_))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self29586_))))
  (define std/event#event:::init!__0
    (lambda (_self29595_ _e29596_ _poll29597_ _ready29598_)
      (let ((_abort29600_ void))
        (if (##fx< '4 (##vector-length _self29595_))
            (begin
              (##vector-set! _self29595_ '1 _e29596_)
              (##vector-set! _self29595_ '2 _poll29597_)
              (##vector-set! _self29595_ '3 _ready29598_)
              (##vector-set! _self29595_ '4 _abort29600_))
            (error '"struct-instance-init!: too many arguments for struct"
                   _self29595_)))))
  (define std/event#event:::init!
    (lambda _g29941_
      (let ((_g29940_ (length _g29941_)))
        (cond ((##fx= _g29940_ 4) (apply std/event#event:::init!__0 _g29941_))
              ((##fx= _g29940_ 5)
               (apply (lambda (_self29602_
                               _e29603_
                               _poll29604_
                               _ready29605_
                               _abort29606_)
                        (if (##fx< '4 (##vector-length _self29602_))
                            (begin
                              (##vector-set! _self29602_ '1 _e29603_)
                              (##vector-set! _self29602_ '2 _poll29604_)
                              (##vector-set! _self29602_ '3 _ready29605_)
                              (##vector-set! _self29602_ '4 _abort29606_))
                            (error '"struct-instance-init!: too many arguments for struct"
                                   _self29602_)))
                      _g29941_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/event#event:::init!
                _g29941_))))))
  (bind-method! std/event#event::t ':init! std/event#event:::init! '#f)
  (define std/event#sync-object?
    (lambda (_obj29455_)
      (let ((_$e29457_
             (##structure-direct-instance-of? _obj29455_ 'std/event#event::t)))
        (if _$e29457_
            _$e29457_
            (let ((_$e29460_
                   (##structure-direct-instance-of?
                    _obj29455_
                    'std/event#event-handler::t)))
              (if _$e29460_
                  _$e29460_
                  (##structure-direct-instance-of?
                   _obj29455_
                   'std/event#event-set::t)))))))
  (define std/event#never-evt
    (let ((__obj29926 (make-object std/event#event::t '4)))
      (std/event#event:::init!__0 __obj29926 '#f false void)
      __obj29926))
  (define std/event#always-evt
    (let ((__obj29927 (make-object std/event#event::t '4)))
      (std/event#event:::init!__0 __obj29927 '#f true values)
      __obj29927))
  (define std/event#wrap-evt
    (lambda (_obj29450_)
      (if (std/event#sync-object? _obj29450_)
          _obj29450_
          (if (std/event#sync-selector? _obj29450_)
              (let ((__obj29928 (make-object std/event#event::t '4)))
                (if (##fx< '4 (##vector-length __obj29928))
                    (begin
                      (##vector-set! __obj29928 '1 _obj29450_)
                      (##vector-set! __obj29928 '2 std/event#event-e)
                      (##vector-set! __obj29928 '3 std/event#event-e)
                      (##vector-set!
                       __obj29928
                       '4
                       std/event#event-abort-sync-selector))
                    (error '"struct-instance-init!: too many arguments for struct"
                           __obj29928))
                __obj29928)
              (if (or (time? _obj29450_) (real? _obj29450_))
                  (let ((__obj29929 (make-object std/event#event::t '4)))
                    (std/event#event:::init!__0
                     __obj29929
                     (std/event#timeout->abs-timeout _obj29450_)
                     std/event#event-e
                     false)
                    __obj29929)
                  (if (input-port? _obj29450_)
                      (std/event#input-port-evt _obj29450_)
                      (std/event#wrap-evt
                       (call-method _obj29450_ ':event))))))))
  (define std/event#handle-evt
    (lambda (_obj29441_ _K29442_)
      (let ((_evt29444_ (std/event#wrap-evt _obj29441_)))
        (if (##structure-direct-instance-of?
             _evt29444_
             'std/event#event-set::t)
            (##structure
             std/event#event-set::t
             (map (lambda (_g2944529447_)
                    (##structure
                     std/event#event-handler::t
                     _g2944529447_
                     _K29442_))
                  (##direct-structure-ref
                   _evt29444_
                   '1
                   std/event#event-set::t
                   '#f)))
            (##structure std/event#event-handler::t _evt29444_ _K29442_)))))
  (define std/event#choice-evt
    (lambda _args29399_
      (let _lp29401_ ((_rest29403_ _args29399_) (_evts29404_ '()))
        (let* ((_rest2940529413_ _rest29403_)
               (_else2940729421_
                (lambda () (##structure std/event#event-set::t _evts29404_)))
               (_K2940929429_
                (lambda (_rest29424_ _obj29425_)
                  (let ((_evt29427_ (std/event#wrap-evt _obj29425_)))
                    (if (##structure-direct-instance-of?
                         _evt29427_
                         'std/event#event-set::t)
                        (if (null? _evts29404_)
                            (_lp29401_
                             _rest29424_
                             (##direct-structure-ref
                              _evt29427_
                              '1
                              std/event#event-set::t
                              '#f))
                            (_lp29401_
                             _rest29424_
                             (foldl1 cons
                                     _evts29404_
                                     (##direct-structure-ref
                                      _evt29427_
                                      '1
                                      std/event#event-set::t
                                      '#f))))
                        (_lp29401_
                         _rest29424_
                         (cons _evt29427_ _evts29404_)))))))
          (if (##pair? _rest2940529413_)
              (let ((_hd2941029432_ (##car _rest2940529413_))
                    (_tl2941129434_ (##cdr _rest2940529413_)))
                (let* ((_obj29437_ _hd2941029432_)
                       (_rest29439_ _tl2941129434_))
                  (_K2940929429_ _rest29439_ _obj29437_)))
              (_else2940729421_))))))
  (define std/event#sync
    (lambda _args29235_
      (letrec* ((_mutexes29237_ (make-table 'test: eq?))
                (_loop29238_
                 (lambda (_rest29355_
                          _sels29356_
                          _sel-evts29357_
                          _timeo29358_
                          _timeo-evt29359_)
                   (let* ((_rest2936029368_ _rest29355_)
                          (_else2936229378_
                           (lambda ()
                             (if (not (null? _sels29356_))
                                 (let ((_rz29376_
                                        (std/event#select__%
                                         _sels29356_
                                         _timeo29358_)))
                                   (if _rz29376_
                                       (_dispatch-selector29242_
                                        _rz29376_
                                        _sels29356_
                                        _sel-evts29357_)
                                       (_dispatch-evt29241_ _timeo-evt29359_)))
                                 (if _timeo29358_
                                     (begin
                                       (thread-sleep! _timeo29358_)
                                       (_dispatch-evt29241_ _timeo-evt29359_))
                                     (thread-sleep! '+inf.0)))))
                          (_K2936429387_
                           (lambda (_rest29381_ _evt29382_)
                             (if (or (##structure-direct-instance-of?
                                      _evt29382_
                                      'std/event#event::t)
                                     (##structure-direct-instance-of?
                                      _evt29382_
                                      'std/event#event-handler::t))
                                 (_poll29239_
                                  _evt29382_
                                  _rest29381_
                                  _sels29356_
                                  _sel-evts29357_
                                  _timeo29358_
                                  _timeo-evt29359_)
                                 (_loop29238_
                                  (foldl1 cons
                                          _rest29381_
                                          (std/misc/shuffle#shuffle
                                           (##direct-structure-ref
                                            _evt29382_
                                            '1
                                            std/event#event-set::t
                                            '#f)))
                                  _sels29356_
                                  _sel-evts29357_
                                  _timeo29358_
                                  _timeo-evt29359_)))))
                     (if (##pair? _rest2936029368_)
                         (let ((_hd2936529390_ (##car _rest2936029368_))
                               (_tl2936629392_ (##cdr _rest2936029368_)))
                           (let* ((_evt29395_ _hd2936529390_)
                                  (_rest29397_ _tl2936629392_))
                             (_K2936429387_ _rest29397_ _evt29395_)))
                         (_else2936229378_)))))
                (_poll29239_
                 (lambda (_evt29345_
                          _rest29346_
                          _sels29347_
                          _sel-evts29348_
                          _timeo29349_
                          _timeo-evt29350_)
                   (let ((_rz29352_ (_poll-evt29240_ _evt29345_)))
                     (if (not _rz29352_)
                         (_loop29238_
                          _rest29346_
                          _sels29347_
                          _sel-evts29348_
                          _timeo29349_
                          _timeo-evt29350_)
                         (if (eq? _rz29352_ '#t)
                             (begin
                               (_abort-selectors!29245_
                                _rest29346_
                                _sels29347_)
                               (_dispatch-evt29241_ _evt29345_))
                             (if (time? _rz29352_)
                                 (if _timeo29349_
                                     (if (< (time->seconds _rz29352_)
                                            (time->seconds _timeo29349_))
                                         (_loop29238_
                                          _rest29346_
                                          _sels29347_
                                          _sel-evts29348_
                                          _rz29352_
                                          _evt29345_)
                                         (_loop29238_
                                          _rest29346_
                                          _sels29347_
                                          _sel-evts29348_
                                          _timeo29349_
                                          _timeo-evt29350_))
                                     (_loop29238_
                                      _rest29346_
                                      _sels29347_
                                      _sel-evts29348_
                                      _rz29352_
                                      _evt29345_))
                                 (if (std/event#sync-selector? _rz29352_)
                                     (begin
                                       (_check-mutex!29243_
                                        _rz29352_
                                        _rest29346_
                                        _sels29347_)
                                       (_loop29238_
                                        _rest29346_
                                        (cons _rz29352_ _sels29347_)
                                        (cons _evt29345_ _sel-evts29348_)
                                        _timeo29349_
                                        _timeo-evt29350_))
                                     (_abort!29244_
                                      _rest29346_
                                      _sels29347_
                                      (lambda ()
                                        (error '"Bad synchronizer"
                                               _evt29345_
                                               _rz29352_))))))))))
                (_poll-evt29240_
                 (lambda (_evt29339_)
                   (let _lp29341_ ((_evt29343_ _evt29339_))
                     (if (##structure-direct-instance-of?
                          _evt29343_
                          'std/event#event::t)
                         ((##direct-structure-ref
                           _evt29343_
                           '2
                           std/event#event::t
                           '#f)
                          _evt29343_)
                         (_lp29341_
                          (##direct-structure-ref
                           _evt29343_
                           '1
                           std/event#event-handler::t
                           '#f))))))
                (_dispatch-evt29241_
                 (lambda (_evt29332_)
                   (let _recur29334_ ((_evt29336_ _evt29332_))
                     (if (##structure-direct-instance-of?
                          _evt29336_
                          'std/event#event::t)
                         ((##direct-structure-ref
                           _evt29336_
                           '3
                           std/event#event::t
                           '#f)
                          _evt29336_)
                         (call-with-values
                          (lambda ()
                            (_recur29334_
                             (##direct-structure-ref
                              _evt29336_
                              '1
                              std/event#event-handler::t
                              '#f)))
                          (##direct-structure-ref
                           _evt29336_
                           '2
                           std/event#event-handler::t
                           '#f))))))
                (_dispatch-selector29242_
                 (lambda (_rz29267_ _sels29268_ _sel-evts29269_)
                   (let _lp29271_ ((_rest-sels29273_ _sels29268_)
                                   (_rest-evts29274_ _sel-evts29269_))
                     (let* ((_rest-sels2927529282_ _rest-sels29273_)
                            (_E2927729286_
                             (lambda ()
                               (error '"No clause matching"
                                      _rest-sels2927529282_)))
                            (_K2927829320_
                             (lambda (_rest-sels29289_ _sel29290_)
                               (let* ((_rest-evts2929129298_ _rest-evts29274_)
                                      (_E2929329302_
                                       (lambda ()
                                         (error '"No clause matching"
                                                _rest-evts2929129298_)))
                                      (_K2929429308_
                                       (lambda (_rest-evts29305_ _evt29306_)
                                         (if (eq? _sel29290_ _rz29267_)
                                             (_dispatch-evt29241_ _evt29306_)
                                             (_lp29271_
                                              _rest-sels29289_
                                              _rest-evts29305_)))))
                                 (if (##pair? _rest-evts2929129298_)
                                     (let ((_hd2929529311_
                                            (##car _rest-evts2929129298_))
                                           (_tl2929629313_
                                            (##cdr _rest-evts2929129298_)))
                                       (let* ((_evt29316_ _hd2929529311_)
                                              (_rest-evts29318_
                                               _tl2929629313_))
                                         (_K2929429308_
                                          _rest-evts29318_
                                          _evt29316_)))
                                     (_E2929329302_))))))
                       (if (##pair? _rest-sels2927529282_)
                           (let ((_hd2927929323_ (##car _rest-sels2927529282_))
                                 (_tl2928029325_
                                  (##cdr _rest-sels2927529282_)))
                             (let* ((_sel29328_ _hd2927929323_)
                                    (_rest-sels29330_ _tl2928029325_))
                               (_K2927829320_ _rest-sels29330_ _sel29328_)))
                           (_E2927729286_))))))
                (_check-mutex!29243_
                 (lambda (_rz29260_ _rest29261_ _sels29262_)
                   (if (pair? _rz29260_)
                       (let ((_mx29264_ (car _rz29260_)))
                         (if (table-ref _mutexes29237_ _mx29264_ '#f)
                             (_abort!29244_
                              _rest29261_
                              _sels29262_
                              (lambda ()
                                (error '"Duplicate mutex synchronizer"
                                       _rz29260_)))
                             (table-set! _mutexes29237_ _mx29264_ '#t)))
                       '#!void)))
                (_abort!29244_
                 (lambda (_rest29256_ _sels29257_ _E29258_)
                   (_abort-selectors!29245_ _rest29256_ _sels29257_)
                   (_E29258_)))
                (_abort-selectors!29245_
                 (lambda (_rest29253_ _sels29254_)
                   (for-each _abort-selector!29246_ _sels29254_)
                   (for-each _abort-evt!29247_ _rest29253_)))
                (_abort-selector!29246_
                 (lambda (_sel29251_)
                   (if (pair? _sel29251_)
                       (mutex-unlock! (car _sel29251_))
                       '#!void)))
                (_abort-evt!29247_
                 (lambda (_evt29249_)
                   (if (##structure-direct-instance-of?
                        _evt29249_
                        'std/event#event::t)
                       ((##direct-structure-ref
                         _evt29249_
                         '4
                         std/event#event::t
                         '#f)
                        _evt29249_)
                       (if (##structure-direct-instance-of?
                            _evt29249_
                            'std/event#event-handler::t)
                           (_abort-evt!29247_
                            (##direct-structure-ref
                             _evt29249_
                             '1
                             std/event#event-handler::t
                             '#f))
                           (for-each
                            _abort-evt!29247_
                            (##direct-structure-ref
                             _evt29249_
                             '1
                             std/event#event-set::t
                             '#f)))))))
        (_loop29238_
         (std/misc/shuffle#shuffle (map std/event#wrap-evt _args29235_))
         '()
         '()
         '#f
         '#f))))
  (define std/event#sync-selector?
    (lambda (_obj29227_)
      (let ((_$e29229_ (thread? _obj29227_)))
        (if _$e29229_
            _$e29229_
            (let ((_$e29232_
                   (if (pair? _obj29227_)
                       (if (mutex? (car _obj29227_))
                           (condition-variable? (cdr _obj29227_))
                           '#f)
                       '#f)))
              (if _$e29232_
                  _$e29232_
                  (std/event#io-condition-variable? _obj29227_)))))))
  (define std/event#event-abort-sync-selector
    (lambda (_evt29223_)
      (let ((_sel29225_
             (##direct-structure-ref _evt29223_ '1 std/event#event::t '#f)))
        (if (pair? _sel29225_) (mutex-unlock! (car _sel29225_)) '#!void))))
  (define std/event#input-port-evt
    (lambda (_port29221_)
      (if (macro-u8vector-port? _port29221_)
          (std/event#make-u8vector-port-evt _port29221_)
          (if (macro-string-port? _port29221_)
              (std/event#make-string-port-evt _port29221_)
              (if (macro-vector-port? _port29221_)
                  (std/event#make-vector-port-evt _port29221_)
                  (if (macro-device-port? _port29221_)
                      (std/event#make-device-port-evt _port29221_)
                      (if (macro-tcp-server-port? _port29221_)
                          (std/event#make-tcp-server-port-evt _port29221_)
                          (if (macro-raw-device-port? _port29221_)
                              (std/event#make-raw-device-port-evt _port29221_)
                              (error '"can't wrap event around unknown port type"
                                     _port29221_)))))))))
  (define std/event#make-u8vector-port-evt
    (lambda (_port29206_)
      (letrec ((_rbuf-check29208_
                (lambda (_port29219_)
                  (##fx< (macro-byte-port-rlo _port29219_)
                         (macro-byte-port-rhi _port29219_))))
               (_rbuf-fill29209_
                (lambda (_port29217_) (macro-byte-port-rbuf-fill _port29217_)))
               (_condvar-e29210_
                (lambda (_port29215_)
                  (macro-u8vector-port-rcondvar _port29215_)))
               (_poll29211_
                (lambda (_evt29213_)
                  (std/event#user-port-poll
                   (##direct-structure-ref
                    _evt29213_
                    '1
                    std/event#event::t
                    '#f)
                   _rbuf-check29208_
                   _rbuf-fill29209_
                   _condvar-e29210_))))
        (let ((__obj29930 (make-object std/event#event::t '4)))
          (std/event#event:::init!__0
           __obj29930
           _port29206_
           _poll29211_
           std/event#event-e)
          __obj29930))))
  (define std/event#make-string-port-evt
    (lambda (_port29191_)
      (letrec ((_rbuf-check29193_
                (lambda (_port29204_)
                  (##fx< (macro-character-port-rlo _port29204_)
                         (macro-character-port-rhi _port29204_))))
               (_rbuf-fill29194_
                (lambda (_port29202_)
                  (macro-character-port-rbuf-fill _port29202_)))
               (_condvar-e29195_
                (lambda (_port29200_)
                  (macro-string-port-rcondvar _port29200_)))
               (_poll29196_
                (lambda (_evt29198_)
                  (std/event#user-port-poll
                   (##direct-structure-ref
                    _evt29198_
                    '1
                    std/event#event::t
                    '#f)
                   _rbuf-check29193_
                   _rbuf-fill29194_
                   _condvar-e29195_))))
        (let ((__obj29931 (make-object std/event#event::t '4)))
          (std/event#event:::init!__0
           __obj29931
           _port29191_
           _poll29196_
           std/event#event-e)
          __obj29931))))
  (define std/event#make-vector-port-evt
    (lambda (_port29176_)
      (letrec ((_rbuf-check29178_
                (lambda (_port29189_)
                  (##fx< (macro-vector-port-rlo _port29189_)
                         (macro-vector-port-rhi _port29189_))))
               (_rbuf-fill29179_
                (lambda (_port29187_)
                  (macro-vector-port-rbuf-fill _port29187_)))
               (_condvar-e29180_
                (lambda (_port29185_)
                  (macro-vector-port-rcondvar _port29185_)))
               (_poll29181_
                (lambda (_evt29183_)
                  (std/event#user-port-poll
                   (##direct-structure-ref
                    _evt29183_
                    '1
                    std/event#event::t
                    '#f)
                   _rbuf-check29178_
                   _rbuf-fill29179_
                   _condvar-e29180_))))
        (let ((__obj29932 (make-object std/event#event::t '4)))
          (std/event#event:::init!__0
           __obj29932
           _port29176_
           _poll29181_
           std/event#event-e)
          __obj29932))))
  (define std/event#user-port-poll
    (lambda (_port29164_ _rbuf-check29165_ _rbuf-fill29166_ _condvar-e29167_)
      (letrec ((_fill!29169_
                (lambda (_port29174_)
                  (std/event#input-port-rbuf-fill!
                   _port29174_
                   (_rbuf-fill29166_ _port29174_)))))
        (let ((_mx29171_ (macro-port-mutex _port29164_)))
          (mutex-lock! _mx29171_)
          (if (_rbuf-check29165_ _port29164_)
              (begin (mutex-unlock! _mx29171_) '#t)
              (if (_fill!29169_ _port29164_)
                  (begin (mutex-unlock! _mx29171_) '#t)
                  (cons _mx29171_ (_condvar-e29167_ _port29164_))))))))
  (define std/event#input-port-rbuf-fill!
    (lambda (_port29156_ _fill29157_)
      (let _lp29159_ ()
        (let ((_r29162_ (_fill29157_ _port29156_ '1 '#f)))
          (if (eq? _r29162_ ##err-code-EINTR)
              (_lp29159_)
              (if (eq? _r29162_ ##err-code-EAGAIN) '#f '#t))))))
  (define std/event#make-device-port-evt
    (lambda (_port29139_)
      (letrec ((_fill!29141_
                (lambda (_port29154_)
                  (std/event#input-port-rbuf-fill!
                   _port29154_
                   (macro-byte-port-rbuf-fill _port29154_))))
               (_poll29142_
                (lambda (_evt29144_)
                  (let* ((_port29146_
                          (##direct-structure-ref
                           _evt29144_
                           '1
                           std/event#event::t
                           '#f))
                         (_mx29148_ (macro-port-mutex _port29146_)))
                    (if (or (##fx< (macro-byte-port-rlo _port29146_)
                                   (macro-byte-port-rhi _port29146_))
                            (##fx< (macro-character-port-rlo _port29146_)
                                   (macro-character-port-rhi _port29146_)))
                        (begin (mutex-unlock! _mx29148_) '#t)
                        (if (_fill!29141_ _port29146_)
                            (begin (mutex-unlock! _mx29148_) '#t)
                            (begin
                              (mutex-unlock! _mx29148_)
                              (macro-device-port-rdevice-condvar
                               _port29146_))))))))
        (let ((__obj29933 (make-object std/event#event::t '4)))
          (std/event#event:::init!__0
           __obj29933
           _port29139_
           _poll29142_
           std/event#event-e)
          __obj29933))))
  (define std/event#make-tcp-server-port-evt
    (lambda (_port29131_)
      (letrec ((_poll29133_
                (lambda (_evt29135_)
                  (let ((_port29137_
                         (##direct-structure-ref
                          _evt29135_
                          '1
                          std/event#event::t
                          '#f)))
                    (macro-tcp-server-port-rdevice-condvar _port29137_)))))
        (let ((__obj29934 (make-object std/event#event::t '4)))
          (std/event#event:::init!__0
           __obj29934
           _port29131_
           _poll29133_
           std/event#event-e)
          __obj29934))))
  (define std/event#make-raw-device-port-evt
    (lambda (_port29123_)
      (letrec ((_poll29125_
                (lambda (_evt29127_)
                  (let ((_port29129_
                         (##direct-structure-ref
                          _evt29127_
                          '1
                          std/event#event::t
                          '#f)))
                    (macro-raw-device-port-rdevice-condvar _port29129_)))))
        (let ((__obj29935 (make-object std/event#event::t '4)))
          (std/event#event:::init!__0
           __obj29935
           _port29123_
           _poll29125_
           std/event#event-e)
          __obj29935)))))
