(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/os/socket#open-socket
    (lambda (_domain145032_ _type145033_ _proto145034_ _dir145035_)
      (let* ((_fd145040_
              (let ((_r145037_
                     (std/os/_socket#_socket
                      _domain145032_
                      _type145033_
                      _proto145034_)))
                (if (not (##fxnegative? _r145037_))
                    _r145037_
                    (std/os/error#raise-os-error
                     (##fx- _r145037_)
                     std/os/socket#socket
                     _domain145032_
                     _type145033_
                     _proto145034_))))
             (_raw145042_ (std/os/fd#fdopen _fd145040_ _dir145035_ 'socket)))
        (std/os/fcntl#fd-set-nonblock/closeonexec _raw145042_)
        _raw145042_)))
  (define std/os/socket#socket__%
    (lambda (_domain145016_ _type145017_ _proto145018_)
      (std/os/socket#open-socket
       _domain145016_
       _type145017_
       _proto145018_
       'inout)))
  (define std/os/socket#socket__0
    (lambda (_domain145023_ _type145024_)
      (let ((_proto145026_ '0))
        (std/os/socket#socket__% _domain145023_ _type145024_ _proto145026_))))
  (define std/os/socket#socket
    (lambda _g145133_
      (let ((_g145132_ (length _g145133_)))
        (cond ((##fx= _g145132_ 2) (apply std/os/socket#socket__0 _g145133_))
              ((##fx= _g145132_ 3) (apply std/os/socket#socket__% _g145133_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket
                _g145133_))))))
  (define std/os/socket#server-socket__%
    (lambda (_domain144999_ _type145000_ _proto145001_)
      (std/os/socket#open-socket
       _domain144999_
       _type145000_
       _proto145001_
       'in)))
  (define std/os/socket#server-socket__0
    (lambda (_domain145006_ _type145007_)
      (let ((_proto145009_ '0))
        (std/os/socket#server-socket__%
         _domain145006_
         _type145007_
         _proto145009_))))
  (define std/os/socket#server-socket
    (lambda _g145135_
      (let ((_g145134_ (length _g145135_)))
        (cond ((##fx= _g145134_ 2)
               (apply std/os/socket#server-socket__0 _g145135_))
              ((##fx= _g145134_ 3)
               (apply std/os/socket#server-socket__% _g145135_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#server-socket
                _g145135_))))))
  (define std/os/socket#socket?
    (lambda (_obj144996_) (std/os/fd#fd-type? _obj144996_ 'socket)))
  (define std/os/socket#socket-bind
    (lambda (_sock144990_ _addr144991_)
      (let ((_r144993_
             (std/os/_socket#_bind
              (std/os/fd#fd-e _sock144990_)
              (std/os/socket#socket-address _addr144991_))))
        (if (not (##fxnegative? _r144993_))
            _r144993_
            (std/os/error#raise-os-error
             (##fx- _r144993_)
             std/os/socket#socket-bind
             _sock144990_
             _addr144991_)))))
  (define std/os/socket#socket-listen__%
    (lambda (_sock144974_ _backlog144975_)
      (let ((_r144977_
             (std/os/_socket#_listen
              (std/os/fd#fd-e _sock144974_)
              _backlog144975_)))
        (if (not (##fxnegative? _r144977_))
            _r144977_
            (std/os/error#raise-os-error
             (##fx- _r144977_)
             std/os/socket#socket-listen
             _sock144974_
             _backlog144975_)))))
  (define std/os/socket#socket-listen__0
    (lambda (_sock144983_)
      (let ((_backlog144985_ '10))
        (std/os/socket#socket-listen__% _sock144983_ _backlog144985_))))
  (define std/os/socket#socket-listen
    (lambda _g145137_
      (let ((_g145136_ (length _g145137_)))
        (cond ((##fx= _g145136_ 1)
               (apply std/os/socket#socket-listen__0 _g145137_))
              ((##fx= _g145136_ 2)
               (apply std/os/socket#socket-listen__% _g145137_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-listen
                _g145137_))))))
  (define std/os/socket#socket-accept__%
    (lambda (_sock144939_ _sa144940_)
      (let ((_fd144941144956_
             (let _lp144943_ ()
               (let ((_r144947_
                      (std/os/_socket#_accept
                       (std/os/fd#fd-e _sock144939_)
                       _sa144940_)))
                 (if (not (##fxnegative? _r144947_))
                     _r144947_
                     (let ((_errno144950_ (##fx- _r144947_)))
                       (if (or (eq? _errno144950_ std/os/error#EAGAIN)
                               (eq? _errno144950_ std/os/error#EWOULDBLOCK))
                           '#f
                           (if (eq? _errno144950_ std/os/error#EINTR)
                               (_lp144943_)
                               (std/os/error#raise-os-error
                                _errno144950_
                                std/os/socket#socket-accept
                                _sock144939_
                                _sa144940_)))))))))
        (if _fd144941144956_
            (let* ((_fd144959_ _fd144941144956_)
                   (_raw144961_ (std/os/fd#fdopen _fd144959_ 'inout 'socket)))
              (std/os/fcntl#fd-set-nonblock _raw144961_)
              (std/os/fcntl#fd-set-closeonexec _raw144961_)
              _raw144961_)
            '#f))))
  (define std/os/socket#socket-accept__0
    (lambda (_sock144966_)
      (let ((_sa144968_ '#f))
        (std/os/socket#socket-accept__% _sock144966_ _sa144968_))))
  (define std/os/socket#socket-accept
    (lambda _g145139_
      (let ((_g145138_ (length _g145139_)))
        (cond ((##fx= _g145138_ 1)
               (apply std/os/socket#socket-accept__0 _g145139_))
              ((##fx= _g145138_ 2)
               (apply std/os/socket#socket-accept__% _g145139_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-accept
                _g145139_))))))
  (define std/os/socket#socket-connect
    (lambda (_sock144923_ _sa144924_)
      (let ((_sa144926_ (std/os/socket#socket-address _sa144924_)))
        (let _lp144928_ ()
          (let ((_r144932_
                 (std/os/_socket#_connect
                  (std/os/fd#fd-e _sock144923_)
                  _sa144926_)))
            (if (not (##fxnegative? _r144932_))
                _r144932_
                (let ((_errno144935_ (##fx- _r144932_)))
                  (if (eq? _errno144935_ std/os/error#EINPROGRESS)
                      '#f
                      (if (eq? _errno144935_ std/os/error#EINTR)
                          (_lp144928_)
                          (std/os/error#raise-os-error
                           _errno144935_
                           std/os/socket#socket-connect
                           _sock144923_
                           _sa144926_))))))))))
  (define std/os/socket#socket-shutdown
    (lambda (_sock144917_ _how144918_)
      (let ((_r144920_
             (std/os/_socket#_shutdown
              (std/os/fd#fd-e _sock144917_)
              _how144918_)))
        (if (not (##fxnegative? _r144920_))
            _r144920_
            (std/os/error#raise-os-error
             (##fx- _r144920_)
             std/os/socket#socket-shutdown
             _sock144917_
             _how144918_)))
      (if (eq? _how144918_ std/os/_socket#SHUT_RD)
          (close-input-port _sock144917_)
          (if (eq? _how144918_ std/os/_socket#SHUT_WR)
              (close-output-port _sock144917_)
              (if (eq? _how144918_ std/os/_socket#SHUT_RDWR)
                  (close-port _sock144917_)
                  '#!void)))))
  (define std/os/socket#socket-close
    (lambda (_sock144915_) (close-port _sock144915_)))
  (define std/os/socket#socket-send__%
    (lambda (_sock144863_
             _bytes144864_
             _start144865_
             _end144866_
             _flags144867_)
      (let _lp144869_ ()
        (let ((_r144873_
               (std/os/_socket#_send
                (std/os/fd#fd-e _sock144863_)
                _bytes144864_
                _start144865_
                _end144866_
                _flags144867_)))
          (if (not (##fxnegative? _r144873_))
              _r144873_
              (let ((_errno144876_ (##fx- _r144873_)))
                (if (or (eq? _errno144876_ std/os/error#EAGAIN)
                        (eq? _errno144876_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno144876_ std/os/error#EINTR)
                        (_lp144869_)
                        (std/os/error#raise-os-error
                         _errno144876_
                         std/os/socket#socket-send
                         _sock144863_
                         _bytes144864_
                         _start144865_
                         _end144866_
                         _flags144867_)))))))))
  (define std/os/socket#socket-send__0
    (lambda (_sock144885_ _bytes144886_)
      (let* ((_start144888_ '0)
             (_end144890_ (u8vector-length _bytes144886_))
             (_flags144892_ '0))
        (std/os/socket#socket-send__%
         _sock144885_
         _bytes144886_
         _start144888_
         _end144890_
         _flags144892_))))
  (define std/os/socket#socket-send__1
    (lambda (_sock144894_ _bytes144895_ _start144896_)
      (let* ((_end144898_ (u8vector-length _bytes144895_)) (_flags144900_ '0))
        (std/os/socket#socket-send__%
         _sock144894_
         _bytes144895_
         _start144896_
         _end144898_
         _flags144900_))))
  (define std/os/socket#socket-send__2
    (lambda (_sock144902_ _bytes144903_ _start144904_ _end144905_)
      (let ((_flags144907_ '0))
        (std/os/socket#socket-send__%
         _sock144902_
         _bytes144903_
         _start144904_
         _end144905_
         _flags144907_))))
  (define std/os/socket#socket-send
    (lambda _g145141_
      (let ((_g145140_ (length _g145141_)))
        (cond ((##fx= _g145140_ 2)
               (apply std/os/socket#socket-send__0 _g145141_))
              ((##fx= _g145140_ 3)
               (apply std/os/socket#socket-send__1 _g145141_))
              ((##fx= _g145140_ 4)
               (apply std/os/socket#socket-send__2 _g145141_))
              ((##fx= _g145140_ 5)
               (apply std/os/socket#socket-send__% _g145141_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-send
                _g145141_))))))
  (define std/os/socket#socket-sendto__%
    (lambda (_sock144803_
             _bytes144804_
             _sa144805_
             _start144806_
             _end144807_
             _flags144808_)
      (let ((_sa144810_ (std/os/socket#socket-address _sa144805_)))
        (let _lp144812_ ()
          (let ((_r144816_
                 (std/os/_socket#_sendto
                  (std/os/fd#fd-e _sock144803_)
                  _bytes144804_
                  _start144806_
                  _end144807_
                  _flags144808_
                  _sa144810_)))
            (if (not (##fxnegative? _r144816_))
                _r144816_
                (let ((_errno144819_ (##fx- _r144816_)))
                  (if (or (eq? _errno144819_ std/os/error#EAGAIN)
                          (eq? _errno144819_ std/os/error#EWOULDBLOCK))
                      '#f
                      (if (eq? _errno144819_ std/os/error#EINTR)
                          (_lp144812_)
                          (std/os/error#raise-os-error
                           _errno144819_
                           std/os/socket#socket-sendto
                           _sock144803_
                           _bytes144804_
                           _sa144810_
                           _start144806_
                           _end144807_
                           _flags144808_))))))))))
  (define std/os/socket#socket-sendto__0
    (lambda (_sock144828_ _bytes144829_ _sa144830_)
      (let* ((_start144832_ '0)
             (_end144834_ (u8vector-length _bytes144829_))
             (_flags144836_ '0))
        (std/os/socket#socket-sendto__%
         _sock144828_
         _bytes144829_
         _sa144830_
         _start144832_
         _end144834_
         _flags144836_))))
  (define std/os/socket#socket-sendto__1
    (lambda (_sock144838_ _bytes144839_ _sa144840_ _start144841_)
      (let* ((_end144843_ (u8vector-length _bytes144839_)) (_flags144845_ '0))
        (std/os/socket#socket-sendto__%
         _sock144838_
         _bytes144839_
         _sa144840_
         _start144841_
         _end144843_
         _flags144845_))))
  (define std/os/socket#socket-sendto__2
    (lambda (_sock144847_ _bytes144848_ _sa144849_ _start144850_ _end144851_)
      (let ((_flags144853_ '0))
        (std/os/socket#socket-sendto__%
         _sock144847_
         _bytes144848_
         _sa144849_
         _start144850_
         _end144851_
         _flags144853_))))
  (define std/os/socket#socket-sendto
    (lambda _g145143_
      (let ((_g145142_ (length _g145143_)))
        (cond ((##fx= _g145142_ 3)
               (apply std/os/socket#socket-sendto__0 _g145143_))
              ((##fx= _g145142_ 4)
               (apply std/os/socket#socket-sendto__1 _g145143_))
              ((##fx= _g145142_ 5)
               (apply std/os/socket#socket-sendto__2 _g145143_))
              ((##fx= _g145142_ 6)
               (apply std/os/socket#socket-sendto__% _g145143_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-sendto
                _g145143_))))))
  (define std/os/socket#socket-sendmsg
    (lambda (_sock144783_
             _name-bytes144784_
             _io-bytes144785_
             _ctl-bytes144786_
             _flags144787_)
      (let _lp144789_ ()
        (let ((_r144793_
               (std/os/_socket#_sendmsg
                (std/os/fd#fd-e _sock144783_)
                _name-bytes144784_
                _io-bytes144785_
                _ctl-bytes144786_
                _flags144787_)))
          (if (not (##fxnegative? _r144793_))
              _r144793_
              (let ((_errno144796_ (##fx- _r144793_)))
                (if (or (eq? _errno144796_ std/os/error#EAGAIN)
                        (eq? _errno144796_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno144796_ std/os/error#EINTR)
                        (_lp144789_)
                        (std/os/error#raise-os-error
                         _errno144796_
                         std/os/socket#socket-sendmsg
                         _sock144783_
                         _name-bytes144784_
                         _io-bytes144785_
                         _ctl-bytes144786_
                         _flags144787_)))))))))
  (define std/os/socket#socket-recv__%
    (lambda (_sock144731_
             _bytes144732_
             _start144733_
             _end144734_
             _flags144735_)
      (let _lp144737_ ()
        (let ((_r144741_
               (std/os/_socket#_recv
                (std/os/fd#fd-e _sock144731_)
                _bytes144732_
                _start144733_
                _end144734_
                _flags144735_)))
          (if (not (##fxnegative? _r144741_))
              _r144741_
              (let ((_errno144744_ (##fx- _r144741_)))
                (if (or (eq? _errno144744_ std/os/error#EAGAIN)
                        (eq? _errno144744_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno144744_ std/os/error#EINTR)
                        (_lp144737_)
                        (std/os/error#raise-os-error
                         _errno144744_
                         std/os/socket#socket-recv
                         _sock144731_
                         _bytes144732_
                         _start144733_
                         _end144734_
                         _flags144735_)))))))))
  (define std/os/socket#socket-recv__0
    (lambda (_sock144753_ _bytes144754_)
      (let* ((_start144756_ '0)
             (_end144758_ (u8vector-length _bytes144754_))
             (_flags144760_ '0))
        (std/os/socket#socket-recv__%
         _sock144753_
         _bytes144754_
         _start144756_
         _end144758_
         _flags144760_))))
  (define std/os/socket#socket-recv__1
    (lambda (_sock144762_ _bytes144763_ _start144764_)
      (let* ((_end144766_ (u8vector-length _bytes144763_)) (_flags144768_ '0))
        (std/os/socket#socket-recv__%
         _sock144762_
         _bytes144763_
         _start144764_
         _end144766_
         _flags144768_))))
  (define std/os/socket#socket-recv__2
    (lambda (_sock144770_ _bytes144771_ _start144772_ _end144773_)
      (let ((_flags144775_ '0))
        (std/os/socket#socket-recv__%
         _sock144770_
         _bytes144771_
         _start144772_
         _end144773_
         _flags144775_))))
  (define std/os/socket#socket-recv
    (lambda _g145145_
      (let ((_g145144_ (length _g145145_)))
        (cond ((##fx= _g145144_ 2)
               (apply std/os/socket#socket-recv__0 _g145145_))
              ((##fx= _g145144_ 3)
               (apply std/os/socket#socket-recv__1 _g145145_))
              ((##fx= _g145144_ 4)
               (apply std/os/socket#socket-recv__2 _g145145_))
              ((##fx= _g145144_ 5)
               (apply std/os/socket#socket-recv__% _g145145_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-recv
                _g145145_))))))
  (define std/os/socket#socket-recvfrom__%
    (lambda (_sock144673_
             _bytes144674_
             _sa144675_
             _start144676_
             _end144677_
             _flags144678_)
      (let _lp144680_ ()
        (let ((_r144684_
               (std/os/_socket#_recvfrom
                (std/os/fd#fd-e _sock144673_)
                _bytes144674_
                _start144676_
                _end144677_
                _flags144678_
                _sa144675_)))
          (if (not (##fxnegative? _r144684_))
              _r144684_
              (let ((_errno144687_ (##fx- _r144684_)))
                (if (or (eq? _errno144687_ std/os/error#EAGAIN)
                        (eq? _errno144687_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno144687_ std/os/error#EINTR)
                        (_lp144680_)
                        (std/os/error#raise-os-error
                         _errno144687_
                         std/os/socket#socket-recvfrom
                         _sock144673_
                         _bytes144674_
                         _sa144675_
                         _start144676_
                         _end144677_
                         _flags144678_)))))))))
  (define std/os/socket#socket-recvfrom__0
    (lambda (_sock144696_ _bytes144697_ _sa144698_)
      (let* ((_start144700_ '0)
             (_end144702_ (u8vector-length _bytes144697_))
             (_flags144704_ '0))
        (std/os/socket#socket-recvfrom__%
         _sock144696_
         _bytes144697_
         _sa144698_
         _start144700_
         _end144702_
         _flags144704_))))
  (define std/os/socket#socket-recvfrom__1
    (lambda (_sock144706_ _bytes144707_ _sa144708_ _start144709_)
      (let* ((_end144711_ (u8vector-length _bytes144707_)) (_flags144713_ '0))
        (std/os/socket#socket-recvfrom__%
         _sock144706_
         _bytes144707_
         _sa144708_
         _start144709_
         _end144711_
         _flags144713_))))
  (define std/os/socket#socket-recvfrom__2
    (lambda (_sock144715_ _bytes144716_ _sa144717_ _start144718_ _end144719_)
      (let ((_flags144721_ '0))
        (std/os/socket#socket-recvfrom__%
         _sock144715_
         _bytes144716_
         _sa144717_
         _start144718_
         _end144719_
         _flags144721_))))
  (define std/os/socket#socket-recvfrom
    (lambda _g145147_
      (let ((_g145146_ (length _g145147_)))
        (cond ((##fx= _g145146_ 3)
               (apply std/os/socket#socket-recvfrom__0 _g145147_))
              ((##fx= _g145146_ 4)
               (apply std/os/socket#socket-recvfrom__1 _g145147_))
              ((##fx= _g145146_ 5)
               (apply std/os/socket#socket-recvfrom__2 _g145147_))
              ((##fx= _g145146_ 6)
               (apply std/os/socket#socket-recvfrom__% _g145147_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-recvfrom
                _g145147_))))))
  (define std/os/socket#socket-recvmsg*
    (lambda (_sock144650_
             _name-bytes144651_
             _rname144652_
             _io-bytes144653_
             _ctl-bytes144654_
             _rctl144655_
             _flags144656_
             _rflags144657_)
      (let _lp144659_ ()
        (let ((_r144663_
               (std/os/_socket#_recvmsg
                (std/os/fd#fd-e _sock144650_)
                _name-bytes144651_
                _rname144652_
                _io-bytes144653_
                _ctl-bytes144654_
                _rctl144655_
                _flags144656_
                _rflags144657_)))
          (if (not (##fxnegative? _r144663_))
              _r144663_
              (let ((_errno144666_ (##fx- _r144663_)))
                (if (or (eq? _errno144666_ std/os/error#EAGAIN)
                        (eq? _errno144666_ std/os/error#EWOULDBLOCK))
                    '#f
                    (if (eq? _errno144666_ std/os/error#EINTR)
                        (_lp144659_)
                        (std/os/error#raise-os-error
                         _errno144666_
                         std/os/socket#socket-recvmsg
                         _sock144650_
                         _name-bytes144651_
                         _io-bytes144653_
                         _ctl-bytes144654_
                         _flags144656_)))))))))
  (define std/os/socket#socket-recvmsg
    (lambda (_sock144629_ _name144630_ _io144631_ _ctl144632_ _flags144633_)
      (let* ((_rname144638_
              (if _name144630_
                  (let ((_r144635_ (std/os/_socket#make_int_ptr)))
                    (if _r144635_
                        _r144635_
                        (error '"Error allocating memory" 'make_int_ptr)))
                  '#f))
             (_rctl144643_
              (if _ctl144632_
                  (let ((_r144640_ (std/os/_socket#make_int_ptr)))
                    (if _r144640_
                        _r144640_
                        (error '"Error allocating memory" 'make_int_ptr)))
                  '#f))
             (_rflags144645_ (std/os/_socket#make_int_ptr))
             (_r144647_
              (std/os/socket#socket-recvmsg*
               _sock144629_
               _name144630_
               _rname144638_
               _io144631_
               _ctl144632_
               _rctl144643_
               _flags144633_
               _rflags144645_)))
        (if _r144647_
            (values _r144647_
                    (if _rname144638_
                        (std/os/_socket#int_ptr_value _rname144638_)
                        '#f)
                    (if _rctl144643_
                        (std/os/_socket#int_ptr_value _rctl144643_)
                        '#f)
                    (std/os/_socket#int_ptr_value _rflags144645_))
            '#f))))
  (define std/os/socket#socket-getpeername__%
    (lambda (_sock144608_ _sa144609_)
      (let ((_sa144614_
             (let ((_$e144611_ _sa144609_))
               (if _$e144611_
                   _$e144611_
                   (std/os/socket#make-socket-address
                    (std/os/socket#socket-domain _sock144608_))))))
        (let ((_r144616_
               (std/os/_socket#_getpeername
                (std/os/fd#fd-e _sock144608_)
                _sa144614_)))
          (if (not (##fxnegative? _r144616_))
              _r144616_
              (std/os/error#raise-os-error
               (##fx- _r144616_)
               std/os/socket#socket-getpeername
               _sock144608_)))
        _sa144614_)))
  (define std/os/socket#socket-getpeername__0
    (lambda (_sock144622_)
      (let ((_sa144624_ '#f))
        (std/os/socket#socket-getpeername__% _sock144622_ _sa144624_))))
  (define std/os/socket#socket-getpeername
    (lambda _g145149_
      (let ((_g145148_ (length _g145149_)))
        (cond ((##fx= _g145148_ 1)
               (apply std/os/socket#socket-getpeername__0 _g145149_))
              ((##fx= _g145148_ 2)
               (apply std/os/socket#socket-getpeername__% _g145149_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-getpeername
                _g145149_))))))
  (define std/os/socket#socket-getsockname__%
    (lambda (_sock144586_ _sa144587_)
      (let ((_sa144592_
             (let ((_$e144589_ _sa144587_))
               (if _$e144589_
                   _$e144589_
                   (std/os/socket#make-socket-address
                    (std/os/socket#socket-domain _sock144586_))))))
        (let ((_r144594_
               (std/os/_socket#_getsockname
                (std/os/fd#fd-e _sock144586_)
                _sa144592_)))
          (if (not (##fxnegative? _r144594_))
              _r144594_
              (std/os/error#raise-os-error
               (##fx- _r144594_)
               std/os/socket#socket-getsockname
               _sock144586_)))
        _sa144592_)))
  (define std/os/socket#socket-getsockname__0
    (lambda (_sock144600_)
      (let ((_sa144602_ '#f))
        (std/os/socket#socket-getsockname__% _sock144600_ _sa144602_))))
  (define std/os/socket#socket-getsockname
    (lambda _g145151_
      (let ((_g145150_ (length _g145151_)))
        (cond ((##fx= _g145150_ 1)
               (apply std/os/socket#socket-getsockname__0 _g145151_))
              ((##fx= _g145150_ 2)
               (apply std/os/socket#socket-getsockname__% _g145151_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/os/socket#socket-getsockname
                _g145151_))))))
  (define std/os/socket#socket-domain
    (lambda (_sock144583_)
      (std/os/socket#socket-getsockopt
       _sock144583_
       std/os/_socket#SOL_SOCKET
       std/os/_socket#SO_DOMAIN)))
  (define std/os/socket#socket-address?
    (lambda (_obj144581_) (std/os/_socket#sockaddr? _obj144581_)))
  (define std/os/socket#make-socket-address
    (lambda (_af144576_)
      (let ((_r144578_ (std/os/_socket#make_sockaddr _af144576_)))
        (if _r144578_
            _r144578_
            (error '"Error allocating memory" 'make_sockaddr)))))
  (define std/os/socket#make-socket-address-in
    (lambda () (std/os/socket#make-socket-address std/os/_socket#AF_INET)))
  (define std/os/socket#make-socket-address-in6
    (lambda () (std/os/socket#make-socket-address std/os/_socket#AF_INET6)))
  (define std/os/socket#make-socket-address-un
    (lambda () (std/os/socket#make-socket-address std/os/_socket#AF_UNIX)))
  (define std/os/socket#socket-address-in
    (lambda (_host144565_ _port144566_)
      (let* ((_ip4144568_ (std/net/address#ip4-address _host144565_))
             (_sa144570_ (std/os/socket#make-socket-address-in)))
        (std/os/_socket#sockaddr_in_addr_set _sa144570_ _ip4144568_)
        (std/os/_socket#sockaddr_in_port_set _sa144570_ _port144566_)
        _sa144570_)))
  (define std/os/socket#socket-address-in6
    (lambda (_host144557_ _port144558_)
      (let* ((_ip6144560_ (std/net/address#ip6-address _host144557_))
             (_sa144562_ (std/os/socket#make-socket-address-in6)))
        (std/os/_socket#sockaddr_in6_addr_set _sa144562_ _ip6144560_)
        (std/os/_socket#sockaddr_in6_port_set _sa144562_ _port144558_)
        _sa144562_)))
  (define std/os/socket#socket-address-un
    (lambda (_path144551_)
      (let ((_pathlen144553_
             (std/text/utf8#string-utf8-length__0 _path144551_)))
        (if (##fx< _pathlen144553_ std/os/_socket#UNIX_MAX_PATH)
            (let ((_sa144555_ (std/os/socket#make-socket-address-un)))
              (std/os/_socket#sockaddr_un_path_set _sa144555_ _path144551_)
              _sa144555_)
            (error '"Malformed address; path is too long")))))
  (define std/os/socket#socket-address-family
    (lambda (_sa144549_) (std/os/_socket#sockaddr_family _sa144549_)))
  (define std/os/socket#socket-address
    (lambda (_addr144544_)
      (if (std/os/_socket#sockaddr? _addr144544_)
          _addr144544_
          (if (or (std/net/address#inet-address? _addr144544_)
                  (std/net/address#inet-address-string? _addr144544_))
              (std/os/socket#inet-address->socket-address _addr144544_)
              (std/os/socket#socket-address-un _addr144544_)))))
  (define std/os/socket#inet-address->socket-address
    (lambda (_addr144514_)
      (let* ((_g144515144522_ (std/net/address#resolve-address _addr144514_))
             (_E144517144526_
              (lambda () (error '"No clause matching" _g144515144522_)))
             (_K144518144532_
              (lambda (_port144529_ _ip144530_)
                (if (std/net/address#ip4-address? _ip144530_)
                    (std/os/socket#socket-address-in _ip144530_ _port144529_)
                    (if (std/net/address#ip6-address? _ip144530_)
                        (std/os/socket#socket-address-in6
                         _ip144530_
                         _port144529_)
                        (error '"Bad address; expected ip4 or ip6 inet-address"
                               _addr144514_))))))
        (if (##pair? _g144515144522_)
            (let ((_hd144519144535_ (##car _g144515144522_))
                  (_tl144520144537_ (##cdr _g144515144522_)))
              (let* ((_ip144540_ _hd144519144535_)
                     (_port144542_ _tl144520144537_))
                (_K144518144532_ _port144542_ _ip144540_)))
            (_E144517144526_)))))
  (define std/os/socket#socket-address->address
    (lambda (_sa144498_)
      (let ((_saf144500_ (std/os/_socket#sockaddr_family _sa144498_)))
        (if (eq? _saf144500_ std/os/_socket#AF_INET)
            (let* ((_ip4144502_ (make-u8vector '4))
                   (_g145152_
                    (std/os/_socket#sockaddr_in_addr _sa144498_ _ip4144502_))
                   (_port144505_ (std/os/_socket#sockaddr_in_port _sa144498_)))
              (cons _ip4144502_ _port144505_))
            (if (eq? _saf144500_ std/os/_socket#AF_INET6)
                (let* ((_ip6144508_ (make-u8vector '16))
                       (_g145153_
                        (std/os/_socket#sockaddr_in6_addr
                         _sa144498_
                         _ip6144508_))
                       (_port144511_
                        (std/os/_socket#sockaddr_in6_port _sa144498_)))
                  (cons _ip6144508_ _port144511_))
                (if (eq? _saf144500_ std/os/_socket#AF_UNIX)
                    (std/os/_socket#sockaddr_un_path _sa144498_)
                    (error '"Unknown address family"
                           _sa144498_
                           _saf144500_)))))))
  (define std/os/socket#socket-address->string
    (lambda (_sa144482_)
      (let ((_saf144484_ (std/os/_socket#sockaddr_family _sa144482_)))
        (if (eq? _saf144484_ std/os/_socket#AF_INET)
            (let* ((_ip4144486_ (make-u8vector '4))
                   (_g145154_
                    (std/os/_socket#sockaddr_in_addr _sa144482_ _ip4144486_))
                   (_port144489_ (std/os/_socket#sockaddr_in_port _sa144482_)))
              (string-append
               (std/net/address#ip4-address->string _ip4144486_)
               '":"
               (number->string _port144489_)))
            (if (eq? _saf144484_ std/os/_socket#AF_INET6)
                (let* ((_ip6144492_ (make-u8vector '16))
                       (_g145155_
                        (std/os/_socket#sockaddr_in6_addr
                         _sa144482_
                         _ip6144492_))
                       (_port144495_
                        (std/os/_socket#sockaddr_in6_port _sa144482_)))
                  (string-append
                   (std/net/address#ip6-address->string _ip6144492_)
                   '":"
                   (number->string _port144495_)))
                (if (eq? _saf144484_ std/os/_socket#AF_UNIX)
                    (std/os/_socket#sockaddr_un_path _sa144482_)
                    (error '"Unknown address family"
                           _sa144482_
                           _saf144484_)))))))
  (define std/os/socket#socket-getsockopt
    (lambda (_sock144436_ _level144437_ _opt144438_ . _args144439_)
      (let ((_$e144441_
             (table-ref std/os/socket#socket-sockopts _level144437_ '#f)))
        (if _$e144441_
            ((lambda (_ht144444_)
               (let ((_$e144446_ (table-ref _ht144444_ _opt144438_ '#f)))
                 (if _$e144446_
                     ((lambda (_e144448144450_)
                        (let* ((_g144452144459_ _e144448144450_)
                               (_E144454144463_
                                (lambda ()
                                  (error '"No clause matching"
                                         _g144452144459_)))
                               (_K144455144469_
                                (lambda (_setf144466_ _getf144467_)
                                  (if _getf144467_
                                      (apply _getf144467_
                                             _sock144436_
                                             _level144437_
                                             _opt144438_
                                             _args144439_)
                                      (error '"No getsockopt operation defined for option"
                                             _level144437_
                                             _opt144438_)))))
                          (if (##fx= (if (##values? _g144452144459_)
                                         (##vector-length _g144452144459_)
                                         '1)
                                     '2)
                              (let* ((_e144456144472_
                                      (##vector-ref _g144452144459_ '0))
                                     (_getf144475_ _e144456144472_)
                                     (_e144457144477_
                                      (##vector-ref _g144452144459_ '1))
                                     (_setf144480_ _e144457144477_))
                                (_K144455144469_ _setf144480_ _getf144475_))
                              (_E144454144463_))))
                      _$e144446_)
                     (error '"Unknown socket option"
                            _level144437_
                            _opt144438_))))
             _$e144441_)
            (error '"Unknown socket level" _level144437_ _opt144438_)))))
  (define std/os/socket#socket-setsockopt
    (lambda (_sock144389_ _level144390_ _opt144391_ _val144392_ . _args144393_)
      (let ((_$e144395_
             (table-ref std/os/socket#socket-sockopts _level144390_ '#f)))
        (if _$e144395_
            ((lambda (_ht144398_)
               (let ((_$e144400_ (table-ref _ht144398_ _opt144391_ '#f)))
                 (if _$e144400_
                     ((lambda (_e144402144404_)
                        (let* ((_g144406144413_ _e144402144404_)
                               (_E144408144417_
                                (lambda ()
                                  (error '"No clause matching"
                                         _g144406144413_)))
                               (_K144409144423_
                                (lambda (_setf144420_ _getf144421_)
                                  (if _setf144420_
                                      (apply _setf144420_
                                             _sock144389_
                                             _level144390_
                                             _opt144391_
                                             _val144392_
                                             _args144393_)
                                      (error '"No setsockopt operation defined for option"
                                             _level144390_
                                             _opt144391_)))))
                          (if (##fx= (if (##values? _g144406144413_)
                                         (##vector-length _g144406144413_)
                                         '1)
                                     '2)
                              (let* ((_e144410144426_
                                      (##vector-ref _g144406144413_ '0))
                                     (_getf144429_ _e144410144426_)
                                     (_e144411144431_
                                      (##vector-ref _g144406144413_ '1))
                                     (_setf144434_ _e144411144431_))
                                (_K144409144423_ _setf144434_ _getf144429_))
                              (_E144408144417_))))
                      _$e144400_)
                     (error '"Unknown socket option"
                            _level144390_
                            _opt144391_))))
             _$e144395_)
            (error '"Unknown socket level" _level144390_ _opt144391_)))))
  (define std/os/socket#socket-getsockopt-int
    (lambda (_sock144382_ _level144383_ _opt144384_)
      (let ((_r144386_
             (std/os/_socket#_getsockopt_int
              (std/os/fd#fd-e _sock144382_)
              _level144383_
              _opt144384_)))
        (if (not (##fxnegative? _r144386_))
            _r144386_
            (std/os/error#raise-os-error
             (##fx- _r144386_)
             std/os/socket#socket-getsockopt
             _sock144382_
             _level144383_
             _opt144384_)))))
  (define std/os/socket#socket-setsockopt-int
    (lambda (_sock144374_ _level144375_ _opt144376_ _val144377_)
      (if (fixnum? _val144377_)
          (let ((_r144379_
                 (std/os/_socket#_setsockopt_int
                  (std/os/fd#fd-e _sock144374_)
                  _level144375_
                  _opt144376_
                  _val144377_)))
            (if (not (##fxnegative? _r144379_))
                _r144379_
                (std/os/error#raise-os-error
                 (##fx- _r144379_)
                 std/os/socket#socket-setsockopt
                 _sock144374_
                 _level144375_
                 _opt144376_
                 _val144377_)))
          (error '"Bad argument; expected fixnum" _val144377_))))
  (define std/os/socket#socket-getsockopt-tv
    (lambda (_sock144362_ _level144363_ _opt144364_)
      (let ((_tv144369_
             (let ((_r144366_ (std/os/_socket#make_tv)))
               (if _r144366_
                   _r144366_
                   (error '"Error allocating memory" 'make_tv)))))
        (let ((_r144371_
               (std/os/_socket#_getsockopt_tv
                (std/os/fd#fd-e _sock144362_)
                _level144363_
                _opt144364_
                _tv144369_)))
          (if (not (##fxnegative? _r144371_))
              _r144371_
              (std/os/error#raise-os-error
               (##fx- _r144371_)
               std/os/socket#socket-getsockopt
               _sock144362_
               _level144363_
               _opt144364_)))
        (+ (std/os/_socket#tv_sec _tv144369_)
           (/ (std/os/_socket#tv_usec _tv144369_) '1000000.)))))
  (define std/os/socket#socket-setsockopt-tv
    (lambda (_sock144342_ _level144343_ _opt144344_ _tm144345_)
      (if (real? _tm144345_)
          (let* ((_tm-sec144347_ (floor _tm144345_))
                 (_tm-frac144349_ (- _tm144345_ _tm-sec144347_))
                 (_tm-usec144351_ (floor (* _tm-frac144349_ '1000000.)))
                 (_tv144356_
                  (let ((_r144353_ (std/os/_socket#make_tv)))
                    (if _r144353_
                        _r144353_
                        (error '"Error allocating memory" 'make_tv)))))
            (std/os/_socket#tv_sec_set
             _tv144356_
             (inexact->exact _tm-sec144347_))
            (std/os/_socket#tv_usec_set
             _tv144356_
             (inexact->exact _tm-usec144351_))
            (let ((_r144359_
                   (std/os/_socket#_setsockopt_tv
                    (std/os/fd#fd-e _sock144342_)
                    _level144343_
                    _opt144344_
                    _tv144356_)))
              (if (not (##fxnegative? _r144359_))
                  _r144359_
                  (std/os/error#raise-os-error
                   (##fx- _r144359_)
                   std/os/socket#socket-setsockopt
                   _sock144342_
                   _level144343_
                   _opt144344_
                   _tm144345_))))
          (error '"Bad argument; expected real" _tm144345_))))
  (define std/os/socket#socket-getsockopt-addr-in
    (lambda (_sock144333_ _level144334_ _opt144335_)
      (let ((_sa144337_ (std/os/socket#make-socket-address-in)))
        (let ((_r144339_
               (std/os/_socket#_getsockopt_sa
                (std/os/fd#fd-e _sock144333_)
                _level144334_
                _opt144335_
                _sa144337_)))
          (if (not (##fxnegative? _r144339_))
              _r144339_
              (std/os/error#raise-os-error
               (##fx- _r144339_)
               std/os/socket#socket-getsockopt
               _sock144333_
               _level144334_
               _opt144335_)))
        _sa144337_)))
  (define std/os/socket#socket-getsockopt-addr-in6
    (lambda (_sock144324_ _level144325_ _opt144326_)
      (let ((_sa144328_ (std/os/socket#make-socket-address-in6)))
        (let ((_r144330_
               (std/os/_socket#_getsockopt_sa
                (std/os/fd#fd-e _sock144324_)
                _level144325_
                _opt144326_
                _sa144328_)))
          (if (not (##fxnegative? _r144330_))
              _r144330_
              (std/os/error#raise-os-error
               (##fx- _r144330_)
               std/os/socket#socket-getsockopt
               _sock144324_
               _level144325_
               _opt144326_)))
        _sa144328_)))
  (define std/os/socket#socket-setsockopt-addr
    (lambda (_sock144314_ _level144315_ _opt144316_ _addr144317_)
      (let* ((_sa144319_ (std/os/socket#socket-address _addr144317_))
             (_r144321_
              (std/os/_socket#_setsockopt_sa
               (std/os/fd#fd-e _sock144314_)
               _level144315_
               _opt144316_
               _sa144319_)))
        (if (not (##fxnegative? _r144321_))
            _r144321_
            (std/os/error#raise-os-error
             (##fx- _r144321_)
             std/os/socket#socket-setsockopt
             _sock144314_
             _level144315_
             _opt144316_
             _addr144317_)))))
  (define std/os/socket#socket-getsockopt-bytes
    (lambda (_sock144306_ _level144307_ _opt144308_ _bytes144309_)
      (if (u8vector? _bytes144309_)
          (let ((_r144311_
                 (std/os/_socket#_getsockopt_bytes
                  (std/os/fd#fd-e _sock144306_)
                  _level144307_
                  _opt144308_
                  _bytes144309_)))
            (if (not (##fxnegative? _r144311_))
                _r144311_
                (std/os/error#raise-os-error
                 (##fx- _r144311_)
                 std/os/socket#socket-getsockopt
                 _sock144306_
                 _level144307_
                 _opt144308_
                 _bytes144309_)))
          (error '"Bad argument; expected bytes" _bytes144309_))))
  (define std/os/socket#socket-setsockopt-bytes
    (lambda (_sock144298_ _level144299_ _opt144300_ _bytes144301_)
      (if (u8vector? _bytes144301_)
          (let ((_r144303_
                 (std/os/_socket#_setsockopt_bytes
                  (std/os/fd#fd-e _sock144298_)
                  _level144299_
                  _opt144300_
                  _bytes144301_)))
            (if (not (##fxnegative? _r144303_))
                _r144303_
                (std/os/error#raise-os-error
                 (##fx- _r144303_)
                 std/os/socket#socket-setsockopt
                 _sock144298_
                 _level144299_
                 _opt144300_
                 _bytes144301_)))
          (error '"Bad argument; expected bytes" _bytes144301_))))
  (define std/os/socket#socket-setsockopt-mreq
    (lambda (_sock144254_ _level144255_ _opt144256_ _ips144257_)
      (let* ((_ips144258144266_ _ips144257_)
             (_else144260144274_
              (lambda ()
                (error '"Bad argument; expected pair of ip4 addresses"
                       _ips144257_)))
             (_K144262144286_
              (lambda (_laddr144277_ _maddr144278_)
                (let ((_maddr144280_
                       (std/net/address#ip4-address _maddr144278_))
                      (_laddr144281_
                       (std/net/address#ip4-address _laddr144277_)))
                  (let ((_r144283_
                         (std/os/_socket#_setsockopt_mreq
                          (std/os/fd#fd-e _sock144254_)
                          _level144255_
                          _opt144256_
                          _maddr144280_
                          _laddr144281_)))
                    (if (not (##fxnegative? _r144283_))
                        _r144283_
                        (std/os/error#raise-os-error
                         (##fx- _r144283_)
                         std/os/socket#socket-setsockopt
                         _sock144254_
                         _level144255_
                         _opt144256_
                         _ips144257_)))))))
        (if (##pair? _ips144258144266_)
            (let ((_hd144263144289_ (##car _ips144258144266_))
                  (_tl144264144291_ (##cdr _ips144258144266_)))
              (let* ((_maddr144294_ _hd144263144289_)
                     (_laddr144296_ _tl144264144291_))
                (_K144262144286_ _laddr144296_ _maddr144294_)))
            (_else144260144274_)))))
  (define std/os/socket#socket-setsockopt-mreq-src
    (lambda (_sock144192_ _level144193_ _opt144194_ _ips144195_)
      (let* ((_ips144196144208_ _ips144195_)
             (_else144198144216_
              (lambda ()
                (error '"Bad argument; expected list with 3 ip4 addresses"
                       _ips144195_)))
             (_K144200144230_
              (lambda (_saddr144219_ _iaddr144220_ _maddr144221_)
                (let ((_maddr144223_
                       (std/net/address#ip4-address _maddr144221_))
                      (_iaddr144224_
                       (std/net/address#ip4-address _iaddr144220_))
                      (_saddr144225_
                       (std/net/address#ip4-address _saddr144219_)))
                  (let ((_r144227_
                         (std/os/_socket#_setsockopt_mreq_src
                          (std/os/fd#fd-e _sock144192_)
                          _level144193_
                          _opt144194_
                          _maddr144223_
                          _iaddr144224_
                          _saddr144225_)))
                    (if (not (##fxnegative? _r144227_))
                        _r144227_
                        (std/os/error#raise-os-error
                         (##fx- _r144227_)
                         std/os/socket#socket-setsockopt
                         _sock144192_
                         _level144193_
                         _opt144194_
                         _ips144195_)))))))
        (if (##pair? _ips144196144208_)
            (let ((_hd144201144233_ (##car _ips144196144208_))
                  (_tl144202144235_ (##cdr _ips144196144208_)))
              (let ((_maddr144238_ _hd144201144233_))
                (if (##pair? _tl144202144235_)
                    (let ((_hd144203144240_ (##car _tl144202144235_))
                          (_tl144204144242_ (##cdr _tl144202144235_)))
                      (let ((_iaddr144245_ _hd144203144240_))
                        (if (##pair? _tl144204144242_)
                            (let ((_hd144205144247_ (##car _tl144204144242_))
                                  (_tl144206144249_ (##cdr _tl144204144242_)))
                              (let ((_saddr144252_ _hd144205144247_))
                                (if (##null? _tl144206144249_)
                                    (_K144200144230_
                                     _saddr144252_
                                     _iaddr144245_
                                     _maddr144238_)
                                    (_else144198144216_))))
                            (_else144198144216_))))
                    (_else144198144216_))))
            (_else144198144216_)))))
  (define std/os/socket#socket-setsockopt-mreq6
    (lambda (_sock144149_ _level144150_ _opt144151_ _ips144152_)
      (let* ((_ips144153144161_ _ips144152_)
             (_else144155144169_
              (lambda ()
                (error '"Bad argument; expected pair of ip6 addresses"
                       _ips144152_)))
             (_K144157144180_
              (lambda (_ifindex144172_ _maddr144173_)
                (let* ((_maddr144175_
                        (std/net/address#ip6-address _maddr144173_))
                       (_r144177_
                        (std/os/_socket#_setsockopt_mreq6
                         (std/os/fd#fd-e _sock144149_)
                         _level144150_
                         _opt144151_
                         _maddr144175_
                         _ifindex144172_)))
                  (if (not (##fxnegative? _r144177_))
                      _r144177_
                      (std/os/error#raise-os-error
                       (##fx- _r144177_)
                       std/os/socket#socket-setsockopt
                       _sock144149_
                       _level144150_
                       _opt144151_
                       _ips144152_))))))
        (if (##pair? _ips144153144161_)
            (let ((_hd144158144183_ (##car _ips144153144161_))
                  (_tl144159144185_ (##cdr _ips144153144161_)))
              (let* ((_maddr144188_ _hd144158144183_)
                     (_ifindex144190_ _tl144159144185_))
                (_K144157144180_ _ifindex144190_ _maddr144188_)))
            (_else144155144169_)))))
  (define std/os/socket#socket-getsockopt-linger
    (lambda (_sock144137_ _level144138_ _opt144139_)
      (let ((_linger144144_
             (let ((_r144141_ (std/os/_socket#make_linger)))
               (if _r144141_
                   _r144141_
                   (error '"Error allocating memory" 'make_linger)))))
        (let ((_r144146_
               (std/os/_socket#_getsockopt_linger
                _sock144137_
                _level144138_
                _opt144139_
                _linger144144_)))
          (if (not (##fxnegative? _r144146_))
              _r144146_
              (std/os/error#raise-os-error
               (##fx- _r144146_)
               std/os/socket#socket-getsockopt
               _sock144137_
               _level144138_
               _opt144139_)))
        (if (##fxzero? (std/os/_socket#linger_onoff _linger144144_))
            '#f
            (std/os/_socket#linger_linger _linger144144_)))))
  (define std/os/socket#socket-setsockopt-linger
    (lambda (_sock144124_ _level144125_ _opt144126_ _val144127_)
      (let ((_linger144132_
             (let ((_r144129_ (std/os/_socket#make_linger)))
               (if _r144129_
                   _r144129_
                   (error '"Error allocating memory" 'make_linger)))))
        (if (fixnum? _val144127_)
            (begin
              (std/os/_socket#linger_onoff_set _linger144132_ '1)
              (std/os/_socket#linger_linger_set _linger144132_ _val144127_))
            (if (not _val144127_)
                (begin
                  (std/os/_socket#linger_onoff_set _linger144132_ '0)
                  (std/os/_socket#linger_linger_set _linger144132_ '0))
                (error '"Bad argument; expected fixnum or #f" _val144127_)))
        (let ((_r144134_
               (std/os/_socket#_setsockopt_linger
                _sock144124_
                _level144125_
                _opt144126_
                _linger144132_)))
          (if (not (##fxnegative? _r144134_))
              _r144134_
              (std/os/error#raise-os-error
               (##fx- _r144134_)
               std/os/socket#socket-setsockopt
               _sock144124_
               _level144125_
               _opt144126_
               _val144127_))))))
  (define std/os/socket#socket-sockopts
    (let ((_ht144121_ (make-table 'test: eq? 'size: '4)))
      (table-set! _ht144121_ std/os/_socket#SOL_SOCKET (make-table 'test: eq?))
      (table-set! _ht144121_ std/os/_socket#IPPROTO_IP (make-table 'test: eq?))
      (table-set!
       _ht144121_
       std/os/_socket#IPPROTO_IPV6
       (make-table 'test: eq?))
      (table-set!
       _ht144121_
       std/os/_socket#IPPROTO_TCP
       (make-table 'test: eq?))
      _ht144121_))
  (if std/os/_socket#SO_ACCEPTCONN
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_ACCEPTCONN
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#SO_BINDTODEVICE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_BINDTODEVICE
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#SO_BROADCAST
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_BROADCAST
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_DEBUG
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_DEBUG
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_DOMAIN
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_DOMAIN
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#SO_DONTROUTE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_DONTROUTE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_ERROR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_ERROR
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#SO_KEEPALIVE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_KEEPALIVE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_LINGER
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_LINGER
       (values std/os/socket#socket-getsockopt-linger
               std/os/socket#socket-setsockopt-linger))
      '#!void)
  (if std/os/_socket#SO_OOBLINE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_OOBLINE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_PASSCRED
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PASSCRED
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_PEERCRED
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PEERCRED
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#SO_PEEK_OFF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PEEK_OFF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_PROTOCOL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_PROTOCOL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_RCVBUF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_RCVBUF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_SNDBUF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_SNDBUF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_RCVLOWAT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_RCVLOWAT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_SNDLOWAT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_SNDLOWAT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_RCVTIMEO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_RCVTIMEO
       (values std/os/socket#socket-getsockopt-tv
               std/os/socket#socket-setsockopt-tv))
      '#!void)
  (if std/os/_socket#SO_SNDTIMEO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_SNDTIMEO
       (values std/os/socket#socket-getsockopt-tv
               std/os/socket#socket-setsockopt-tv))
      '#!void)
  (if std/os/_socket#SO_REUSEADDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_REUSEADDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_REUSEPORT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_REUSEPORT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_TYPE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_TYPE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_TIMESTAMP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_TIMESTAMP
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#SO_USELOOPBACK
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#SOL_SOCKET)
       std/os/_socket#SO_USELOOPBACK
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_ADD_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_ADD_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq))
      '#!void)
  (if std/os/_socket#IP_DROP_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_DROP_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq))
      '#!void)
  (if std/os/_socket#IP_ADD_SOURCE_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_ADD_SOURCE_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_DROP_SOURCE_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_DROP_SOURCE_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_BLOCK_SOURCE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_BLOCK_SOURCE
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_UNBLOCK_SOURCE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_UNBLOCK_SOURCE
       (values '#f std/os/socket#socket-setsockopt-mreq-src))
      '#!void)
  (if std/os/_socket#IP_FREEBIND
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_FREEBIND
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_HDRINCL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_HDRINCL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MTU
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MTU
       (values std/os/socket#socket-getsockopt-int '#f))
      '#!void)
  (if std/os/_socket#IP_MTU_DISCOVER
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MTU_DISCOVER
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_ALL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_ALL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_IF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_IF
       (values '#f std/os/socket#socket-setsockopt-mreq))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_LOOP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_LOOP
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_MULTICAST_TTL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_MULTICAST_TTL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_NODEFRAG
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_NODEFRAG
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_OPTIONS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_OPTIONS
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#IP_PKTINFO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_PKTINFO
       (values std/os/socket#socket-getsockopt-bytes
               std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#IP_RECVERR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVERR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVORIGDSTADDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVORIGDSTADDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVTOS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVTOS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RECVTTL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RECVTTL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_RETOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_RETOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_ROUTER_ALERT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_ROUTER_ALERT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_TOS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_TOS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IP_TTL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IP)
       std/os/_socket#IP_TTL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_ADDRFORM
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_ADDRFORM
       (values '#f std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_ADD_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_ADD_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq6))
      '#!void)
  (if std/os/_socket#IPV6_DROP_MEMBERSHIP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_DROP_MEMBERSHIP
       (values '#f std/os/socket#socket-setsockopt-mreq6))
      '#!void)
  (if std/os/_socket#IPV6_MTU
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MTU
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MTU_DISCOVER
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MTU_DISCOVER
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MULTICAST_HOPS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MULTICAST_HOPS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MULTICAST_IF
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MULTICAST_IF
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_MULTICAST_LOOP
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_MULTICAST_LOOP
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_RECVPKTINFO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_RECVPKTINFO
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_RTHDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_RTHDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_AUTHHDR
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_AUTHHDR
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_DSTOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_DSTOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_HOPOPTS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_HOPOPTS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_FLOWINFO
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_FLOWINFO
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_HOPLIMIT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_HOPLIMIT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_ROUTER_ALERT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_ROUTER_ALERT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_UNICAST_HOPS
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_UNICAST_HOPS
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#IPV6_V6ONLY
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_IPV6)
       std/os/_socket#IPV6_V6ONLY
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_CONGESTION
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_CONGESTION
       (values '#f std/os/socket#socket-setsockopt-bytes))
      '#!void)
  (if std/os/_socket#TCP_CORK
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_CORK
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_DEFER_ACCEPT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_DEFER_ACCEPT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_KEEPCNT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_KEEPCNT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_KEEPIDLE
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_KEEPIDLE
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_KEEPINTVL
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_KEEPINTVL
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_MAXSEG
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_MAXSEG
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_NODELAY
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_NODELAY
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void)
  (if std/os/_socket#TCP_SYNCNT
      (table-set!
       (table-ref std/os/socket#socket-sockopts std/os/_socket#IPPROTO_TCP)
       std/os/_socket#TCP_SYNCNT
       (values std/os/socket#socket-getsockopt-int
               std/os/socket#socket-setsockopt-int))
      '#!void))
