/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DynamicMap;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public abstract class FieldScript {
    public static final String[] PARAMETERS = new String[0];
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(DynamicMap.class));
    private static final Map<String, Function<Object, Object>> PARAMS_FUNCTIONS = org.elasticsearch.common.collect.Map.of((Object)"doc", value -> {
        deprecationLogger.deprecatedAndMaybeLog("field-script_doc", "Accessing variable [doc] via [params.doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, (Object)"_doc", value -> {
        deprecationLogger.deprecatedAndMaybeLog("field-script__doc", "Accessing variable [doc] via [params._doc] from within an field-script is deprecated in favor of directly accessing [doc].", new Object[0]);
        return value;
    }, (Object)"_source", value -> ((SourceLookup)value).loadSourceIfNeeded());
    private final Map<String, Object> params;
    private final LeafSearchLookup leafLookup;
    public static final ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("field", Factory.class);

    public FieldScript(Map<String, Object> params, SearchLookup lookup, LeafReaderContext leafContext) {
        this.leafLookup = lookup.getLeafSearchLookup(leafContext);
        params = new HashMap<String, Object>(params);
        params.putAll(this.leafLookup.asMap());
        this.params = new DynamicMap(params, PARAMS_FUNCTIONS);
    }

    protected FieldScript() {
        this.params = null;
        this.leafLookup = null;
    }

    public abstract Object execute();

    protected final LeafSearchLookup getLeafLookup() {
        return this.leafLookup;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public final Map<String, ScriptDocValues<?>> getDoc() {
        return this.leafLookup.doc();
    }

    public void setDocument(int docid) {
        this.leafLookup.setDocument(docid);
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(Map<String, Object> var1, SearchLookup var2);
    }

    public static interface LeafFactory {
        public FieldScript newInstance(LeafReaderContext var1) throws IOException;
    }
}

