/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc.xml;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.LocalizableReport;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.css.EpubCSSCheckCSSHandler;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.util.LocationImpl;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import org.idpf.epubcheck.util.css.CssParser;
import org.idpf.epubcheck.util.css.CssSource;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CSSStyleAttributeHandler
extends DefaultHandler {
    String fileName;
    Stack<String> tagStack = new Stack();
    private Locator locator;
    private boolean inStyleTag = false;
    private boolean isGlobalFixedFormat = false;
    private boolean documentIsFixedFormat = false;
    private StyleAttribute currentStyleTag = null;
    private final HashMap<String, StyleAttribute> styleAttributesValues = new LinkedHashMap<String, StyleAttribute>();
    private final Stack<HashMap<String, EpubCSSCheckCSSHandler.ClassUsage>> localStyles = new Stack();
    private final Stack<Integer> styleLevels = new Stack();
    private EpubCSSCheckCSSHandler cssHandler;
    private Report report;
    private final Vector<StyleAttribute> styleTagValues = new Vector();

    public CSSStyleAttributeHandler(boolean isGlobalFixedFormat, boolean documentIsFixedFormat) {
        this.isGlobalFixedFormat = isGlobalFixedFormat;
        this.documentIsFixedFormat = documentIsFixedFormat;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public EpubCSSCheckCSSHandler getCssHandler() {
        return this.cssHandler;
    }

    public void setCssHandler(EpubCSSCheckCSSHandler value) {
        this.cssHandler = value;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Collection<StyleAttribute> getStyleAttributesValues() {
        return this.styleAttributesValues.values();
    }

    public Vector<StyleAttribute> getStyleTagValues() {
        return this.styleTagValues;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        this.localStyles.clear();
        this.styleLevels.clear();
    }

    @Override
    public void endDocument() {
        while (!this.localStyles.isEmpty()) {
            HashMap<String, EpubCSSCheckCSSHandler.ClassUsage> localStyleMap = this.localStyles.pop();
            for (String key : localStyleMap.keySet()) {
                EpubCSSCheckCSSHandler.ClassUsage cu = localStyleMap.get(key);
                if (cu.Count != 0) continue;
                assert (cu.Name != null && !cu.Name.isEmpty());
                this.report.message(MessageId.CSS_024, EPUBLocation.create(this.getFileName(), cu.Location.getLineNumber(), cu.Location.getColumnNumber(), key), new Object[0]);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tagStack.push(qName.toLowerCase(Locale.ROOT));
        if (qName.compareToIgnoreCase("style") == 0) {
            LinkedHashMap localStyleMap = new LinkedHashMap();
            this.localStyles.push(localStyleMap);
            this.styleLevels.push(this.tagStack.size() - 1);
            this.inStyleTag = true;
            this.currentStyleTag = new StyleAttribute();
            this.currentStyleTag.setLine(this.locator.getLineNumber());
            this.currentStyleTag.setColumn(this.locator.getColumnNumber());
            this.currentStyleTag.setValue("");
        } else {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String[] attrValues;
                String attrValue;
                String attrName = attributes.getQName(i);
                if (attrName.compareToIgnoreCase("style") == 0) {
                    attrValue = attributes.getValue(i);
                    StyleAttribute sa = new StyleAttribute();
                    sa.setValue(attrValue);
                    sa.setLine(this.locator.getLineNumber());
                    sa.setColumn(this.locator.getColumnNumber());
                    this.styleAttributesValues.put(attrValue, sa);
                    continue;
                }
                if (attrName.compareToIgnoreCase("class") != 0 || (attrValue = attributes.getValue(i)) == null || attrValue.length() <= 0) continue;
                for (String value : attrValues = attrValue.split("\\s+")) {
                    String styleName;
                    if (value.length() <= 0 || this.IncrementLocalCssClassCount(styleName = "." + value) || this.IncrementGlobalCssClassCount(styleName)) continue;
                    this.report.message(MessageId.CSS_025, EPUBLocation.create(this.getFileName(), this.locator.getLineNumber(), this.locator.getColumnNumber(), styleName), new Object[0]);
                }
            }
        }
    }

    private boolean IncrementGlobalCssClassCount(String attrValue) {
        EpubCSSCheckCSSHandler handler = this.getCssHandler();
        return handler != null && handler.IncrementGlobalCssClassCount(attrValue);
    }

    private boolean IncrementLocalCssClassCount(String className) {
        for (int i = this.localStyles.size() - 1; i >= 0; --i) {
            EpubCSSCheckCSSHandler.ClassUsage cu;
            HashMap h = (HashMap)this.localStyles.get(i);
            if (h == null || (cu = (EpubCSSCheckCSSHandler.ClassUsage)h.get(className)) == null) continue;
            ++cu.Count;
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.tagStack.pop();
        if (this.inStyleTag && "style".compareToIgnoreCase(qName) == 0) {
            this.parseCurrentStyleTag(this.currentStyleTag);
            this.styleTagValues.add(this.currentStyleTag);
            this.inStyleTag = false;
        }
        if (this.styleLevels.size() > 0 && this.tagStack.size() < this.styleLevels.peek()) {
            HashMap<String, EpubCSSCheckCSSHandler.ClassUsage> localStyleMap;
            if (!this.tagStack.empty() && "head".compareToIgnoreCase(qName) != 0) {
                this.styleLevels.pop();
                localStyleMap = this.localStyles.pop();
            } else {
                localStyleMap = this.localStyles.peek();
            }
            if ("head".compareToIgnoreCase(qName) != 0) {
                for (String key : localStyleMap.keySet()) {
                    EpubCSSCheckCSSHandler.ClassUsage cu = localStyleMap.get(key);
                    if (cu == null || cu.Count != 0) continue;
                    EPUBLocation location = EPUBLocation.create(cu.FileName, cu.Location.getLineNumber(), cu.Location.getColumnNumber(), key);
                    if (cu != null) assert (cu.Name != null && !cu.Name.isEmpty());
                    assert (key != null && !key.isEmpty());
                    this.report.message(MessageId.CSS_024, location, new Object[0]);
                }
            }
        }
    }

    private void parseCurrentStyleTag(StyleAttribute currentStyleTag) {
        EpubCSSCheckCSSHandler handler = new EpubCSSCheckCSSHandler(this.report, currentStyleTag.getLine(), currentStyleTag.getColumn(), this.isGlobalFixedFormat, this.documentIsFixedFormat);
        try {
            String s = currentStyleTag.getValue();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes("UTF-8"));
            CssSource source = new CssSource(this.getFileName(), inputStream);
            CssParser parser = new CssParser(this.report instanceof LocalizableReport ? ((LocalizableReport)this.report).getLocale() : Locale.getDefault());
            handler.setPath(this.getFileName());
            HashMap<String, EpubCSSCheckCSSHandler.ClassUsage> localStyleMap = this.localStyles.peek();
            parser.parse(source, handler, handler);
            HashMap<String, EpubCSSCheckCSSHandler.ClassUsage> map = handler.getClassMap();
            for (String key : map.keySet()) {
                EpubCSSCheckCSSHandler.ClassUsage cu = map.get(key);
                int line = cu.Location.getLineNumber();
                int column = cu.Location.getColumnNumber();
                cu.Location = new LocationImpl(line, column, cu.Location.getCharacterOffset(), cu.FileName, cu.FileName);
                cu.Count = 0;
                cu.Name = key;
                localStyleMap.put(cu.Name, cu);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inStyleTag) {
            this.currentStyleTag.setValue(this.currentStyleTag.getValue() + new String(ch, start, length));
        }
    }

    public class StyleAttribute {
        int line;
        int column;
        String value = "";

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

