/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Specification;

public final class ResourceType
extends FreeColGameObjectType {
    private int maxValue;
    private int minValue;
    private static final String MAXIMUM_VALUE_TAG = "maximum-value";
    private static final String MINIMUM_VALUE_TAG = "minimum-value";

    public ResourceType(String id, Specification specification) {
        super(id, specification);
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public GoodsType getBestGoodsType() {
        Specification spec = this.getSpecification();
        GoodsType bestType = null;
        float bestValue = 0.0f;
        for (Modifier modifier : this.getModifiers()) {
            GoodsType goodsType = spec.getGoodsType(modifier.getId());
            float value = (float)spec.getInitialPrice(goodsType) * modifier.applyTo(100.0f);
            if (bestType != null && !(value > bestValue)) continue;
            bestType = goodsType;
            bestValue = value;
        }
        return bestType;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.maxValue > -1) {
            xw.writeAttribute(MAXIMUM_VALUE_TAG, this.maxValue);
            xw.writeAttribute(MINIMUM_VALUE_TAG, this.minValue);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.maxValue = xr.getAttribute(MAXIMUM_VALUE_TAG, -1);
        this.minValue = xr.getAttribute(MINIMUM_VALUE_TAG, -1);
    }

    @Override
    public String getXMLTagName() {
        return ResourceType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "resource-type";
    }
}

