/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.TransportableAIObject;
import net.sf.freecol.server.ai.mission.Mission;
import org.w3c.dom.Element;

public class AIGoods
extends TransportableAIObject {
    private static final Logger logger = Logger.getLogger(AIGoods.class.getName());
    private Goods goods;
    private Location destination;
    private static final String DESTINATION_TAG = "destination";

    public AIGoods(AIMain aiMain, String id) {
        super(aiMain, id);
        this.goods = null;
        this.destination = null;
    }

    public AIGoods(AIMain aiMain, Location location, GoodsType type, int amount, Location destination) {
        this(aiMain, AIGoods.getXMLElementTagName() + ":" + aiMain.getNextId());
        this.goods = new Goods(aiMain.getGame(), location, type, amount);
        this.destination = destination;
        this.uninitialized = false;
    }

    public AIGoods(AIMain aiMain, Element element) {
        super(aiMain, element);
        this.uninitialized = this.getGoods() == null;
    }

    public AIGoods(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.uninitialized = this.getGoods() == null;
    }

    public final Goods getGoods() {
        return this.goods;
    }

    public final void setGoods(Goods goods) {
        this.goods = goods;
    }

    public final GoodsType getGoodsType() {
        return this.goods.getType();
    }

    public final int getGoodsAmount() {
        return this.goods.getAmount();
    }

    public final void setGoodsAmount(int amount) {
        this.goods.setAmount(amount);
    }

    private boolean leaveTransport(int amount) {
        GoodsType type;
        if (!(this.goods.getLocation() instanceof Unit)) {
            return false;
        }
        Unit carrier = (Unit)this.goods.getLocation();
        if (carrier.getGoodsCount(type = this.goods.getType()) < amount) {
            return false;
        }
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        int oldAmount = carrier.getGoodsCount(type);
        boolean result = AIMessage.askUnloadGoods(type, amount, aiCarrier);
        if (result) {
            int newAmount = carrier.getGoodsCount(type);
            if (oldAmount - newAmount != amount) {
                logger.warning("Partial goods unload, expected: " + amount + ", got: " + (oldAmount - newAmount));
                result = false;
            }
            logger.fine("Unloaded " + amount + " " + type + " from " + oldAmount + " leaving " + newAmount + " off of " + carrier + " at " + carrier.getLocation());
        }
        return result;
    }

    @Override
    public Locatable getTransportLocatable() {
        return this.getGoods();
    }

    @Override
    public Location getTransportSource() {
        return this.goods == null ? null : this.goods.getLocation();
    }

    @Override
    public Location getTransportDestination() {
        return this.destination;
    }

    @Override
    public void setTransportDestination(Location destination) {
        this.destination = destination;
    }

    @Override
    public PathNode getDeliveryPath(Unit carrier, Location dst) {
        PathNode path;
        if (dst == null) {
            dst = Location.upLoc(this.getTransportDestination());
        }
        PathNode pathNode = this.goods.getLocation() == carrier ? carrier.findPath(dst) : (path = this.goods.getLocation() instanceof Unit ? null : carrier.findPath(this.goods.getLocation(), dst, null, null));
        if (path != null) {
            path.convertToGoodsDeliveryPath();
        }
        return path;
    }

    @Override
    public PathNode getIntermediatePath(Unit carrier, Location dst) {
        return null;
    }

    @Override
    public boolean carriableBy(Unit carrier) {
        return carrier.couldCarry(this.getGoods());
    }

    @Override
    public boolean canMove() {
        return false;
    }

    @Override
    public boolean leaveTransport() {
        return this.leaveTransport(null);
    }

    @Override
    public boolean leaveTransport(Direction direction) {
        if (direction != null) {
            return false;
        }
        return this.leaveTransport(this.goods.getAmount());
    }

    @Override
    public boolean joinTransport(Unit carrier, Direction direction) {
        if (direction != null) {
            return false;
        }
        AIUnit aiCarrier = this.getAIMain().getAIUnit(carrier);
        if (aiCarrier == null) {
            return false;
        }
        GoodsType type = this.goods.getType();
        boolean failed = false;
        int oldAmount = carrier.getGoodsCount(type);
        int goodsAmount = this.goods.getAmount();
        int amount = Math.min(goodsAmount, carrier.getLoadableAmount(type));
        if (AIMessage.askLoadGoods(this.goods.getLocation(), type, amount, aiCarrier)) {
            this.setGoods(new Goods(this.getGame(), carrier, type, amount));
            Colony colony = carrier.getColony();
            if (colony != null) {
                this.getAIMain().getAIColony(colony).removeExportGoods(this);
            }
        }
        logger.fine("Loaded " + amount + " " + type.getSuffix() + " over " + oldAmount + " leaving " + (goodsAmount - amount) + " onto " + carrier + " at " + carrier.getLocation());
        return !failed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String invalidReason() {
        String string;
        String reason = Mission.invalidTransportableReason(this);
        if (reason != null) {
            string = reason;
            return string;
        } else {
            if (!(this.goods.getLocation() instanceof Unit)) return null;
            if (!(this.destination instanceof Settlement)) return null;
            Settlement s = (Settlement)this.destination;
            if (((Unit)this.goods.getLocation()).getOwner().owns(s)) return null;
            string = "transportableDestination-" + s.getName() + "-captured-by-" + s.getOwner().getDebugName();
        }
        return string;
    }

    @Override
    public void dispose() {
        this.dropTransport();
        if (this.destination != null) {
            if (this.destination instanceof Colony) {
                AIColony aic = this.getAIMain().getAIColony((Colony)this.destination);
                if (aic != null) {
                    aic.removeExportGoods(this);
                }
            } else if (!(this.destination instanceof Europe)) {
                logger.warning("Unknown type of destination: " + this.destination);
            }
            this.destination = null;
        }
        this.goods = null;
        super.dispose();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        String why;
        int result = super.checkIntegrity(fix);
        String string = result < 0 ? "super" : (this.goods == null ? "null-goods" : (this.goods.getType() == null ? "null-goods-type" : (this.goods.getAmount() <= 0 ? "non-positive-goods-amount" : (this.goods.getLocation() == null ? "null-location" : (why = ((FreeColGameObject)((Object)this.goods.getLocation())).isDisposed() ? "disposed-location" : null)))));
        if (this.destination != null && ((FreeColGameObject)((Object)this.destination)).isDisposed()) {
            if (fix) {
                logger.warning("Fixing disposed destination for " + this);
                this.destination = null;
                if (result > 0) {
                    result = 0;
                }
            } else {
                why = "disposed-destination";
            }
        }
        if (why != null) {
            logger.finest("checkIntegrity(" + this + ") = " + why);
            result = -1;
        }
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.destination != null) {
            xw.writeAttribute(DESTINATION_TAG, this.destination.getId());
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.goods != null) {
            this.goods.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Game game = this.getAIMain().getGame();
        this.destination = xr.getLocationAttribute(game, DESTINATION_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        if (this.getGoods() != null) {
            this.uninitialized = false;
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (Goods.getXMLElementTagName().equals(tag)) {
            if (this.goods != null) {
                this.goods.readFromXML(xr);
            } else {
                this.goods = new Goods(this.getAIMain().getGame(), xr);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        LogBuilder lb = new LogBuilder(64);
        lb.add("[", this.getId(), " ", this.goods);
        if (this.goods != null) {
            lb.add(" at ", this.goods.getLocation());
        }
        lb.add(" -> ", this.destination);
        AIUnit transport = this.getTransport();
        if (transport != null) {
            lb.add(" using ", transport.getUnit());
        }
        lb.add("/", this.getTransportPriority(), "]");
        return lb.toString();
    }

    @Override
    public String getXMLTagName() {
        return AIGoods.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "aiGoods";
    }
}

