"""Generated client library for apikeys version v2alpha1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.apikeys.v2alpha1 import apikeys_v2alpha1_messages as messages


class ApikeysV2alpha1(base_api.BaseApiClient):
  """Generated client library for service apikeys version v2alpha1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://apikeys.googleapis.com/'
  MTLS_BASE_URL = 'https://apikeys.mtls.googleapis.com/'

  _PACKAGE = 'apikeys'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only']
  _VERSION = 'v2alpha1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ApikeysV2alpha1'
  _URL_VERSION = 'v2alpha1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new apikeys handle."""
    url = url or self.BASE_URL
    super(ApikeysV2alpha1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.operations = self.OperationsService(self)
    self.projects_keys = self.ProjectsKeysService(self)
    self.projects = self.ProjectsService(self)
    self.v2alpha1 = self.V2alpha1Service(self)

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = 'operations'

    def __init__(self, client):
      super(ApikeysV2alpha1.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ApikeysOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/operations/{operationsId}',
        http_method='GET',
        method_id='apikeys.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2alpha1/{+name}',
        request_field='',
        request_type_name='ApikeysOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsKeysService(base_api.BaseApiService):
    """Service class for the projects_keys resource."""

    _NAME = 'projects_keys'

    def __init__(self, client):
      super(ApikeysV2alpha1.ProjectsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Clone(self, request, global_params=None):
      r"""Clones the existing key's restriction, display name to a new Api Key.

      Args:
        request: (ApikeysProjectsKeysCloneRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Clone')
      return self._RunMethod(
          config, request, global_params=global_params)

    Clone.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys/{keysId}:clone',
        http_method='POST',
        method_id='apikeys.projects.keys.clone',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2alpha1/{+name}:clone',
        request_field='v2alpha1CloneKeyRequest',
        request_type_name='ApikeysProjectsKeysCloneRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new API key.

      Args:
        request: (ApikeysProjectsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys',
        http_method='POST',
        method_id='apikeys.projects.keys.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v2alpha1/{+parent}/keys',
        request_field='v2alpha1ApiKey',
        request_type_name='ApikeysProjectsKeysCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an API key.

      Args:
        request: (ApikeysProjectsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys/{keysId}',
        http_method='DELETE',
        method_id='apikeys.projects.keys.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2alpha1/{+name}',
        request_field='',
        request_type_name='ApikeysProjectsKeysDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the metadata for an API key. Key string will not be set in the response.

      Args:
        request: (ApikeysProjectsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1ApiKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys/{keysId}',
        http_method='GET',
        method_id='apikeys.projects.keys.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2alpha1/{+name}',
        request_field='',
        request_type_name='ApikeysProjectsKeysGetRequest',
        response_type_name='V2alpha1ApiKey',
        supports_download=False,
    )

    def GetKeyString(self, request, global_params=None):
      r"""Get key string for an API key.

      Args:
        request: (ApikeysProjectsKeysGetKeyStringRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1GetKeyStringResponse) The response message.
      """
      config = self.GetMethodConfig('GetKeyString')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetKeyString.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys/{keysId}/keyString',
        http_method='GET',
        method_id='apikeys.projects.keys.getKeyString',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2alpha1/{+name}/keyString',
        request_field='',
        request_type_name='ApikeysProjectsKeysGetKeyStringRequest',
        response_type_name='V2alpha1GetKeyStringResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists the API keys owned by a project. Key string of ApiKey will not be set.

      Args:
        request: (ApikeysProjectsKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1ListKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys',
        http_method='GET',
        method_id='apikeys.projects.keys.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v2alpha1/{+parent}/keys',
        request_field='',
        request_type_name='ApikeysProjectsKeysListRequest',
        response_type_name='V2alpha1ListKeysResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Patches the modifiable fields of an API key. Key string will not be set in the ApiKey response of the long running operation.

      Args:
        request: (ApikeysProjectsKeysPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys/{keysId}',
        http_method='PATCH',
        method_id='apikeys.projects.keys.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v2alpha1/{+name}',
        request_field='v2alpha1ApiKey',
        request_type_name='ApikeysProjectsKeysPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undeletes an API key which was deleted within 30 days.

      Args:
        request: (ApikeysProjectsKeysUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v2alpha1/projects/{projectsId}/keys/{keysId}:undelete',
        http_method='POST',
        method_id='apikeys.projects.keys.undelete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v2alpha1/{+name}:undelete',
        request_field='v2alpha1UndeleteKeyRequest',
        request_type_name='ApikeysProjectsKeysUndeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ApikeysV2alpha1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class V2alpha1Service(base_api.BaseApiService):
    """Service class for the v2alpha1 resource."""

    _NAME = 'v2alpha1'

    def __init__(self, client):
      super(ApikeysV2alpha1.V2alpha1Service, self).__init__(client)
      self._upload_configs = {
          }

    def GetKeyStringName(self, request, global_params=None):
      r"""Get parent and name of the Api Key which has the key string. Permission `apikeys.keys.getKeyStringName` is required on the parent.

      Args:
        request: (ApikeysGetKeyStringNameRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (V2alpha1GetKeyStringNameResponse) The response message.
      """
      config = self.GetMethodConfig('GetKeyStringName')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetKeyStringName.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='apikeys.getKeyStringName',
        ordered_params=[],
        path_params=[],
        query_params=['keyString'],
        relative_path='v2alpha1/keyStringName',
        request_field='',
        request_type_name='ApikeysGetKeyStringNameRequest',
        response_type_name='V2alpha1GetKeyStringNameResponse',
        supports_download=False,
    )
