/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features;

import com.intellij.filePrediction.FileFeaturesComputationResult;
import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.references.ExternalReferencesResult;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/filePrediction/features/FilePredictionFeaturesHelper;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "calculateFileFeatures", "Lcom/intellij/filePrediction/FileFeaturesComputationResult;", "project", "Lcom/intellij/openapi/project/Project;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "refs", "Lcom/intellij/filePrediction/references/ExternalReferencesResult;", "prevFile", "calculateProviderPrefix", "", "provider", "getFeatureCodes", "", "", "intellij.filePrediction"})
public final class FilePredictionFeaturesHelper {
    private static final ExtensionPointName<FilePredictionFeatureProvider> EP_NAME;
    public static final FilePredictionFeaturesHelper INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FileFeaturesComputationResult calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @NotNull ExternalReferencesResult refs, @Nullable VirtualFile prevFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        long start = System.currentTimeMillis();
        HashMap result2 = new HashMap();
        Iterator iterator = EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext()) {
            void $this$mapKeysTo$iv$iv;
            FilePredictionFeatureProvider provider;
            FilePredictionFeatureProvider filePredictionFeatureProvider = provider = (FilePredictionFeatureProvider)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)filePredictionFeatureProvider, (String)"provider");
            String prefix = this.calculateProviderPrefix(filePredictionFeatureProvider);
            Map<String, FilePredictionFeature> $this$mapKeys$iv = provider.calculateFileFeatures(project, newFile, prevFile, refs);
            boolean $i$f$mapKeys = false;
            Map<String, FilePredictionFeature> map = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                String string = prefix + (String)it.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string2 = string;
                Map map3 = map2;
                boolean bl2 = false;
                Object v = it$iv$iv.getValue();
                map3.put(string2, v);
            }
            Map features = destination$iv$iv;
            result2.putAll(features);
        }
        return new FileFeaturesComputationResult(result2, start);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Integer> getFeatureCodes() {
        boolean bl = false;
        HashMap codes = new HashMap();
        bl = false;
        List list = EP_NAME.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"EP_NAME.extensionList");
        Iterator iterator = ((Iterable)list).iterator();
        while (iterator.hasNext()) {
            void index;
            FilePredictionFeatureProvider provider;
            FilePredictionFeatureProvider filePredictionFeatureProvider = provider = (FilePredictionFeatureProvider)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)filePredictionFeatureProvider, (String)"provider");
            String prefix = this.calculateProviderPrefix(filePredictionFeatureProvider);
            String[] stringArray = provider.getFeatures();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                void featureIndex;
                String feature = stringArray[n2];
                String key = prefix + feature;
                int value = 100 * index + featureIndex;
                ((Map)codes).put(key, value);
                ++featureIndex;
            }
            ++index;
        }
        return codes;
    }

    private final String calculateProviderPrefix(FilePredictionFeatureProvider provider) {
        CharSequence charSequence = provider.getName();
        boolean bl = false;
        return charSequence.length() > 0 ? provider.getName() + "_" : "";
    }

    private FilePredictionFeaturesHelper() {
    }

    static {
        FilePredictionFeaturesHelper filePredictionFeaturesHelper;
        INSTANCE = filePredictionFeaturesHelper = new FilePredictionFeaturesHelper();
        EP_NAME = new ExtensionPointName("com.intellij.filePrediction.featureProvider");
    }
}

