/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features;

import com.intellij.filePrediction.features.FilePredictionFeature;
import com.intellij.filePrediction.features.FilePredictionFeatureProvider;
import com.intellij.filePrediction.references.ExternalReferencesResult;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J6\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/filePrediction/features/FilePredictionGeneralFeatures;", "Lcom/intellij/filePrediction/features/FilePredictionFeatureProvider;", "()V", "addFileTypeFeatures", "", "result", "", "", "Lcom/intellij/filePrediction/features/FilePredictionFeature;", "newFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "prevFile", "calculateFileFeatures", "", "project", "Lcom/intellij/openapi/project/Project;", "refs", "Lcom/intellij/filePrediction/references/ExternalReferencesResult;", "getFeatures", "", "()[Ljava/lang/String;", "getName", "unify", "path", "intellij.filePrediction"})
public final class FilePredictionGeneralFeatures
implements FilePredictionFeatureProvider {
    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    @NotNull
    public String[] getFeatures() {
        return new String[]{"file_type", "prev_file_type", "in_project", "in_source", "in_library", "excluded", "same_module", "name_prefix", "path_prefix", "relative_path_prefix", "same_dir", "in_ref"};
    }

    @Override
    @NotNull
    public Map<String, FilePredictionFeature> calculateFileFeatures(@NotNull Project project, @NotNull VirtualFile newFile, @Nullable VirtualFile prevFile, @NotNull ExternalReferencesResult refs) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)newFile, (String)"newFile");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        HashMap result2 = new HashMap();
        ThreeState isInRef = refs.contains(newFile);
        if (isInRef != ThreeState.UNSURE) {
            ((Map)result2).put("in_ref", FilePredictionFeature.Companion.binary(isInRef == ThreeState.YES));
        }
        this.addFileTypeFeatures(result2, newFile, prevFile);
        ApplicationManager.getApplication().runReadAction(new Runnable(newFile, project, result2, prevFile){
            final /* synthetic */ VirtualFile $newFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap $result;
            final /* synthetic */ VirtualFile $prevFile;

            public final void run() {
                if (this.$newFile.isValid()) {
                    FileIndexFacade fileIndex = FileIndexFacade.getInstance((Project)this.$project);
                    ((Map)this.$result).put("in_project", FilePredictionFeature.Companion.binary(fileIndex.isInProjectScope(this.$newFile)));
                    ((Map)this.$result).put("in_source", FilePredictionFeature.Companion.binary(fileIndex.isInSource(this.$newFile)));
                    ((Map)this.$result).put("in_library", FilePredictionFeature.Companion.binary(fileIndex.isInLibraryClasses(this.$newFile) || fileIndex.isInLibrarySource(this.$newFile)));
                    ((Map)this.$result).put("excluded", FilePredictionFeature.Companion.binary(fileIndex.isExcludedFile(this.$newFile)));
                    if (this.$prevFile != null && this.$prevFile.isValid()) {
                        Module newModule = fileIndex.getModuleForFile(this.$newFile);
                        ((Map)this.$result).put("same_module", FilePredictionFeature.Companion.binary(newModule != null && Intrinsics.areEqual((Object)newModule, (Object)fileIndex.getModuleForFile(this.$prevFile))));
                    }
                }
            }
            {
                this.$newFile = virtualFile;
                this.$project = project;
                this.$result = hashMap;
                this.$prevFile = virtualFile2;
            }
        });
        if (prevFile != null) {
            String string = newFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newFile.name");
            String newFileName = this.unify(string);
            String string2 = newFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"newFile.path");
            String newFilePath = this.unify(string2);
            String string3 = prevFile.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"prevFile.name");
            String prevFileName = this.unify(string3);
            ((Map)result2).put("name_prefix", FilePredictionFeature.Companion.numerical(StringUtil.commonPrefixLength((CharSequence)newFileName, (CharSequence)prevFileName)));
            String string4 = prevFile.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"prevFile.path");
            String prevFilePath = this.unify(string4);
            ((Map)result2).put("path_prefix", FilePredictionFeature.Companion.numerical(StringUtil.commonPrefixLength((CharSequence)newFilePath, (CharSequence)prevFilePath)));
            if (!project.isDisposed()) {
                String baseDir;
                String string5;
                Object object = ProjectUtil.guessProjectDir((Project)project);
                if (object != null && (object = object.getPath()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Object object3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                    string5 = this.unify((String)object3);
                } else {
                    string5 = baseDir = null;
                }
                if (baseDir != null) {
                    String newRelativePath = FileUtil.getRelativePath(baseDir, (String)newFilePath, (char)File.separatorChar, (boolean)false);
                    String prevRelativePath = FileUtil.getRelativePath(baseDir, (String)prevFilePath, (char)File.separatorChar, (boolean)false);
                    if (newRelativePath != null && prevRelativePath != null) {
                        ((Map)result2).put("relative_path_prefix", FilePredictionFeature.Companion.numerical(StringUtil.commonPrefixLength((CharSequence)newRelativePath, (CharSequence)prevRelativePath)));
                    }
                }
            }
            ((Map)result2).put("same_dir", FilePredictionFeature.Companion.binary(Intrinsics.areEqual((Object)PathUtil.getParentPath((String)newFilePath), (Object)PathUtil.getParentPath((String)prevFilePath))));
        }
        return result2;
    }

    private final void addFileTypeFeatures(Map<String, FilePredictionFeature> result2, VirtualFile newFile, VirtualFile prevFile) {
        String string = FileTypeUsagesCollector.getSafeFileTypeName((FileType)newFile.getFileType());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileTypeUsagesCollector.\u2026ypeName(newFile.fileType)");
        result2.put("file_type", FilePredictionFeature.Companion.categorical(string));
        if (prevFile != null) {
            String string2 = FileTypeUsagesCollector.getSafeFileTypeName((FileType)prevFile.getFileType());
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileTypeUsagesCollector.\u2026peName(prevFile.fileType)");
            result2.put("prev_file_type", FilePredictionFeature.Companion.categorical(string2));
        }
    }

    private final String unify(String path) {
        String string;
        boolean caseSensitive = SystemInfo.isFileSystemCaseSensitive;
        if (caseSensitive) {
            String string2 = FileUtil.getNameWithoutExtension((String)path);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.getNameWithoutExtension(path)");
        } else {
            String string3 = FileUtil.getNameWithoutExtension((String)StringUtil.toLowerCase((String)path));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"FileUtil.getNameWithoutE\u2026ension(toLowerCase(path))");
        }
        return string;
    }
}

