/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.predictor;

import com.intellij.filePrediction.FileFeaturesComputationResult;
import com.intellij.filePrediction.FileReferencesComputationResult;
import com.intellij.filePrediction.candidates.FilePredictionCandidateFile;
import com.intellij.filePrediction.candidates.FilePredictionCandidateProvider;
import com.intellij.filePrediction.features.FilePredictionFeaturesHelper;
import com.intellij.filePrediction.predictor.FilePredictionCandidate;
import com.intellij.filePrediction.predictor.FileUsagePredictor;
import com.intellij.filePrediction.predictor.model.FilePredictionModel;
import com.intellij.filePrediction.references.ExternalReferencesResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/filePrediction/predictor/FileUsageMLPredictor;", "Lcom/intellij/filePrediction/predictor/FileUsagePredictor;", "candidateProvider", "Lcom/intellij/filePrediction/candidates/FilePredictionCandidateProvider;", "model", "Lcom/intellij/filePrediction/predictor/model/FilePredictionModel;", "(Lcom/intellij/filePrediction/candidates/FilePredictionCandidateProvider;Lcom/intellij/filePrediction/predictor/model/FilePredictionModel;)V", "predictNextFile", "", "Lcom/intellij/filePrediction/predictor/FilePredictionCandidate;", "project", "Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "refs", "Lcom/intellij/filePrediction/FileReferencesComputationResult;", "topCandidates", "", "predictNextFile$intellij_filePrediction", "intellij.filePrediction"})
final class FileUsageMLPredictor
extends FileUsagePredictor {
    private final FilePredictionModel model;

    @Override
    @NotNull
    public List<FilePredictionCandidate> predictNextFile$intellij_filePrediction(@NotNull Project project, @Nullable VirtualFile currentFile, @NotNull FileReferencesComputationResult refs, int topCandidates) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        boolean bl = false;
        List candidates = new ArrayList();
        Set<VirtualFile> references = ((ExternalReferencesResult)refs.getValue()).getReferences();
        Collection<FilePredictionCandidateFile> candidateFiles = this.getCandidateProvider().provideCandidates(project, currentFile, references, topCandidates);
        for (FilePredictionCandidateFile candidate : candidateFiles) {
            FileFeaturesComputationResult features = FilePredictionFeaturesHelper.INSTANCE.calculateFileFeatures(project, candidate.getFile(), (ExternalReferencesResult)refs.getValue(), currentFile);
            long start = System.currentTimeMillis();
            double probability = this.model.predict((Map)features.getValue());
            long duration = System.currentTimeMillis() - start;
            String string = candidate.getFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidate.file.path");
            candidates.add(new FilePredictionCandidate(string, candidate.getSource(), (Map)features.getValue(), features.getDuration(), duration, probability));
        }
        List $this$sortByDescending$iv = candidates;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            List list = $this$sortByDescending$iv;
            boolean bl2 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    FilePredictionCandidate it = (FilePredictionCandidate)b;
                    boolean bl2 = false;
                    Comparable comparable = it.getProbability();
                    it = (FilePredictionCandidate)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = it.getProbability();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator);
        }
        return candidates;
    }

    public FileUsageMLPredictor(@NotNull FilePredictionCandidateProvider candidateProvider, @NotNull FilePredictionModel model) {
        Intrinsics.checkParameterIsNotNull((Object)candidateProvider, (String)"candidateProvider");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        super(candidateProvider, false);
        this.model = model;
    }
}

