/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.predictor;

import com.intellij.filePrediction.FileFeaturesComputationResult;
import com.intellij.filePrediction.FileReferencesComputationResult;
import com.intellij.filePrediction.candidates.FilePredictionCandidateFile;
import com.intellij.filePrediction.candidates.FilePredictionCandidateProvider;
import com.intellij.filePrediction.features.FilePredictionFeaturesHelper;
import com.intellij.filePrediction.predictor.FilePredictionCandidate;
import com.intellij.filePrediction.predictor.FileUsagePredictor;
import com.intellij.filePrediction.references.ExternalReferencesResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J5\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0010\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/filePrediction/predictor/FileUsageSimplePredictor;", "Lcom/intellij/filePrediction/predictor/FileUsagePredictor;", "candidateProvider", "Lcom/intellij/filePrediction/candidates/FilePredictionCandidateProvider;", "(Lcom/intellij/filePrediction/candidates/FilePredictionCandidateProvider;)V", "predictNextFile", "", "Lcom/intellij/filePrediction/predictor/FilePredictionCandidate;", "project", "Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "refs", "Lcom/intellij/filePrediction/FileReferencesComputationResult;", "topCandidates", "", "predictNextFile$intellij_filePrediction", "intellij.filePrediction"})
final class FileUsageSimplePredictor
extends FileUsagePredictor {
    @Override
    @NotNull
    public List<FilePredictionCandidate> predictNextFile$intellij_filePrediction(@NotNull Project project, @Nullable VirtualFile currentFile, @NotNull FileReferencesComputationResult refs, int topCandidates) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)refs, (String)"refs");
        Set<VirtualFile> references = ((ExternalReferencesResult)refs.getValue()).getReferences();
        Collection<FilePredictionCandidateFile> candidateFiles = this.getCandidateProvider().provideCandidates(project, currentFile, references, topCandidates);
        boolean bl = false;
        List candidates = new ArrayList();
        for (FilePredictionCandidateFile candidate : candidateFiles) {
            FileFeaturesComputationResult features = FilePredictionFeaturesHelper.INSTANCE.calculateFileFeatures(project, candidate.getFile(), (ExternalReferencesResult)refs.getValue(), currentFile);
            String string = candidate.getFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"candidate.file.path");
            candidates.add(new FilePredictionCandidate(string, candidate.getSource(), (Map)features.getValue(), features.getDuration(), null, null, 48, null));
        }
        return candidates;
    }

    public FileUsageSimplePredictor(@NotNull FilePredictionCandidateProvider candidateProvider) {
        Intrinsics.checkParameterIsNotNull((Object)candidateProvider, (String)"candidateProvider");
        super(candidateProvider, true);
    }
}

