/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class ModulePath {
    public static final ModulePath EMPTY = new ModulePath(){

        @Override
        public Collection<? extends File> getPath() {
            return Collections.emptyList();
        }

        @Override
        public String getModuleName(File pathElement) {
            return null;
        }
    };

    public abstract Collection<? extends File> getPath();

    public abstract String getModuleName(File var1);

    public boolean isEmpty() {
        return this.getPath().isEmpty();
    }

    public static ModulePath create(Collection<? extends File> path) {
        if (path.isEmpty()) {
            return EMPTY;
        }
        final Collection<? extends File> files = Collections.unmodifiableCollection(path);
        return new ModulePath(){

            @Override
            public Collection<? extends File> getPath() {
                return files;
            }

            @Override
            public String getModuleName(File pathElement) {
                return null;
            }
        };
    }

    public static Builder newBuilder() {
        return new Builder(){
            private final Map<File, String> myMap = new THashMap();
            private final Collection<File> myPath = new ArrayList<File>();

            @Override
            public Builder add(String moduleName, File pathElement) {
                this.myPath.add(pathElement);
                if (moduleName != null) {
                    this.myMap.put(pathElement, moduleName);
                }
                return this;
            }

            @Override
            public ModulePath create() {
                if (this.myPath.isEmpty()) {
                    return EMPTY;
                }
                final Collection<File> files = Collections.unmodifiableCollection(this.myPath);
                return new ModulePath(){

                    @Override
                    public Collection<? extends File> getPath() {
                        return files;
                    }

                    @Override
                    public String getModuleName(File pathElement) {
                        return (String)myMap.get(pathElement);
                    }
                };
            }
        };
    }

    public static interface Builder {
        public Builder add(String var1, File var2);

        public ModulePath create();
    }
}

