/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import org.jetbrains.annotations.NotNull;

public class XmlPropertiesIndex
extends FileBasedIndexExtension<Key, String>
implements DataIndexer<Key, String, FileContent>,
KeyDescriptor<Key> {
    public static final Key MARKER_KEY = new Key();
    public static final ID<Key, String> NAME = ID.create((String)"xmlProperties");
    private static final String HTTP_JAVA_SUN_COM_DTD_PROPERTIES_DTD = "http://java.sun.com/dtd/properties.dtd";

    @NotNull
    public ID<Key, String> getName() {
        ID<Key, String> iD = NAME;
        if (iD == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Key, String, FileContent> getIndexer() {
        XmlPropertiesIndex xmlPropertiesIndex = this;
        if (xmlPropertiesIndex == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(1);
        }
        return xmlPropertiesIndex;
    }

    @NotNull
    public KeyDescriptor<Key> getKeyDescriptor() {
        XmlPropertiesIndex xmlPropertiesIndex = this;
        if (xmlPropertiesIndex == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(2);
        }
        return xmlPropertiesIndex;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file.getName().endsWith(".xml");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/properties/xml/XmlPropertiesIndex$1", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Map<Key, String> map(@NotNull FileContent inputData) {
        CharSequence text;
        if (inputData == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(4);
        }
        if (CharArrayUtil.indexOf((CharSequence)(text = inputData.getContentAsText()), (CharSequence)HTTP_JAVA_SUN_COM_DTD_PROPERTIES_DTD, (int)0) == -1) {
            Map<Key, String> map = Collections.emptyMap();
            if (map == null) {
                XmlPropertiesIndex.$$$reportNull$$$0(5);
            }
            return map;
        }
        MyIXMLBuilderAdapter builder = XmlPropertiesIndex.parse(text, false);
        HashMap map = builder.myMap;
        if (builder.accepted) {
            map.put(MARKER_KEY, "");
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    static boolean isPropertiesFile(XmlFile file) {
        Project project = file.getProject();
        if (!file.isValid()) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || DumbService.isDumb((Project)project) || NoAccessDuringPsiEvents.isInsideEventProcessing()) {
            CharSequence contents = file.getViewProvider().getContents();
            return CharArrayUtil.indexOf((CharSequence)contents, (CharSequence)HTTP_JAVA_SUN_COM_DTD_PROPERTIES_DTD, (int)0) != -1 && XmlPropertiesIndex.isAccepted(contents);
        }
        return !FileBasedIndex.getInstance().getFileData(NAME, virtualFile, project).isEmpty();
    }

    private static boolean isAccepted(CharSequence bytes) {
        return XmlPropertiesIndex.parse((CharSequence)bytes, (boolean)true).accepted;
    }

    @NotNull
    private static MyIXMLBuilderAdapter parse(CharSequence text, boolean stopIfAccepted) {
        StdXMLReader reader = new StdXMLReader(CharArrayUtil.readerFromCharSequence((CharSequence)text)){

            public Reader openStream(String publicID, String systemID) throws IOException {
                if (!XmlPropertiesIndex.HTTP_JAVA_SUN_COM_DTD_PROPERTIES_DTD.equals(systemID)) {
                    throw new IOException();
                }
                return new StringReader(" ");
            }
        };
        MyIXMLBuilderAdapter builder = new MyIXMLBuilderAdapter(stopIfAccepted);
        NanoXmlUtil.parse((IXMLReader)reader, (IXMLBuilder)builder);
        MyIXMLBuilderAdapter myIXMLBuilderAdapter = builder;
        if (myIXMLBuilderAdapter == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(7);
        }
        return myIXMLBuilderAdapter;
    }

    public void save(@NotNull DataOutput out, Key value) throws IOException {
        if (out == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(8);
        }
        out.writeBoolean(value.isMarker);
        if (value.key != null) {
            IOUtil.writeUTF((DataOutput)out, (String)value.key);
        }
    }

    public Key read(@NotNull DataInput in) throws IOException {
        boolean isMarker;
        if (in == null) {
            XmlPropertiesIndex.$$$reportNull$$$0(9);
        }
        return (isMarker = in.readBoolean()) ? MARKER_KEY : new Key(IOUtil.readUTF((DataInput)in));
    }

    public int getHashCode(Key value) {
        return value.hashCode();
    }

    public boolean isEqual(Key val1, Key val2) {
        return val1.isMarker == val2.isMarker && Objects.equals(val1.key, val2.key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/xml/XmlPropertiesIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/xml/XmlPropertiesIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyIXMLBuilderAdapter
    implements NanoXmlBuilder {
        boolean accepted;
        boolean insideEntry;
        String key;
        private final HashMap<Key, String> myMap = new HashMap();
        private final boolean myStopIfAccepted;

        MyIXMLBuilderAdapter(boolean stopIfAccepted) {
            this.myStopIfAccepted = stopIfAccepted;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            if (!this.accepted) {
                if (!"properties".equals(name)) throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
                this.accepted = true;
            } else {
                this.insideEntry = "entry".equals(name);
            }
            if (!this.myStopIfAccepted) return;
            throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
            if (this.insideEntry && "key".equals(key)) {
                this.key = value;
            }
        }

        public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
            if (this.insideEntry && this.key != null) {
                String value = StreamUtil.readTextFrom((Reader)reader);
                this.myMap.put(new Key(this.key), value);
            }
        }
    }

    public static class Key {
        final boolean isMarker;
        final String key;

        public Key(String key) {
            this.key = key;
            this.isMarker = false;
        }

        public Key() {
            this.isMarker = true;
            this.key = null;
        }

        public int hashCode() {
            return this.isMarker ? 0 : this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            if (this.isMarker != key1.isMarker) {
                return false;
            }
            return Objects.equals(this.key, key1.key);
        }
    }
}

