/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspectionBase
extends LocalInspectionTool {
    public boolean myFilterOutGeneratedCode;
    private static final int MIN_FRAGMENT_SIZE = 3;

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(1);
        }
        if (!((virtualFile = psiFile.getVirtualFile()) instanceof VirtualFileWithId) || !DuplicatesIndex.ourEnabled) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        DuplicatesProfile profile = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
        if (profile == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        FileASTNode node = psiFile.getNode();
        boolean usingLightProfile = profile instanceof LightDuplicateProfile && node.getElementType() instanceof ILightStubFileElementType;
        Project project = psiFile.getProject();
        DuplicatedCodeProcessor<?> processor = usingLightProfile ? this.processLightDuplicates(node, virtualFile, (LightDuplicateProfile)((Object)profile), project) : this.processPsiDuplicates(psiFile, virtualFile, profile, project);
        if (processor == null) {
            return null;
        }
        SmartList descriptors = new SmartList();
        VirtualFile baseDir = project.getBaseDir();
        for (Int2ObjectMap.Entry entry : processor.reportedRanges.int2ObjectEntrySet()) {
            LocalQuickFix extractMethodFix;
            int offset = entry.getIntKey();
            if (!usingLightProfile && processor.fragmentSize.get(offset) < 3) continue;
            VirtualFile file = (VirtualFile)processor.reportedFiles.get(offset);
            String path = null;
            if (file.equals(virtualFile)) {
                path = "this file";
            } else if (baseDir != null) {
                path = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir);
            }
            if (path == null) {
                path = file.getPath();
            }
            String message = DupLocatorBundle.message("inspection.message.found.duplicated.code.in", path);
            PsiElement targetElement = (PsiElement)processor.reportedPsi.get(offset);
            TextRange rangeInElement = (TextRange)entry.getValue();
            int offsetInOtherFile = processor.reportedOffsetInOtherFiles.get(offset);
            LocalQuickFix fix = isOnTheFly ? this.createNavigateToDupeFix(file, offsetInOtherFile) : null;
            long hash = processor.fragmentHash.get(offset);
            int hash2 = (int)(hash >> 32);
            LocalQuickFix viewAllDupesFix = isOnTheFly && hash != 0L ? this.createShowOtherDupesFix(virtualFile, offset, (int)hash, hash2) : null;
            boolean onlyExtractable = Registry.is((String)"duplicates.inspection.only.extractable");
            LocalQuickFix localQuickFix = extractMethodFix = (isOnTheFly || onlyExtractable) && hash != 0L ? this.createExtractMethodFix(targetElement, rangeInElement, (int)hash, hash2) : null;
            if (onlyExtractable) {
                if (extractMethodFix == null) {
                    return null;
                }
                if (!isOnTheFly) {
                    extractMethodFix = null;
                }
            }
            ProblemDescriptor descriptor = manager.createProblemDescriptor(targetElement, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[]{fix, viewAllDupesFix, extractMethodFix});
            descriptors.add((Object)descriptor);
        }
        return descriptors.isEmpty() ? null : (ProblemDescriptor[])descriptors.toArray((Object[])ProblemDescriptor.EMPTY_ARRAY);
    }

    private DuplicatedCodeProcessor<?> processLightDuplicates(FileASTNode node, VirtualFile virtualFile, LightDuplicateProfile profile, Project project) {
        Ref processorRef = new Ref();
        LighterAST lighterAST = node.getLighterAST();
        profile.process(lighterAST, (hash, hash2, ast, nodes) -> {
            DuplicatedCodeProcessor processor = (DuplicatedCodeProcessor)processorRef.get();
            if (processor == null) {
                processor = new LightDuplicatedCodeProcessor((TreeBackedLighterAST)ast, virtualFile, project);
                processorRef.set((Object)processor);
            }
            processor.process(hash, hash2, nodes[0]);
        });
        return (DuplicatedCodeProcessor)processorRef.get();
    }

    private DuplicatedCodeProcessor<?> processPsiDuplicates(PsiFile psiFile, VirtualFile virtualFile, DuplicatesProfile profile, Project project) {
        DuplocatorState state = profile.getDuplocatorState(psiFile.getLanguage());
        Ref processorRef = new Ref();
        DuplocateVisitor visitor = profile.createVisitor((hash, cost, frag) -> {
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, profile, state)) {
                return;
            }
            DuplicatedCodeProcessor processor = (DuplicatedCodeProcessor)processorRef.get();
            if (processor == null) {
                processor = new OldDuplicatedCodeProcessor(virtualFile, project);
                processorRef.set((Object)processor);
            }
            processor.process(hash, 0, frag);
        }, true);
        visitor.visitNode((PsiElement)psiFile);
        return (DuplicatedCodeProcessor)processorRef.get();
    }

    protected LocalQuickFix createNavigateToDupeFix(@NotNull VirtualFile file, int offsetInOtherFile) {
        if (file == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(2);
        }
        return null;
    }

    protected LocalQuickFix createShowOtherDupesFix(VirtualFile file, int offset, int hash, int hash2) {
        return null;
    }

    protected LocalQuickFix createExtractMethodFix(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement, int hash, int hash2) {
        if (targetElement == null) {
            DuplicatesInspectionBase.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigateToDupeFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createExtractMethodFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static abstract class DuplicatedCodeProcessor<T>
    implements FileBasedIndex.ValueProcessor<IntArrayList> {
        final Int2ObjectRBTreeMap<TextRange> reportedRanges = new Int2ObjectRBTreeMap();
        final Int2ObjectOpenHashMap<VirtualFile> reportedFiles = new Int2ObjectOpenHashMap();
        final Int2ObjectOpenHashMap<PsiElement> reportedPsi = new Int2ObjectOpenHashMap();
        final Int2IntOpenHashMap reportedOffsetInOtherFiles = new Int2IntOpenHashMap();
        final Int2IntOpenHashMap fragmentSize = new Int2IntOpenHashMap();
        final Int2LongOpenHashMap fragmentHash = new Int2LongOpenHashMap();
        final VirtualFile virtualFile;
        final Project project;
        final FileIndex myFileIndex;
        final boolean mySkipGeneratedCode;
        final boolean myFileWithinGeneratedCode;
        T myNode;
        int myHash;
        int myHash2;

        DuplicatedCodeProcessor(VirtualFile file, Project project, boolean skipGeneratedCode) {
            this.virtualFile = file;
            this.project = project;
            this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            this.mySkipGeneratedCode = skipGeneratedCode;
            this.myFileWithinGeneratedCode = skipGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)project);
        }

        void process(int hash, int hash2, T node) {
            ProgressManager.checkCanceled();
            this.myNode = node;
            this.myHash = hash;
            this.myHash2 = hash2;
            FileBasedIndex.getInstance().processValues(DuplicatesIndex.NAME, (Object)hash, null, (FileBasedIndex.ValueProcessor)this, GlobalSearchScope.projectScope((Project)this.project));
        }

        public boolean process(@NotNull VirtualFile file, IntArrayList list) {
            if (file == null) {
                DuplicatedCodeProcessor.$$$reportNull$$$0(0);
            }
            int len = list.size();
            for (int i = 0; i < len; i += 2) {
                ProgressManager.checkCanceled();
                if (list.getInt(i + 1) != this.myHash2) continue;
                int offset = list.getInt(i);
                if (this.myFileIndex.isInSourceContent(this.virtualFile)) {
                    if (!this.myFileIndex.isInSourceContent(file)) {
                        return true;
                    }
                    if (!TestSourcesFilter.isTestSources((VirtualFile)this.virtualFile, (Project)this.project) && TestSourcesFilter.isTestSources((VirtualFile)file, (Project)this.project)) {
                        return true;
                    }
                    if (this.mySkipGeneratedCode && !this.myFileWithinGeneratedCode && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)this.project)) {
                        return true;
                    }
                } else if (this.myFileIndex.isInSourceContent(file)) {
                    return true;
                }
                int startOffset = this.getStartOffset(this.myNode);
                int endOffset = this.getEndOffset(this.myNode);
                if (file.equals(this.virtualFile) && offset >= startOffset && offset < endOffset) continue;
                PsiElement target = this.getPsi(this.myNode);
                TextRange rangeInElement = this.getRangeInElement(this.myNode);
                int fragmentStartOffsetInteger = startOffset;
                Int2ObjectSortedMap map = this.reportedRanges.subMap(fragmentStartOffsetInteger, endOffset);
                int newFragmentSize = !map.isEmpty() ? 0 : 1;
                IntBidirectionalIterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    int next = iterator.nextInt();
                    iterator.remove();
                    this.reportedFiles.remove(next);
                    this.reportedOffsetInOtherFiles.remove(next);
                    this.reportedPsi.remove(next);
                    newFragmentSize += this.fragmentSize.remove(next);
                }
                this.reportedRanges.put(fragmentStartOffsetInteger, (Object)rangeInElement);
                this.reportedFiles.put(fragmentStartOffsetInteger, (Object)file);
                this.reportedOffsetInOtherFiles.put(fragmentStartOffsetInteger, offset);
                this.reportedPsi.put(fragmentStartOffsetInteger, (Object)target);
                this.fragmentSize.put(fragmentStartOffsetInteger, newFragmentSize);
                if (newFragmentSize >= 3 || this.isLightProfile()) {
                    this.fragmentHash.put(fragmentStartOffsetInteger, (long)this.myHash & 0xFFFFFFFFL | (long)this.myHash2 << 32);
                }
                return false;
            }
            return true;
        }

        protected abstract TextRange getRangeInElement(T var1);

        protected abstract PsiElement getPsi(T var1);

        protected abstract int getStartOffset(T var1);

        protected abstract int getEndOffset(T var1);

        protected abstract boolean isLightProfile();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/index/DuplicatesInspectionBase$DuplicatedCodeProcessor", "process"));
        }
    }

    final class OldDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<PsiFragment> {
        private OldDuplicatedCodeProcessor(VirtualFile file, Project project) {
            super(file, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
        }

        @Override
        protected TextRange getRangeInElement(PsiFragment node) {
            PsiElement[] elements = node.getElements();
            TextRange rangeInElement = null;
            if (elements.length > 1) {
                PsiElement lastElement = elements[elements.length - 1];
                rangeInElement = new TextRange(elements[0].getStartOffsetInParent(), lastElement.getStartOffsetInParent() + lastElement.getTextLength());
            }
            return rangeInElement;
        }

        @Override
        protected PsiElement getPsi(PsiFragment node) {
            PsiElement[] elements = node.getElements();
            return elements.length > 1 ? elements[0].getParent() : elements[0];
        }

        @Override
        protected int getStartOffset(PsiFragment node) {
            return node.getStartOffset();
        }

        @Override
        protected int getEndOffset(PsiFragment node) {
            return node.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return false;
        }
    }

    private final class LightDuplicatedCodeProcessor
    extends DuplicatedCodeProcessor<LighterASTNode> {
        private final TreeBackedLighterAST myAst;

        private LightDuplicatedCodeProcessor(TreeBackedLighterAST ast, VirtualFile file, Project project) {
            if (ast == null) {
                LightDuplicatedCodeProcessor.$$$reportNull$$$0(0);
            }
            super(file, project, DuplicatesInspectionBase.this.myFilterOutGeneratedCode);
            this.myAst = ast;
        }

        @Override
        protected TextRange getRangeInElement(LighterASTNode node) {
            return null;
        }

        @Override
        protected PsiElement getPsi(LighterASTNode node) {
            return this.myAst.unwrap(node).getPsi();
        }

        @Override
        protected int getStartOffset(LighterASTNode node) {
            return node.getStartOffset();
        }

        @Override
        protected int getEndOffset(LighterASTNode node) {
            return node.getEndOffset();
        }

        @Override
        protected boolean isLightProfile() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesInspectionBase$LightDuplicatedCodeProcessor", "<init>"));
        }
    }
}

