/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.GenericAttachingConnector;
import com.jetbrains.jdi.SocketTransportService;
import com.jetbrains.jdi.VirtualMachineManagerImpl;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.util.Map;

public class SocketAttachingConnector
extends GenericAttachingConnector {
    static final String ARG_PORT = "port";
    static final String ARG_HOST = "hostname";

    public SocketAttachingConnector() {
        super(new SocketTransportService());
        String defaultHostName = "localhost";
        this.addStringArgument(ARG_HOST, this.getString("socket_attaching.host.label"), this.getString("socket_attaching.host"), defaultHostName, false);
        this.addIntegerArgument(ARG_PORT, this.getString("socket_attaching.port.label"), this.getString("socket_attaching.port"), "", true, 0, Integer.MAX_VALUE);
        this.transport = () -> "dt_socket";
    }

    @Override
    public VirtualMachine attach(Map<String, ? extends Connector.Argument> arguments) throws IOException, IllegalConnectorArgumentsException {
        String host = this.argument(ARG_HOST, arguments).value();
        if (host.length() > 0) {
            host = host + ":";
        }
        String address = host + this.argument(ARG_PORT, arguments).value();
        return super.attach(address, arguments);
    }

    @Override
    public String name() {
        return VirtualMachineManagerImpl.connectorName("com.jetbrains.jdi.SocketAttach");
    }

    @Override
    public String description() {
        return this.getString("socket_attaching.description");
    }
}

