/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;

public class EPathCommonUtil {
    @NotNull
    public static String getRelativeModuleName(String path) {
        int secondSlIdx = path.indexOf(47, 1);
        String string = secondSlIdx > 1 ? path.substring(1, secondSlIdx) : path.substring(1);
        if (string == null) {
            EPathCommonUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public static String getRelativeToModulePath(String path) {
        int secondSlIdx = path.indexOf(47, 1);
        return secondSlIdx != -1 && secondSlIdx + 1 < path.length() ? path.substring(secondSlIdx + 1) : null;
    }

    @Nullable
    public static String expandEclipseRelative2ContentRoots(@NotNull List<String> currentRoots, @NotNull String rootPath, @Nullable String relativeToRootPath) {
        if (currentRoots == null) {
            EPathCommonUtil.$$$reportNull$$$0(1);
        }
        if (rootPath == null) {
            EPathCommonUtil.$$$reportNull$$$0(2);
        }
        for (String currentRoot : currentRoots) {
            if (!currentRoot.endsWith(rootPath) && !Comparing.strEqual((String)rootPath, (String)EclipseProjectFinder.findProjectName(currentRoot))) continue;
            if (relativeToRootPath == null) {
                return EPathCommonUtil.pathToUrl(currentRoot);
            }
            File relativeToOtherModuleFile = new File(currentRoot, relativeToRootPath);
            if (!relativeToOtherModuleFile.exists()) continue;
            return EPathCommonUtil.pathToUrl(relativeToOtherModuleFile.getPath());
        }
        return null;
    }

    public static String pathToUrl(String path) {
        return "file://" + FileUtil.toSystemIndependentName((String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/EPathCommonUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeModuleName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/EPathCommonUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expandEclipseRelative2ContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

