/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownActionUtil {
    @Nullable
    public static SplitFileEditor findSplitEditor(AnActionEvent e) {
        FileEditor editor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        return MarkdownActionUtil.findSplitEditor(editor);
    }

    @Nullable
    public static SplitFileEditor findSplitEditor(@Nullable FileEditor editor) {
        if (editor instanceof SplitFileEditor) {
            return (SplitFileEditor)editor;
        }
        return (SplitFileEditor)((Object)SplitFileEditor.PARENT_SPLIT_KEY.get((UserDataHolder)editor));
    }

    @Nullable
    public static Editor findMarkdownTextEditor(AnActionEvent e) {
        SplitFileEditor splitEditor = MarkdownActionUtil.findSplitEditor(e);
        if (splitEditor == null) {
            PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (psiFile != null && psiFile.getLanguage() == MarkdownLanguage.INSTANCE && ApplicationManager.getApplication().isUnitTestMode()) {
                return (Editor)e.getData(CommonDataKeys.EDITOR);
            }
            return null;
        }
        if (!(splitEditor.getMainEditor() instanceof TextEditor)) {
            return null;
        }
        TextEditor mainEditor = (TextEditor)splitEditor.getMainEditor();
        if (!mainEditor.getComponent().isVisible()) {
            return null;
        }
        return mainEditor.getEditor();
    }

    @Nullable
    public static Couple<PsiElement> getElementsUnderCaretOrSelection(@NotNull PsiFile file, @NotNull Caret caret) {
        if (file == null) {
            MarkdownActionUtil.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            MarkdownActionUtil.$$$reportNull$$$0(1);
        }
        if (caret.getSelectionStart() == caret.getSelectionEnd()) {
            PsiElement element = file.findElementAt(caret.getSelectionStart());
            if (element == null) {
                return null;
            }
            return Couple.of((Object)element, (Object)element);
        }
        PsiElement startElement = file.findElementAt(caret.getSelectionStart());
        PsiElement endElement = file.findElementAt(caret.getSelectionEnd());
        if (startElement == null || endElement == null) {
            return null;
        }
        return Couple.of((Object)startElement, (Object)endElement);
    }

    @Nullable
    public static PsiElement getCommonParentOfType(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull IElementType elementType) {
        if (element1 == null) {
            MarkdownActionUtil.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            MarkdownActionUtil.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            MarkdownActionUtil.$$$reportNull$$$0(4);
        }
        return MarkdownActionUtil.getCommonParentOfTypes(element1, element2, TokenSet.create((IElementType[])new IElementType[]{elementType}));
    }

    @Nullable
    public static PsiElement getCommonTopmostParentOfTypes(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull TokenSet tokenSet) {
        if (element1 == null) {
            MarkdownActionUtil.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            MarkdownActionUtil.$$$reportNull$$$0(6);
        }
        if (tokenSet == null) {
            MarkdownActionUtil.$$$reportNull$$$0(7);
        }
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        return MarkdownActionUtil.getTopmostParentOfType(base, (Condition<? super PsiElement>)((Condition)element -> {
            ASTNode node = element.getNode();
            return node != null && tokenSet.contains(node.getElementType());
        }));
    }

    @Nullable
    public static PsiElement getTopmostParentOfType(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        PsiElement next;
        if (condition == null) {
            MarkdownActionUtil.$$$reportNull$$$0(8);
        }
        PsiElement answer = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, condition);
        while ((next = PsiTreeUtil.findFirstParent((PsiElement)answer, (boolean)true, condition)) != null) {
            answer = next;
        }
        return answer;
    }

    @Nullable
    public static PsiElement getCommonParentOfTypes(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull TokenSet tokenSet) {
        if (element1 == null) {
            MarkdownActionUtil.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            MarkdownActionUtil.$$$reportNull$$$0(10);
        }
        if (tokenSet == null) {
            MarkdownActionUtil.$$$reportNull$$$0(11);
        }
        PsiElement base = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        return PsiTreeUtil.findFirstParent((PsiElement)base, (boolean)false, element -> {
            ASTNode node = element.getNode();
            return node != null && tokenSet.contains(node.getElementType());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/ui/actions/MarkdownActionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsUnderCaretOrSelection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonParentOfType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonTopmostParentOfTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getTopmostParentOfType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommonParentOfTypes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

