/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.BeanDescription;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.DeserializationConfig;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.JavaType;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.JsonDeserializer;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.JsonMappingException;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.JsonSerializer;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.SerializationConfig;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.deser.Deserializers;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext.Java7Handlers;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.ser.Serializers;
import org.gradle.internal.impldep.com.fasterxml.jackson.databind.util.ClassUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    private static final Class<?> CLASS_DOM_NODE;
    private static final Class<?> CLASS_DOM_DOCUMENT;
    private static final Java7Handlers _jdk7Helper;
    public static final OptionalHandlerFactory instance;

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        JsonSerializer<?> ser;
        Class<?> rawType = type.getRawClass();
        if (CLASS_DOM_NODE != null && CLASS_DOM_NODE.isAssignableFrom(rawType)) {
            return (JsonSerializer)this.instantiate("org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext.DOMSerializer");
        }
        if (_jdk7Helper != null && (ser = _jdk7Helper.getSerializerForJavaNioFilePath(rawType)) != null) {
            return ser;
        }
        String className = rawType.getName();
        if (!className.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        String factoryName = "org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        return ((Serializers)ob).findSerializer(config, type, beanDesc);
    }

    public JsonDeserializer<?> findDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        JsonDeserializer<?> deser;
        Class<?> rawType = type.getRawClass();
        if (_jdk7Helper != null && (deser = _jdk7Helper.getDeserializerForJavaNioFilePath(rawType)) != null) {
            return deser;
        }
        if (CLASS_DOM_NODE != null && CLASS_DOM_NODE.isAssignableFrom(rawType)) {
            return (JsonDeserializer)this.instantiate("org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer");
        }
        if (CLASS_DOM_DOCUMENT != null && CLASS_DOM_DOCUMENT.isAssignableFrom(rawType)) {
            return (JsonDeserializer)this.instantiate("org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer");
        }
        String className = rawType.getName();
        if (!className.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        String factoryName = "org.gradle.internal.impldep.com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        return ((Deserializers)ob).findBeanDeserializer(type, config, beanDesc);
    }

    private Object instantiate(String className) {
        try {
            return ClassUtil.createInstance(Class.forName(className), false);
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean hasSuperClassStartingWith(Class<?> rawType, String prefix) {
        for (Class<?> supertype = rawType.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
            if (supertype == Object.class) {
                return false;
            }
            if (!supertype.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        Class<Document> doc = null;
        Class<Node> node = null;
        try {
            node = Node.class;
            doc = Document.class;
        }
        catch (Throwable e) {
            Logger.getLogger(OptionalHandlerFactory.class.getName()).log(Level.INFO, "Could not load DOM `Node` and/or `Document` classes: no DOM support");
        }
        CLASS_DOM_NODE = node;
        CLASS_DOM_DOCUMENT = doc;
        Java7Handlers x = null;
        try {
            x = Java7Handlers.instance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _jdk7Helper = x;
        instance = new OptionalHandlerFactory();
    }
}

