/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.jcifs.netbios;

import java.net.InetAddress;
import org.gradle.internal.impldep.jcifs.netbios.Name;
import org.gradle.internal.impldep.jcifs.netbios.NbtAddress;
import org.gradle.internal.impldep.jcifs.util.Hexdump;

abstract class NameServicePacket {
    static final int QUERY = 0;
    static final int WACK = 7;
    static final int FMT_ERR = 1;
    static final int SRV_ERR = 2;
    static final int IMP_ERR = 4;
    static final int RFS_ERR = 5;
    static final int ACT_ERR = 6;
    static final int CFT_ERR = 7;
    static final int NB_IN = 0x200001;
    static final int NBSTAT_IN = 0x210001;
    static final int NB = 32;
    static final int NBSTAT = 33;
    static final int IN = 1;
    static final int A = 1;
    static final int NS = 2;
    static final int NULL = 10;
    static final int HEADER_LENGTH = 12;
    static final int OPCODE_OFFSET = 2;
    static final int QUESTION_OFFSET = 4;
    static final int ANSWER_OFFSET = 6;
    static final int AUTHORITY_OFFSET = 8;
    static final int ADDITIONAL_OFFSET = 10;
    int addrIndex;
    NbtAddress[] addrEntry;
    int nameTrnId;
    int opCode;
    int resultCode;
    int questionCount = 1;
    int answerCount;
    int authorityCount;
    int additionalCount;
    boolean received;
    boolean isResponse;
    boolean isAuthAnswer;
    boolean isTruncated;
    boolean isRecurDesired = true;
    boolean isRecurAvailable;
    boolean isBroadcast = true;
    Name questionName;
    Name recordName;
    int questionType;
    int questionClass = 1;
    int recordType;
    int recordClass;
    int ttl;
    int rDataLength;
    InetAddress addr;

    static void writeInt2(int val, byte[] dst, int dstIndex) {
        dst[dstIndex++] = (byte)(val >> 8 & 0xFF);
        dst[dstIndex] = (byte)(val & 0xFF);
    }

    static void writeInt4(int val, byte[] dst, int dstIndex) {
        dst[dstIndex++] = (byte)(val >> 24 & 0xFF);
        dst[dstIndex++] = (byte)(val >> 16 & 0xFF);
        dst[dstIndex++] = (byte)(val >> 8 & 0xFF);
        dst[dstIndex] = (byte)(val & 0xFF);
    }

    static int readInt2(byte[] src, int srcIndex) {
        return ((src[srcIndex] & 0xFF) << 8) + (src[srcIndex + 1] & 0xFF);
    }

    static int readInt4(byte[] src, int srcIndex) {
        return ((src[srcIndex] & 0xFF) << 24) + ((src[srcIndex + 1] & 0xFF) << 16) + ((src[srcIndex + 2] & 0xFF) << 8) + (src[srcIndex + 3] & 0xFF);
    }

    static int readNameTrnId(byte[] src, int srcIndex) {
        return NameServicePacket.readInt2(src, srcIndex);
    }

    NameServicePacket() {
    }

    int writeWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        dstIndex += this.writeBodyWireFormat(dst, dstIndex);
        return dstIndex - start;
    }

    int readWireFormat(byte[] src, int srcIndex) {
        int start = srcIndex;
        srcIndex += this.readHeaderWireFormat(src, srcIndex);
        srcIndex += this.readBodyWireFormat(src, srcIndex);
        return srcIndex - start;
    }

    int writeHeaderWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        NameServicePacket.writeInt2(this.nameTrnId, dst, dstIndex);
        dst[dstIndex + 2] = (byte)((this.isResponse ? 128 : 0) + (this.opCode << 3 & 0x78) + (this.isAuthAnswer ? 4 : 0) + (this.isTruncated ? 2 : 0) + (this.isRecurDesired ? 1 : 0));
        dst[dstIndex + 2 + 1] = (byte)((this.isRecurAvailable ? 128 : 0) + (this.isBroadcast ? 16 : 0) + (this.resultCode & 0xF));
        NameServicePacket.writeInt2(this.questionCount, dst, start + 4);
        NameServicePacket.writeInt2(this.answerCount, dst, start + 6);
        NameServicePacket.writeInt2(this.authorityCount, dst, start + 8);
        NameServicePacket.writeInt2(this.additionalCount, dst, start + 10);
        return 12;
    }

    int readHeaderWireFormat(byte[] src, int srcIndex) {
        this.nameTrnId = NameServicePacket.readInt2(src, srcIndex);
        this.isResponse = (src[srcIndex + 2] & 0x80) != 0;
        this.opCode = (src[srcIndex + 2] & 0x78) >> 3;
        this.isAuthAnswer = (src[srcIndex + 2] & 4) != 0;
        this.isTruncated = (src[srcIndex + 2] & 2) != 0;
        this.isRecurDesired = (src[srcIndex + 2] & 1) != 0;
        this.isRecurAvailable = (src[srcIndex + 2 + 1] & 0x80) != 0;
        this.isBroadcast = (src[srcIndex + 2 + 1] & 0x10) != 0;
        this.resultCode = src[srcIndex + 2 + 1] & 0xF;
        this.questionCount = NameServicePacket.readInt2(src, srcIndex + 4);
        this.answerCount = NameServicePacket.readInt2(src, srcIndex + 6);
        this.authorityCount = NameServicePacket.readInt2(src, srcIndex + 8);
        this.additionalCount = NameServicePacket.readInt2(src, srcIndex + 10);
        return 12;
    }

    int writeQuestionSectionWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dstIndex += this.questionName.writeWireFormat(dst, dstIndex);
        NameServicePacket.writeInt2(this.questionType, dst, dstIndex);
        NameServicePacket.writeInt2(this.questionClass, dst, dstIndex += 2);
        return (dstIndex += 2) - start;
    }

    int readQuestionSectionWireFormat(byte[] src, int srcIndex) {
        int start = srcIndex;
        srcIndex += this.questionName.readWireFormat(src, srcIndex);
        this.questionType = NameServicePacket.readInt2(src, srcIndex);
        this.questionClass = NameServicePacket.readInt2(src, srcIndex += 2);
        return (srcIndex += 2) - start;
    }

    int writeResourceRecordWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.recordName == this.questionName) {
            dst[dstIndex++] = -64;
            dst[dstIndex++] = 12;
        } else {
            dstIndex += this.recordName.writeWireFormat(dst, dstIndex);
        }
        NameServicePacket.writeInt2(this.recordType, dst, dstIndex);
        NameServicePacket.writeInt2(this.recordClass, dst, dstIndex += 2);
        NameServicePacket.writeInt4(this.ttl, dst, dstIndex += 2);
        this.rDataLength = this.writeRDataWireFormat(dst, (dstIndex += 4) + 2);
        NameServicePacket.writeInt2(this.rDataLength, dst, dstIndex);
        return (dstIndex += 2 + this.rDataLength) - start;
    }

    int readResourceRecordWireFormat(byte[] src, int srcIndex) {
        int start = srcIndex;
        if ((src[srcIndex] & 0xC0) == 192) {
            this.recordName = this.questionName;
            srcIndex += 2;
        } else {
            srcIndex += this.recordName.readWireFormat(src, srcIndex);
        }
        this.recordType = NameServicePacket.readInt2(src, srcIndex);
        this.recordClass = NameServicePacket.readInt2(src, srcIndex += 2);
        this.ttl = NameServicePacket.readInt4(src, srcIndex += 2);
        this.rDataLength = NameServicePacket.readInt2(src, srcIndex += 4);
        this.addrEntry = new NbtAddress[this.rDataLength / 6];
        int end = (srcIndex += 2) + this.rDataLength;
        this.addrIndex = 0;
        while (srcIndex < end) {
            srcIndex += this.readRDataWireFormat(src, srcIndex);
            ++this.addrIndex;
        }
        return srcIndex - start;
    }

    abstract int writeBodyWireFormat(byte[] var1, int var2);

    abstract int readBodyWireFormat(byte[] var1, int var2);

    abstract int writeRDataWireFormat(byte[] var1, int var2);

    abstract int readRDataWireFormat(byte[] var1, int var2);

    public String toString() {
        String recordTypeString;
        String questionTypeString;
        String opCodeString;
        switch (this.opCode) {
            case 0: {
                opCodeString = "QUERY";
                break;
            }
            case 7: {
                opCodeString = "WACK";
                break;
            }
            default: {
                opCodeString = Integer.toString(this.opCode);
            }
        }
        switch (this.resultCode) {
            case 1: {
                String resultCodeString = "FMT_ERR";
                break;
            }
            case 2: {
                String resultCodeString = "SRV_ERR";
                break;
            }
            case 4: {
                String resultCodeString = "IMP_ERR";
                break;
            }
            case 5: {
                String resultCodeString = "RFS_ERR";
                break;
            }
            case 6: {
                String resultCodeString = "ACT_ERR";
                break;
            }
            case 7: {
                String resultCodeString = "CFT_ERR";
                break;
            }
            default: {
                String resultCodeString = "0x" + Hexdump.toHexString(this.resultCode, 1);
            }
        }
        switch (this.questionType) {
            case 32: {
                questionTypeString = "NB";
                break;
            }
            case 33: {
                questionTypeString = "NBSTAT";
                break;
            }
            default: {
                questionTypeString = "0x" + Hexdump.toHexString(this.questionType, 4);
            }
        }
        switch (this.recordType) {
            case 1: {
                recordTypeString = "A";
                break;
            }
            case 2: {
                recordTypeString = "NS";
                break;
            }
            case 10: {
                recordTypeString = "NULL";
                break;
            }
            case 32: {
                recordTypeString = "NB";
                break;
            }
            case 33: {
                recordTypeString = "NBSTAT";
                break;
            }
            default: {
                recordTypeString = "0x" + Hexdump.toHexString(this.recordType, 4);
            }
        }
        return new String("nameTrnId=" + this.nameTrnId + ",isResponse=" + this.isResponse + ",opCode=" + opCodeString + ",isAuthAnswer=" + this.isAuthAnswer + ",isTruncated=" + this.isTruncated + ",isRecurAvailable=" + this.isRecurAvailable + ",isRecurDesired=" + this.isRecurDesired + ",isBroadcast=" + this.isBroadcast + ",resultCode=" + this.resultCode + ",questionCount=" + this.questionCount + ",answerCount=" + this.answerCount + ",authorityCount=" + this.authorityCount + ",additionalCount=" + this.additionalCount + ",questionName=" + this.questionName + ",questionType=" + questionTypeString + ",questionClass=" + (this.questionClass == 1 ? "IN" : "0x" + Hexdump.toHexString(this.questionClass, 4)) + ",recordName=" + this.recordName + ",recordType=" + recordTypeString + ",recordClass=" + (this.recordClass == 1 ? "IN" : "0x" + Hexdump.toHexString(this.recordClass, 4)) + ",ttl=" + this.ttl + ",rDataLength=" + this.rDataLength);
    }
}

