/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevSort;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;

class PedestrianReachabilityChecker
implements ReachabilityChecker {
    private final boolean topoSort;
    private final RevWalk walk;

    public PedestrianReachabilityChecker(boolean topoSort, RevWalk walk) {
        this.topoSort = topoSort;
        this.walk = walk;
    }

    @Override
    public Optional<RevCommit> areAllReachable(Collection<RevCommit> targets, Collection<RevCommit> starters) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.walk.reset();
        if (this.topoSort) {
            this.walk.sort(RevSort.TOPO);
        }
        for (RevCommit target : targets) {
            this.walk.markStart(target);
        }
        for (RevCommit starter : starters) {
            this.walk.markUninteresting(starter);
        }
        return Optional.ofNullable(this.walk.next());
    }
}

