/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import org.gradle.internal.impldep.org.simpleframework.http.core.BodyConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.Builder;
import org.gradle.internal.impldep.org.simpleframework.http.core.Channel;
import org.gradle.internal.impldep.org.simpleframework.http.core.Consumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.ConsumerFactory;
import org.gradle.internal.impldep.org.simpleframework.http.core.Expectation;
import org.gradle.internal.impldep.org.simpleframework.http.core.RequestConsumer;
import org.gradle.internal.impldep.org.simpleframework.transport.Cursor;
import org.gradle.internal.impldep.org.simpleframework.util.buffer.Allocator;

class BuilderConsumer
implements Consumer {
    protected ConsumerFactory factory;
    protected RequestConsumer header = new RequestConsumer();
    protected BodyConsumer body;
    protected Expectation expect;
    protected Builder builder;

    public BuilderConsumer(Allocator allocator, Builder builder, Channel channel) {
        this.expect = new Expectation(channel);
        this.factory = new ConsumerFactory(allocator, this.header);
        this.builder = builder;
    }

    public void consume(Cursor cursor) throws IOException {
        while (cursor.isReady()) {
            if (this.header.isFinished()) {
                if (this.body == null) {
                    this.body = this.factory.getInstance();
                }
                this.body.consume(cursor);
                if (!this.body.isFinished()) continue;
                break;
            }
            this.header.consume(cursor);
        }
        if (this.header.isFinished()) {
            if (this.body == null) {
                this.expect.execute(this.header);
                this.body = this.factory.getInstance();
            }
            this.builder.setBody(this.body);
            this.builder.setHeader(this.header);
        }
    }

    public boolean isFinished() {
        if (this.header.isFinished()) {
            if (this.body == null) {
                this.body = this.factory.getInstance();
            }
            return this.body.isFinished();
        }
        return false;
    }
}

