/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import java.util.List;
import org.gradle.internal.impldep.org.simpleframework.http.Address;
import org.gradle.internal.impldep.org.simpleframework.http.Path;
import org.gradle.internal.impldep.org.simpleframework.http.Query;
import org.gradle.internal.impldep.org.simpleframework.http.core.HeaderConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.parse.AddressParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestConsumer
extends HeaderConsumer {
    protected AddressParser parser;
    protected String method;
    protected String target;
    protected int major;
    protected int minor;

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public Address getAddress() {
        if (this.parser == null) {
            this.parser = new AddressParser(this.target);
        }
        return this.parser;
    }

    @Override
    public Query getQuery() {
        return this.getAddress().getQuery();
    }

    @Override
    public Path getPath() {
        return this.getAddress().getPath();
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public boolean contains(String name) {
        return this.header.contains(name);
    }

    @Override
    public long getDate(String name) {
        return this.header.getDate(name);
    }

    @Override
    public int getInteger(String name) {
        return this.header.getInteger(name);
    }

    @Override
    public List<String> getNames() {
        return this.header.getNames();
    }

    @Override
    protected void process() {
        this.method();
        this.target();
        this.version();
        this.adjust();
        this.headers();
    }

    private void target() {
        Token token = new Token(this.pos, 0);
        while (this.pos < this.count) {
            if (this.space(this.array[this.pos])) {
                ++this.pos;
                break;
            }
            ++token.size;
            ++this.pos;
        }
        this.target = token.text();
    }

    private void method() {
        Token token = new Token(this.pos, 0);
        while (this.pos < this.count) {
            if (this.space(this.array[this.pos])) {
                ++this.pos;
                break;
            }
            ++token.size;
            ++this.pos;
        }
        this.method = token.text();
    }

    protected void version() {
        this.pos += 5;
        this.major();
        ++this.pos;
        this.minor();
    }

    private void major() {
        while (this.pos < this.count && this.digit(this.array[this.pos])) {
            this.major *= 10;
            this.major += this.array[this.pos];
            this.major -= 48;
            ++this.pos;
        }
    }

    private void minor() {
        while (this.pos < this.count && this.digit(this.array[this.pos])) {
            this.minor *= 10;
            this.minor += this.array[this.pos];
            this.minor -= 48;
            ++this.pos;
        }
    }

    protected boolean digit(byte octet) {
        return octet >= 48 && octet <= 57;
    }

    @Override
    protected boolean space(byte octet) {
        switch (octet) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private class Token {
        public int size;
        public int off;

        public Token(int off, int size) {
            this.off = off;
            this.size = size;
        }

        public String text() {
            return this.text("UTF-8");
        }

        public String text(String charset) {
            try {
                return new String(RequestConsumer.this.array, this.off, this.size, charset);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

