/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import org.gradle.internal.impldep.org.simpleframework.http.ContentType;
import org.gradle.internal.impldep.org.simpleframework.http.Cookie;
import org.gradle.internal.impldep.org.simpleframework.http.Request;
import org.gradle.internal.impldep.org.simpleframework.http.Response;
import org.gradle.internal.impldep.org.simpleframework.http.core.Accumulator;
import org.gradle.internal.impldep.org.simpleframework.http.core.Channel;
import org.gradle.internal.impldep.org.simpleframework.http.core.Conversation;
import org.gradle.internal.impldep.org.simpleframework.http.core.Entity;
import org.gradle.internal.impldep.org.simpleframework.http.core.Header;
import org.gradle.internal.impldep.org.simpleframework.http.core.Monitor;
import org.gradle.internal.impldep.org.simpleframework.http.core.ResponseMessage;
import org.gradle.internal.impldep.org.simpleframework.http.core.Sender;

class ResponseEntity
extends ResponseMessage
implements Response {
    private Conversation support;
    private Accumulator buffer;
    private Channel channel;
    private Sender sender;
    private Header header;
    private boolean committed;

    public ResponseEntity(Request request, Entity entity, Monitor monitor) {
        this.support = new Conversation(request, this);
        this.buffer = new Accumulator(this.support, entity, monitor);
        this.channel = entity.getChannel();
        this.sender = this.channel.getSender();
        this.header = entity.getHeader();
    }

    public Object getAttribute(Object name) {
        return this.getAttributes().get(name);
    }

    public Map getAttributes() {
        return this.channel.getAttributes();
    }

    public void setContentLength(int length) {
        this.set("Content-Length", length);
    }

    private String getCharset() {
        ContentType type = this.getContentType();
        if (type == null) {
            return "iso-8859-1";
        }
        if (type.getCharset() == null) {
            return "iso-8859-1";
        }
        return type.getCharset();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.buffer;
    }

    public OutputStream getOutputStream(int size) throws IOException {
        if (size > 0) {
            this.buffer.expand(size);
        }
        return this.buffer;
    }

    public PrintStream getPrintStream() throws IOException {
        return this.getPrintStream(0, this.getCharset());
    }

    public PrintStream getPrintStream(int size) throws IOException {
        return this.getPrintStream(size, this.getCharset());
    }

    private PrintStream getPrintStream(int size, String charset) throws IOException {
        if (size > 0) {
            this.buffer.expand(size);
        }
        return new PrintStream((OutputStream)this.buffer, false, charset);
    }

    public WritableByteChannel getByteChannel() throws IOException {
        return this.buffer;
    }

    public WritableByteChannel getByteChannel(int size) throws IOException {
        if (size > 0) {
            this.buffer.expand(size);
        }
        return this.buffer;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void commit() throws IOException {
        if (!this.committed) {
            Cookie cookie = this.header.getSession(false);
            if (cookie != null) {
                this.setSession(cookie);
            }
            byte[] message = this.getMessage();
            this.sender.send(message);
            this.committed = true;
        }
    }

    private void setSession(Cookie session) {
        String name = session.getName();
        Cookie cookie = this.getCookie(name);
        if (cookie == null) {
            cookie = session;
        }
        if (cookie.isNew()) {
            this.setCookie(cookie);
        }
    }

    public void reset() throws IOException {
        this.buffer.reset();
    }

    public void close() throws IOException {
        this.buffer.close();
    }
}

