/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.util.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.gradle.internal.impldep.org.sonatype.aether.repository.Proxy;
import org.gradle.internal.impldep.org.sonatype.aether.repository.ProxySelector;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;

public class DefaultProxySelector
implements ProxySelector {
    private List<ProxyDef> proxies = new ArrayList<ProxyDef>();

    public DefaultProxySelector add(Proxy proxy, String nonProxyHosts) {
        this.proxies.add(new ProxyDef(proxy, nonProxyHosts));
        return this;
    }

    public Proxy getProxy(RemoteRepository repository) {
        ProxyDef proxy2;
        HashMap<String, ProxyDef> candidates = new HashMap<String, ProxyDef>();
        String host = repository.getHost();
        for (ProxyDef proxy2 : this.proxies) {
            String key;
            if (DefaultProxySelector.isNonProxyHosts(host, proxy2.nonProxyHosts) || candidates.containsKey(key = proxy2.proxy.getType().toLowerCase(Locale.ENGLISH))) continue;
            candidates.put(key, proxy2);
        }
        String protocol = repository.getProtocol().toLowerCase(Locale.ENGLISH);
        if ("davs".equals(protocol)) {
            protocol = "https";
        } else if ("dav".equals(protocol)) {
            protocol = "http";
        } else if (protocol.startsWith("dav:")) {
            protocol = protocol.substring("dav:".length());
        }
        proxy2 = (ProxyDef)candidates.get(protocol);
        if (proxy2 == null && "https".equals(protocol)) {
            proxy2 = (ProxyDef)candidates.get("http");
        }
        return proxy2 != null ? proxy2.proxy : null;
    }

    static boolean isNonProxyHosts(String host, String nonProxyHosts) {
        if (host != null && nonProxyHosts != null && nonProxyHosts.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!host.matches(pattern = pattern.replace(".", "\\.").replace("*", ".*"))) continue;
                return true;
            }
        }
        return false;
    }

    static class ProxyDef {
        final Proxy proxy;
        final String nonProxyHosts;

        public ProxyDef(Proxy proxy, String nonProxyHosts) {
            this.proxy = proxy;
            this.nonProxyHosts = nonProxyHosts;
        }
    }
}

