/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionProcessingHelper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChainResolver {
    private static final Logger LOG = Logger.getInstance(ChainResolver.class);
    private ChainsSearchResult mySearchResult = new ChainsSearchResult(0L, -1L, null);

    ChainResolver() {
    }

    @NotNull
    ChainStatus tryFindChain(@NotNull PsiElement elementAtDebugger) {
        if (elementAtDebugger == null) {
            ChainResolver.$$$reportNull$$$0(0);
        }
        if (this.mySearchResult.isSuitableFor(elementAtDebugger)) {
            ChainStatus chainStatus = this.mySearchResult.chainsStatus;
            if (chainStatus == null) {
                ChainResolver.$$$reportNull$$$0(1);
            }
            return chainStatus;
        }
        this.mySearchResult = ChainsSearchResult.of(elementAtDebugger);
        ChainResolver.checkChainsExistenceInBackground(elementAtDebugger, this.mySearchResult);
        ChainStatus chainStatus = this.mySearchResult.chainsStatus;
        if (chainStatus == null) {
            ChainResolver.$$$reportNull$$$0(2);
        }
        return chainStatus;
    }

    private static void checkChainsExistenceInBackground(@NotNull PsiElement elementAtDebugger, @NotNull ChainsSearchResult searchResult) {
        List<LibrarySupportProvider> extensions;
        if (elementAtDebugger == null) {
            ChainResolver.$$$reportNull$$$0(3);
        }
        if (searchResult == null) {
            ChainResolver.$$$reportNull$$$0(4);
        }
        if ((extensions = ChainResolver.forLanguage(elementAtDebugger.getLanguage())).isEmpty()) {
            searchResult.markUnsupportedLanguage();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> DumbService.getInstance((Project)elementAtDebugger.getProject()).runReadActionInSmartMode(() -> {
                boolean found;
                LibrarySupportProvider provider = (LibrarySupportProvider)ExtensionProcessingHelper.findFirstSafe(p -> p.getChainBuilder().isChainExists(elementAtDebugger), (Iterable)extensions);
                boolean bl = found = provider != null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Chains found:" + found);
                }
                searchResult.updateStatus(found);
            }));
        }
    }

    @NotNull
    List<StreamChainWithLibrary> getChains(@NotNull PsiElement elementAtDebugger) {
        if (elementAtDebugger == null) {
            ChainResolver.$$$reportNull$$$0(5);
        }
        if (!this.mySearchResult.isSuitableFor(elementAtDebugger) || !this.mySearchResult.chainsStatus.equals((Object)ChainStatus.FOUND)) {
            LOG.error("Cannot build chains: " + (Object)((Object)this.mySearchResult.chainsStatus));
            List<StreamChainWithLibrary> list2 = Collections.emptyList();
            if (list2 == null) {
                ChainResolver.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<StreamChainWithLibrary> chains = new ArrayList<StreamChainWithLibrary>();
        String elementLanguageId = elementAtDebugger.getLanguage().getID();
        LibrarySupportProvider.EP_NAME.forEachExtensionSafe(provider -> {
            StreamChainBuilder chainBuilder;
            if (provider.getLanguageId().equals(elementLanguageId) && (chainBuilder = provider.getChainBuilder()).isChainExists(elementAtDebugger)) {
                for (StreamChain x : chainBuilder.build(elementAtDebugger)) {
                    chains.add(new StreamChainWithLibrary(x, (LibrarySupportProvider)provider));
                }
            }
        });
        ArrayList<StreamChainWithLibrary> arrayList = chains;
        if (arrayList == null) {
            ChainResolver.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    private static List<LibrarySupportProvider> forLanguage(@NotNull Language language) {
        if (language == null) {
            ChainResolver.$$$reportNull$$$0(8);
        }
        List list2 = LibrarySupportProvider.EP_NAME.getByGroupingKey((Object)language.getID(), ChainResolver.class, LibrarySupportProvider::getLanguageId);
        if (list2 == null) {
            ChainResolver.$$$reportNull$$$0(9);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAtDebugger";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/streams/action/ChainResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchResult";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/streams/action/ChainResolver";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tryFindChain";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChains";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryFindChain";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkChainsExistenceInBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChains";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChainsSearchResult {
        final long elementHash;
        final long offset;
        final long fileModificationStamp;
        @NotNull
        volatile ChainStatus chainsStatus = ChainStatus.COMPUTING;

        ChainsSearchResult(long elementHash, long offsetInFile, @Nullable PsiFile containingFile) {
            this.elementHash = elementHash;
            this.fileModificationStamp = ChainsSearchResult.getModificationStamp(containingFile);
            this.offset = offsetInFile;
        }

        private static long getModificationStamp(@Nullable PsiFile file) {
            return file == null ? -1L : file.getModificationStamp();
        }

        @NotNull
        static ChainsSearchResult of(@NotNull PsiElement element) {
            if (element == null) {
                ChainsSearchResult.$$$reportNull$$$0(0);
            }
            return new ChainsSearchResult(element.hashCode(), element.getTextOffset(), element.getContainingFile());
        }

        void updateStatus(boolean found) {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = found ? ChainStatus.FOUND : ChainStatus.NOT_FOUND;
        }

        void markUnsupportedLanguage() {
            LOG.assertTrue(ChainStatus.COMPUTING.equals((Object)this.chainsStatus));
            this.chainsStatus = ChainStatus.LANGUAGE_NOT_SUPPORTED;
        }

        boolean isSuitableFor(@NotNull PsiElement element) {
            if (element == null) {
                ChainsSearchResult.$$$reportNull$$$0(1);
            }
            return this.elementHash == (long)element.hashCode() && this.offset == (long)element.getTextOffset() && this.fileModificationStamp == ChainsSearchResult.getModificationStamp(element.getContainingFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/debugger/streams/action/ChainResolver$ChainsSearchResult";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuitableFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class StreamChainWithLibrary {
        final StreamChain chain;
        final LibrarySupportProvider provider;

        StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull LibrarySupportProvider provider) {
            if (chain == null) {
                StreamChainWithLibrary.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                StreamChainWithLibrary.$$$reportNull$$$0(1);
            }
            this.chain = chain;
            this.provider = provider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "chain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/streams/action/ChainResolver$StreamChainWithLibrary";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum ChainStatus {
        LANGUAGE_NOT_SUPPORTED,
        COMPUTING,
        FOUND,
        NOT_FOUND;

    }
}

