/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.history.LocalHistory;
import com.intellij.ide.macro.Macro;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.execution.AntBeforeExecutionEvent;
import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.AntCommandLineBuilder;
import com.intellij.lang.ant.config.execution.AntExecutionListener;
import com.intellij.lang.ant.config.execution.AntFinishedExecutionEvent;
import com.intellij.lang.ant.config.execution.AntProcessHandler;
import com.intellij.lang.ant.config.execution.AntRunConfiguration;
import com.intellij.lang.ant.config.execution.AntRunProfileState;
import com.intellij.lang.ant.config.execution.OutputParser;
import com.intellij.lang.ant.config.execution.OutputParser2;
import com.intellij.lang.ant.config.execution.RunCanceledException;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.segments.OutputPacketProcessor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FutureResult;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionHandler {
    private static final Logger LOG = Logger.getInstance(ExecutionHandler.class);
    @NonNls
    public static final String PARSER_JAR = "xerces1.jar";

    private ExecutionHandler() {
    }

    @Nullable
    public static ProcessHandler executeRunConfiguration(AntRunConfiguration antRunConfiguration, DataContext dataContext, List<BuildFileProperty> additionalProperties, @NotNull AntBuildListener antBuildListener) {
        AntBuildTarget target;
        if (antBuildListener == null) {
            ExecutionHandler.$$$reportNull$$$0(0);
        }
        if ((target = antRunConfiguration.getTarget()) == null) {
            return null;
        }
        FutureResult<ProcessHandler> result = ExecutionHandler.runBuildImpl((AntBuildFileBase)target.getModel().getBuildFile(), target.getTargetNames(), null, dataContext, additionalProperties, antBuildListener, false);
        if (result != null) {
            try {
                return (ProcessHandler)result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
        return null;
    }

    @Deprecated
    public static void runBuild(AntBuildFileBase buildFile, String[] targets, @Nullable AntBuildMessageView buildMessageViewToReuse, DataContext dataContext, List<BuildFileProperty> additionalProperties, @NotNull AntBuildListener antBuildListener) {
        if (antBuildListener == null) {
            ExecutionHandler.$$$reportNull$$$0(1);
        }
        ExecutionHandler.runBuild(buildFile, Arrays.asList(targets), buildMessageViewToReuse, dataContext, additionalProperties, antBuildListener);
    }

    public static void runBuild(AntBuildFileBase buildFile, List<String> targets, @Nullable AntBuildMessageView buildMessageViewToReuse, DataContext dataContext, List<BuildFileProperty> additionalProperties, @NotNull AntBuildListener antBuildListener) {
        if (antBuildListener == null) {
            ExecutionHandler.$$$reportNull$$$0(2);
        }
        ExecutionHandler.runBuildImpl(buildFile, targets, buildMessageViewToReuse, dataContext, additionalProperties, antBuildListener, true);
    }

    @Nullable
    private static FutureResult<ProcessHandler> runBuildImpl(final AntBuildFileBase buildFile, List<String> targets, @Nullable AntBuildMessageView buildMessageViewToReuse, DataContext dataContext, List<BuildFileProperty> additionalProperties, @NotNull AntBuildListener antBuildListener, final boolean waitFor) {
        GeneralCommandLine commandLine;
        AntBuildMessageView messageView;
        if (antBuildListener == null) {
            ExecutionHandler.$$$reportNull$$$0(3);
        }
        final AntBuildListenerWrapper listenerWrapper = new AntBuildListenerWrapper(buildFile, antBuildListener);
        Project project = buildFile.getProject();
        try {
            FileDocumentManager.getInstance().saveAllDocuments();
            AntCommandLineBuilder builder = new AntCommandLineBuilder();
            builder.setBuildFile(buildFile.getAllOptions(), VfsUtilCore.virtualToIoFile((VirtualFile)buildFile.getVirtualFile()));
            builder.calculateProperties(dataContext, buildFile.getProject(), additionalProperties);
            builder.addTargets(targets);
            builder.getCommandLine().setCharset(EncodingProjectManager.getInstance((Project)buildFile.getProject()).getDefaultCharset());
            messageView = ExecutionHandler.prepareMessageView(buildMessageViewToReuse, buildFile, targets, additionalProperties);
            commandLine = builder.getCommandLine().toCommandLine();
            messageView.setBuildCommandLine(commandLine.getCommandLineString());
            ((AntExecutionListener)project.getMessageBus().syncPublisher(AntExecutionListener.TOPIC)).beforeExecution(new AntBeforeExecutionEvent(buildFile, messageView));
        }
        catch (RunCanceledException e) {
            e.showMessage(project, AntBundle.message("run.ant.error.dialog.title", new Object[0]));
            listenerWrapper.buildFinished(2, 0);
            return null;
        }
        catch (CantRunException e) {
            ExecutionErrorDialog.show((com.intellij.execution.ExecutionException)e, (String)AntBundle.message("cant.run.ant.error.dialog.title", new Object[0]), (Project)project);
            listenerWrapper.buildFinished(2, 0);
            return null;
        }
        catch (Macro.ExecutionCancelledException e) {
            listenerWrapper.buildFinished(1, 0);
            return null;
        }
        catch (Throwable e) {
            listenerWrapper.buildFinished(2, 0);
            LOG.error(e);
            return null;
        }
        final FutureResult future = new FutureResult();
        new Task.Backgroundable(buildFile.getProject(), AntBundle.message("ant.build.progress.dialog.title", new Object[0]), true){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void onCancel() {
                listenerWrapper.buildFinished(1, 0);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    ProcessHandler handler = ExecutionHandler.runBuild(indicator, messageView, buildFile, listenerWrapper, commandLine);
                    future.set((Object)handler);
                    if (waitFor && handler != null) {
                        handler.waitFor();
                    }
                }
                catch (Throwable e) {
                    LOG.error(e);
                    listenerWrapper.buildFinished(2, 0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/ant/config/execution/ExecutionHandler$1", "run"));
            }
        }.queue();
        return future;
    }

    @Nullable
    private static ProcessHandler runBuild(ProgressIndicator progress, @NotNull AntBuildMessageView errorView, @NotNull AntBuildFileBase buildFile, @NotNull AntBuildListener antBuildListener, @NotNull GeneralCommandLine commandLine) {
        AntProcessHandler handler;
        if (errorView == null) {
            ExecutionHandler.$$$reportNull$$$0(4);
        }
        if (buildFile == null) {
            ExecutionHandler.$$$reportNull$$$0(5);
        }
        if (antBuildListener == null) {
            ExecutionHandler.$$$reportNull$$$0(6);
        }
        if (commandLine == null) {
            ExecutionHandler.$$$reportNull$$$0(7);
        }
        Project project = buildFile.getProject();
        long startTime = System.currentTimeMillis();
        LocalHistory.getInstance().putSystemLabel(project, AntBundle.message("ant.build.local.history.label", buildFile.getName()));
        try {
            handler = AntProcessHandler.runCommandLine(commandLine);
        }
        catch (com.intellij.execution.ExecutionException e) {
            ApplicationManager.getApplication().invokeLater(() -> ExecutionErrorDialog.show((com.intellij.execution.ExecutionException)e, (String)AntBundle.message("could.not.start.process.error.dialog.title", new Object[0]), (Project)project));
            antBuildListener.buildFinished(2, 0);
            return null;
        }
        ExecutionHandler.processRunningAnt(progress, handler, errorView, buildFile, startTime, antBuildListener);
        return handler;
    }

    private static void processRunningAnt(final ProgressIndicator progress, final AntProcessHandler handler, final AntBuildMessageView errorView, AntBuildFileBase buildFile, final long startTime, final AntBuildListener antBuildListener) {
        Project project = buildFile.getProject();
        StatusBar statusbar = WindowManager.getInstance().getStatusBar(project);
        if (statusbar != null) {
            statusbar.setInfo(AntBundle.message("ant.build.started.status.message", new Object[0]));
        }
        final CheckCancelTask checkCancelTask = new CheckCancelTask(progress, (OSProcessHandler)handler);
        checkCancelTask.start(0L);
        final OutputParser parser = OutputParser2.attachParser(project, handler, errorView, progress, buildFile);
        handler.putUserData(AntRunProfileState.MESSAGE_VIEW, errorView);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private final StringBuilder myUnprocessedStdErr = new StringBuilder();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDERR) {
                    String text = event.getText();
                    StringBuilder stringBuilder = this.myUnprocessedStdErr;
                    synchronized (stringBuilder) {
                        this.myUnprocessedStdErr.append(text);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(@NotNull ProcessEvent event) {
                OutputPacketProcessor dispatcher;
                long buildTime;
                block11: {
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    buildTime = System.currentTimeMillis() - startTime;
                    checkCancelTask.cancel();
                    parser.setStopped(true);
                    dispatcher = handler.getErr().getEventsDispatcher();
                    try {
                        if (event.getExitCode() != 0) {
                            String unprocessed;
                            StringBuilder stringBuilder = this.myUnprocessedStdErr;
                            synchronized (stringBuilder) {
                                unprocessed = this.myUnprocessedStdErr.toString();
                                this.myUnprocessedStdErr.setLength(0);
                            }
                            if (!unprocessed.isEmpty()) {
                                dispatcher.processOutput(new Printable(){

                                    public void printOn(Printer printer) {
                                        errorView.outputError(unprocessed, 0);
                                    }
                                });
                            }
                            break block11;
                        }
                        StringBuilder stringBuilder = this.myUnprocessedStdErr;
                        synchronized (stringBuilder) {
                            this.myUnprocessedStdErr.setLength(0);
                        }
                    }
                    catch (Throwable throwable) {
                        errorView.buildFinished(progress != null && progress.isCanceled(), buildTime, antBuildListener, dispatcher);
                        throw throwable;
                    }
                }
                errorView.buildFinished(progress != null && progress.isCanceled(), buildTime, antBuildListener, dispatcher);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/ant/config/execution/ExecutionHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        handler.startNotify();
    }

    private static AntBuildMessageView prepareMessageView(@Nullable AntBuildMessageView buildMessageViewToReuse, AntBuildFileBase buildFile, List<String> targets, List<BuildFileProperty> additionalProperties) throws RunCanceledException {
        AntBuildMessageView messageView;
        if (buildMessageViewToReuse != null) {
            messageView = buildMessageViewToReuse;
            messageView.emptyAll();
        } else {
            messageView = AntBuildMessageView.openBuildMessageView(buildFile.getProject(), buildFile, targets, additionalProperties);
            if (messageView == null) {
                throw new RunCanceledException(AntBundle.message("canceled.by.user.error.message", new Object[0]));
            }
        }
        return messageView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "antBuildListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ant/config/execution/ExecutionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeRunConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "runBuild";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "runBuildImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AntBuildListenerWrapper
    implements AntBuildListener {
        @NotNull
        private final AntBuildFile myBuildFile;
        @NotNull
        private final AntBuildListener myDelegate;

        AntBuildListenerWrapper(@NotNull AntBuildFile buildFile, @NotNull AntBuildListener delegate) {
            if (buildFile == null) {
                AntBuildListenerWrapper.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                AntBuildListenerWrapper.$$$reportNull$$$0(1);
            }
            this.myBuildFile = buildFile;
            this.myDelegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buildFinished(int state, int errorCount) {
            try {
                AntFinishedExecutionEvent.Status status = state == 1 ? AntFinishedExecutionEvent.Status.CANCELED : (state == 2 ? AntFinishedExecutionEvent.Status.FAILURE : AntFinishedExecutionEvent.Status.SUCCESS);
                ((AntExecutionListener)this.myBuildFile.getProject().getMessageBus().syncPublisher(AntExecutionListener.TOPIC)).buildFinished(new AntFinishedExecutionEvent(this.myBuildFile, status, errorCount));
            }
            finally {
                this.myDelegate.buildFinished(state, errorCount);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/ant/config/execution/ExecutionHandler$AntBuildListenerWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class CheckCancelTask
    implements Runnable {
        private final ProgressIndicator myProgressIndicator;
        private final OSProcessHandler myProcessHandler;
        private volatile boolean myCanceled;

        CheckCancelTask(ProgressIndicator progressIndicator, OSProcessHandler process) {
            this.myProgressIndicator = progressIndicator;
            this.myProcessHandler = process;
        }

        public void cancel() {
            this.myCanceled = true;
        }

        @Override
        public void run() {
            if (!this.myCanceled) {
                try {
                    this.myProgressIndicator.checkCanceled();
                    this.start(50L);
                }
                catch (ProcessCanceledException e) {
                    this.myProcessHandler.destroyProcess();
                }
            }
        }

        public void start(long delay) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(this, delay, TimeUnit.MILLISECONDS);
        }
    }
}

