/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.lang.ant.config.execution.AntOutputView;
import com.intellij.lang.ant.config.execution.HyperlinkUtil;
import com.intellij.lang.ant.config.execution.TreeView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlainTextView
implements AntOutputView {
    private final ConsoleView myConsole;
    private final Project myProject;
    private String myCommandLine;
    private final LightProcessHandler myProcessHandler = new LightProcessHandler();

    public PlainTextView(Project project) {
        this.myProject = project;
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        builder.addFilter((Filter)new AntMessageFilter());
        builder.addFilter((Filter)new JUnitFilter());
        this.myConsole = builder.getConsole();
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myConsole);
    }

    @Override
    public String getId() {
        return "_text_view_";
    }

    @Override
    public JComponent getComponent() {
        return this.myConsole.getComponent();
    }

    @Override
    @Nullable
    public Object addMessage(AntMessage message) {
        this.print(message.getText() + "\n", ProcessOutputTypes.STDOUT);
        return null;
    }

    private void print(String text, Key type) {
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    public void addMessages(AntMessage[] messages) {
        for (AntMessage message : messages) {
            this.addMessage(message);
        }
    }

    @Override
    public void addJavacMessage(AntMessage message, String url) {
        if (message.getLine() > 0) {
            String msg = TreeView.printMessage(message, url);
            this.print(msg, ProcessOutputTypes.STDOUT);
        }
        this.print(message.getText(), ProcessOutputTypes.STDOUT);
    }

    @Override
    public void addException(AntMessage exception, boolean showFullTrace) {
        int index;
        String text = exception.getText();
        if (!showFullTrace && (index = text.indexOf("\r\n")) != -1) {
            text = text.substring(0, index) + "\n";
        }
        this.print(text, ProcessOutputTypes.STDOUT);
    }

    public void clearAllMessages() {
        this.myConsole.clear();
    }

    @Override
    public void startBuild(AntMessage message) {
        this.print(this.myCommandLine + "\n", ProcessOutputTypes.SYSTEM);
        this.addMessage(message);
    }

    @Override
    public void buildFailed(AntMessage message) {
        this.print(this.myCommandLine + "\n", ProcessOutputTypes.SYSTEM);
        this.addMessage(message);
    }

    @Override
    public void startTarget(AntMessage message) {
        this.addMessage(message);
    }

    @Override
    public void startTask(AntMessage message) {
        this.addMessage(message);
    }

    @Override
    public void finishBuild(String messageText) {
        this.print("\n" + messageText + "\n", ProcessOutputTypes.SYSTEM);
    }

    @Override
    public void finishTarget() {
    }

    @Override
    public void finishTask() {
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            PlainTextView.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void setBuildCommandLine(String commandLine) {
        this.myCommandLine = commandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/lang/ant/config/execution/PlainTextView", "getData"));
    }

    private static class LightProcessHandler
    extends ProcessHandler {
        private LightProcessHandler() {
        }

        protected void destroyProcessImpl() {
            throw new UnsupportedOperationException();
        }

        protected void detachProcessImpl() {
            throw new UnsupportedOperationException();
        }

        public boolean detachIsDefault() {
            return false;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return null;
        }
    }

    private final class AntMessageFilter
    implements Filter {
        private AntMessageFilter() {
        }

        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            int lineNumber;
            int afterLineNumberIndex;
            if (line == null) {
                AntMessageFilter.$$$reportNull$$$0(0);
            }
            if ((afterLineNumberIndex = line.indexOf(": ")) == -1) {
                return null;
            }
            String fileAndLineNumber = line.substring(0, afterLineNumberIndex);
            int index = fileAndLineNumber.lastIndexOf(58);
            if (index == -1) {
                return null;
            }
            String fileName = fileAndLineNumber.substring(0, index);
            String lineNumberStr = fileAndLineNumber.substring(index + 1).trim();
            try {
                lineNumber = Integer.parseInt(lineNumberStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fileName.replace(File.separatorChar, '/'));
            if (file == null) {
                return null;
            }
            int textStartOffset = entireLength - line.length();
            int highlightEndOffset = textStartOffset + afterLineNumberIndex;
            OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(PlainTextView.this.myProject, file, lineNumber - 1);
            return new Filter.Result(textStartOffset, highlightEndOffset, (HyperlinkInfo)info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/ant/config/execution/PlainTextView$AntMessageFilter", "applyFilter"));
        }
    }

    private final class JUnitFilter
    implements Filter {
        private JUnitFilter() {
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            HyperlinkUtil.PlaceInfo placeInfo;
            if (line == null) {
                JUnitFilter.$$$reportNull$$$0(0);
            }
            if ((placeInfo = HyperlinkUtil.parseJUnitMessage(PlainTextView.this.myProject, line)) == null) {
                return null;
            }
            int textStartOffset = entireLength - line.length();
            int highlightStartOffset = textStartOffset + placeInfo.getLinkStartIndex();
            int highlightEndOffset = textStartOffset + placeInfo.getLinkEndIndex() + 1;
            OpenFileHyperlinkInfo info = new OpenFileHyperlinkInfo(PlainTextView.this.myProject, placeInfo.getFile(), placeInfo.getLine(), placeInfo.getColumn());
            return new Filter.Result(highlightStartOffset, highlightEndOffset, (HyperlinkInfo)info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/ant/config/execution/PlainTextView$JUnitFilter", "applyFilter"));
        }
    }
}

