/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.impl.AntBeforeRunTaskProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class AntBeforeRunTask
extends BeforeRunTask<AntBeforeRunTask> {
    private String myTargetName;
    private String myAntFileUrl;

    public AntBeforeRunTask() {
        super(AntBeforeRunTaskProvider.ID);
    }

    public String getAntFileUrl() {
        return this.myAntFileUrl;
    }

    public void setAntFileUrl(String url) {
        this.myAntFileUrl = url;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public void setTargetName(String targetName) {
        this.myTargetName = targetName;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            AntBeforeRunTask.$$$reportNull$$$0(0);
        }
        super.writeExternal(element);
        if (this.myAntFileUrl != null && this.myTargetName != null) {
            element.setAttribute("antfile", this.myAntFileUrl);
            element.setAttribute("target", this.myTargetName);
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            AntBeforeRunTask.$$$reportNull$$$0(1);
        }
        super.readExternal(element);
        String url = element.getAttributeValue("antfile");
        String targetName = element.getAttributeValue("target");
        if (url != null && targetName != null) {
            this.myAntFileUrl = url;
            this.myTargetName = targetName;
        }
    }

    public boolean isRunningTarget(AntBuildTarget target) {
        VirtualFile vFile = target.getModel().getBuildFile().getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (this.myAntFileUrl == null || !FileUtil.pathsEqual((String)this.myAntFileUrl, (String)vFile.getUrl())) {
            return false;
        }
        return Objects.equals(this.myTargetName, target.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AntBeforeRunTask that = (AntBeforeRunTask)((Object)o);
        if (this.myAntFileUrl != null ? !this.myAntFileUrl.equals(that.myAntFileUrl) : that.myAntFileUrl != null) {
            return false;
        }
        return !(this.myTargetName != null ? !this.myTargetName.equals(that.myTargetName) : that.myTargetName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myTargetName != null ? this.myTargetName.hashCode() : 0);
        result = 31 * result + (this.myAntFileUrl != null ? this.myAntFileUrl.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/intellij/lang/ant/config/impl/AntBeforeRunTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

