/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.annotator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenDomAnnotator
implements DomElementsAnnotator {
    public void annotate(DomElement element, DomElementAnnotationHolder holder) {
        if (element instanceof MavenDomProjectModel) {
            MavenDomAnnotator.addProblems(element, (MavenDomProjectModel)element, holder, MavenProjectProblem.ProblemType.STRUCTURE, MavenProjectProblem.ProblemType.SETTINGS_OR_PROFILES);
        } else if (element instanceof MavenDomParent) {
            MavenDomAnnotator.addProblems(element, (MavenDomProjectModel)DomUtil.getParentOfType((DomElement)element, MavenDomProjectModel.class, (boolean)true), holder, MavenProjectProblem.ProblemType.PARENT);
        }
    }

    private static void addProblems(DomElement element, MavenDomProjectModel model, DomElementAnnotationHolder holder, MavenProjectProblem.ProblemType ... types) {
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            for (MavenProjectProblem each : mavenProject.getProblems()) {
                MavenProjectProblem.ProblemType type = each.getType();
                if (!Arrays.asList(types).contains(type)) continue;
                VirtualFile problemFile = LocalFileSystem.getInstance().findFileByPath(each.getPath());
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                if (problemFile != null && !Comparing.equal((Object)mavenProject.getFile(), (Object)problemFile)) {
                    fixes = new LocalQuickFix[]{new OpenProblemFileFix(problemFile)};
                }
                holder.createProblem(element, HighlightSeverity.ERROR, each.getDescription(), fixes);
            }
        }
    }

    private static class OpenProblemFileFix
    implements LocalQuickFix {
        private final VirtualFile myFile;

        private OpenProblemFileFix(VirtualFile file) {
            this.myFile = file;
        }

        @NotNull
        public String getName() {
            String string = MavenDomBundle.message("fix.open.file", this.myFile.getName());
            if (string == null) {
                OpenProblemFileFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.group", new Object[0]);
            if (string == null) {
                OpenProblemFileFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                OpenProblemFileFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                OpenProblemFileFix.$$$reportNull$$$0(3);
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, this.myFile, -1).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/annotator/MavenDomAnnotator$OpenProblemFileFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/annotator/MavenDomAnnotator$OpenProblemFileFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

