/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomProjectModelDescription;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomExclusion;

public class MavenPomXmlCompletionTagListenerContributor
extends CompletionContributor {
    private final Set<String> myHandledTags = ImmutableSet.of((Object)"dependency", (Object)"exclusion");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            MavenPomXmlCompletionTagListenerContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MavenPomXmlCompletionTagListenerContributor.$$$reportNull$$$0(1);
        }
        if (TemplateManager.getInstance((Project)parameters.getOriginalFile().getProject()).getActiveTemplate(parameters.getEditor()) != null) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        if (!MavenDomUtil.isProjectFile(psiFile)) {
            return;
        }
        DomFileDescription description = DomManager.getDomManager((Project)psiFile.getProject()).getDomFileDescription((XmlFile)psiFile);
        if (!(description instanceof MavenDomProjectModelDescription)) {
            return;
        }
        result.runRemainingContributors(parameters, r -> {
            final LookupElement lookupElement = r.getLookupElement();
            String lookupString = lookupElement.getLookupString();
            if (this.myHandledTags.contains(lookupString)) {
                LookupElementDecorator decorator = LookupElementDecorator.withInsertHandler((LookupElement)lookupElement, (InsertHandler)new InsertHandler<LookupElementDecorator<LookupElement>>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        lookupElement.handleInsert(context);
                        Object object = lookupElement.getObject();
                        if (object instanceof XmlTag && "maven-4.0.0.xsd".equals(((XmlTag)object).getContainingFile().getName())) {
                            DomElement domElement;
                            context.commitDocument();
                            CaretModel caretModel = context.getEditor().getCaretModel();
                            PsiElement psiElement = context.getFile().findElementAt(caretModel.getOffset());
                            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class);
                            if (xmlTag != null && ((domElement = DomManager.getDomManager((Project)context.getProject()).getDomElement(xmlTag)) instanceof MavenDomDependency || domElement instanceof MavenDomExclusion)) {
                                String s = "\n<groupId></groupId>\n<artifactId></artifactId>\n";
                                context.getDocument().insertString(caretModel.getOffset(), (CharSequence)s);
                                caretModel.moveToOffset(caretModel.getOffset() + s.length() - "</artifactId>\n".length());
                                context.commitDocument();
                                new ReformatCodeProcessor(context.getProject(), context.getFile(), xmlTag.getTextRange(), false).run();
                                MavenDependencyCompletionUtil.invokeCompletion(context, CompletionType.BASIC);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenPomXmlCompletionTagListenerContributor$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                r = r.withLookupElement((LookupElement)decorator);
            }
            result.passResult(r);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenPomXmlCompletionTagListenerContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

