/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenPathReferenceConverter
extends PathReferenceConverter {
    private final Condition<PsiFileSystemItem> myCondition;

    public MavenPathReferenceConverter() {
        this((Condition<PsiFileSystemItem>)Conditions.alwaysTrue());
    }

    public MavenPathReferenceConverter(@NotNull Condition<PsiFileSystemItem> condition) {
        if (condition == null) {
            MavenPathReferenceConverter.$$$reportNull$$$0(0);
        }
        this.myCondition = condition;
    }

    public static PsiReference[] createReferences(DomElement genericDomValue, PsiElement element, @NotNull Condition<PsiFileSystemItem> fileFilter) {
        if (fileFilter == null) {
            MavenPathReferenceConverter.$$$reportNull$$$0(1);
        }
        return MavenPathReferenceConverter.createReferences(genericDomValue, element, fileFilter, false);
    }

    public static PsiReference[] createReferences(final DomElement genericDomValue, PsiElement element, final @NotNull Condition<PsiFileSystemItem> fileFilter, boolean isAbsolutePath) {
        if (fileFilter == null) {
            MavenPathReferenceConverter.$$$reportNull$$$0(2);
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String text = range.substring(element.getText());
        FileReferenceSet set = new FileReferenceSet(text, element, range.getStartOffset(), null, SystemInfo.isFileSystemCaseSensitive, false){
            private MavenDomProjectModel model;

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return fileFilter;
            }

            protected boolean isSoft() {
                return true;
            }

            public FileReference createFileReference(TextRange range, int index, String text) {
                return new FileReference(this, range, index, text){

                    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
                        String resolvedText;
                        DomElement rootElement;
                        if (text == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (context == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (model == null && (rootElement = DomUtil.getFileElement((DomElement)genericDomValue).getRootElement()) instanceof MavenDomProjectModel) {
                            model = (MavenDomProjectModel)rootElement;
                        }
                        String string = resolvedText = model == null ? text : MavenPropertyResolver.resolve(text, model);
                        if (resolvedText.equals(text)) {
                            if (this.getIndex() == 0 && resolvedText.length() == 2 && resolvedText.charAt(1) == ':') {
                                PsiDirectory psiDirectory;
                                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(resolvedText + '/');
                                if (file != null && (psiDirectory = context.getManager().findDirectory(file)) != null) {
                                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiDirectory));
                                }
                            } else if (this.getIndex() == this.getAllReferences().length - 1 && Objects.equals("relativePath", genericDomValue.getXmlElementName()) && context.getVirtualFile() != null) {
                                VirtualFile parentFile = context.getVirtualFile().findChild(text);
                                if (parentFile != null) {
                                    PsiFile psiFile;
                                    VirtualFile parentPom;
                                    VirtualFile virtualFile = parentPom = parentFile.isDirectory() ? parentFile.findChild("pom.xml") : parentFile;
                                    if (parentPom != null && (psiFile = context.getManager().findFile(parentPom)) != null) {
                                        result.add((ResolveResult)new PsiElementResolveResult((PsiElement)psiFile));
                                    }
                                }
                            } else if ("..".equals(resolvedText)) {
                                PsiFileSystemItem resolved = context.getParent();
                                if (resolved != null) {
                                    if (context instanceof XmlFileImpl) {
                                        resolved = resolved.getParent();
                                    }
                                    if (resolved != null) {
                                        result.add((ResolveResult)new PsiElementResolveResult((PsiElement)resolved));
                                    }
                                }
                            } else {
                                super.innerResolveInContext(resolvedText, context, result, caseSensitive);
                            }
                        } else {
                            VirtualFile contextFile = context.getVirtualFile();
                            if (contextFile == null) {
                                return;
                            }
                            VirtualFile file = null;
                            if (this.getIndex() == 0) {
                                file = LocalFileSystem.getInstance().findFileByPath(resolvedText);
                            }
                            if (file == null) {
                                file = LocalFileSystem.getInstance().findFileByPath(contextFile.getPath() + '/' + resolvedText);
                            }
                            if (file != null) {
                                PsiDirectory res;
                                Object object = res = file.isDirectory() ? context.getManager().findDirectory(file) : context.getManager().findFile(file);
                                if (res != null) {
                                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)res));
                                }
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "text";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter$1$1";
                        objectArray[2] = "innerResolveInContext";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
        if (isAbsolutePath) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return (Collection)FileReferenceSet.ABSOLUTE_TOP_LEVEL.fun(file);
                }
                virtualFile = VfsUtil.getRootFile((VirtualFile)virtualFile);
                PsiDirectory root = file.getManager().findDirectory(virtualFile);
                if (root == null) {
                    return (Collection)FileReferenceSet.ABSOLUTE_TOP_LEVEL.fun(file);
                }
                return Collections.singletonList(root);
            });
        }
        return set.getAllReferences();
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray = MavenPathReferenceConverter.createReferences((DomElement)genericDomValue, element, this.myCondition);
        if (psiReferenceArray == null) {
            MavenPathReferenceConverter.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    public PsiReference @NotNull [] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            MavenPathReferenceConverter.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenPathReferenceConverter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

