/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.maven.execution.RunnerBundle;

public class MavenCommandLineOptions {
    private static final Map<String, Option> ourOptionsIndexMap;
    private static final Set<Option> ourAllOptions;

    public static Collection<Option> getAllOptions() {
        return Collections.unmodifiableSet(ourAllOptions);
    }

    public static Option findOption(String name) {
        return ourOptionsIndexMap.get(name);
    }

    static {
        ourAllOptions = new HashSet<Option>();
        ourAllOptions.add(new Option("-am", "--also-make", RunnerBundle.message("maven.options.description.am", new Object[0])));
        ourAllOptions.add(new Option("-amd", "--also-make-dependents", RunnerBundle.message("maven.options.description.amd", new Object[0])));
        ourAllOptions.add(new Option("-B", "--batch-mode", RunnerBundle.message("maven.options.description.B", new Object[0])));
        ourAllOptions.add(new Option("-b", "--builder", RunnerBundle.message("maven.options.description.b", new Object[0])));
        ourAllOptions.add(new Option("-C", "--strict-checksums", RunnerBundle.message("maven.options.description.C", new Object[0])));
        ourAllOptions.add(new Option("-c", "--lax-checksums", RunnerBundle.message("maven.options.description.c", new Object[0])));
        ourAllOptions.add(new Option("-cpu", "--check-plugin-updates", RunnerBundle.message("maven.options.description.cpu", new Object[0])));
        ourAllOptions.add(new Option("-D", "--define", RunnerBundle.message("maven.options.description.D", new Object[0])));
        ourAllOptions.add(new Option("-e", "--errors", RunnerBundle.message("maven.options.description.e", new Object[0])));
        ourAllOptions.add(new Option("-emp", "--encrypt-master-password", RunnerBundle.message("maven.options.description.emp", new Object[0])));
        ourAllOptions.add(new Option("-ep", "--encrypt-password", RunnerBundle.message("maven.options.description.ep", new Object[0])));
        ourAllOptions.add(new Option("-f", "--file", RunnerBundle.message("maven.options.description.f", new Object[0])));
        ourAllOptions.add(new Option("-fae", "--fail-at-end", RunnerBundle.message("maven.options.description.fae", new Object[0])));
        ourAllOptions.add(new Option("-ff", "--fail-fast", RunnerBundle.message("maven.options.description.ff", new Object[0])));
        ourAllOptions.add(new Option("-fn", "--fail-never", RunnerBundle.message("maven.options.description.fn", new Object[0])));
        ourAllOptions.add(new Option("-gs", "--global-settings", RunnerBundle.message("maven.options.description.gs", new Object[0])));
        ourAllOptions.add(new Option("-gt", "--global-toolchains", RunnerBundle.message("maven.options.description.gt", new Object[0])));
        ourAllOptions.add(new Option("-h", "--help", RunnerBundle.message("maven.options.description.h", new Object[0])));
        ourAllOptions.add(new Option("-l", "--log-file", RunnerBundle.message("maven.options.description.l", new Object[0])));
        ourAllOptions.add(new Option("-llr", "--legacy-local-repository", RunnerBundle.message("maven.options.description.llr", new Object[0])));
        ourAllOptions.add(new Option("-N", "--non-recursive", RunnerBundle.message("maven.options.description.N", new Object[0])));
        ourAllOptions.add(new Option("-npr", "--no-plugin-registry", RunnerBundle.message("maven.options.description.npr", new Object[0])));
        ourAllOptions.add(new Option("-npu", "--no-plugin-updates", RunnerBundle.message("maven.options.description.npu", new Object[0])));
        ourAllOptions.add(new Option("-nsu", "--no-snapshot-updates", RunnerBundle.message("maven.options.description.nsu", new Object[0])));
        ourAllOptions.add(new Option("-o", "--offline", RunnerBundle.message("maven.options.description.o", new Object[0])));
        ourAllOptions.add(new Option("-P", "--activate-profiles", RunnerBundle.message("maven.options.description.P", new Object[0])));
        ourAllOptions.add(new Option("-pl", "--projects", RunnerBundle.message("maven.options.description.pl", new Object[0])));
        ourAllOptions.add(new Option("-q", "--quiet", RunnerBundle.message("maven.options.description.q", new Object[0])));
        ourAllOptions.add(new Option("-rf", "--resume-from", RunnerBundle.message("maven.options.description.rf", new Object[0])));
        ourAllOptions.add(new Option("-s", "--settings", RunnerBundle.message("maven.options.description.s", new Object[0])));
        ourAllOptions.add(new Option("-t", "--toolchains", RunnerBundle.message("maven.options.description.t", new Object[0])));
        ourAllOptions.add(new Option("-T", "--threads", RunnerBundle.message("maven.options.description.T", new Object[0])));
        ourAllOptions.add(new Option("-U", "--update-snapshots", RunnerBundle.message("maven.options.description.U", new Object[0])));
        ourAllOptions.add(new Option("-up", "--update-plugins", RunnerBundle.message("maven.options.description.up", new Object[0])));
        ourAllOptions.add(new Option("-v", "--version", RunnerBundle.message("maven.options.description.v", new Object[0])));
        ourAllOptions.add(new Option("-V", "--show-version", RunnerBundle.message("maven.options.description.V", new Object[0])));
        ourAllOptions.add(new Option("-X", "--debug", RunnerBundle.message("maven.options.description.X", new Object[0])));
        ourOptionsIndexMap = new HashMap<String, Option>();
        for (Option option : ourAllOptions) {
            ourOptionsIndexMap.put(option.getName(false), option);
            ourOptionsIndexMap.put(option.getName(true), option);
        }
    }

    public static class Option {
        private final String myName;
        private final String myLongName;
        private final String myDescription;

        public Option(@NonNls String name, @NonNls String longName, @Nls(capitalization=Nls.Capitalization.Sentence) String description) {
            this.myName = name;
            this.myLongName = longName;
            this.myDescription = description;
        }

        public String getName(boolean longName) {
            return longName ? this.myLongName : this.myName;
        }

        public String getDescription() {
            return this.myDescription;
        }
    }
}

