/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerKt;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.uploader.EventLogUploadException;
import com.intellij.internal.statistic.service.fus.EventLogMetadataUpdateError;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EventLogSystemLogger {
    private static final String GROUP = "event.log";

    public static void logMetadataLoad(@NotNull String recorderId, @Nullable String version) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(0);
        }
        FeatureUsageData data = new FeatureUsageData().addVersionByString(version);
        EventLogSystemLogger.logEvent(recorderId, "metadata.loaded", data);
    }

    public static void logMetadataUpdated(@NotNull String recorderId, @Nullable String version) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(1);
        }
        FeatureUsageData data = new FeatureUsageData().addVersionByString(version);
        EventLogSystemLogger.logEvent(recorderId, "metadata.updated", data);
    }

    public static void logMetadataErrorOnLoad(@NotNull String recorderId, @NotNull EventLogMetadataUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(2);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(3);
        }
        EventLogSystemLogger.logMetadataError(recorderId, "metadata.load.failed", error);
    }

    public static void logMetadataErrorOnUpdate(@NotNull String recorderId, @NotNull EventLogMetadataUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(4);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(5);
        }
        EventLogSystemLogger.logMetadataError(recorderId, "metadata.update.failed", error);
    }

    private static void logMetadataError(@NotNull String recorderId, @NotNull String eventId, @NotNull EventLogMetadataUpdateError error) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(6);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(7);
        }
        if (error == null) {
            EventLogSystemLogger.$$$reportNull$$$0(8);
        }
        FeatureUsageData data = new FeatureUsageData().addData("stage", error.getUpdateStage().name()).addData("error", error.getErrorType());
        int code = error.getErrorCode();
        if (code != -1) {
            data.addData("code", code);
        }
        EventLogSystemLogger.logEvent(recorderId, eventId, data);
    }

    public static void logFilesSend(@NotNull String recorderId, int total, int succeed, int failed, boolean external, @NotNull List<String> successfullySentFiles) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(9);
        }
        if (successfullySentFiles == null) {
            EventLogSystemLogger.$$$reportNull$$$0(10);
        }
        FeatureUsageData data = new FeatureUsageData().addData("total", total).addData("send", succeed + failed).addData("failed", failed).addData("external", external).addData("paths", ContainerUtil.map(successfullySentFiles, path -> EventLogConfiguration.INSTANCE.anonymize((String)path)));
        EventLogSystemLogger.logEvent(recorderId, "logs.send", data);
    }

    public static void logStartingExternalSend(@NotNull String recorderId, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(11);
        }
        FeatureUsageData data = new FeatureUsageData().addData("send_ts", time);
        EventLogSystemLogger.logEvent(recorderId, "external.send.started", data);
    }

    public static void logFinishedExternalSend(@NotNull String recorderId, @Nullable String error, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(12);
        }
        boolean succeed = StringUtil.isEmpty((String)error);
        FeatureUsageData data = new FeatureUsageData().addData("succeed", succeed).addData("send_ts", time);
        if (!succeed) {
            data.addData("error", error);
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.finished", data);
    }

    public static void logCreatingExternalSendCommand(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(13);
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.command.creation.started");
    }

    public static void logFinishedCreatingExternalSendCommand(@NotNull String recorderId, @Nullable EventLogUploadException.EventLogUploadErrorType errorType) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(14);
        }
        boolean succeed = errorType == null;
        FeatureUsageData data = new FeatureUsageData().addData("succeed", succeed);
        if (!succeed) {
            data.addData("error", errorType.name());
        }
        EventLogSystemLogger.logEvent(recorderId, "external.send.command.creation.finished", data);
    }

    public static void logSystemError(@NotNull String recorderId, @NotNull String eventId, @NotNull String errorClass, long time) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(15);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(16);
        }
        if (errorClass == null) {
            EventLogSystemLogger.$$$reportNull$$$0(17);
        }
        FeatureUsageData data = new FeatureUsageData().addData("error", errorClass);
        if (time != -1L) {
            data.addData("error_ts", time);
        }
        EventLogSystemLogger.logEvent(recorderId, eventId, data);
    }

    private static void logEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull FeatureUsageData data) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(18);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(19);
        }
        if (data == null) {
            EventLogSystemLogger.$$$reportNull$$$0(20);
        }
        StatisticsEventLoggerProvider provider = StatisticsEventLoggerKt.getEventLogProvider(recorderId);
        provider.getLogger().logAsync(new EventLogGroup(GROUP, provider.getVersion()), eventId, data.build(), false);
    }

    private static void logEvent(@NotNull String recorderId, @NotNull String eventId) {
        if (recorderId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(21);
        }
        if (eventId == null) {
            EventLogSystemLogger.$$$reportNull$$$0(22);
        }
        StatisticsEventLoggerProvider provider = StatisticsEventLoggerKt.getEventLogProvider(recorderId);
        provider.getLogger().logAsync(new EventLogGroup(GROUP, provider.getVersion()), eventId, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successfullySentFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogSystemLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataLoad";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataUpdated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataErrorOnLoad";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataErrorOnUpdate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "logMetadataError";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "logFilesSend";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "logStartingExternalSend";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinishedExternalSend";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "logCreatingExternalSendCommand";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinishedCreatingExternalSendCommand";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "logSystemError";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "logEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

