/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.statistics.GradleActionsUsagesCollector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PasteMvnDependencyPreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        return null;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        if (this.isApplicable(file) && PasteMvnDependencyPreProcessor.isMvnDependency(text)) {
            GradleActionsUsagesCollector.trigger(project, GradleActionsUsagesCollector.ActionID.PasteMvnDependency);
            String string = this.toGradleDependency(text);
            if (string == null) {
                PasteMvnDependencyPreProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected boolean isApplicable(PsiFile file) {
        return file.getName().endsWith(".gradle");
    }

    @NotNull
    protected String formatGradleDependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @NotNull String scope, @NotNull String classifier) {
        if (groupId == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(2);
        }
        if (artifactId == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(3);
        }
        if (version == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(5);
        }
        if (classifier == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(6);
        }
        String gradleClassifier = classifier.isEmpty() ? "" : ":" + classifier;
        String string = scope + "'" + groupId + ":" + artifactId + ":" + version + gradleClassifier + "'";
        if (string == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private String toGradleDependency(String mavenDependency) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            try {
                Document document = builder.parse(new InputSource(new StringReader(mavenDependency)));
                String gradleDependency = this.extractGradleDependency(document);
                return gradleDependency != null ? gradleDependency : mavenDependency;
            }
            catch (IOException | SAXException exception) {
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return mavenDependency;
    }

    @Nullable
    private String extractGradleDependency(Document document) {
        String groupId = PasteMvnDependencyPreProcessor.getGroupId(document);
        String artifactId = PasteMvnDependencyPreProcessor.getArtifactId(document);
        String version = PasteMvnDependencyPreProcessor.getVersion(document);
        String scope = PasteMvnDependencyPreProcessor.getScope(document);
        String classifier = PasteMvnDependencyPreProcessor.getClassifier(document);
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) {
            return null;
        }
        return this.formatGradleDependency(groupId, artifactId, version, scope, classifier);
    }

    @NotNull
    private static String getScope(@NotNull Document document) {
        String scope;
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(8);
        }
        switch (scope = PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("scope"))) {
            case "test": {
                scope = "testCompile ";
                break;
            }
            case "provided": {
                scope = "compileOnly ";
                break;
            }
            case "compile": 
            case "runtime": {
                scope = scope + " ";
                break;
            }
            default: {
                scope = "compile ";
            }
        }
        String string = scope;
        if (string == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static String getVersion(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(10);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("version"));
    }

    private static String getArtifactId(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(11);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("artifactId"));
    }

    private static String getGroupId(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(12);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("groupId"));
    }

    private static String getClassifier(@NotNull Document document) {
        if (document == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(13);
        }
        return PasteMvnDependencyPreProcessor.firstOrEmpty(document.getElementsByTagName("classifier"));
    }

    private static String firstOrEmpty(@NotNull NodeList list) {
        Node first;
        if (list == null) {
            PasteMvnDependencyPreProcessor.$$$reportNull$$$0(14);
        }
        return (first = list.item(0)) != null ? first.getTextContent() : "";
    }

    private static boolean isMvnDependency(String text) {
        String trimmed = text.trim();
        return trimmed.startsWith("<dependency>") && trimmed.endsWith("</dependency>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classifier";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/action/PasteMvnDependencyPreProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatGradleDependency";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatGradleDependency";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGroupId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClassifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "firstOrEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

