/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.CommonBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.config.GradleSettingsListenerAdapter;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleUnlinkedProjectProcessor;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.gradle.common"})
public final class GradleUnlinkedProjectProcessor
implements StartupActivity.DumbAware {
    private static final String SHOW_UNLINKED_GRADLE_POPUP = "show.unlinked.gradle.project.popup";
    private static final Logger LOG;
    public static final Companion Companion;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (GradleUnlinkedProjectProcessor.Companion.isEnabledNotifications(project)) {
            GradleUnlinkedProjectProcessor.Companion.showNotification(project);
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GradleUnlinkedProjectProcessor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Gradl\u2026ectProcessor::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleUnlinkedProjectProcessor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SHOW_UNLINKED_GRADLE_POPUP", "", "disableNotifications", "", "project", "Lcom/intellij/openapi/project/Project;", "enableNotifications", "isEnabledNotifications", "", "showNotification", "intellij.gradle.common"})
    public static final class Companion {
        private final void showNotification(Project project) {
            GradleSettings gradleSettings = GradleSettings.getInstance(project);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
            if (!gradleSettings.getLinkedProjectsSettings().isEmpty()) {
                return;
            }
            if ((Boolean)project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE) {
                return;
            }
            String string = project.getBasePath();
            if (string == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.basePath ?: return");
            String externalProjectPath = string;
            String gradleGroovyDslFile = externalProjectPath + "/" + "build.gradle";
            String kotlinDslGradleFile = externalProjectPath + "/" + "build.gradle.kts";
            if (FileUtil.findFirstThatExist((String[])new String[]{gradleGroovyDslFile, kotlinDslGradleFile}) == null) {
                return;
            }
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkExpressionValueIsNotNull((Object)disposable, (String)"Disposer.newDisposable()");
            Disposable subscription = disposable;
            Object[] objectArray = new Object[1];
            ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
            objectArray[0] = applicationNamesInfo.getFullProductName();
            String string2 = GradleBundle.message("gradle.notifications.unlinked.project.found.title", objectArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GradleBundle.message(\"gr\u2026stance().fullProductName)");
            Notification notification2 = GradleNotification.NOTIFICATION_GROUP.createNotification(string2, NotificationType.INFORMATION);
            Function0 notificationExpire2 = (Function0)new Function0<Unit>(notification2, subscription){
                final /* synthetic */ Notification $notification;
                final /* synthetic */ Disposable $subscription;

                public final void invoke() {
                    this.$notification.expire();
                    GradleUnlinkedProjectProcessor.access$getLOG$cp().debug("Unlinked project notification expired");
                    Disposer.dispose((Disposable)this.$subscription);
                }
                {
                    this.$notification = notification2;
                    this.$subscription = disposable;
                    super(0);
                }
            };
            notification2.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.notifications.unlinked.project.found.import", new Object[0]), (Runnable)new Runnable(notificationExpire2, externalProjectPath, project){
                final /* synthetic */ Function0 $notificationExpire;
                final /* synthetic */ String $externalProjectPath;
                final /* synthetic */ Project $project;

                public final void run() {
                    this.$notificationExpire.invoke();
                    GradleProjectImportUtil.linkAndRefreshGradleProject(this.$externalProjectPath, this.$project);
                }
                {
                    this.$notificationExpire = function0;
                    this.$externalProjectPath = string;
                    this.$project = project;
                }
            }));
            notification2.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.notifications.unlinked.project.found.skip", new Object[0]), (Runnable)new Runnable(notificationExpire2, project){
                final /* synthetic */ Function0 $notificationExpire;
                final /* synthetic */ Project $project;

                public final void run() {
                    this.$notificationExpire.invoke();
                    org.jetbrains.plugins.gradle.startup.GradleUnlinkedProjectProcessor$Companion.access$disableNotifications(GradleUnlinkedProjectProcessor.Companion, this.$project);
                }
                {
                    this.$notificationExpire = function0;
                    this.$project = project;
                }
            }));
            notification2.setContextHelpAction((AnAction)new DumbAwareAction(CommonBundle.getHelpButtonText(), GradleBundle.message("gradle.notifications.unlinked.project.found.help", new Object[0]), null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                }
            });
            GradleSettingsListenerAdapter settingsListener2 = new GradleSettingsListenerAdapter(notificationExpire2){
                final /* synthetic */ Function0 $notificationExpire;

                public void onProjectsLinked(@NotNull Collection<GradleProjectSettings> settings2) {
                    Intrinsics.checkParameterIsNotNull(settings2, (String)"settings");
                    this.$notificationExpire.invoke();
                }
                {
                    this.$notificationExpire = $captured_local_variable$0;
                }
            };
            Disposer.register((Disposable)((Disposable)project), (Disposable)subscription);
            ExternalSystemApiUtil.subscribe((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (ExternalSystemSettingsListener)settingsListener2, (Disposable)subscription);
            notification2.notify(project);
        }

        private final boolean isEnabledNotifications(Project project) {
            return PropertiesComponent.getInstance((Project)project).getBoolean(GradleUnlinkedProjectProcessor.SHOW_UNLINKED_GRADLE_POPUP, true);
        }

        private final void disableNotifications(Project project) {
            PropertiesComponent.getInstance((Project)project).setValue(GradleUnlinkedProjectProcessor.SHOW_UNLINKED_GRADLE_POPUP, false, true);
        }

        public final void enableNotifications(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PropertiesComponent.getInstance((Project)project).setValue(GradleUnlinkedProjectProcessor.SHOW_UNLINKED_GRADLE_POPUP, true, false);
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$disableNotifications(Companion $this, Project project) {
            $this.disableNotifications(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

