/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;

public class JpsGlobalElementSaver {
    private static final JpsGlobalExtensionSerializer[] SERIALIZERS = new JpsGlobalExtensionSerializer[]{new JpsGlobalLoader.PathVariablesSerializer(), new JpsGlobalLoader.GlobalLibrariesSerializer(), new JpsGlobalLoader.SdkTableSerializer()};
    private final JpsGlobal myGlobal;

    public JpsGlobalElementSaver(JpsGlobal global) {
        this.myGlobal = global;
    }

    public static void saveGlobalElement(JpsGlobal global, String optionsPath) throws IOException {
        File optionsDir = new File(FileUtil.toCanonicalPath((String)optionsPath));
        new JpsGlobalElementSaver(global).save(optionsDir);
    }

    private void save(File optionsDir) throws IOException {
        for (JpsGlobalExtensionSerializer serializer : SERIALIZERS) {
            this.saveGlobalComponents(serializer, optionsDir);
        }
    }

    private void saveGlobalComponents(JpsGlobalExtensionSerializer serializer, File optionsDir) throws IOException {
        String fileName = serializer.getConfigFileName();
        File configFile = new File(optionsDir, fileName != null ? fileName : "other.xml");
        Element rootElement = JpsGlobalElementSaver.loadOrCreateRootElement(configFile);
        serializer.saveExtension(this.myGlobal, JDomSerializationUtil.findOrCreateComponentElement(rootElement, serializer.getComponentName()));
        JDOMUtil.write((Element)rootElement, (File)configFile);
    }

    private static Element loadOrCreateRootElement(File configFile) {
        if (!configFile.exists()) {
            return new Element("application");
        }
        try {
            return JDOMUtil.load((File)configFile);
        }
        catch (IOException | JDOMException e) {
            throw new RuntimeException(e);
        }
    }
}

