/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure;

import io.ktor.network.sockets.ServerSocket;
import io.ktor.network.sockets.Socket;
import java.io.Closeable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.experimental.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteReadChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ByteWriteChannelWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.DefaultAuthorizableClient;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server$WhenMappings;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ServerBase;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.ServerSocketWrapper;
import org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.StreamWrappersKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\bf\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002:\b*+,-./01J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u001f\u001a\u00020\u00162\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000!2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0015H\u0016J)\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u001eH\u0016R.\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000b\u0010\n\u001a\u00020\u000b8BX\u0082\u0004R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server;", "T", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "clients", "Ljava/util/HashMap;", "Lio/ktor/network/sockets/Socket;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ClientInfo;", "Lkotlin/collections/HashMap;", "getClients", "()Ljava/util/HashMap;", "log", "Ljava/util/logging/Logger;", "serverPort", "", "getServerPort", "()I", "serverSocketWithPort", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "getServerSocketWithPort", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerSocketWrapper;", "attachClient", "Lkotlinx/coroutines/Deferred;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$State;", "client", "checkClientCanReadFile", "", "clientInputChannel", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dealWithClient", "", "processMessage", "msg", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "runServer", "serverHandshake", "input", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;Ljava/util/logging/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shutdownClient", "shutdownServer", "AnyMessage", "ClientInfo", "EndConnectionMessage", "KeepAliveAcknowledgement", "KeepAliveMessage", "Message", "ServerDownMessage", "State", "daemon-common-new"})
public interface Server<T extends ServerBase>
extends ServerBase {
    @NotNull
    public ServerSocketWrapper getServerSocketWithPort();

    public int getServerPort();

    @NotNull
    public State processMessage(@NotNull AnyMessage<? super T> var1, @NotNull ByteWriteChannelWrapper var2);

    @NotNull
    public Deferred<State> attachClient(@NotNull Socket var1);

    @NotNull
    public HashMap<Socket, ClientInfo> getClients();

    @NotNull
    public Deferred<Unit> runServer();

    public void shutdownServer();

    @Nullable
    public Object checkClientCanReadFile(@NotNull ByteReadChannelWrapper var1, @NotNull Continuation<? super Boolean> var2);

    @Nullable
    public Object serverHandshake(@NotNull ByteReadChannelWrapper var1, @NotNull ByteWriteChannelWrapper var2, @NotNull Logger var3, @NotNull Continuation<? super Boolean> var4);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$State;", "", "(Ljava/lang/String;I)V", "WORKING", "CLOSED", "ERROR", "DOWNING", "UNVERIFIED", "daemon-common-new"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State WORKING;
        public static final /* enum */ State CLOSED;
        public static final /* enum */ State ERROR;
        public static final /* enum */ State DOWNING;
        public static final /* enum */ State UNVERIFIED;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[5];
            State[] stateArray2 = stateArray;
            stateArray[0] = WORKING = new State();
            stateArray[1] = CLOSED = new State();
            stateArray[2] = ERROR = new State();
            stateArray[3] = DOWNING = new State();
            stateArray[4] = UNVERIFIED = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00020\u0006R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Ljava/io/Serializable;", "()V", "messageId", "", "getMessageId", "()Ljava/lang/Integer;", "setMessageId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "withId", "id", "daemon-common-new"})
    public static abstract class AnyMessage<ServerType extends ServerBase>
    implements Serializable {
        @Nullable
        private Integer messageId;

        @Nullable
        public final Integer getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(@Nullable Integer n) {
            this.messageId = n;
        }

        @NotNull
        public final AnyMessage<ServerType> withId(int id) {
            this.messageId = id;
            return this;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00028\u00012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ/\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00012\u0014\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00070\u000eH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$Message;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "process", "Lkotlinx/coroutines/Deferred;", "", "server", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;)Lkotlinx/coroutines/Deferred;", "processImpl", "sendReply", "Lkotlin/Function1;", "", "(Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "daemon-common-new"})
    public static abstract class Message<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
        @NotNull
        public final Deferred<Unit> process(@NotNull ServerType server, @NotNull ByteWriteChannelWrapper output) {
            Intrinsics.checkParameterIsNotNull(server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, server, output, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Message this$0;
                final /* synthetic */ ServerBase $server;
                final /* synthetic */ ByteWriteChannelWrapper $output;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$async = this.p$;
                            ClientUtilsKt.getLog().fine(this.$server + " starts processing " + this.this$0);
                            this.L$0 = $this$async;
                            this.label = 1;
                            Object object2 = this.this$0.processImpl(this.$server, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){
                                final /* synthetic */ process.1 this$0;

                                public final void invoke(@Nullable Object it) {
                                    ClientUtilsKt.getLog().fine(this.this$0.$server + " finished processing " + this.this$0.this$0 + ", sending output");
                                    BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, it, null){
                                        private CoroutineScope p$;
                                        Object L$0;
                                        int label;
                                        final /* synthetic */ Message.process.1 this$0;
                                        final /* synthetic */ Object $it;

                                        /*
                                         * Unable to fully structure code
                                         */
                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    $this$async = this.p$;
                                                    ClientUtilsKt.getLog().fine(this.this$0.this$0.$server + " starts sending " + this.this$0.this$0.this$0 + " to output");
                                                    v0 = this.this$0.this$0.this$0.getMessageId();
                                                    this.L$0 = $this$async;
                                                    this.label = 1;
                                                    v1 = this.this$0.this$0.$output.writeObject(new DefaultAuthorizableClient.MessageReply<Object>(v0 != null ? v0 : -1, this.$it), (Continuation<? super Unit>)this);
                                                    if (v1 == var3_2) {
                                                        return var3_2;
                                                    }
                                                    ** GOTO lbl18
                                                }
                                                case 1: {
                                                    $this$async = (CoroutineScope)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl18:
                                                    // 2 sources

                                                    ClientUtilsKt.getLog().fine(this.this$0.this$0.$server + " finished sending " + this.this$0.this$0.this$0 + " to output");
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$it = object;
                                            super(2, continuation);
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                            return function2;
                                        }

                                        public final Object invoke(Object object, Object object2) {
                                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (int)3, null);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }), (Continuation<Unit>)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$async = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = message;
                    this.$server = serverBase;
                    this.$output = byteWriteChannelWrapper;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Nullable
        public abstract Object processImpl(@NotNull ServerType var1, @NotNull Function1<Object, Unit> var2, @NotNull Continuation<? super Unit> var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$EndConnectionMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class EndConnectionMessage<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$KeepAliveAcknowledgement;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class KeepAliveAcknowledgement<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$KeepAliveMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class KeepAliveMessage<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ServerDownMessage;", "ServerType", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ServerBase;", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$AnyMessage;", "()V", "daemon-common-new"})
    public static final class ServerDownMessage<ServerType extends ServerBase>
    extends AnyMessage<ServerType> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/Server$ClientInfo;", "", "socket", "Lio/ktor/network/sockets/Socket;", "input", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "output", "Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "(Lio/ktor/network/sockets/Socket;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;)V", "getInput", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteReadChannelWrapper;", "getOutput", "()Lorg/jetbrains/kotlin/daemon/common/experimental/socketInfrastructure/ByteWriteChannelWrapper;", "getSocket", "()Lio/ktor/network/sockets/Socket;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "daemon-common-new"})
    public static final class ClientInfo {
        @NotNull
        private final Socket socket;
        @NotNull
        private final ByteReadChannelWrapper input;
        @NotNull
        private final ByteWriteChannelWrapper output;

        @NotNull
        public final Socket getSocket() {
            return this.socket;
        }

        @NotNull
        public final ByteReadChannelWrapper getInput() {
            return this.input;
        }

        @NotNull
        public final ByteWriteChannelWrapper getOutput() {
            return this.output;
        }

        public ClientInfo(@NotNull Socket socket, @NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output) {
            Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            this.socket = socket;
            this.input = input;
            this.output = output;
        }

        @NotNull
        public final Socket component1() {
            return this.socket;
        }

        @NotNull
        public final ByteReadChannelWrapper component2() {
            return this.input;
        }

        @NotNull
        public final ByteWriteChannelWrapper component3() {
            return this.output;
        }

        @NotNull
        public final ClientInfo copy(@NotNull Socket socket, @NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output) {
            Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            return new ClientInfo(socket, input, output);
        }

        public static /* synthetic */ ClientInfo copy$default(ClientInfo clientInfo, Socket socket, ByteReadChannelWrapper byteReadChannelWrapper, ByteWriteChannelWrapper byteWriteChannelWrapper, int n, Object object) {
            if ((n & 1) != 0) {
                socket = clientInfo.socket;
            }
            if ((n & 2) != 0) {
                byteReadChannelWrapper = clientInfo.input;
            }
            if ((n & 4) != 0) {
                byteWriteChannelWrapper = clientInfo.output;
            }
            return clientInfo.copy(socket, byteReadChannelWrapper, byteWriteChannelWrapper);
        }

        @NotNull
        public String toString() {
            return "ClientInfo(socket=" + this.socket + ", input=" + this.input + ", output=" + this.output + ")";
        }

        public int hashCode() {
            Socket socket = this.socket;
            ByteReadChannelWrapper byteReadChannelWrapper = this.input;
            ByteWriteChannelWrapper byteWriteChannelWrapper = this.output;
            return ((socket != null ? socket.hashCode() : 0) * 31 + (byteReadChannelWrapper != null ? byteReadChannelWrapper.hashCode() : 0)) * 31 + (byteWriteChannelWrapper != null ? byteWriteChannelWrapper.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientInfo)) break block3;
                    ClientInfo clientInfo = (ClientInfo)object;
                    if (!Intrinsics.areEqual((Object)this.socket, (Object)clientInfo.socket) || !Intrinsics.areEqual((Object)this.input, (Object)clientInfo.input) || !Intrinsics.areEqual((Object)this.output, (Object)clientInfo.output)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static <T extends ServerBase> int getServerPort(Server<? extends T> $this) {
            return $this.getServerSocketWithPort().getPort();
        }

        private static <T extends ServerBase> Logger getLog(Server<? extends T> $this) {
            Logger logger = Logger.getLogger("default server(" + $this.getServerPort() + ')');
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getLogger(\"default server($serverPort)\")");
            return logger;
        }

        @NotNull
        public static <T extends ServerBase> State processMessage(Server<? extends T> $this, @NotNull AnyMessage<? super T> msg, @NotNull ByteWriteChannelWrapper output) {
            State state;
            Intrinsics.checkParameterIsNotNull(msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            AnyMessage<? super T> anyMessage = msg;
            if (anyMessage instanceof Message) {
                State state2 = State.WORKING;
                boolean bl = false;
                boolean bl2 = false;
                State it = state2;
                boolean bl3 = false;
                Server<? extends T> server = $this;
                if (server == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                ((Message)msg).process((ServerBase)server, output);
                state = state2;
            } else {
                state = anyMessage instanceof EndConnectionMessage ? State.CLOSED : (anyMessage instanceof ServerDownMessage ? State.CLOSED : State.ERROR);
            }
            return state;
        }

        @NotNull
        public static <T extends ServerBase> Deferred<State> attachClient(Server<? extends T> $this, @NotNull Socket client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super State>, Object>($this, client, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                int label;
                final /* synthetic */ Server this$0;
                final /* synthetic */ Socket $client;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    block21: {
                        var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$async = this.p$;
                                var5_4 = StreamWrappersKt.openIO(this.$client, DefaultImpls.access$getLog$p(this.this$0));
                                var3_5 = var5_4.component1();
                                output = var5_4.component2();
                                this.L$0 = $this$async;
                                this.L$1 = input;
                                this.L$2 = output;
                                this.label = 1;
                                v0 = this.this$0.serverHandshake(input, output, DefaultImpls.access$getLog$p(this.this$0), (Continuation<Boolean>)this);
                                if (v0 == var14_2) {
                                    return var14_2;
                                }
                                ** GOTO lbl23
                            }
                            case 1: {
                                output = (ByteWriteChannelWrapper)this.L$2;
                                input = (ByteReadChannelWrapper)this.L$1;
                                $this$async = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                if (!((Boolean)v0).booleanValue()) {
                                    return State.UNVERIFIED;
                                }
                                this.L$0 = $this$async;
                                this.L$1 = input;
                                this.L$2 = output;
                                this.label = 2;
                                v1 = this.this$0.checkClientCanReadFile(input, (Continuation<Boolean>)this);
                                if (v1 == var14_2) {
                                    return var14_2;
                                }
                                ** GOTO lbl39
                            }
                            case 2: {
                                output = (ByteWriteChannelWrapper)this.L$2;
                                input = (ByteReadChannelWrapper)this.L$1;
                                $this$async = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl39:
                                // 2 sources

                                if (!((Boolean)v1).booleanValue()) {
                                    return State.UNVERIFIED;
                                }
                                ((Map)this.this$0.getClients()).put(this.$client, new ClientInfo(this.$client, input, output));
                                finalState = State.WORKING;
                                keepAliveAcknowledgement = new KeepAliveAcknowledgement<ServerType>();
lbl46:
                                // 4 sources

                                while (true) {
                                    this.L$0 = $this$async;
                                    this.L$1 = input;
                                    this.L$2 = output;
                                    this.L$3 = finalState;
                                    this.L$4 = keepAliveAcknowledgement;
                                    this.label = 3;
                                    v2 = input.nextObject((Continuation<Object>)this);
                                    if (v2 == var14_2) {
                                        return var14_2;
                                    }
                                    ** GOTO lbl65
                                    break;
                                }
                            }
                            case 3: {
                                keepAliveAcknowledgement = (KeepAliveAcknowledgement<ServerType>)this.L$4;
                                finalState = (State)this.L$3;
                                output = (ByteWriteChannelWrapper)this.L$2;
                                input = (ByteReadChannelWrapper)this.L$1;
                                $this$async = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl65:
                                // 2 sources

                                if (!((var8_9 = (message = v2)) instanceof ServerDownMessage)) ** GOTO lbl68
                                DefaultImpls.access$shutdownClient(this.this$0, this.$client);
                                break block21;
lbl68:
                                // 1 sources

                                if (!(var8_9 instanceof KeepAliveMessage)) break;
                                var9_10 = State.WORKING;
                                var10_11 = false;
                                var11_12 = false;
                                it = var9_10;
                                $i$a$-also-Server$attachClient$1$1 = false;
                                v3 = ((KeepAliveMessage)message).getMessageId();
                                if (v3 == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.L$0 = $this$async;
                                this.L$1 = input;
                                this.L$2 = output;
                                this.L$3 = finalState;
                                this.L$4 = keepAliveAcknowledgement;
                                this.L$5 = message;
                                this.L$6 = var9_10;
                                this.L$7 = it;
                                this.label = 4;
                                v4 = output.writeObject(new DefaultAuthorizableClient.MessageReply<KeepAliveAcknowledgement<ServerType>>(v3, keepAliveAcknowledgement), (Continuation<? super Unit>)this);
                                if (v4 != var14_2) ** GOTO lbl46
                                return var14_2;
                            }
                            case 4: {
                                it = (State)this.L$7;
                                var9_10 = (State)this.L$6;
                                message = this.L$5;
                                keepAliveAcknowledgement = (KeepAliveAcknowledgement)this.L$4;
                                finalState = (State)this.L$3;
                                output = (ByteWriteChannelWrapper)this.L$2;
                                input = (ByteReadChannelWrapper)this.L$1;
                                $this$async = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
                                ** GOTO lbl46
                            }
                        }
                        if (!(var8_9 instanceof AnyMessage)) {
                            finalState = State.ERROR;
                        } else {
                            v5 = message;
                            if (v5 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.experimental.socketInfrastructure.Server.AnyMessage<T>");
                            }
                            state = this.this$0.processMessage((AnyMessage)v5, output);
                            switch (Server$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                                case 1: {
                                    ** continue;
                                }
                                case 2: {
                                    finalState = State.ERROR;
                                    break;
                                }
                                default: {
                                    finalState = state;
                                    break;
                                }
                            }
                        }
                    }
                    return finalState;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = server;
                    this.$client = socket;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super State>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private static <T extends ServerBase> Deferred<Unit> dealWithClient(Server<? extends T> $this, Socket client) {
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this, client, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Server this$0;
                final /* synthetic */ Socket $client;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$async = this.p$;
                            this.L$0 = $this$async;
                            this.label = 1;
                            v0 = this.this$0.attachClient(this.$client).await((Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$async = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            state = (State)v0;
                            switch (Server$WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                                case 1: 
                                case 2: {
                                    DefaultImpls.access$shutdownClient(this.this$0, this.$client);
                                    break;
                                }
                                case 3: {
                                    this.this$0.shutdownServer();
                                    break;
                                }
                                default: {
                                    DefaultImpls.access$shutdownClient(this.this$0, this.$client);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = server;
                    this.$client = socket;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @NotNull
        public static <T extends ServerBase> Deferred<Unit> runServer(Server<? extends T> $this) {
            ServerSocket serverSocket = $this.getServerSocketWithPort().getSocket();
            return BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this, serverSocket, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int label;
                final /* synthetic */ Server this$0;
                final /* synthetic */ ServerSocket $serverSocket;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $this$async = this.p$;
                            var3_4 = (Closeable)this.$serverSocket;
                            var4_5 = false;
                            var5_6 = null;
                            try {
                                it = (ServerSocket)var3_4;
                                $i$a$-use-Server$runServer$1$1 = false;
                            }
                            catch (Throwable var6_8) {
                                var5_6 = var6_8;
                                throw var6_8;
                            }
                            catch (Throwable var6_9) {
                                CloseableKt.closeFinally((Closeable)var3_4, (Throwable)var5_6);
                                throw var6_9;
                            }
lbl21:
                            // 2 sources

                            while (true) {
                                var8_11 = this.this$0;
                                this.L$0 = $this$async;
                                this.L$1 = var3_4;
                                this.L$2 = var5_6;
                                this.L$3 = it;
                                this.L$4 = var8_11;
                                this.label = 1;
                                v0 = this.$serverSocket.accept((Continuation)this);
                                if (v0 == var10_2) {
                                    return var10_2;
                                }
                                ** GOTO lbl42
                                break;
                            }
                        }
                        case 1: {
                            var8_11 = (Server)this.L$4;
                            it = (ServerSocket)this.L$3;
                            var5_6 = (Throwable)this.L$2;
                            var3_4 = (Closeable)this.L$1;
                            $this$async = (CoroutineScope)this.L$0;
                            {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl42:
                                // 2 sources

                                var9_12 = v0;
                                DefaultImpls.access$dealWithClient(var8_11, (Socket)var9_12);
                                ** continue;
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = server;
                    this.$serverSocket = serverSocket;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static <T extends ServerBase> void shutdownServer(Server<? extends T> $this) {
            $this.getClients().forEach(shutdownServer.1.INSTANCE);
            $this.getClients().clear();
            $this.getServerSocketWithPort().getSocket().close();
        }

        private static <T extends ServerBase> void shutdownClient(Server<? extends T> $this, Socket client) {
            $this.getClients().remove(client);
            client.close();
        }

        @Nullable
        public static <T extends ServerBase> Object checkClientCanReadFile(Server<? extends T> $this, @NotNull ByteReadChannelWrapper clientInputChannel, @NotNull Continuation<? super Boolean> $completion) {
            return Boxing.boxBoolean((boolean)true);
        }

        @Nullable
        public static <T extends ServerBase> Object serverHandshake(Server<? extends T> $this, @NotNull ByteReadChannelWrapper input, @NotNull ByteWriteChannelWrapper output, @NotNull Logger log, @NotNull Continuation<? super Boolean> $completion) {
            return Boxing.boxBoolean((boolean)true);
        }

        public static /* synthetic */ Logger access$getLog$p(Server $this) {
            return DefaultImpls.getLog($this);
        }

        public static /* synthetic */ void access$shutdownClient(Server $this, Socket client) {
            DefaultImpls.shutdownClient($this, client);
        }

        public static /* synthetic */ Deferred access$dealWithClient(Server $this, Socket client) {
            return DefaultImpls.dealWithClient($this, client);
        }
    }
}

