/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;

public class StringValidation
implements JsonSchemaValidation {
    public static final StringValidation INSTANCE = new StringValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options) {
        StringValidation.checkString(propValue.getDelegate(), schema, consumer);
    }

    private static void checkString(PsiElement propValue, JsonSchemaObject schema, JsonValidationHost consumer) {
        String v = JsonSchemaAnnotatorChecker.getValue(propValue, schema);
        if (v == null) {
            return;
        }
        String value = StringUtil.unquoteString((String)v);
        if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
            consumer.error(JsonBundle.message("schema.validation.string.shorter.than", schema.getMinLength()), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
            consumer.error(JsonBundle.message("schema.validation.string.longer.than", schema.getMaxLength()), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema.getPattern() != null) {
            if (schema.getPatternError() != null) {
                consumer.error(JsonBundle.message("schema.validation.invalid.string.pattern", StringUtil.convertLineSeparators((String)schema.getPatternError())), propValue, JsonErrorPriority.LOW_PRIORITY);
            }
            if (!schema.checkByPattern(value)) {
                consumer.error(JsonBundle.message("schema.validation.string.violates.pattern", StringUtil.convertLineSeparators((String)schema.getPattern())), propValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }
}

