/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestUtil {
    public static String getJavaTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    public static String getRelativeJavaTestDataPath() {
        String absolute = JavaTestUtil.getJavaTestDataPath();
        return StringUtil.trimStart((String)absolute, (String)PathManager.getHomePath());
    }

    public static Sdk setupInternalJdkAsTestJDK(@NotNull Disposable parentDisposable, @Nullable String testJdkName) {
        if (parentDisposable == null) {
            JavaTestUtil.$$$reportNull$$$0(0);
        }
        Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        if (testJdkName == null) {
            testJdkName = internalJdk.getName();
        }
        String finalJdkName = testJdkName;
        return (Sdk)WriteAction.compute(() -> {
            ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
            Sdk oldJdk = jdkTable.findJdk(finalJdkName);
            if (oldJdk != null) {
                jdkTable.removeJdk(oldJdk);
            }
            Sdk jdk = internalJdk;
            if (!internalJdk.getName().equals(finalJdkName)) {
                try {
                    ProjectJdkImpl copy = (ProjectJdkImpl)internalJdk.clone();
                    copy.setName(finalJdkName);
                    jdk = copy;
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
            }
            jdkTable.addJdk(jdk, parentDisposable);
            return jdk;
        });
    }

    public static LanguageLevel getMaxRegisteredLanguageLevel() {
        LanguageLevel[] values = LanguageLevel.values();
        return values[values.length - 1];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/JavaTestUtil", "setupInternalJdkAsTestJDK"));
    }
}

