/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.JavaExpectedHighlightingData;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.testFramework.ExpectedHighlightingData;
import com.intellij.testFramework.FileTreeAccessFilter;
import com.intellij.testFramework.HighlightTestInfo;
import com.intellij.testFramework.LightJavaCodeInsightTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtilRt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightDaemonAnalyzerTestCase
extends LightJavaCodeInsightTestCase {
    private final FileTreeAccessFilter myJavaFilesFilter = new FileTreeAccessFilter();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject())).prepareForTest();
        DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(false);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            DaemonCodeAnalyzerSettings.getInstance().setImportHintEnabled(true);
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.getProject());
            if (daemonCodeAnalyzer != null) {
                daemonCodeAnalyzer.cleanupAfterTest();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void runTest() throws Throwable {
        Throwable[] throwable = new Throwable[]{null};
        CommandProcessor.getInstance().executeCommand(this.getProject(), () -> {
            try {
                this.doRunTest();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
        }, "", null);
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkInfos) {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkInfos, filePath);
    }

    protected void doTest(@NonNls String filePath, boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        this.configureByFile(filePath);
        this.doTestConfiguredFile(checkWarnings, checkWeakWarnings, checkInfos, filePath);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkInfos, @Nullable String filePath) {
        this.doTestConfiguredFile(checkWarnings, false, checkInfos, filePath);
    }

    protected void doTestConfiguredFile(boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos, @Nullable String filePath) {
        PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.getTestRootDisposable());
        ExpectedHighlightingData data = this.getExpectedHighlightingData(checkWarnings, checkWeakWarnings, checkInfos);
        this.checkHighlighting(data, this.composeLocalPath(filePath));
    }

    protected ExpectedHighlightingData getExpectedHighlightingData(boolean checkWarnings, boolean checkWeakWarnings, boolean checkInfos) {
        return new ExpectedHighlightingData(this.getEditor().getDocument(), checkWarnings, checkWeakWarnings, checkInfos);
    }

    @Nullable
    private String composeLocalPath(@Nullable String filePath) {
        return filePath != null ? this.getTestDataPath() + "/" + filePath : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHighlighting(ExpectedHighlightingData data, String filePath) {
        data.init();
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        this.getFile().getText();
        this.myJavaFilesFilter.allowTreeAccessForFile(this.getVFile());
        PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter((VirtualFileFilter)this.myJavaFilesFilter, this.getTestRootDisposable());
        try {
            List<HighlightInfo> infos = this.doHighlighting();
            data.checkResult(this.getFile(), infos, this.getEditor().getDocument().getText(), filePath);
        }
        finally {
            PsiManagerEx.getInstanceEx((Project)this.getProject()).setAssertOnFileLoadingFilter(VirtualFileFilter.NONE, this.getTestRootDisposable());
        }
    }

    protected HighlightTestInfo doTestFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(0);
        }
        return new HighlightTestInfo(this.getTestRootDisposable(), new String[]{filePath}){

            public HighlightTestInfo doTest() {
                String path = (String)UsefulTestCase.assertOneElement((Object[])this.filePaths);
                LightDaemonAnalyzerTestCase.this.configureByFile(path);
                JavaExpectedHighlightingData data = new JavaExpectedHighlightingData(LightDaemonAnalyzerTestCase.this.getEditor().getDocument(), this.checkWarnings, this.checkWeakWarnings, this.checkInfos);
                if (this.checkSymbolNames) {
                    data.checkSymbolNames();
                }
                LightDaemonAnalyzerTestCase.this.checkHighlighting(data, LightDaemonAnalyzerTestCase.this.composeLocalPath(path));
                return this;
            }
        };
    }

    @NotNull
    protected List<HighlightInfo> highlightErrors() {
        List<HighlightInfo> list = this.doHighlighting(HighlightSeverity.ERROR);
        if (list == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        IntArrayList toIgnoreList = new IntArrayList();
        if (!this.doFolding()) {
            toIgnoreList.add(1);
        }
        if (!this.doInspections()) {
            toIgnoreList.add(7);
            toIgnoreList.add(12);
        }
        int[] toIgnore = toIgnoreList.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : toIgnoreList.toIntArray();
        Editor editor = this.getEditor();
        PsiFile file = this.getFile();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        }
        List list = CodeInsightTestFixtureImpl.instantiateAndRun((PsiFile)file, (Editor)editor, (int[])toIgnore, (boolean)this.canChangeDocumentDuringHighlighting());
        if (list == null) {
            LightDaemonAnalyzerTestCase.$$$reportNull$$$0(2);
        }
        return list;
    }

    private boolean canChangeDocumentDuringHighlighting() {
        return this.annotatedWith(DaemonAnalyzerTestCase.CanChangeDocumentDuringHighlighting.class);
    }

    protected List<HighlightInfo> doHighlighting(HighlightSeverity minSeverity) {
        return DaemonAnalyzerTestCase.filter(this.doHighlighting(), minSeverity);
    }

    protected boolean doFolding() {
        return false;
    }

    protected boolean doInspections() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/LightDaemonAnalyzerTestCase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightErrors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTestFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

