/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationCreationListener;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase<T>
extends UserDataHolderBase
implements RunConfiguration,
TargetAwareRunProfile,
ConfigurationCreationListener,
FragmentedSettings {
    private static final String SHOW_CONSOLE_ON_STD_OUT = "show_console_on_std_out";
    private static final String SHOW_CONSOLE_ON_STD_ERR = "show_console_on_std_err";
    @Nullable
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName;
    private RunConfigurationOptions myOptions;
    @NotNull
    private List<BeforeRunTask<?>> myBeforeRunTasks;

    protected RunConfigurationBase(@NotNull Project project, @Nullable ConfigurationFactory factory, @Nullable String name) {
        if (project == null) {
            RunConfigurationBase.$$$reportNull$$$0(0);
        }
        this.myBeforeRunTasks = Collections.emptyList();
        this.myProject = project;
        this.myFactory = factory;
        this.myName = name;
        this.myOptions = this.createOptions();
    }

    @NotNull
    private RunConfigurationOptions createOptions() {
        RunConfigurationOptions runConfigurationOptions = (RunConfigurationOptions)ReflectionUtil.newInstance(this.getOptionsClass());
        if (runConfigurationOptions == null) {
            RunConfigurationBase.$$$reportNull$$$0(1);
        }
        return runConfigurationOptions;
    }

    @NotNull
    protected RunConfigurationOptions getOptions() {
        RunConfigurationOptions runConfigurationOptions = this.myOptions;
        if (runConfigurationOptions == null) {
            RunConfigurationBase.$$$reportNull$$$0(2);
        }
        return runConfigurationOptions;
    }

    @Override
    @Transient
    @NotNull
    public List<BeforeRunTask<?>> getBeforeRunTasks() {
        List<BeforeRunTask<?>> list = this.myBeforeRunTasks;
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void setBeforeRunTasks(@NotNull List<BeforeRunTask<?>> value) {
        if (value == null) {
            RunConfigurationBase.$$$reportNull$$$0(4);
        }
        this.myBeforeRunTasks = value;
    }

    @Override
    @Nullable
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RunConfigurationBase.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myFactory == null ? null : this.myFactory.getIcon();
    }

    @Override
    @Transient
    @NotNull
    public final String getName() {
        String string = StringUtilRt.notNullize((String)this.myName);
        if (string == null) {
            RunConfigurationBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
        if (runner == null) {
            RunConfigurationBase.$$$reportNull$$$0(7);
        }
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
    }

    @Override
    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            RunConfigurationBase.$$$reportNull$$$0(8);
        }
        return true;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase result = (RunConfigurationBase)super.clone();
        result.myOptions = this.createOptions();
        result.doCopyOptionsFrom(this);
        return result;
    }

    void doCopyOptionsFrom(@NotNull RunConfigurationBase<T> template) {
        if (template == null) {
            RunConfigurationBase.$$$reportNull$$$0(9);
        }
        this.myOptions.copyFrom(template.myOptions);
        this.myOptions.resetModificationCount();
        this.myOptions.setAllowRunningInParallel(template.isAllowRunningInParallel());
        this.myBeforeRunTasks = ContainerUtil.copyList(template.myBeforeRunTasks);
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.getOptions().getPredefinedLogFiles().clear();
    }

    public void addPredefinedLogFile(@NotNull PredefinedLogFile predefinedLogFile) {
        if (predefinedLogFile == null) {
            RunConfigurationBase.$$$reportNull$$$0(10);
        }
        this.getOptions().getPredefinedLogFiles().add(predefinedLogFile);
    }

    @NotNull
    public List<PredefinedLogFile> getPredefinedLogFiles() {
        List<PredefinedLogFile> list = this.getOptions().getPredefinedLogFiles();
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>(this.getLogFiles());
        for (PredefinedLogFile predefinedLogFile : this.getOptions().getPredefinedLogFiles()) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list.add(options);
        }
        ArrayList<LogFileOptions> arrayList = list;
        if (arrayList == null) {
            RunConfigurationBase.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    public List<LogFileOptions> getLogFiles() {
        List<LogFileOptions> list = this.getOptions().getLogFiles();
        if (list == null) {
            RunConfigurationBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void addLogFile(String file, String alias, boolean checked) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file, checked));
    }

    public void addLogFile(String file, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.getOptions().getLogFiles().clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    @Nullable
    public T getState() {
        return (T)this.getOptions();
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            RunConfigurationBase.$$$reportNull$$$0(14);
        }
        this.myOptions = state instanceof Element ? XmlSerializer.deserialize((Element)state, this.getOptionsClass()) : (RunConfigurationOptions)state;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RunConfigurationBase.$$$reportNull$$$0(15);
        }
        boolean isAllowRunningInParallel = this.myOptions.isAllowRunningInParallel();
        this.loadState(element);
        this.myOptions.setAllowRunningInParallel(isAllowRunningInParallel);
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            RunConfigurationBase.$$$reportNull$$$0(16);
        }
        XmlSerializer.serializeObjectInto(this.myOptions, element);
    }

    @Override
    @NotNull
    public Set<String> getSelectedOptions() {
        Set<String> set = this.myOptions.getSelectedOptions();
        if (set == null) {
            RunConfigurationBase.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Override
    public void setSelectedOptions(@NotNull Set<String> fragmentIds) {
        if (fragmentIds == null) {
            RunConfigurationBase.$$$reportNull$$$0(18);
        }
        this.myOptions.setSelectedOptions(fragmentIds);
    }

    @ApiStatus.Experimental
    public void setOptionsFromConfigurationFile(@NotNull BaseState state) {
        if (state == null) {
            RunConfigurationBase.$$$reportNull$$$0(19);
        }
        this.myOptions.copyFrom(state, false);
    }

    protected Class<? extends RunConfigurationOptions> getOptionsClass() {
        Class<? extends BaseState> result;
        Class<? extends BaseState> clazz = result = this.myFactory == null ? null : this.myFactory.getOptionsClass();
        if (result != null) {
            return result;
        }
        if (this instanceof PersistentStateComponent) {
            PersistentStateComponent instance = (PersistentStateComponent)((Object)this);
            return ComponentSerializationUtil.getStateClass(instance.getClass());
        }
        return this.getDefaultOptionsClass();
    }

    @NotNull
    protected Class<? extends RunConfigurationOptions> getDefaultOptionsClass() {
        return RunConfigurationOptions.class;
    }

    @Transient
    public boolean isSaveOutputToFile() {
        return this.myOptions.getFileOutput().isSaveOutput();
    }

    public void setSaveOutputToFile(boolean redirectOutput) {
        this.myOptions.getFileOutput().setSaveOutput(redirectOutput);
    }

    @Attribute(value="show_console_on_std_out")
    public boolean isShowConsoleOnStdOut() {
        return this.myOptions.isShowConsoleOnStdOut();
    }

    public void setShowConsoleOnStdOut(boolean showConsoleOnStdOut) {
        this.myOptions.setShowConsoleOnStdOut(showConsoleOnStdOut);
    }

    @Attribute(value="show_console_on_std_err")
    public boolean isShowConsoleOnStdErr() {
        return this.myOptions.isShowConsoleOnStdErr();
    }

    public void setShowConsoleOnStdErr(boolean showConsoleOnStdErr) {
        this.myOptions.setShowConsoleOnStdErr(showConsoleOnStdErr);
    }

    @Transient
    public String getOutputFilePath() {
        return this.myOptions.getFileOutput().getFileOutputPath();
    }

    public void setFileOutputPath(String fileOutputPath) {
        this.myOptions.getFileOutput().setFileOutputPath(fileOutputPath);
    }

    public boolean collectOutputFromProcessHandler() {
        return true;
    }

    @Deprecated
    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    public String toString() {
        return this.getType().getDisplayName() + ": " + this.getName();
    }

    @Deprecated
    protected boolean isNewSerializationUsed() {
        return false;
    }

    @Override
    public final boolean isAllowRunningInParallel() {
        return this.getOptions().isAllowRunningInParallel();
    }

    @Override
    public final void setAllowRunningInParallel(boolean value) {
        this.getOptions().setAllowRunningInParallel(value);
    }

    @Override
    public void onNewConfigurationCreated() {
    }

    @Override
    public void onConfigurationCopied() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLogFile";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/RunConfigurationBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeRunTasks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLogFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLogFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBeforeRunTasks";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRunnerSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCopyOptionsFrom";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedLogFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedOptions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setOptionsFromConfigurationFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

