/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileBasedIndex {
    @Deprecated
    public static final boolean ourEnableTracingOfKeyHashToVirtualFileMapping = true;
    @ApiStatus.Internal
    public static final boolean ourSnapshotMappingsEnabled = SystemProperties.getBooleanProperty((String)"idea.index.snapshot.mappings.enabled", (boolean)true);
    private static final boolean ourDisableIndexAccessDuringDumbMode = SystemProperties.getBooleanProperty((String)"idea.disable.index.access.during.dumb.mode", (boolean)false);
    @ApiStatus.Internal
    public static final boolean USE_IN_MEMORY_INDEX = SystemProperties.is((String)"idea.use.in.memory.file.based.index");
    @ApiStatus.Internal
    public static final boolean IGNORE_PLAIN_TEXT_FILES = SystemProperties.is((String)"idea.ignore.plain.text.indexing");

    public abstract void iterateIndexableFiles(@NotNull ContentIterator var1, @NotNull Project var2, @Nullable ProgressIndicator var3);

    @Nullable
    public abstract VirtualFile getFileBeingCurrentlyIndexed();

    @ApiStatus.Internal
    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        throw new UnsupportedOperationException();
    }

    public abstract void registerIndexableSet(@NotNull IndexableFileSet var1, @Nullable Project var2);

    public abstract void removeIndexableSet(@NotNull IndexableFileSet var1);

    public static FileBasedIndex getInstance() {
        return (FileBasedIndex)ApplicationManager.getApplication().getService(FileBasedIndex.class);
    }

    public static int getFileId(@NotNull VirtualFile file) {
        if (file == null) {
            FileBasedIndex.$$$reportNull$$$0(0);
        }
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)((Object)file)).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    @Deprecated
    public abstract VirtualFile findFileById(Project var1, int var2);

    public void requestRebuild(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(1);
        }
        this.requestRebuild(indexId, new Throwable());
    }

    @NotNull
    public abstract <K, V> List<V> getValues(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    @NotNull
    public abstract <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> var1, @NotNull K var2, @NotNull GlobalSearchScope var3);

    public abstract <K, V> boolean processValues(@NotNull ID<K, V> var1, @NotNull K var2, @Nullable VirtualFile var3, @NotNull ValueProcessor<? super V> var4, @NotNull GlobalSearchScope var5);

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(2);
        }
        if (dataKey == null) {
            FileBasedIndex.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            FileBasedIndex.$$$reportNull$$$0(5);
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter);
    }

    public abstract <K, V> long getIndexModificationStamp(@NotNull ID<K, V> var1, @NotNull Project var2);

    public abstract <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> var1, @NotNull Collection<? extends K> var2, @NotNull GlobalSearchScope var3, @Nullable Condition<? super V> var4, @NotNull Processor<? super VirtualFile> var5);

    @NotNull
    public abstract <K> Collection<K> getAllKeys(@NotNull ID<K, ?> var1, @NotNull Project var2);

    @ApiStatus.Internal
    public abstract <K> void ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3);

    public abstract void requestRebuild(@NotNull ID<?, ?> var1, @NotNull Throwable var2);

    public abstract <K> void scheduleRebuild(@NotNull ID<K, ?> var1, @NotNull Throwable var2);

    public abstract void requestReindex(@NotNull VirtualFile var1);

    public abstract <K, V> boolean getFilesWithKey(@NotNull ID<K, V> var1, @NotNull Set<? extends K> var2, @NotNull Processor<? super VirtualFile> var3, @NotNull GlobalSearchScope var4);

    @ApiStatus.Experimental
    public void ignoreDumbMode(@NotNull Runnable command, @NotNull DumbModeAccessType dumbModeAccessType) {
        if (command == null) {
            FileBasedIndex.$$$reportNull$$$0(6);
        }
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(7);
        }
        this.ignoreDumbMode(dumbModeAccessType, () -> {
            command.run();
            return null;
        });
    }

    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndex.$$$reportNull$$$0(8);
        }
        if (computable == null) {
            FileBasedIndex.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    public abstract <K> boolean processAllKeys(@NotNull ID<K, ?> var1, @NotNull Processor<? super K> var2, @Nullable Project var3);

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndex.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            FileBasedIndex.$$$reportNull$$$0(12);
        }
        return this.processAllKeys(indexId, processor, scope.getProject());
    }

    @NotNull
    public abstract <K, V> Map<K, V> getFileData(@NotNull ID<K, V> var1, @NotNull VirtualFile var2, @NotNull Project var3);

    public static void iterateRecursively(@NotNull VirtualFile root, @NotNull ContentIterator processor, @Nullable ProgressIndicator indicator, @Nullable Set<? super VirtualFile> visitedRoots, @Nullable ProjectFileIndex projectFileIndex) {
        if (root == null) {
            FileBasedIndex.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            FileBasedIndex.$$$reportNull$$$0(14);
        }
        VirtualFileFilter acceptFilter = file -> {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (visitedRoots != null && !root.equals(file) && file.isDirectory() && !visitedRoots.add(file)) {
                return false;
            }
            return projectFileIndex == null || (Boolean)ReadAction.compute(() -> projectFileIndex.isExcluded(file)) == false;
        };
        VirtualFileFilter symlinkFilter = file -> {
            if (acceptFilter.accept(file)) {
                if (file.is(VFileProperty.SYMLINK)) {
                    if (!Registry.is((String)"indexer.follows.symlinks")) {
                        return false;
                    }
                    VirtualFile canonicalFile = file.getCanonicalFile();
                    if (canonicalFile != null) {
                        return acceptFilter.accept(canonicalFile);
                    }
                }
                return true;
            }
            return false;
        };
        VfsUtilCore.iterateChildrenRecursively(root, symlinkFilter, processor);
    }

    public void invalidateCaches() {
        throw new IncorrectOperationException();
    }

    @ApiStatus.Internal
    public static boolean isIndexAccessDuringDumbModeEnabled() {
        return !ourDisableIndexAccessDuringDumbMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 4: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileBasedIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestRebuild";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processValues";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreDumbMode";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllKeys";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateRecursively";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface FileTypeSpecificInputFilter
    extends InputFilter {
        public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> var1);
    }

    @FunctionalInterface
    public static interface InputFilter {
        public boolean acceptInput(@NotNull VirtualFile var1);
    }

    @FunctionalInterface
    public static interface ValueProcessor<V> {
        public boolean process(@NotNull VirtualFile var1, V var2);
    }
}

