/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    @Deprecated
    public static final String DEFAULT_EMPTY_TEXT = "Nothing to show";
    private static final int Y_GAP = 2;
    @Nullable
    private Component myOwner;
    private Component myMouseTarget;
    @NotNull
    private final MouseMotionListener myMouseMotionListener;
    @NotNull
    private final ClickListener myClickListener;
    private boolean myIsDefaultText;
    private String myText = "";
    private final Column myPrimaryColumn = new Column();
    private final Column mySecondaryColumn = new Column();
    private boolean myHasActiveClickListeners;
    private boolean myShowAboveCenter = true;
    private Font myFont = null;

    protected StatusText(JComponent owner) {
        this();
        this.attachTo(owner);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/StatusText$1", "onClick"));
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){
            private Cursor myOriginalCursor;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisible()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        if (this.myOriginalCursor == null) {
                            this.myOriginalCursor = StatusText.this.myMouseTarget.getCursor();
                            StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else if (this.myOriginalCursor != null) {
                        StatusText.this.myMouseTarget.setCursor(this.myOriginalCursor);
                        this.myOriginalCursor = null;
                    }
                }
            }
        };
        this.setText(StatusText.getDefaultEmptyText(), DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
    }

    protected boolean isFontSet() {
        return this.myFont != null;
    }

    public void setFont(@NotNull Font font) {
        if (font == null) {
            StatusText.$$$reportNull$$$0(0);
        }
        this.myPrimaryColumn.fragments.forEach(fragment -> ((Fragment)fragment).myComponent.setFont(font));
        this.mySecondaryColumn.fragments.forEach(fragment -> ((Fragment)fragment).myComponent.setFont(font));
        this.myFont = font;
    }

    public void attachTo(@Nullable Component owner) {
        this.attachTo(owner, owner);
    }

    public void attachTo(@Nullable Component owner, @Nullable Component mouseTarget) {
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private static ActionListener findListener(@NotNull SimpleColoredComponent component, @NotNull List<? extends ActionListener> listeners, int xCoord) {
        int index;
        if (component == null) {
            StatusText.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            StatusText.$$$reportNull$$$0(2);
        }
        if ((index = component.findFragmentAt(xCoord)) >= 0 && index < listeners.size()) {
            return listeners.get(index);
        }
        return null;
    }

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        if (!this.myHasActiveClickListeners || !this.isStatusVisible()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle commonBounds = this.getTextComponentBound();
        if (commonBounds.contains(point)) {
            ActionListener listener2 = this.getListener(this.myPrimaryColumn, point, commonBounds);
            if (listener2 != null) {
                return listener2;
            }
            listener2 = this.getListener(this.mySecondaryColumn, point, commonBounds);
            if (listener2 != null) {
                return listener2;
            }
        }
        return null;
    }

    @Nullable
    private ActionListener getListener(Column column, Point point, Rectangle commonBounds) {
        Point primaryLocation = this.getColumnLocation(column == this.myPrimaryColumn, commonBounds);
        for (Fragment fragment : column.fragments) {
            ActionListener listener2;
            Rectangle fragmentBounds = this.getFragmentBounds(column, primaryLocation, commonBounds, fragment);
            if (!fragmentBounds.contains(new Point(point.x, point.y)) || (listener2 = StatusText.findListener(fragment.myComponent, fragment.myClickListeners, point.x - fragmentBounds.x)) == null) continue;
            return listener2;
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / (this.myShowAboveCenter ? 3 : 2);
        return new Rectangle(x, y, size.width, size.height);
    }

    public final boolean isShowAboveCenter() {
        return this.myShowAboveCenter;
    }

    public final StatusText setShowAboveCenter(boolean showAboveCenter) {
        this.myShowAboveCenter = showAboveCenter;
        return this;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            StatusText.$$$reportNull$$$0(3);
        }
        return string;
    }

    public StatusText setText(@NlsContexts.StatusText String text) {
        return this.setText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(@NlsContexts.StatusText String text, SimpleTextAttributes attrs) {
        return this.clear().appendText(text, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        this.myPrimaryColumn.fragments.clear();
        this.mySecondaryColumn.fragments.clear();
        this.myHasActiveClickListeners = false;
        this.repaintOwner();
        return this;
    }

    private void repaintOwner() {
        if (this.myOwner != null && this.isStatusVisible()) {
            this.myOwner.repaint();
        }
    }

    public StatusText appendText(@NlsContexts.StatusText String text) {
        return this.appendText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(@NlsContexts.StatusText String text, SimpleTextAttributes attrs) {
        return this.appendText(text, attrs, null);
    }

    public StatusText appendText(@NlsContexts.StatusText String text, SimpleTextAttributes attrs, ActionListener listener2) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text;
        return this.appendText(true, Math.max(0, this.myPrimaryColumn.fragments.size() - 1), text, attrs, listener2);
    }

    public StatusText appendText(boolean isPrimaryColumn, int row, @NlsContexts.StatusText String text, SimpleTextAttributes attrs, ActionListener listener2) {
        Fragment fragment = this.getOrCreateFragment(isPrimaryColumn, row);
        fragment.myComponent.append(text, attrs);
        fragment.myClickListeners.add(listener2);
        this.myHasActiveClickListeners |= listener2 != null;
        this.updateBounds();
        this.repaintOwner();
        return this;
    }

    private void updateBounds() {
        StatusText.updateBounds(this.myPrimaryColumn);
        StatusText.updateBounds(this.mySecondaryColumn);
    }

    private static void updateBounds(Column column) {
        Fragment fragment;
        int i;
        Dimension size = new Dimension();
        for (i = 0; i < column.fragments.size(); ++i) {
            fragment = column.fragments.get(i);
            Dimension d = fragment.myComponent.getPreferredSize();
            fragment.boundsInColumn.setBounds(0, size.height, d.width, d.height);
            size.height += d.height;
            if (i > 0) {
                size.height += JBUIScale.scale((int)2);
            }
            size.width = Math.max(size.width, d.width);
        }
        for (i = 0; i < column.fragments.size(); ++i) {
            fragment = column.fragments.get(i);
            ((Fragment)fragment).boundsInColumn.x += (size.width - ((Fragment)fragment).boundsInColumn.width) / 2;
        }
        column.preferredSize.setSize(size);
    }

    private Fragment getOrCreateFragment(boolean isPrimaryColumn, int row) {
        Fragment fragment;
        Column column;
        Column column2 = column = isPrimaryColumn ? this.myPrimaryColumn : this.mySecondaryColumn;
        if (column.fragments.size() < row) {
            throw new IllegalStateException("Cannot add text to row " + row + " as in " + (isPrimaryColumn ? "left" : "right") + " column there are " + column.fragments.size() + " rows only");
        }
        if (column.fragments.size() == row) {
            fragment = new Fragment();
            if (this.myFont != null) {
                fragment.myComponent.setFont(this.myFont);
            }
            column.fragments.add(fragment);
        } else {
            fragment = column.fragments.get(row);
        }
        return fragment;
    }

    @NotNull
    public StatusText appendSecondaryText(@NotNull @NlsContexts.StatusText String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(4);
        }
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(5);
        }
        StatusText statusText = this.appendText(true, 1, text, attrs, listener2);
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(6);
        }
        return statusText;
    }

    @NotNull
    public StatusText appendLine(@NotNull @NlsContexts.StatusText String text) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(7);
        }
        StatusText statusText = this.appendLine(text, DEFAULT_ATTRIBUTES, null);
        if (statusText == null) {
            StatusText.$$$reportNull$$$0(8);
        }
        return statusText;
    }

    public StatusText appendLine(@NotNull @NlsContexts.StatusText String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener2) {
        if (text == null) {
            StatusText.$$$reportNull$$$0(9);
        }
        if (attrs == null) {
            StatusText.$$$reportNull$$$0(10);
        }
        return this.appendText(true, this.myPrimaryColumn.fragments.size(), text, attrs, listener2);
    }

    public void paint(Component owner, Graphics g) {
        if (!this.isStatusVisible()) {
            return;
        }
        if (owner == this.myOwner) {
            this.doPaintStatusText(g, this.getTextComponentBound());
        } else {
            this.paintOnComponentUnderViewport(owner, g);
        }
    }

    private void paintOnComponentUnderViewport(Component component, Graphics g) {
        JBViewport viewport = (JBViewport)ObjectUtils.tryCast((Object)this.myOwner, JBViewport.class);
        if (viewport == null || viewport.getView() != component || viewport.isPaintingNow()) {
            return;
        }
        Rectangle textBoundsInViewport = this.getTextComponentBound();
        int xInOwner = textBoundsInViewport.x - component.getX();
        int yInOwner = textBoundsInViewport.y - component.getY();
        Rectangle textBoundsInOwner = new Rectangle(xInOwner, yInOwner, textBoundsInViewport.width, textBoundsInViewport.height);
        this.doPaintStatusText(g, textBoundsInOwner);
        viewport.repaint(textBoundsInViewport);
    }

    private Point getColumnLocation(boolean isPrimary, Rectangle bounds) {
        if (isPrimary && this.mySecondaryColumn.fragments.isEmpty()) {
            return new Point(bounds.x + (bounds.width - ((Column)this.myPrimaryColumn).preferredSize.width) / 2, bounds.y);
        }
        if (isPrimary) {
            return new Point(bounds.x, bounds.y);
        }
        return new Point(bounds.x + bounds.width - ((Column)this.mySecondaryColumn).preferredSize.width, bounds.y);
    }

    private void doPaintStatusText(@NotNull Graphics g, @NotNull Rectangle bounds) {
        if (g == null) {
            StatusText.$$$reportNull$$$0(11);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(12);
        }
        this.paintColumnInBounds(this.myPrimaryColumn, g, this.getColumnLocation(true, bounds), bounds);
        this.paintColumnInBounds(this.mySecondaryColumn, g, this.getColumnLocation(false, bounds), bounds);
    }

    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        if (component == null) {
            StatusText.$$$reportNull$$$0(13);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(14);
        }
        Dimension size = component.getPreferredSize();
        if (this.mySecondaryColumn.fragments.isEmpty()) {
            return new Rectangle(bounds.x + (bounds.width - size.width) / 2, bounds.y, size.width, size.height);
        }
        return component == this.getComponent() ? new Rectangle(bounds.x, bounds.y, size.width, size.height) : new Rectangle(bounds.x + bounds.width - size.width, bounds.y, size.width, size.height);
    }

    private void paintColumnInBounds(Column column, Graphics g, Point location, Rectangle bounds) {
        for (Fragment fragment : column.fragments) {
            Rectangle r = this.getFragmentBounds(column, location, bounds, fragment);
            StatusText.paintComponentInBounds(fragment.myComponent, g, r);
        }
    }

    @NotNull
    private Rectangle getFragmentBounds(Column column, Point columnLocation, Rectangle bounds, Fragment fragment) {
        Rectangle r = new Rectangle();
        r.setBounds(fragment.boundsInColumn);
        r.x += columnLocation.x;
        r.y += columnLocation.y;
        if (column.fragments.size() == 1) {
            r = this.adjustComponentBounds(fragment.myComponent, bounds);
        }
        Rectangle rectangle = r;
        if (rectangle == null) {
            StatusText.$$$reportNull$$$0(15);
        }
        return rectangle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintComponentInBounds(@NotNull SimpleColoredComponent component, @NotNull Graphics g, @NotNull Rectangle bounds) {
        if (component == null) {
            StatusText.$$$reportNull$$$0(16);
        }
        if (g == null) {
            StatusText.$$$reportNull$$$0(17);
        }
        if (bounds == null) {
            StatusText.$$$reportNull$$$0(18);
        }
        Graphics2D g2 = (Graphics2D)g.create(bounds.x, bounds.y, bounds.width, bounds.height);
        try {
            component.setBounds(0, 0, bounds.width, bounds.height);
            component.paint(g2);
        }
        finally {
            g2.dispose();
        }
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        SimpleColoredComponent simpleColoredComponent = this.getOrCreateFragment(true, 0).myComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(19);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent getSecondaryComponent() {
        SimpleColoredComponent simpleColoredComponent = this.getOrCreateFragment(true, 1).myComponent;
        if (simpleColoredComponent == null) {
            StatusText.$$$reportNull$$$0(20);
        }
        return simpleColoredComponent;
    }

    public Dimension getPreferredSize() {
        return new Dimension(((Column)this.myPrimaryColumn).preferredSize.width + ((Column)this.mySecondaryColumn).preferredSize.width, Math.max(((Column)this.myPrimaryColumn).preferredSize.height, ((Column)this.mySecondaryColumn).preferredSize.height));
    }

    public static String getDefaultEmptyText() {
        return UIBundle.message("message.nothingToShow", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/StatusText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendSecondaryText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "appendLine";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragmentBounds";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFont";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findListener";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 19: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSecondaryText";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doPaintStatusText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "adjustComponentBounds";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "paintComponentInBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 15: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class Fragment {
        private final SimpleColoredComponent myComponent = new SimpleColoredComponent();
        private final Rectangle boundsInColumn = new Rectangle();
        private final List<ActionListener> myClickListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        public Fragment() {
            this.myComponent.setOpaque(false);
            this.myComponent.setFont(UIUtil.getLabelFont());
        }
    }

    protected static final class Column {
        List<Fragment> fragments = new ArrayList<Fragment>();
        private final Dimension preferredSize = new Dimension();

        protected Column() {
        }
    }
}

