/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.cache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

class CodeStyleCachedValueProvider
implements CachedValueProvider<CodeStyleSettings> {
    private static final Logger LOG = Logger.getInstance(CodeStyleCachedValueProvider.class);
    private static final int MAX_COMPUTATION_THREADS = 10;
    @NotNull
    private final WeakReference<PsiFile> myFileRef;
    @NotNull
    private final AsyncComputation myComputation;
    @NotNull
    private final Lock myComputationLock;
    private static final ExecutorService ourExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CodeStyleCachedValueProvider", (int)10);

    CodeStyleCachedValueProvider(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(0);
        }
        this.myComputationLock = new ReentrantLock();
        this.myFileRef = new WeakReference<PsiFile>(file2);
        this.myComputation = new AsyncComputation();
    }

    boolean isExpired() {
        return this.myFileRef.get() == null || this.myComputation.isExpired();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CodeStyleSettings tryGetSettings() {
        PsiFile file2 = this.getReferencedPsi();
        if (!this.myComputationLock.tryLock()) return null;
        try {
            CodeStyleSettings codeStyleSettings = (CodeStyleSettings)CachedValuesManager.getCachedValue((PsiElement)file2, (CachedValueProvider)this);
            this.myComputationLock.unlock();
            return codeStyleSettings;
        }
        catch (Throwable throwable) {
            try {
                this.myComputationLock.unlock();
                throw throwable;
            }
            catch (OutdatedFileReferenceException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
    }

    void scheduleWhenComputed(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(1);
        }
        this.myComputation.schedule(runnable2);
    }

    @Nullable
    public CachedValueProvider.Result<CodeStyleSettings> compute() {
        CodeStyleSettings settings = this.myComputation.getCurrResult();
        if (settings != null) {
            CodeStyleCachedValueProvider.logCached(this.getReferencedPsi(), settings);
            return new CachedValueProvider.Result((Object)settings, this.getDependencies(settings, this.myComputation));
        }
        return null;
    }

    public void cancelComputation() {
        this.myComputation.cancel();
    }

    Object @NotNull [] getDependencies(@NotNull CodeStyleSettings settings, @NotNull AsyncComputation computation) {
        if (settings == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(2);
        }
        if (computation == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(3);
        }
        ArrayList<SimpleModificationTracker> dependencies = new ArrayList<SimpleModificationTracker>();
        if (settings instanceof TransientCodeStyleSettings) {
            dependencies.addAll(((TransientCodeStyleSettings)settings).getDependencies());
        } else {
            dependencies.add(settings.getModificationTracker());
        }
        dependencies.add(computation.getTracker());
        Object[] objectArray = ArrayUtil.toObjectArray(dependencies);
        if (objectArray == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static void logCached(@NotNull PsiFile file2, @NotNull CodeStyleSettings settings) {
        if (file2 == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(6);
        }
        LOG.debug(String.format("File: %s (%s), cached: %s, tracker: %d", file2.getName(), Integer.toHexString(file2.hashCode()), settings, settings.getModificationTracker().getModificationCount()));
    }

    @NotNull
    private PsiFile getReferencedPsi() {
        PsiFile file2 = (PsiFile)this.myFileRef.get();
        if (file2 == null) {
            throw new OutdatedFileReferenceException();
        }
        PsiFile psiFile = file2;
        if (psiFile == null) {
            CodeStyleCachedValueProvider.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    public boolean equals(Object obj) {
        return obj instanceof CodeStyleCachedValueProvider && Objects.equals(this.myFileRef.get(), ((CodeStyleCachedValueProvider)obj).myFileRef.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scheduleWhenComputed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logCached";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OutdatedFileReferenceException
    extends RuntimeException {
        OutdatedFileReferenceException() {
            super("Outdated file reference used to obtain settings");
        }
    }

    private class AsyncComputation {
        private final AtomicBoolean myIsActive = new AtomicBoolean();
        private volatile CodeStyleSettings myCurrResult;
        @NotNull
        private final CodeStyleSettingsManager mySettingsManager;
        private final SimpleModificationTracker myTracker = new SimpleModificationTracker();
        private final Project myProject;
        private CancellablePromise<Void> myPromise;
        private final List<Runnable> myScheduledRunnables = new ArrayList<Runnable>();

        private AsyncComputation() {
            this.myProject = CodeStyleCachedValueProvider.this.getReferencedPsi().getProject();
            this.mySettingsManager = CodeStyleSettingsManager.getInstance((Project)this.myProject);
            this.myCurrResult = this.mySettingsManager.getCurrentSettings();
        }

        private void start() {
            if (this.isRunOnBackground()) {
                this.myPromise = ReadAction.nonBlocking(() -> this.computeSettings()).expireWith((Disposable)this.myProject).expireWhen(() -> CodeStyleCachedValueProvider.this.myFileRef.get() == null).finishOnUiThread(ModalityState.NON_MODAL, val -> this.notifyCachedValueComputed()).submit((Executor)ourExecutorService);
            } else {
                ReadAction.run(() -> this.computeSettings());
                this.notifyOnEdt();
            }
        }

        public void cancel() {
            if (this.myPromise != null && !this.myPromise.isDone()) {
                this.myPromise.cancel();
            }
            this.myCurrResult = null;
        }

        public boolean isExpired() {
            return this.myCurrResult == null;
        }

        private void schedule(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                AsyncComputation.$$$reportNull$$$0(0);
            }
            if (this.myIsActive.get()) {
                this.myScheduledRunnables.add(runnable2);
            } else {
                runnable2.run();
            }
        }

        private boolean isRunOnBackground() {
            Application application = ApplicationManager.getApplication();
            return !application.isUnitTestMode() && !application.isHeadlessEnvironment() && application.isDispatchThread();
        }

        private void notifyOnEdt() {
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread()) {
                this.notifyCachedValueComputed();
            } else {
                application.invokeLater(() -> this.notifyCachedValueComputed(), ModalityState.any());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeSettings() {
            try {
                CodeStyleSettings currSettings;
                CodeStyleCachedValueProvider.this.myComputationLock.lock();
                PsiFile file2 = CodeStyleCachedValueProvider.this.getReferencedPsi();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computation started for " + file2.getName());
                }
                if ((currSettings = this.mySettingsManager.getCurrentSettings()) != this.mySettingsManager.getTemporarySettings()) {
                    TransientCodeStyleSettings modifiableSettings = new TransientCodeStyleSettings(file2, currSettings);
                    modifiableSettings.applyIndentOptionsFromProviders(file2);
                    for (CodeStyleSettingsModifier modifier : CodeStyleSettingsModifier.EP_NAME.getExtensionList()) {
                        if (!modifier.modifySettings(modifiableSettings, file2)) continue;
                        LOG.debug("Modifier: " + modifier.getClass().getName());
                        modifiableSettings.setModifier(modifier);
                        currSettings = modifiableSettings;
                        break;
                    }
                }
                this.myCurrResult = currSettings;
                this.myTracker.incModificationCount();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computation ended for " + file2.getName());
                }
            }
            finally {
                CodeStyleCachedValueProvider.this.myComputationLock.unlock();
            }
        }

        @Nullable
        public CodeStyleSettings getCurrResult() {
            if (this.myIsActive.compareAndSet(false, true)) {
                this.start();
            }
            return this.myCurrResult;
        }

        private SimpleModificationTracker getTracker() {
            return this.myTracker;
        }

        void reset() {
            this.myScheduledRunnables.clear();
            this.myIsActive.set(false);
        }

        private void notifyCachedValueComputed() {
            for (Runnable runnable2 : this.myScheduledRunnables) {
                runnable2.run();
            }
            if (!this.myProject.isDisposed()) {
                ObjectUtils.consumeIfNotNull((Object)((PsiFile)CodeStyleCachedValueProvider.this.myFileRef.get()), file2 -> {
                    CodeStyleSettingsManager settingsManager = CodeStyleSettingsManager.getInstance((Project)this.myProject);
                    settingsManager.fireCodeStyleSettingsChanged(file2);
                });
            }
            CodeStyleCachedValueProvider.this.myComputation.reset();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/application/options/codeStyle/cache/CodeStyleCachedValueProvider$AsyncComputation", "schedule"));
        }
    }
}

