/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.model.psi.PsiCompletableReference;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.impl.ReferencesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/completion/ReferenceBasedCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.platform.lang.impl"})
public final class ReferenceBasedCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        if (parameters2.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        int fileOffset = parameters2.getOffset();
        PsiElement psiElement = parameters2.getPosition();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parameters.position");
        PsiFile psiFile = psiElement.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"parameters.position.containingFile");
        for (PsiSymbolReference reference2 : ReferencesKt.referencesAt(psiFile, fileOffset)) {
            String prefix;
            String string;
            PsiElement element2;
            Collection variants;
            ProgressManager.checkCanceled();
            if (!(reference2 instanceof PsiCompletableReference)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)((PsiCompletableReference)reference2).getCompletionVariants(), (String)"reference.completionVariants");
            if (variants.isEmpty()) continue;
            ProgressManager.checkCanceled();
            Intrinsics.checkExpressionValueIsNotNull((Object)reference2.getElement(), (String)"reference.getElement()");
            TextRange textRange = ((PsiCompletableReference)reference2).getRangeInElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"reference.rangeInElement");
            int beginIndex = textRange.getStartOffset();
            TextRange textRange2 = element2.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"element.textRange");
            int offsetInElement = fileOffset - textRange2.getStartOffset();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2.getText(), (String)"element.text");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(beginIndex, offsetInElement), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            Intrinsics.checkExpressionValueIsNotNull((Object)result2.withPrefixMatcher(prefix), (String)"result.withPrefixMatcher(prefix)");
            for (Object variant : variants) {
                CompletionResultSet resultWithPrefix;
                if (variant == null) continue;
                resultWithPrefix.addElement(CompletionData.objectToLookupItem(variant));
            }
        }
    }
}

