/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.UtilBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ConfigureInspectionsAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingSettingsPerFile;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private Icon icon;
    String statistics;
    String statusLabel;
    String statusExtraLine;
    boolean passStatusesVisible;
    final Map<ProgressableTextEditorHighlightingPass, Pair<JProgressBar, JLabel>> passes;
    private final TObjectIntHashMap<HighlightSeverity> errorCount;
    static final int MAX = 100;
    boolean progressBarsEnabled;
    Boolean progressBarsCompleted;

    @Deprecated
    public TrafficLightRenderer(Project project, Document document, PsiFile psiFile) {
        this(project, document);
        DeprecatedMethodException.report((String)"Please use TrafficLightRenderer(Project, Document) instead");
    }

    public TrafficLightRenderer(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            TrafficLightRenderer.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TrafficLightRenderer.$$$reportNull$$$0(1);
        }
        this.passes = new LinkedHashMap<ProgressableTextEditorHighlightingPass, Pair<JProgressBar, JLabel>>();
        this.errorCount = new TObjectIntHashMap();
        this.myProject = project;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        this.myDocument = document;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.refresh(null);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        model.addMarkupModelListener(this, new MarkupModelListener(){

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                TrafficLightRenderer.this.incErrorCount(highlighter, 1);
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                TrafficLightRenderer.this.incErrorCount(highlighter, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            for (RangeHighlighter rangeHighlighter : model.getAllHighlighters()) {
                this.incErrorCount(rangeHighlighter, 1);
            }
        });
    }

    private PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
    }

    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(2);
        }
        return severityRegistrar;
    }

    public int[] getErrorCount() {
        List<HighlightSeverity> severities = this.mySeverityRegistrar.getAllSeverities();
        int[] result2 = new int[severities.size()];
        for (HighlightSeverity severity : severities) {
            int severityIndex = this.mySeverityRegistrar.getSeverityIdx(severity);
            result2[severityIndex] = this.errorCount.get((Object)severity);
        }
        return result2;
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
    }

    public void dispose() {
        this.errorCount.clear();
    }

    private void incErrorCount(RangeHighlighter highlighter, int delta) {
        HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
        if (info == null) {
            return;
        }
        HighlightSeverity infoSeverity = info.getSeverity();
        if (infoSeverity.myVal <= HighlightSeverity.INFORMATION.myVal) {
            return;
        }
        if (this.errorCount.containsKey((Object)infoSeverity)) {
            this.errorCount.adjustValue((Object)infoSeverity, delta);
        } else {
            this.errorCount.put((Object)infoSeverity, delta);
        }
    }

    public boolean isValid() {
        return this.getPsiFile() != null;
    }

    @NotNull
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(3);
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.no.file", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(4);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (this.myProject.isDisposed()) {
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.project.is.disposed", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(5);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (!this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
            if (!psiFile.isPhysical()) {
                status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.file.is.generated", (Object[])new Object[0]);
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(6);
                }
                return daemonCodeAnalyzerStatus;
            }
            if (psiFile instanceof PsiCompiledElement) {
                status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.file.is.decompiled", (Object[])new Object[0]);
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(7);
                }
                return daemonCodeAnalyzerStatus;
            }
            FileType fileType = psiFile.getFileType();
            if (fileType.isBinary()) {
                status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.file.is.binary", (Object[])new Object[0]);
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(8);
                }
                return daemonCodeAnalyzerStatus;
            }
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.highlighting.is.disabled.for.this.file", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(9);
            }
            return daemonCodeAnalyzerStatus;
        }
        FileViewProvider provider = psiFile.getViewProvider();
        Set languages = provider.getLanguages();
        HighlightingSettingsPerFile levelSettings = HighlightingSettingsPerFile.getInstance(this.myProject);
        boolean shouldHighlight = languages.isEmpty();
        for (Language language : languages) {
            PsiFile root = provider.getPsi(language);
            FileHighlightingSetting level = levelSettings.getHighlightingSettingForRoot((PsiElement)root);
            shouldHighlight |= level != FileHighlightingSetting.SKIP_HIGHLIGHTING;
        }
        if (!shouldHighlight) {
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.highlighting.level.is.none", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(10);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            Map.Entry processEntry = HeavyProcessLatch.INSTANCE.getRunningOperation();
            if (processEntry != null) {
                status.reasonWhySuspended = (String)processEntry.getKey();
                status.heavyProcessType = (HeavyProcessLatch.Type)processEntry.getValue();
            } else {
                status.reasonWhySuspended = DaemonBundle.message((String)"process.title.heavy.operation.is.running", (Object[])new Object[0]);
                status.heavyProcessType = HeavyProcessLatch.Type.Processing;
            }
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(11);
            }
            return daemonCodeAnalyzerStatus;
        }
        status.errorCount = this.getErrorCount();
        status.passes = ContainerUtil.filter(this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument), p -> !StringUtil.isEmpty((String)p.getPresentableName()) && p.getProgress() >= 0.0);
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(psiFile);
        status.reasonWhySuspended = this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled() ? null : DaemonBundle.message((String)"process.title.highlighting.is.paused.temporarily", (Object[])new Object[0]);
        this.fillDaemonCodeAnalyzerErrorsStatus(status, severityRegistrar);
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(12);
        }
        return daemonCodeAnalyzerStatus;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(13);
        }
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(14);
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TrafficLightRenderer.$$$reportNull$$$0(15);
        }
        return project;
    }

    public void paint(@NotNull Component c, Graphics g, @NotNull Rectangle r) {
        if (c == null) {
            TrafficLightRenderer.$$$reportNull$$$0(16);
        }
        if (r == null) {
            TrafficLightRenderer.$$$reportNull$$$0(17);
        }
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        Icon icon2 = this.getIcon(status);
        icon2.paintIcon(c, g, r.x, r.y);
    }

    @NotNull
    private Icon getIcon(@NotNull DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(18);
        }
        this.updatePanel(status);
        Icon icon2 = this.icon;
        if (PowerSaveMode.isEnabled() || status.reasonWhySuspended != null || status.reasonWhyDisabled != null || status.errorAnalyzingFinished) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                TrafficLightRenderer.$$$reportNull$$$0(19);
            }
            return icon3;
        }
        Icon icon4 = AllIcons.General.InspectionsEye;
        if (icon4 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(20);
        }
        return icon4;
    }

    boolean updatePanel(@NotNull DaemonCodeAnalyzerStatus status) {
        Icon icon2;
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(21);
        }
        this.progressBarsEnabled = false;
        this.progressBarsCompleted = null;
        this.statistics = "";
        this.passStatusesVisible = false;
        this.statusLabel = null;
        this.statusExtraLine = null;
        boolean result2 = false;
        if (!status.passes.equals(new ArrayList<ProgressableTextEditorHighlightingPass>(this.passes.keySet()))) {
            this.rebuildPassesMap(status);
            result2 = true;
        }
        if (PowerSaveMode.isEnabled()) {
            this.statusLabel = DaemonBundle.message((String)"label.code.analysis.is.disabled.in.power.save.mode", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            this.icon = AllIcons.General.InspectionsPowerSaveMode;
            return result2;
        }
        if (status.reasonWhyDisabled != null) {
            this.statusLabel = DaemonBundle.message((String)"label.no.analysis.has.been.performed", (Object[])new Object[0]);
            this.statusExtraLine = "(" + status.reasonWhyDisabled + ")";
            this.passStatusesVisible = true;
            this.progressBarsCompleted = Boolean.FALSE;
            this.icon = AllIcons.General.InspectionsTrafficOff;
            return result2;
        }
        if (status.reasonWhySuspended != null) {
            this.statusLabel = DaemonBundle.message((String)"label.code.analysis.has.been.suspended", (Object[])new Object[0]);
            this.statusExtraLine = "(" + status.reasonWhySuspended + ")";
            this.passStatusesVisible = true;
            this.progressBarsCompleted = Boolean.FALSE;
            this.icon = AllIcons.General.InspectionsPause;
            return result2;
        }
        int lastNotNullIndex = ArrayUtil.lastIndexOfNot((int[])status.errorCount, (int)0);
        Icon icon3 = icon2 = lastNotNullIndex == -1 ? AllIcons.General.InspectionsOK : this.mySeverityRegistrar.getRendererIconByIndex(lastNotNullIndex);
        if (status.errorAnalyzingFinished) {
            boolean isDumb = DumbService.isDumb((Project)this.myProject);
            if (isDumb) {
                this.statusLabel = DaemonBundle.message((String)"label.shallow.analysis.completed", (Object[])new Object[0]);
                this.statusExtraLine = DaemonBundle.message((String)"label.complete.results.will.be.available.after.indexing", (Object[])new Object[0]);
            } else {
                this.statusLabel = "";
            }
            this.progressBarsCompleted = Boolean.TRUE;
        } else {
            this.statusLabel = DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]);
            this.passStatusesVisible = true;
            this.progressBarsEnabled = true;
            this.progressBarsCompleted = null;
        }
        int currentSeverityErrors = 0;
        StringBuilder text = new StringBuilder();
        for (int i2 = lastNotNullIndex; i2 >= 0; --i2) {
            int count = status.errorCount[i2];
            if (count <= 0) continue;
            HighlightSeverity severity = this.mySeverityRegistrar.getSeverityByIndex(i2);
            String name = count > 1 ? StringUtil.pluralize((String)StringUtil.toLowerCase((String)severity.getName())) : StringUtil.toLowerCase((String)severity.getName());
            text.append(status.errorAnalyzingFinished ? DaemonBundle.message((String)"errors.found", (Object[])new Object[]{count, name}) : DaemonBundle.message((String)"errors.found.so.far", (Object[])new Object[]{count, name})).append("<br/>");
            currentSeverityErrors += count;
        }
        if (currentSeverityErrors == 0) {
            text.append(status.errorAnalyzingFinished ? DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]) : DaemonBundle.message((String)"no.errors.or.warnings.found.so.far", (Object[])new Object[0])).append("<br/>");
        }
        this.statistics = XmlStringUtil.wrapInHtml((CharSequence)text.toString());
        this.icon = icon2;
        return result2;
    }

    private void rebuildPassesMap(@NotNull DaemonCodeAnalyzerStatus status) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(22);
        }
        this.passes.clear();
        for (ProgressableTextEditorHighlightingPass pass : status.passes) {
            JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setMaximum(100);
            UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.MINI, (Component)progressBar);
            JLabel percentLabel = new JLabel();
            percentLabel.setText("100%");
            this.passes.put(pass, (Pair<JProgressBar, JLabel>)Pair.create((Object)progressBar, (Object)percentLabel));
        }
    }

    @NotNull
    public AnalyzerStatus getStatus(@NotNull Editor editor) {
        if (editor == null) {
            TrafficLightRenderer.$$$reportNull$$$0(23);
        }
        if (PowerSaveMode.isEnabled()) {
            return new AnalyzerStatus(AllIcons.General.InspectionsPowerSaveMode, "Code analysis is disabled in power save mode", "", () -> this.createUIController(editor));
        }
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        ArrayList<StatusItem> statusItems = new ArrayList<StatusItem>();
        Icon mainIcon = null;
        String title = "";
        String details = "";
        boolean isDumb = DumbService.isDumb((Project)this.myProject);
        if (status.errorAnalyzingFinished) {
            if (isDumb) {
                title = DaemonBundle.message((String)"shallow.analysis.completed", (Object[])new Object[0]);
                details = DaemonBundle.message((String)"shallow.analysis.completed.details", (Object[])new Object[0]);
            }
        } else {
            title = DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]);
        }
        int[] errorCount = status.errorCount;
        for (int i2 = errorCount.length - 1; i2 >= 0; --i2) {
            int count = errorCount[i2];
            if (count <= 0) continue;
            HighlightSeverity severity = this.mySeverityRegistrar.getSeverityByIndex(i2);
            String name = StringUtil.toLowerCase((String)severity.getName());
            if (count > 1) {
                name = StringUtil.pluralize((String)name);
            }
            Icon icon2 = this.mySeverityRegistrar.getRendererIconByIndex(i2);
            statusItems.add(new StatusItem(Integer.toString(count), icon2, name));
            if (mainIcon != null) continue;
            mainIcon = icon2;
        }
        if (!statusItems.isEmpty()) {
            if (mainIcon == null) {
                mainIcon = AllIcons.General.InspectionsOK;
            }
            AnalyzerStatus result2 = new AnalyzerStatus(mainIcon, title, "", () -> this.createUIController(editor)).withNavigation().withExpandedStatus(statusItems);
            AnalyzerStatus analyzerStatus = status.errorAnalyzingFinished ? result2 : result2.withAnalyzingType(AnalyzingType.PARTIAL).withPasses(ContainerUtil.map(status.passes, p -> new PassWrapper(p.getPresentableName(), p.getProgress(), p.isFinished())));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(24);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty((String)status.reasonWhyDisabled)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsTrafficOff, DaemonBundle.message((String)"no.analysis.performed", (Object[])new Object[0]), status.reasonWhyDisabled, () -> this.createUIController(editor)).withTextStatus(DaemonBundle.message((String)"iw.status.off", (Object[])new Object[0]));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(25);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty((String)status.reasonWhySuspended)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsPause, DaemonBundle.message((String)"analysis.suspended", (Object[])new Object[0]), status.reasonWhySuspended, () -> this.createUIController(editor)).withTextStatus(status.heavyProcessType != null ? status.heavyProcessType.toString() : DaemonBundle.message((String)"iw.status.paused", (Object[])new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED);
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(26);
            }
            return analyzerStatus;
        }
        if (status.errorAnalyzingFinished) {
            return isDumb ? new AnalyzerStatus(AllIcons.General.InspectionsPause, title, details, () -> this.createUIController(editor)).withTextStatus(UtilBundle.message((String)"heavyProcess.type.indexing", (Object[])new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED) : new AnalyzerStatus(AllIcons.General.InspectionsOK, DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]), details, () -> this.createUIController(editor));
        }
        AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsEye, title, details, () -> this.createUIController(editor)).withTextStatus(DaemonBundle.message((String)"iw.status.analyzing", (Object[])new Object[0])).withAnalyzingType(AnalyzingType.EMPTY).withPasses(ContainerUtil.map(status.passes, p -> new PassWrapper(p.getPresentableName(), p.getProgress(), p.isFinished())));
        if (analyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(27);
        }
        return analyzerStatus;
    }

    @NotNull
    protected UIController createUIController(@NotNull Editor editor) {
        if (editor == null) {
            TrafficLightRenderer.$$$reportNull$$$0(28);
        }
        boolean mergeEditor = editor.getUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG) == Boolean.TRUE;
        return editor.getEditorKind() == EditorKind.DIFF && !mergeEditor ? new SimplifiedUIController() : new DefaultUIController();
    }

    private static void applyPanel(@NotNull HectorComponentPanel panel2) {
        if (panel2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(29);
        }
        try {
            panel2.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @NotNull
    private static InspectionsLevel getHighlightLevel(boolean highlight, boolean inspect) {
        if (!highlight && !inspect) {
            InspectionsLevel inspectionsLevel = InspectionsLevel.NONE;
            if (inspectionsLevel == null) {
                TrafficLightRenderer.$$$reportNull$$$0(30);
            }
            return inspectionsLevel;
        }
        if (highlight && !inspect) {
            InspectionsLevel inspectionsLevel = InspectionsLevel.SYNTAX;
            if (inspectionsLevel == null) {
                TrafficLightRenderer.$$$reportNull$$$0(31);
            }
            return inspectionsLevel;
        }
        InspectionsLevel inspectionsLevel = InspectionsLevel.ALL;
        if (inspectionsLevel == null) {
            TrafficLightRenderer.$$$reportNull$$$0(32);
        }
        return inspectionsLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 13: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updatePanel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "rebuildPassesMap";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createUIController";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class SimplifiedUIController
    extends AbstractUIController {
        public boolean enableToolbar() {
            return false;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                SimplifiedUIController.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$SimplifiedUIController", "getActions"));
        }
    }

    public class DefaultUIController
    extends AbstractUIController {
        private final List<AnAction> myMenuActions;

        public DefaultUIController() {
            this.myMenuActions = this.initActions();
        }

        @NotNull
        private List<AnAction> initActions() {
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            result2.add((AnAction)new ConfigureInspectionsAction());
            result2.add((AnAction)DaemonEditorPopup.createGotoGroup());
            result2.add((AnAction)Separator.create());
            result2.add((AnAction)new ToggleAction(EditorBundle.message((String)"iw.show.import.tooltip", (Object[])new Object[0])){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    PsiFile psiFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (psiFile = TrafficLightRenderer.this.getPsiFile()) != null && TrafficLightRenderer.this.myDaemonCodeAnalyzer.isImportHintsEnabled(psiFile);
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    PsiFile psiFile;
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                        TrafficLightRenderer.this.myDaemonCodeAnalyzer.setImportHintsEnabled(psiFile, state);
                    }
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.update(e);
                    e.getPresentation().setEnabled(TrafficLightRenderer.this.myDaemonCodeAnalyzer.isAutohintsAvailable(TrafficLightRenderer.this.getPsiFile()));
                }

                public boolean isDumbAware() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "update";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                DefaultUIController.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = this.myMenuActions;
            if (list2 == null) {
                DefaultUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public boolean enableToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    protected abstract class AbstractUIController
    implements UIController {
        private final boolean inLibrary;
        private final List<LanguageHighlightLevel> myLevelsList;
        private List<HectorComponentPanel> myAdditionalPanels = Collections.emptyList();

        AbstractUIController() {
            PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
            if (psiFile != null) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)TrafficLightRenderer.this.getProject()).getFileIndex();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                assert (virtualFile != null);
                this.inLibrary = fileIndex.isInLibrary(virtualFile) && !fileIndex.isInContent(virtualFile);
            } else {
                this.inLibrary = false;
            }
            this.myLevelsList = this.initLevels();
        }

        @NotNull
        private List<LanguageHighlightLevel> initLevels() {
            ArrayList<LanguageHighlightLevel> result2 = new ArrayList<LanguageHighlightLevel>();
            PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
            if (psiFile != null && !TrafficLightRenderer.this.getProject().isDisposed()) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                HighlightingLevelManager hlManager = HighlightingLevelManager.getInstance(TrafficLightRenderer.this.getProject());
                for (Language language : viewProvider.getLanguages()) {
                    PsiFile psiRoot = viewProvider.getPsi(language);
                    result2.add(new LanguageHighlightLevel(language.getID(), TrafficLightRenderer.getHighlightLevel(hlManager.shouldHighlight((PsiElement)psiRoot), hlManager.shouldInspect((PsiElement)psiRoot))));
                }
            }
            ArrayList<LanguageHighlightLevel> arrayList = result2;
            if (arrayList == null) {
                AbstractUIController.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @NotNull
        public List<InspectionsLevel> getAvailableLevels() {
            List<InspectionsLevel> list2 = this.inLibrary ? Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX) : Arrays.asList(InspectionsLevel.values());
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        public List<LanguageHighlightLevel> getHighlightLevels() {
            List<LanguageHighlightLevel> list2 = Collections.unmodifiableList(this.myLevelsList);
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public void setHighLightLevel(@NotNull LanguageHighlightLevel level) {
            PsiFile psiFile;
            if (level == null) {
                AbstractUIController.$$$reportNull$$$0(3);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null && !TrafficLightRenderer.this.getProject().isDisposed() && !this.myLevelsList.contains(level)) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                Language language = Language.findLanguageByID((String)level.getLangID());
                if (language != null) {
                    PsiFile root = viewProvider.getPsi(language);
                    if (level.getLevel() == InspectionsLevel.NONE) {
                        HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_HIGHLIGHTING);
                    } else if (level.getLevel() == InspectionsLevel.SYNTAX) {
                        HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_INSPECTION);
                    } else {
                        HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.FORCE_HIGHLIGHTING);
                    }
                    this.myLevelsList.replaceAll(l -> l.getLangID().equals(level.getLangID()) ? level : l);
                    InjectedLanguageManager.getInstance((Project)TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
            }
        }

        public void fillHectorPanels(@NotNull Container container2, @NotNull GridBag gc) {
            PsiFile psiFile;
            if (container2 == null) {
                AbstractUIController.$$$reportNull$$$0(4);
            }
            if (gc == null) {
                AbstractUIController.$$$reportNull$$$0(5);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                this.myAdditionalPanels = HectorComponentPanelsProvider.EP_NAME.extensions((AreaInstance)TrafficLightRenderer.this.getProject()).map(hp -> hp.createConfigurable(psiFile)).filter(p -> p != null).collect(Collectors.toList());
                for (HectorComponentPanel p2 : this.myAdditionalPanels) {
                    JComponent c;
                    try {
                        p2.reset();
                        c = p2.createComponent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Logger.getInstance(TrafficLightRenderer.class).error(e);
                        continue;
                    }
                    if (c == null) continue;
                    container2.add((Component)c, gc.nextLine().next().fillCellHorizontally().coverLine().weightx(1.0));
                }
            }
        }

        public boolean canClosePopup() {
            if (this.myAdditionalPanels.isEmpty()) {
                return true;
            }
            if (this.myAdditionalPanels.stream().allMatch(p -> p.canClose())) {
                PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
                if (this.myAdditionalPanels.stream().filter(p -> p.isModified()).peek(x$0 -> TrafficLightRenderer.applyPanel(x$0)).count() > 0L) {
                    if (psiFile != null) {
                        InjectedLanguageManager.getInstance((Project)TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    }
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
                return true;
            }
            return false;
        }

        public void onClosePopup() {
            this.myAdditionalPanels.forEach(p -> p.disposeUIResources());
            this.myAdditionalPanels = Collections.emptyList();
        }

        public void toggleProblemsView() {
            ProblemsView.toggleCurrentFileProblems(TrafficLightRenderer.this.getProject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initLevels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightLevels";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setHighLightLevel";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fillHectorPanels";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static final class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        List<ProgressableTextEditorHighlightingPass> passes = Collections.emptyList();
        public int[] errorCount = ArrayUtilRt.EMPTY_INT_ARRAY;
        public String reasonWhyDisabled;
        public String reasonWhySuspended;
        private HeavyProcessLatch.Type heavyProcessType;

        public String toString() {
            StringBuilder s = new StringBuilder("DS: finished=" + this.errorAnalyzingFinished);
            s.append("; pass statuses: ").append(this.passes.size()).append("; ");
            for (ProgressableTextEditorHighlightingPass passStatus : this.passes) {
                s.append(String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished()));
            }
            s.append("; error count: ").append(this.errorCount.length).append(": ").append(new TIntArrayList(this.errorCount));
            return s.toString();
        }
    }
}

