/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.documentation.DockablePopupManager;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.WindowAction;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SwingActionDelegate;
import com.intellij.ui.content.Content;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.MenuSelectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class DocumentationManager
extends DockablePopupManager<DocumentationComponent> {
    public static final String JAVADOC_LOCATION_AND_SIZE = "javadoc.popup";
    public static final String NEW_JAVADOC_LOCATION_AND_SIZE = "javadoc.popup.new";
    public static final DataKey<String> SELECTED_QUICK_DOC_TEXT = DataKey.create((String)"QUICK_DOC.SELECTED_TEXT");
    private static final Logger LOG = Logger.getInstance(DocumentationManager.class);
    private static final String SHOW_DOCUMENTATION_IN_TOOL_WINDOW = "ShowDocumentationInToolWindow";
    private static final String DOCUMENTATION_AUTO_UPDATE_ENABLED = "DocumentationAutoUpdateEnabled";
    private static final Class[] ACTION_CLASSES_TO_IGNORE = new Class[]{HintManagerImpl.ActionToIgnore.class, ScrollingUtil.ScrollingAction.class, SwingActionDelegate.class, BaseNavigateToSourceAction.class, WindowAction.class};
    private static final String[] ACTION_IDS_TO_IGNORE = new String[]{"EditorDown", "EditorUp", "EditorPageDown", "EditorPageUp", "EditorEscape"};
    private static final String[] ACTION_PLACES_TO_IGNORE = new String[]{"JavadocInplaceSettings", "JavadocToolbar"};
    private Editor myEditor;
    private final Alarm myUpdateDocAlarm;
    private WeakReference<JBPopup> myDocInfoHintRef;
    private WeakReference<Component> myFocusedBeforePopup;
    public static final Key<SmartPsiElementPointer<?>> ORIGINAL_ELEMENT_KEY = Key.create((String)"Original element");
    private boolean myCloseOnSneeze;
    private String myPrecalculatedDocumentation;
    private ActionCallback myLastAction;
    private DocumentationComponent myTestDocumentationComponent;
    private AnAction myRestorePopupAction;

    @Override
    protected String getToolwindowId() {
        return "Documentation";
    }

    @Override
    protected DocumentationComponent createComponent() {
        return new DocumentationComponent(this);
    }

    @Override
    protected String getRestorePopupDescription() {
        return CodeInsightBundle.message((String)"action.description.restore.popup.view.mode", (Object[])new Object[0]);
    }

    @Override
    protected String getAutoUpdateDescription() {
        return CodeInsightBundle.message((String)"action.description.refresh.documentation.on.selection.change.automatically", (Object[])new Object[0]);
    }

    @Override
    protected String getAutoUpdateTitle() {
        return CodeInsightBundle.message((String)"popup.title.auto.update.from.source", (Object[])new Object[0]);
    }

    @Override
    protected boolean getAutoUpdateDefault() {
        return true;
    }

    @Override
    @NotNull
    protected AnAction createRestorePopupAction() {
        AnAction anAction = this.myRestorePopupAction = super.createRestorePopupAction();
        if (anAction == null) {
            DocumentationManager.$$$reportNull$$$0(0);
        }
        return anAction;
    }

    @Override
    public void restorePopupBehavior() {
        super.restorePopupBehavior();
        Component previouslyFocused = (Component)SoftReference.dereference(this.myFocusedBeforePopup);
        if (previouslyFocused != null && previouslyFocused.isShowing()) {
            UIUtil.runWhenFocused((Component)previouslyFocused, () -> this.updateComponent(true));
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(previouslyFocused, true);
        }
    }

    @Override
    public void createToolWindow(@NotNull CompletableFuture<PsiElement> elementFuture, PsiElement originalElement) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(1);
        }
        super.createToolWindow(elementFuture, originalElement);
        if (this.myToolWindow != null) {
            this.myToolWindow.getComponent().putClientProperty("ChooseByNameBase.TemporarilyFocusableComponent", Boolean.TRUE);
            if (this.myRestorePopupAction != null) {
                ShortcutSet quickDocShortcut = ActionManager.getInstance().getAction("QuickJavaDoc").getShortcutSet();
                this.myRestorePopupAction.registerCustomShortcutSet(quickDocShortcut, this.myToolWindow.getComponent());
                this.myRestorePopupAction = null;
            }
        }
    }

    @Override
    protected void installComponentActions(@NotNull ToolWindow toolWindow, DocumentationComponent component2) {
        if (toolWindow == null) {
            DocumentationManager.$$$reportNull$$$0(2);
        }
        ((ToolWindowEx)toolWindow).setTitleActions(component2.getActions());
        DefaultActionGroup group = new DefaultActionGroup(this.createActions());
        group.add(component2.getFontSizeAction());
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)group);
        component2.removeCornerMenu();
    }

    @Override
    protected void setToolwindowDefaultState() {
        Rectangle rectangle = WindowManager.getInstance().getIdeFrame(this.myProject).suggestChildFrameBounds();
        this.myToolWindow.setDefaultState(ToolWindowAnchor.RIGHT, ToolWindowType.DOCKED, new Rectangle(rectangle.width / 4, rectangle.height));
        this.myToolWindow.setType(ToolWindowType.DOCKED, null);
        this.myToolWindow.setSplitMode(true, null);
        this.myToolWindow.setAutoHide(false);
    }

    public static DocumentationManager getInstance(@NotNull Project project) {
        if (project == null) {
            DocumentationManager.$$$reportNull$$$0(3);
        }
        return (DocumentationManager)project.getService(DocumentationManager.class);
    }

    public DocumentationManager(@NotNull Project project) {
        if (project == null) {
            DocumentationManager.$$$reportNull$$$0(4);
        }
        super(project);
        AnActionListener actionListener = new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(DocumentationManager.this.getDocInfoHint() == null || LookupManager.getActiveLookup(DocumentationManager.this.myEditor) != null || Conditions.instanceOf((Class[])ACTION_CLASSES_TO_IGNORE).value((Object)action2) || ArrayUtil.contains((String)event.getPlace(), (String[])ACTION_PLACES_TO_IGNORE) || ContainerUtil.exists((Object[])ACTION_IDS_TO_IGNORE, id2 -> ActionManager.getInstance().getAction(id2) == action2))) {
                    DocumentationManager.this.closeDocHint();
                }
            }

            public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
                JBPopup hint;
                if (dataContext == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((hint = DocumentationManager.this.getDocInfoHint()) != null && LookupManager.getActiveLookup(DocumentationManager.this.myEditor) == null) {
                    hint.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeActionPerformed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeEditorTyping";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(AnActionListener.TOPIC, (Object)actionListener);
        this.myUpdateDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    private void closeDocHint() {
        JBPopup hint = this.getDocInfoHint();
        if (hint == null) {
            return;
        }
        this.myCloseOnSneeze = false;
        hint.cancel();
        Component toFocus = (Component)SoftReference.dereference(this.myFocusedBeforePopup);
        hint.cancel();
        if (toFocus != null) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true);
        }
    }

    public void setAllowContentUpdateFromContext(boolean allow) {
        if (this.hasActiveDockedDocWindow()) {
            this.restartAutoUpdate(allow);
        }
    }

    public void updateToolwindowContext() {
        if (this.hasActiveDockedDocWindow()) {
            this.updateComponent();
        }
    }

    public void showJavaDocInfoAtToolWindow(@NotNull PsiElement element2, @NotNull PsiElement original) {
        Content content2;
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(5);
        }
        if (original == null) {
            DocumentationManager.$$$reportNull$$$0(6);
        }
        if ((content2 = this.recreateToolWindow(element2, original)) == null) {
            return;
        }
        DocumentationComponent component2 = (DocumentationComponent)content2.getComponent();
        this.myUpdateDocAlarm.cancelAllRequests();
        this.doFetchDocInfo(component2, new MyCollector(this.myProject, CompletableFuture.completedFuture(element2), original, null, false)).doWhenDone(() -> component2.clearHistory());
    }

    public void showJavaDocInfo(@NotNull PsiElement element2, PsiElement original) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(7);
        }
        this.showJavaDocInfo(element2, original, null);
    }

    public void showJavaDocInfo(@NotNull Editor editor, @NotNull PsiElement element2, @NotNull PsiElement original, @Nullable Runnable closeCallback, @Nullable String documentation, boolean closeOnSneeze, boolean useStoredPopupSize) {
        if (editor == null) {
            DocumentationManager.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(9);
        }
        if (original == null) {
            DocumentationManager.$$$reportNull$$$0(10);
        }
        this.myEditor = editor;
        this.myCloseOnSneeze = closeOnSneeze;
        this.showJavaDocInfo(element2, original, false, closeCallback, documentation, useStoredPopupSize);
    }

    public void showJavaDocInfo(@NotNull PsiElement element2, PsiElement original, @Nullable Runnable closeCallback) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(11);
        }
        this.showJavaDocInfo(element2, original, false, closeCallback);
    }

    public void showJavaDocInfo(@NotNull PsiElement element2, PsiElement original, boolean requestFocus, @Nullable Runnable closeCallback) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(12);
        }
        this.showJavaDocInfo(element2, original, requestFocus, closeCallback, null, true);
    }

    public void showJavaDocInfo(@NotNull PsiElement element2, final PsiElement original, final boolean requestFocus, @Nullable Runnable closeCallback, @Nullable String documentation, final boolean useStoredPopupSize) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(13);
        }
        if (!element2.isValid()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(element2.getProject()){

            public void updatePopup(Object lookupItemObject) {
                if (lookupItemObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo(CompletableFuture.completedFuture((PsiElement)lookupItemObject), requestFocus, this, original, null, null, useStoredPopupSize);
                }
            }
        };
        this.doShowJavaDocInfo(CompletableFuture.completedFuture(element2), requestFocus, updateProcessor, original, closeCallback, documentation, useStoredPopupSize);
    }

    public void showJavaDocInfo(Editor editor, @Nullable PsiFile file2, boolean requestFocus) {
        this.showJavaDocInfo(editor, file2, requestFocus, null);
    }

    public void showJavaDocInfo(Editor editor, @Nullable PsiFile file2, boolean requestFocus, final @Nullable Runnable closeCallback) {
        this.myEditor = editor;
        Project project = this.getProject((PsiElement)file2);
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (file2 != null && !file2.isValid()) {
            file2 = null;
        }
        final PsiFile finalFile = file2;
        final PsiElement originalElement = DocumentationManager.getContextElement(editor, file2);
        CancellablePromise elementPromise = ReadAction.nonBlocking(() -> this.findTargetElementFromContext(editor, finalFile, originalElement)).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
        final CompletableFuture<PsiElement> elementFuture = DocumentationManager.toCompletableFuture((CancellablePromise<PsiElement>)elementPromise);
        PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project){

            public void updatePopup(Object lookupIteObject) {
                if (lookupIteObject == null) {
                    DocumentationManager.this.doShowJavaDocInfo(elementFuture, false, this, originalElement, closeCallback, CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), true);
                    return;
                }
                if (lookupIteObject instanceof PsiElement) {
                    DocumentationManager.this.doShowJavaDocInfo(CompletableFuture.completedFuture((PsiElement)lookupIteObject), false, this, originalElement, closeCallback, null, true);
                    return;
                }
                DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)finalFile);
                PsiElement element2 = documentationProvider.getDocumentationElementForLookupItem(PsiManager.getInstance((Project)DocumentationManager.this.myProject), lookupIteObject, originalElement);
                if (element2 == null) {
                    DocumentationManager.this.doShowJavaDocInfo(elementFuture, false, this, originalElement, closeCallback, CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), true);
                    return;
                }
                if (DocumentationManager.this.myEditor != null) {
                    PsiFile file2 = element2.getContainingFile();
                    if (file2 != null) {
                        Editor editor = DocumentationManager.this.myEditor;
                        DocumentationManager.this.showJavaDocInfo(DocumentationManager.this.myEditor, file2, false);
                        DocumentationManager.this.myEditor = editor;
                    }
                } else {
                    DocumentationManager.this.doShowJavaDocInfo(CompletableFuture.completedFuture(element2), false, this, originalElement, closeCallback, null, true);
                }
            }
        };
        this.doShowJavaDocInfo(elementFuture, requestFocus, updateProcessor, originalElement, closeCallback, null, true);
    }

    public PsiElement findTargetElement(Editor editor, PsiFile file2) {
        return this.findTargetElement(editor, file2, DocumentationManager.getContextElement(editor, file2));
    }

    private static PsiElement getContextElement(Editor editor, PsiFile file2) {
        return file2 != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    protected void doShowJavaDocInfo(@NotNull CompletableFuture<PsiElement> elementFuture, boolean requestFocus, @NotNull PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, @Nullable String documentation, boolean useStoredPopupSize) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(14);
        }
        if (updateProcessor == null) {
            DocumentationManager.$$$reportNull$$$0(15);
        }
        if (!this.myProject.isOpen()) {
            return;
        }
        elementFuture.thenAccept(element2 -> ReadAction.run(() -> {
            this.assertSameProject((PsiElement)element2);
            DocumentationManager.storeOriginalElement(this.myProject, originalElement, element2);
        }));
        JBPopup prevHint = this.getDocInfoHint();
        PsiElement targetElement = null;
        try {
            targetElement = elementFuture.get(50L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.debug("Failed to calculate targetElement in 50ms", (Throwable)e);
        }
        this.myPrecalculatedDocumentation = documentation;
        if (this.myToolWindow == null && PropertiesComponent.getInstance().isTrueValue(SHOW_DOCUMENTATION_IN_TOOL_WINDOW)) {
            this.createToolWindow(elementFuture, originalElement);
        } else if (this.myToolWindow != null) {
            Content content2 = this.myToolWindow.getContentManager().getSelectedContent();
            if (content2 != null) {
                boolean cancelAndFetchInfo = true;
                DocumentationComponent component2 = (DocumentationComponent)content2.getComponent();
                if (targetElement != null) {
                    boolean sameElement = targetElement.getManager().areElementsEquivalent(component2.getElement(), targetElement);
                    if (sameElement) {
                        boolean focus;
                        JComponent preferredFocusableComponent = content2.getPreferredFocusableComponent();
                        boolean bl = focus = requestFocus || CommandProcessor.getInstance().getCurrentCommand() != null;
                        if (preferredFocusableComponent != null && focus) {
                            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)preferredFocusableComponent, true);
                        }
                    }
                    boolean bl = cancelAndFetchInfo = !sameElement || !component2.isUpToDate();
                }
                if (cancelAndFetchInfo) {
                    this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, elementFuture, originalElement, null, false)).doWhenDone(() -> component2.clearHistory());
                }
            }
            if (!this.myToolWindow.isVisible()) {
                this.myToolWindow.show(null);
            }
        } else if (prevHint != null && prevHint.isVisible() && prevHint instanceof AbstractPopup) {
            DocumentationComponent component3 = (DocumentationComponent)((AbstractPopup)prevHint).getComponent();
            ActionCallback result2 = this.cancelAndFetchDocInfo(component3, new MyCollector(this.myProject, elementFuture, originalElement, null, false));
            if (requestFocus) {
                result2.doWhenDone(() -> {
                    JBPopup hint = this.getDocInfoHint();
                    if (hint != null) {
                        ((AbstractPopup)hint).focusPreferredComponent();
                    }
                });
            }
        } else {
            this.showInPopup(elementFuture, requestFocus, updateProcessor, originalElement, closeCallback, useStoredPopupSize);
        }
    }

    private void showInPopup(@NotNull CompletableFuture<PsiElement> elementFuture, boolean requestFocus, PopupUpdateProcessor updateProcessor, PsiElement originalElement, @Nullable Runnable closeCallback, boolean useStoredPopupSize) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(16);
        }
        Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
        this.myFocusedBeforePopup = new WeakReference<Component>(focusedComponent);
        DocumentationComponent component2 = this.myTestDocumentationComponent == null ? new DocumentationComponent(this, useStoredPopupSize) : this.myTestDocumentationComponent;
        ActionListener actionListener = __ -> {
            this.createToolWindow(elementFuture, originalElement);
            JBPopup hint = this.getDocInfoHint();
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        };
        SmartList actions = new SmartList();
        AnAction quickDocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        for (Shortcut shortcut : quickDocAction.getShortcutSet().getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            actions.add(Pair.create((Object)actionListener, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()));
        }
        boolean hasLookup = LookupManager.getActiveLookup(this.myEditor) != null;
        AbstractPopup hint = (AbstractPopup)JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component2, (JComponent)component2).setProject(this.myProject).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setKeyboardActions((List)actions).setResizable(true).setMovable(true).setFocusable(true).setRequestFocus(requestFocus).setCancelOnClickOutside(!hasLookup).setModalContext(false).setCancelCallback(() -> {
            if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
                return false;
            }
            this.myCloseOnSneeze = false;
            if (closeCallback != null) {
                closeCallback.run();
            }
            this.findQuickSearchComponent().ifPresent(QuickSearchComponent::unregisterHint);
            Disposer.dispose((Disposable)component2);
            this.myEditor = null;
            return Boolean.TRUE;
        }).setKeyEventHandler(e -> {
            if (this.myCloseOnSneeze) {
                this.closeDocHint();
            }
            if (AbstractPopup.isCloseRequest(e) && this.getDocInfoHint() != null) {
                this.closeDocHint();
                return true;
            }
            return false;
        }).createPopup();
        component2.setHint(hint);
        component2.setToolwindowCallback(() -> {
            this.createToolWindow(elementFuture, originalElement);
            this.myToolWindow.setAutoHide(false);
            hint.cancel();
        });
        if (useStoredPopupSize && DimensionService.getInstance().getSize(NEW_JAVADOC_LOCATION_AND_SIZE, this.myProject) != null) {
            hint.setDimensionServiceKey(NEW_JAVADOC_LOCATION_AND_SIZE);
        }
        if (this.myEditor == null) {
            LookupEx lookup2 = LookupManager.getInstance(this.myProject).getActiveLookup();
            this.myEditor = lookup2 != null ? lookup2.getEditor() : null;
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, elementFuture, originalElement, null, false));
        this.myDocInfoHintRef = new WeakReference<AbstractPopup>(hint);
        this.findQuickSearchComponent().ifPresent(quickSearch -> quickSearch.registerHint((JBPopup)hint));
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e.getID() == 501 && e.getSource() == hint.getPopupWindow()) {
                this.myCloseOnSneeze = false;
            }
            return false;
        }, component2);
    }

    public static void storeOriginalElement(Project project, PsiElement originalElement, PsiElement element2) {
        if (element2 == null) {
            return;
        }
        try {
            element2.putUserData(ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(originalElement));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nullable
    private PsiElement findTargetElementFromContext(@NotNull Editor editor, @Nullable PsiFile file2, @Nullable PsiElement originalElement) {
        PsiElement element2;
        if (editor == null) {
            DocumentationManager.$$$reportNull$$$0(17);
        }
        Object list2 = ParameterInfoController.findArgumentList(file2, editor.getCaretModel().getOffset(), -1);
        Object expressionList = null;
        if (list2 != null) {
            LookupEx lookup2 = LookupManager.getInstance(this.myProject).getActiveLookup();
            expressionList = lookup2 != null ? null : list2;
        }
        if ((element2 = this.assertSameProject(this.findTargetElement(editor, file2))) == null && expressionList != null) {
            element2 = expressionList;
        }
        if (element2 == null && file2 == null) {
            return null;
        }
        if (element2 == null) {
            element2 = this.assertSameProject(originalElement);
            if (element2 == null) {
                return null;
            }
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiComment.class);
            if (comment == null) {
                return null;
            }
            PsiElement psiElement = element2 = comment instanceof PsiDocCommentBase ? ((PsiDocCommentBase)comment).getOwner() : comment.getParent();
            if (element2 == null) {
                return null;
            }
        }
        return element2;
    }

    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, @Nullable PsiFile file2, PsiElement contextElement) {
        if (editor == null) {
            DocumentationManager.$$$reportNull$$$0(18);
        }
        return this.findTargetElement(editor, editor.getCaretModel().getOffset(), file2, contextElement);
    }

    @Nullable
    public PsiElement findTargetElement(Editor editor, int offset, @Nullable PsiFile file2, PsiElement contextElement) {
        try {
            return this.findTargetElementUnsafe(editor, offset, file2, contextElement);
        }
        catch (IndexNotReadyException ex) {
            LOG.warn("Index not ready");
            LOG.debug((Throwable)ex);
            return null;
        }
    }

    @Nullable
    private PsiElement findTargetElementUnsafe(Editor editor, int offset, @Nullable PsiFile file2, PsiElement contextElement) {
        PsiReference ref;
        PsiElement adjusted;
        TargetElementUtil targetElementUtil;
        if (LookupManager.getInstance(this.myProject).getActiveLookup() != null) {
            return this.assertSameProject(this.getElementFromLookup(editor, file2));
        }
        TargetElementUtil util = TargetElementUtil.getInstance();
        PsiElement element2 = null;
        if (file2 != null) {
            DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2);
            element2 = this.assertSameProject(documentationProvider.getCustomDocumentationElement(editor, file2, contextElement, offset));
        }
        if (element2 == null && ((element2 = this.assertSameProject(util.findTargetElement(editor, (targetElementUtil = TargetElementUtil.getInstance()).getAllAccepted(), offset))) != null || contextElement != null) && (adjusted = this.assertSameProject(util.adjustElement(editor, targetElementUtil.getAllAccepted(), element2, contextElement))) != null) {
            element2 = adjusted;
        }
        if (element2 == null && (ref = TargetElementUtil.findReference(editor, offset)) != null) {
            element2 = this.assertSameProject(util.adjustReference(ref));
            if (ref instanceof PsiPolyVariantReference) {
                element2 = this.assertSameProject(ref.getElement());
            }
        }
        DocumentationManager.storeOriginalElement(this.myProject, contextElement, element2);
        return element2;
    }

    @Nullable
    public PsiElement getElementFromLookup(Editor editor, @Nullable PsiFile file2) {
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null) {
            PsiElement targetElement;
            int offset = editor.getCaretModel().getOffset();
            if (offset > 0 && offset == editor.getDocument().getTextLength()) {
                --offset;
            }
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            PsiElement contextElement = file2 == null ? null : (PsiElement)ObjectUtils.coalesce((Object)file2.findElementAt(offset), (Object)file2);
            PsiElement psiElement = targetElement = ref != null ? ref.getElement() : contextElement;
            if (targetElement != null) {
                PsiUtilCore.ensureValid((PsiElement)targetElement);
            }
            DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)file2);
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            PsiElement fromProvider = targetElement == null ? null : documentationProvider.getDocumentationElementForLookupItem(psiManager, item.getObject(), targetElement);
            return fromProvider != null ? fromProvider : CompletionUtil.getTargetElement(item);
        }
        return null;
    }

    public String generateDocumentation(@NotNull PsiElement element2, @Nullable PsiElement originalElement, boolean onHover) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(19);
        }
        return new MyCollector(this.myProject, CompletableFuture.completedFuture(element2), originalElement, null, onHover).getDocumentation();
    }

    @Nullable
    public JBPopup getDocInfoHint() {
        if (this.myDocInfoHintRef == null) {
            return null;
        }
        JBPopup hint = (JBPopup)this.myDocInfoHintRef.get();
        if (hint == null || !hint.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) {
            if (hint != null) {
                hint.cancel();
            }
            this.myDocInfoHintRef = null;
            return null;
        }
        return hint;
    }

    public void fetchDocInfo(@NotNull PsiElement element2, @NotNull DocumentationComponent component2) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(20);
        }
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(21);
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, CompletableFuture.completedFuture(element2), null, null, false));
    }

    public ActionCallback queueFetchDocInfo(@NotNull PsiElement element2, @NotNull DocumentationComponent component2) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(22);
        }
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(23);
        }
        return this.doFetchDocInfo(component2, new MyCollector(this.myProject, CompletableFuture.completedFuture(element2), null, null, false));
    }

    private ActionCallback cancelAndFetchDocInfo(@NotNull DocumentationComponent component2, @NotNull DocumentationCollector provider) {
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(24);
        }
        if (provider == null) {
            DocumentationManager.$$$reportNull$$$0(25);
        }
        this.myUpdateDocAlarm.cancelAllRequests();
        return this.doFetchDocInfo(component2, provider);
    }

    void updateToolWindowTabName(@NotNull PsiElement element2) {
        Content content2;
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(26);
        }
        if (this.myToolWindow != null && (content2 = this.myToolWindow.getContentManager().getSelectedContent()) != null) {
            content2.setDisplayName(this.getTitle(element2));
        }
    }

    private ActionCallback doFetchDocInfo(@NotNull DocumentationComponent component2, @NotNull DocumentationCollector collector) {
        ActionCallback callback2;
        if (component2 == null) {
            DocumentationManager.$$$reportNull$$$0(27);
        }
        if (collector == null) {
            DocumentationManager.$$$reportNull$$$0(28);
        }
        this.myLastAction = callback2 = new ActionCallback();
        if (this.myPrecalculatedDocumentation != null) {
            LOG.debug("Setting precalculated documentation:\n", new Object[]{this.myPrecalculatedDocumentation});
            PsiElement element2 = collector.getElement(false);
            if (element2 == null) {
                LOG.debug("Element for precalculated documentation is not available anymore");
                component2.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), null, collector.provider);
                callback2.setDone();
                return callback2;
            }
            PsiElement originalElement = DocumentationManager.getOriginalElement(collector, element2);
            DocumentationProvider provider = (DocumentationProvider)ReadAction.compute(() -> DocumentationManager.getProviderFromElement(element2, originalElement));
            component2.setData(element2, this.myPrecalculatedDocumentation, collector.effectiveUrl, collector.ref, provider);
            callback2.setDone();
            this.myPrecalculatedDocumentation = null;
            return callback2;
        }
        boolean wasEmpty = component2.isEmpty();
        component2.startWait();
        if (wasEmpty) {
            component2.setText(CodeInsightBundle.message((String)"javadoc.fetching.progress", (Object[])new Object[0]), null, collector.provider);
        }
        ModalityState modality = ModalityState.defaultModalityState();
        this.myUpdateDocAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            LOG.debug("Started fetching documentation...");
            PsiElement element2 = collector.getElement(true);
            if (element2 == null || !((Boolean)ReadAction.compute(() -> element2.isValid())).booleanValue()) {
                LOG.debug("Element for which documentation was requested is not available anymore");
                GuiUtils.invokeLaterIfNeeded(() -> component2.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), null, collector.provider), (ModalityState)ModalityState.any());
                callback2.setDone();
                return;
            }
            Throwable fail = null;
            String text = null;
            try {
                text = collector.getDocumentation();
            }
            catch (Throwable e) {
                LOG.info(e);
                fail = e;
            }
            if (fail != null) {
                Throwable finalFail = fail;
                GuiUtils.invokeLaterIfNeeded(() -> {
                    String message = finalFail instanceof IndexNotReadyException ? "Documentation is not available until indices are built." : CodeInsightBundle.message((String)"javadoc.external.fetch.error.message", (Object[])new Object[0]);
                    component2.setText(message, null, collector.provider);
                    component2.clearHistory();
                    callback2.setDone();
                }, (ModalityState)ModalityState.any());
                return;
            }
            LOG.debug("Documentation fetched successfully:\n", new Object[]{text});
            String finalText = text;
            PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                if (!element2.isValid()) {
                    LOG.debug("Element for which documentation was requested is not valid");
                    callback2.setDone();
                    return;
                }
                String currentText = component2.getText();
                if (finalText == null) {
                    component2.setText(CodeInsightBundle.message((String)"no.documentation.found", (Object[])new Object[0]), element2, collector.provider);
                } else if (finalText.isEmpty()) {
                    component2.setText(currentText, element2, collector.provider);
                } else {
                    component2.setData(element2, finalText, collector.effectiveUrl, collector.ref, collector.provider);
                }
                if (wasEmpty) {
                    component2.clearHistory();
                }
                callback2.setDone();
            }, modality);
        }, 10);
        return callback2;
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(PsiElement element2) {
        return DocumentationManager.getProviderFromElement(element2, null);
    }

    @NotNull
    public static DocumentationProvider getProviderFromElement(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        if (element2 != null && !element2.isValid()) {
            element2 = null;
        }
        if (originalElement != null && !originalElement.isValid()) {
            originalElement = null;
        }
        if (originalElement == null) {
            originalElement = DocumentationManager.getOriginalElement(element2);
        }
        PsiFile containingFile = originalElement != null ? originalElement.getContainingFile() : (element2 != null ? element2.getContainingFile() : null);
        LinkedHashSet result2 = new LinkedHashSet();
        Language containingFileLanguage = containingFile != null ? containingFile.getLanguage() : null;
        DocumentationProvider originalProvider = containingFile != null ? LanguageDocumentation.INSTANCE.forLanguage(containingFileLanguage) : null;
        Language elementLanguage = element2 != null ? element2.getLanguage() : null;
        DocumentationProvider elementProvider = element2 == null || elementLanguage.is(containingFileLanguage) ? null : LanguageDocumentation.INSTANCE.forLanguage(elementLanguage);
        ContainerUtil.addIfNotNull(result2, elementProvider);
        ContainerUtil.addIfNotNull(result2, (Object)originalProvider);
        if (containingFile != null) {
            Language baseLanguage = containingFile.getViewProvider().getBaseLanguage();
            if (!baseLanguage.is(containingFileLanguage)) {
                ContainerUtil.addIfNotNull(result2, (Object)LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        } else if (element2 instanceof PsiDirectory) {
            HashSet<Language> set = new HashSet<Language>();
            for (PsiFile file2 : ((PsiDirectory)element2).getFiles()) {
                Language baseLanguage = file2.getViewProvider().getBaseLanguage();
                if (set.contains(baseLanguage)) continue;
                set.add(baseLanguage);
                ContainerUtil.addIfNotNull(result2, (Object)LanguageDocumentation.INSTANCE.forLanguage(baseLanguage));
            }
        }
        DocumentationProvider documentationProvider = CompositeDocumentationProvider.wrapProviders(result2);
        if (documentationProvider == null) {
            DocumentationManager.$$$reportNull$$$0(29);
        }
        return documentationProvider;
    }

    @Nullable
    public static PsiElement getOriginalElement(PsiElement element2) {
        SmartPsiElementPointer originalElementPointer = element2 != null ? (SmartPsiElementPointer)element2.getUserData(ORIGINAL_ELEMENT_KEY) : null;
        return originalElementPointer != null ? originalElementPointer.getElement() : null;
    }

    @Nullable
    public PsiElement getTargetElement(@Nullable PsiElement context, @Nullable String url) {
        Pair<@NotNull PsiElement, @Nullable String> target2 = this.getTarget(context, url);
        return target2 == null ? null : (PsiElement)target2.first;
    }

    @Nullable
    private @Nullable Pair<@NotNull PsiElement, @Nullable String> getTarget(@Nullable PsiElement context, @Nullable String url) {
        if (context != null && url != null && url.startsWith("psi_element://")) {
            Iterator iterator2;
            DocumentationProvider provider;
            PsiElement targetElement;
            PsiManager manager = PsiManager.getInstance((Project)this.getProject(context));
            String refText = url.substring("psi_element://".length());
            int separatorPos = refText.lastIndexOf("###");
            String ref = null;
            if (separatorPos >= 0) {
                ref = refText.substring(separatorPos + "###".length());
                refText = refText.substring(0, separatorPos);
            }
            if ((targetElement = (provider = DocumentationManager.getProviderFromElement(context)).getDocumentationElementForLink(manager, refText, context)) == null) {
                DocumentationProvider documentationProvider;
                iterator2 = DocumentationProvider.EP_NAME.getExtensionList().iterator();
                while (iterator2.hasNext() && (targetElement = (documentationProvider = (DocumentationProvider)iterator2.next()).getDocumentationElementForLink(manager, refText, context)) == null) {
                }
            }
            if (targetElement == null) {
                Language language;
                DocumentationProvider documentationProvider;
                iterator2 = Language.getRegisteredLanguages().iterator();
                while (iterator2.hasNext() && ((documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language = (Language)iterator2.next())) == null || (targetElement = documentationProvider.getDocumentationElementForLink(manager, refText, context)) == null)) {
                }
            }
            if (targetElement != null) {
                return Pair.create((Object)targetElement, (Object)ref);
            }
        }
        return null;
    }

    private static PsiElement getOriginalElement(@NotNull DocumentationCollector collector, PsiElement targetElement) {
        if (collector == null) {
            DocumentationManager.$$$reportNull$$$0(30);
        }
        return collector instanceof MyCollector ? ((MyCollector)collector).originalElement : targetElement;
    }

    public void navigateByLink(DocumentationComponent component2, final String url) {
        component2.setCursor(Cursor.getPredefinedCursor(3));
        final PsiElement psiElement = component2.getElement();
        if (psiElement == null) {
            return;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.getProject(psiElement));
        if (url.equals("external_doc")) {
            component2.showExternalDoc();
            return;
        }
        if (url.startsWith("open")) {
            PsiFile containingFile = psiElement.getContainingFile();
            OrderEntry libraryEntry = null;
            if (containingFile != null) {
                VirtualFile virtualFile = containingFile.getVirtualFile();
                libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)virtualFile, (Project)this.myProject);
            } else if (psiElement instanceof PsiDirectoryContainer) {
                PsiDirectory directory;
                VirtualFile virtualFile;
                PsiDirectory[] directories;
                PsiDirectory[] psiDirectoryArray = directories = ((PsiDirectoryContainer)psiElement).getDirectories();
                int n = psiDirectoryArray.length;
                for (int j = 0; j < n && (libraryEntry = LibraryUtil.findLibraryEntry((VirtualFile)(virtualFile = (directory = psiDirectoryArray[j]).getVirtualFile()), (Project)this.myProject)) == null; ++j) {
                }
            }
            if (libraryEntry != null) {
                ProjectSettingsService.getInstance(this.myProject).openLibraryOrSdkSettings(libraryEntry);
            }
        } else if (url.startsWith("psi_element://")) {
            Pair<@NotNull PsiElement, @Nullable String> target2 = this.getTarget(psiElement, url);
            if (target2 != null) {
                this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, CompletableFuture.completedFuture((PsiElement)target2.first), null, (String)target2.second, false));
            }
        } else {
            DocumentationProvider provider = DocumentationManager.getProviderFromElement(psiElement);
            boolean processed2 = false;
            if (provider instanceof CompositeDocumentationProvider) {
                for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                    if (!(p instanceof ExternalDocumentationHandler)) continue;
                    final ExternalDocumentationHandler externalHandler = (ExternalDocumentationHandler)p;
                    if (externalHandler.canFetchDocumentationLink(url)) {
                        String ref = externalHandler.extractRefFromLink(url);
                        this.cancelAndFetchDocInfo(component2, new DocumentationCollector(psiElement, url, ref, p){

                            @Override
                            public String getDocumentation() {
                                return externalHandler.fetchExternalDocumentation(url, psiElement);
                            }
                        });
                        processed2 = true;
                        continue;
                    }
                    if (!externalHandler.handleExternalLink(manager, url, psiElement)) continue;
                    processed2 = true;
                    break;
                }
            }
            if (!processed2) {
                this.cancelAndFetchDocInfo(component2, new DocumentationCollector(psiElement, url, null, provider){

                    @Override
                    public String getDocumentation() {
                        if (BrowserUtil.isAbsoluteURL((String)url)) {
                            BrowserUtil.browse((String)url);
                            return "";
                        }
                        return CodeInsightBundle.message((String)"javadoc.error.resolving.url", (Object[])new Object[]{url});
                    }
                });
            }
        }
        component2.setCursor(Cursor.getPredefinedCursor(0));
    }

    public Project getProject(@Nullable PsiElement element2) {
        this.assertSameProject(element2);
        return this.myProject;
    }

    private PsiElement assertSameProject(@Nullable PsiElement element2) {
        if (element2 != null && element2.isValid() && this.myProject != element2.getProject()) {
            throw new AssertionError((Object)(this.myProject + "!=" + element2.getProject() + "; element=" + element2));
        }
        return element2;
    }

    public static void createHyperlink(StringBuilder buffer, String refText, String label2, boolean plainLink) {
        DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (String)refText, (String)label2, (boolean)plainLink);
    }

    @Override
    public String getShowInToolWindowProperty() {
        return SHOW_DOCUMENTATION_IN_TOOL_WINDOW;
    }

    @Override
    public String getAutoUpdateEnabledProperty() {
        return DOCUMENTATION_AUTO_UPDATE_ENABLED;
    }

    @Override
    protected void doUpdateComponent(@NotNull CompletableFuture<PsiElement> elementFuture, PsiElement originalElement, DocumentationComponent component2) {
        if (elementFuture == null) {
            DocumentationManager.$$$reportNull$$$0(31);
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, elementFuture, originalElement, null, false));
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element2, PsiElement originalElement, DocumentationComponent component2) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(32);
        }
        this.cancelAndFetchDocInfo(component2, new MyCollector(this.myProject, CompletableFuture.completedFuture(element2), originalElement, null, false));
    }

    @Override
    protected void doUpdateComponent(Editor editor, PsiFile psiFile, boolean requestFocus) {
        this.showJavaDocInfo(editor, psiFile, requestFocus, null);
    }

    @Override
    protected void doUpdateComponent(Editor editor, PsiFile psiFile) {
        this.doUpdateComponent(editor, psiFile, false);
    }

    @Override
    protected void doUpdateComponent(@NotNull PsiElement element2) {
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(33);
        }
        this.showJavaDocInfo(element2, element2, null);
    }

    @Override
    protected String getTitle(PsiElement element2) {
        String title = SymbolPresentationUtil.getSymbolPresentableText(element2);
        return title != null ? title : element2.getText();
    }

    @Nullable
    Image getElementImage(@NotNull PsiElement element2, @NotNull String imageSpec) {
        DocumentationProvider provider;
        if (element2 == null) {
            DocumentationManager.$$$reportNull$$$0(34);
        }
        if (imageSpec == null) {
            DocumentationManager.$$$reportNull$$$0(35);
        }
        if ((provider = DocumentationManager.getProviderFromElement(element2)) instanceof CompositeDocumentationProvider) {
            for (DocumentationProvider p : ((CompositeDocumentationProvider)provider).getAllProviders()) {
                Image image;
                if (!(p instanceof DocumentationProviderEx) || (image = ((DocumentationProviderEx)p).getLocalImageForElement(element2, imageSpec)) == null) continue;
                return image;
            }
        }
        return null;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    public ActionCallback getLastAction() {
        return this.myLastAction;
    }

    public void setDocumentationComponent(DocumentationComponent documentationComponent) {
        this.myTestDocumentationComponent = documentationComponent;
    }

    @Nullable
    private static String generateFileDoc(@NotNull PsiFile psiFile, boolean withUrl) {
        VirtualFile file2;
        if (psiFile == null) {
            DocumentationManager.$$$reportNull$$$0(36);
        }
        File ioFile = (file2 = PsiUtilCore.getVirtualFile((PsiElement)psiFile)) == null || !file2.isInLocalFileSystem() ? null : VfsUtilCore.virtualToIoFile((VirtualFile)file2);
        BasicFileAttributes attr = null;
        try {
            attr = ioFile == null ? null : Files.readAttributes(Paths.get(ioFile.toURI()), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (attr == null) {
            return null;
        }
        FileType type = file2.getFileType();
        String typeName = type == UnknownFileType.INSTANCE ? "Unknown" : (type == PlainTextFileType.INSTANCE ? "Text" : (type == ArchiveFileType.INSTANCE ? "Archive" : type.getName()));
        String languageName = type.isBinary() ? "" : psiFile.getLanguage().getDisplayName();
        return (withUrl ? "<div class='definition'><pre>" + file2.getPresentableUrl() + "</pre></div>" + "<div class='content'>" : "") + DocumentationManager.getVcsStatus(psiFile.getProject(), file2) + DocumentationManager.getScope(psiFile.getProject(), file2) + "<p><span class='grayed'>Size:</span> " + StringUtil.formatFileSize((long)attr.size()) + "<p><span class='grayed'>Type:</span> " + typeName + (type.isBinary() || typeName.equals(languageName) ? "" : " (" + languageName + ")") + "<p><span class='grayed'>Modified:</span> " + DateFormatUtil.formatDateTime((long)attr.lastModifiedTime().toMillis()) + "<p><span class='grayed'>Created:</span> " + DateFormatUtil.formatDateTime((long)attr.creationTime().toMillis()) + (withUrl ? "</div>" : "");
    }

    private static String getScope(Project project, VirtualFile file2) {
        FileColorManagerImpl colorManager = (FileColorManagerImpl)FileColorManager.getInstance((Project)project);
        Color color = colorManager.getRendererBackground(file2);
        if (color == null) {
            return "";
        }
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            for (NamedScope scope : holder.getScopes()) {
                PackageSet packageSet = scope.getValue();
                String name = scope.getName();
                if (!(packageSet instanceof PackageSetBase) || !((PackageSetBase)packageSet).contains(file2, project, holder) || colorManager.getScopeColor(name) != color) continue;
                return "<p><span class='grayed'>Scope:</span> <span bgcolor='" + ColorUtil.toHex((Color)color) + "'>" + scope.getName() + "</span>";
            }
        }
        return "";
    }

    @NotNull
    private static String getVcsStatus(Project project, VirtualFile file2) {
        FileStatus status = FileStatusManager.getInstance((Project)project).getStatus(file2);
        return status != FileStatus.NOT_CHANGED ? "<p><span class='grayed'>VCS Status:</span> <span color='" + ColorUtil.toHex((Color)status.getColor()) + "'>" + status.getText() + "</span>" : "";
    }

    private Optional<QuickSearchComponent> findQuickSearchComponent() {
        for (Component c = (Component)SoftReference.dereference(this.myFocusedBeforePopup); c != null; c = c.getParent()) {
            if (!(c instanceof QuickSearchComponent)) continue;
            return Optional.of((QuickSearchComponent)c);
        }
        return Optional.empty();
    }

    @NotNull
    private static CompletableFuture<PsiElement> toCompletableFuture(@NotNull CancellablePromise<PsiElement> promise) {
        if (promise == null) {
            DocumentationManager.$$$reportNull$$$0(37);
        }
        CompletableFuture<PsiElement> future2 = new CompletableFuture<PsiElement>();
        promise.onSuccess(element2 -> future2.complete((PsiElement)element2));
        promise.onError(ex -> future2.completeExceptionally((Throwable)ex));
        CompletableFuture<PsiElement> completableFuture = future2;
        if (completableFuture == null) {
            DocumentationManager.$$$reportNull$$$0(38);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/DocumentationManager";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFuture";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 19: 
            case 20: 
            case 22: 
            case 26: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 8: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestorePopupAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/DocumentationManager";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderFromElement";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompletableFuture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installComponentActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showJavaDocInfoAtToolWindow";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showJavaDocInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doShowJavaDocInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showInPopup";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementFromContext";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateDocumentation";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fetchDocInfo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "queueFetchDocInfo";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "cancelAndFetchDocInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindowTabName";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doFetchDocInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateComponent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getElementImage";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateFileDoc";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toCompletableFuture";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCollector
    extends DocumentationCollector {
        final Project project;
        final PsiElement originalElement;
        final boolean onHover;

        MyCollector(@NotNull Project project, @NotNull CompletableFuture<PsiElement> elementSupplier, PsiElement originalElement, String ref, boolean onHover) {
            if (project == null) {
                MyCollector.$$$reportNull$$$0(0);
            }
            if (elementSupplier == null) {
                MyCollector.$$$reportNull$$$0(1);
            }
            super(elementSupplier, null, ref, null);
            this.project = project;
            this.originalElement = originalElement;
            this.onHover = onHover;
        }

        @Override
        @Nullable
        public String getDocumentation() {
            PsiElement element2 = this.getElement(true);
            if (element2 == null) {
                return null;
            }
            this.provider = (DocumentationProvider)ReadAction.compute(() -> DocumentationManager.getProviderFromElement(element2, this.originalElement));
            LOG.debug("Using provider ", new Object[]{this.provider});
            if (this.provider instanceof ExternalDocumentationProvider) {
                List urls = (List)ReadAction.nonBlocking(() -> {
                    SmartPsiElementPointer originalElementPtr = (SmartPsiElementPointer)element2.getUserData(ORIGINAL_ELEMENT_KEY);
                    PsiElement originalElement = originalElementPtr != null ? originalElementPtr.getElement() : null;
                    return this.provider.getUrlFor(element2, originalElement);
                }).executeSynchronously();
                LOG.debug("External documentation URLs: ", new Object[]{urls});
                if (urls != null) {
                    for (String url : urls) {
                        String doc = ((ExternalDocumentationProvider)this.provider).fetchExternalDocumentation(this.project, element2, Collections.singletonList(url), this.onHover);
                        if (doc == null) continue;
                        LOG.debug("Fetched documentation from ", new Object[]{url});
                        this.effectiveUrl = url;
                        return doc;
                    }
                }
            }
            return (String)ReadAction.nonBlocking(() -> {
                String fileDoc;
                String doc;
                if (!element2.isValid()) {
                    return null;
                }
                SmartPsiElementPointer originalPointer = (SmartPsiElementPointer)element2.getUserData(ORIGINAL_ELEMENT_KEY);
                PsiElement originalPsi = originalPointer != null ? originalPointer.getElement() : null;
                String string = doc = this.onHover ? this.provider.generateHoverDoc(element2, originalPsi) : this.provider.generateDoc(element2, originalPsi);
                if (element2 instanceof PsiFile && (fileDoc = DocumentationManager.generateFileDoc((PsiFile)element2, doc == null)) != null) {
                    doc = doc == null ? fileDoc : doc + fileDoc;
                }
                return doc;
            }).executeSynchronously();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "elementSupplier";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/documentation/DocumentationManager$MyCollector";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class DocumentationCollector {
        private final CompletableFuture<PsiElement> myElementFuture;
        final String ref;
        volatile DocumentationProvider provider;
        String effectiveUrl;

        DocumentationCollector(PsiElement element2, String effectiveUrl, String ref, DocumentationProvider provider) {
            this(CompletableFuture.completedFuture(element2), effectiveUrl, ref, provider);
        }

        DocumentationCollector(@NotNull CompletableFuture<PsiElement> elementFuture, String effectiveUrl, String ref, DocumentationProvider provider) {
            if (elementFuture == null) {
                DocumentationCollector.$$$reportNull$$$0(0);
            }
            this.myElementFuture = elementFuture;
            this.ref = ref;
            this.effectiveUrl = effectiveUrl;
            this.provider = provider;
        }

        @Nullable
        public PsiElement getElement(boolean wait) {
            try {
                return wait ? this.myElementFuture.get() : (PsiElement)this.myElementFuture.getNow(null);
            }
            catch (Exception e) {
                LOG.debug("Cannot get target element", (Throwable)e);
                return null;
            }
        }

        @Nullable
        abstract String getDocumentation() throws Exception;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFuture", "com/intellij/codeInsight/documentation/DocumentationManager$DocumentationCollector", "<init>"));
        }
    }
}

