/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableInspectionToolAction
extends IntentionAndQuickFixAction
implements Iconable {
    private final String myToolId;

    public DisableInspectionToolAction(LocalInspectionTool tool) {
        this.myToolId = tool.getShortName();
    }

    public DisableInspectionToolAction(HighlightDisplayKey key) {
        this.myToolId = key.toString();
    }

    @NotNull
    public String getName() {
        String string = DisableInspectionToolAction.getNameText();
        if (string == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = DisableInspectionToolAction.getNameText();
        if (string == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        InspectionProjectProfileManager profileManager;
        InspectionProfileImpl inspectionProfile;
        InspectionToolWrapper toolWrapper;
        if (project == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(2);
        }
        return (toolWrapper = (inspectionProfile = (profileManager = InspectionProjectProfileManager.getInstance(project)).getCurrentProfile()).getInspectionTool(this.myToolId, project)) == null || !toolWrapper.getDefaultLevel().isNonSwitchable();
    }

    public void applyFix(@NotNull Project project, PsiFile file2, @Nullable Editor editor) {
        if (project == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(3);
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project, (Consumer<InspectionProfileModifiableModel>)((Consumer)it -> it.disableTool(this.myToolId, (PsiElement)file2)));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    public static String getNameText() {
        return InspectionsBundle.message((String)"disable.inspection.action.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/DisableInspectionToolAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/DisableInspectionToolAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

